/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.c;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.utility.StringUtility;

public class RFIDWithISO14443A4CPU
extends c {
    private static RFIDWithISO14443A4CPU a = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized RFIDWithISO14443A4CPU getInstance() throws ConfigurationException {
        if (a != null) return a;
        Class<RFIDWithISO14443A4CPU> clazz = RFIDWithISO14443A4CPU.class;
        synchronized (RFIDWithISO14443A4CPU.class) {
            if (a != null) return a;
            a = new RFIDWithISO14443A4CPU();
            // ** MonitorExit[var0] (shouldn't be in output)
            return a;
        }
    }

    protected RFIDWithISO14443A4CPU() throws ConfigurationException {
    }

    public String sendCommand(String cmd) {
        char[] cArray;
        if (StringUtility.isEmpty(cmd)) {
            Log.e((String)"RFIDWithISO14443A4CPU", (String)"sendCommand() err:cmd  is empty");
            return null;
        }
        if (!StringUtility.isHexNumberRex(cmd)) {
            Log.e((String)"RFIDWithISO14443A4CPU", (String)"sendCommand() err:cmd  not hex");
            return null;
        }
        cArray = StringUtility.hexString2Chars((String)cArray);
        cArray = this.getDeviceAPI().ISO14443A_cpu_command(cArray, cArray.length);
        if (cArray == null || cArray[0] != '\u0000' || cArray[1] == '\u0000') {
            Log.e((String)"RFIDWithISO14443A4CPU", (String)("sendCommand() err:" + (cArray == null ? "null" : Integer.valueOf(cArray[0]))));
            return null;
        }
        char[] cArray2 = new char[cArray[1]];
        int n = 0;
        while (n < cArray2.length) {
            cArray2[n] = cArray[n + 2];
            ++n;
        }
        return StringUtility.chars2HexString(cArray2, cArray2.length);
    }

    public String reset() {
        char[] cArray = this.getDeviceAPI().ISO14443A_cpu_reset();
        if (cArray == null || cArray[0] != '\u0000' || cArray[1] == '\u0000') {
            Log.e((String)"RFIDWithISO14443A4CPU", (String)("reset() err:" + (cArray == null ? "null" : Integer.valueOf(cArray[0]))));
            return null;
        }
        char[] cArray2 = new char[cArray[1]];
        int n = 0;
        while (n < cArray2.length) {
            cArray2[n] = cArray[n + 2];
            ++n;
        }
        return StringUtility.chars2HexString(cArray2, cArray2.length);
    }

    public String rats() {
        char[] cArray = this.getDeviceAPI().ISO14443A_cpu_rats();
        if (cArray == null || cArray[0] != '\u0000' || cArray[1] == '\u0000') {
            Log.e((String)"RFIDWithISO14443A4CPU", (String)("rats() err:" + (cArray == null ? "null" : Integer.valueOf(cArray[0]))));
            return null;
        }
        char[] cArray2 = new char[cArray[1]];
        int n = 0;
        while (n < cArray2.length) {
            cArray2[n] = cArray[n + 2];
            ++n;
        }
        return StringUtility.chars2HexString(cArray2, cArray2.length);
    }

    public static /* bridge */ /* synthetic */ c getInstance() throws ConfigurationException {
        return RFIDWithISO14443A4CPU.getInstance();
    }
}

