/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.a;
import com.rscja.deviceapi.b;
import com.rscja.deviceapi.entity.AnimalEntity;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.utility.StringUtility;
import java.util.Arrays;

public class RFIDWithLF
extends a {
    protected b config_LF = b.h();
    private static RFIDWithLF a = null;

    private RFIDWithLF() throws ConfigurationException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized RFIDWithLF getInstance() throws ConfigurationException {
        if (a != null) return a;
        Class<RFIDWithLF> clazz = RFIDWithLF.class;
        synchronized (RFIDWithLF.class) {
            if (a != null) return a;
            a = new RFIDWithLF();
            // ** MonitorExit[var0] (shouldn't be in output)
            return a;
        }
    }

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.a();
    }

    public synchronized boolean init() {
        Log.i((String)"RFIDWithLF", (String)("init() DeviceName:" + this.config_LF.k() + " Uart=" + this.config_LF.l() + " Baudrate=" + this.config_LF.m()));
        int n = this.getDeviceAPI().EM125k_init(this.config_LF.k(), this.config_LF.l(), this.config_LF.m());
        if (n >= 0) {
            this.setPowerOn(true);
            return true;
        }
        Log.e((String)"RFIDWithLF", (String)("init() err:" + n));
        return false;
    }

    public synchronized boolean free() {
        int n = this.getDeviceAPI().EM125k_free(this.config_LF.k());
        if (n == 0) {
            this.setPowerOn(false);
            return true;
        }
        Log.e((String)"RFIDWithLF", (String)("free() err:" + n));
        return false;
    }

    public synchronized String getHardwareVersion() {
        if (!this.isPowerOn()) {
            return null;
        }
        Object object = this.getDeviceAPI().HardwareVersion_125k();
        if (object[0] != '\u0000') {
            Log.e((String)"RFIDWithLF", (String)("getHardwareVersion() err:" + Integer.valueOf(object[0])));
            return null;
        }
        String string = new String((char[])object).trim();
        object = string;
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized String readDataWithIDCard(int iMode) {
        void var1_1;
        char[] cArray = this.a((int)var1_1);
        if (cArray == null) {
            return null;
        }
        return StringUtility.chars2HexString(cArray, cArray.length);
    }

    private char[] a(int n) {
        if (n > 2 || n < 0) {
            return null;
        }
        char[] cArray = this.getDeviceAPI().EM125k_read(n);
        if (cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithLF", (String)("read() err:" + Integer.valueOf(cArray[0])));
            return null;
        }
        cArray = Arrays.copyOfRange(cArray, 2, cArray[1] + 2);
        return cArray;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized AnimalEntity readAnimalTags(int iMode) {
        void var1_1;
        char[] cArray = this.a((int)var1_1);
        if (cArray == null) {
            return null;
        }
        AnimalEntity animalEntity = new AnimalEntity();
        char[] cArray2 = new char[8];
        int n = 0;
        while (n < 8) {
            cArray2[n] = cArray[7 - n];
            ++n;
        }
        char[] cArray3 = new char[2];
        char[] cArray4 = cArray3;
        cArray3[0] = cArray[9];
        cArray4[1] = cArray[8];
        char[] cArray5 = new char[2];
        char[] cArray6 = cArray5;
        cArray5[0] = cArray[11];
        cArray6[1] = cArray[10];
        animalEntity.setNationalID(StringUtility.charArrayTolong(cArray2));
        animalEntity.setCountryID(StringUtility.charArrayTolong(cArray4));
        animalEntity.setReserved(StringUtility.charArrayTolong(cArray6));
        cArray2 = new char[cArray.length - 8];
        int n2 = 0;
        while (n2 < cArray.length - 8) {
            cArray2[n2] = cArray[n2];
            ++n2;
        }
        char[] cArray7 = new char[8];
        int n3 = 0;
        while (n3 < 8) {
            cArray7[n3] = cArray[cArray2.length + n3];
            ++n3;
        }
        animalEntity.setRawData(StringUtility.chars2HexString(cArray2, cArray2.length));
        animalEntity.setIdData(StringUtility.chars2HexString(cArray7, cArray7.length));
        return animalEntity;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized String readDataWithHitagS(int nPage) {
        void var1_1;
        char[] cArray = this.getDeviceAPI().EM125k_ReadHitag((int)var1_1);
        if (cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithLF", (String)("readWithHitagS() err:" + Integer.valueOf(cArray[0])));
            return null;
        }
        cArray = Arrays.copyOfRange(cArray, 2, cArray[1] + 2);
        return StringUtility.chars2HexString(cArray, cArray.length);
    }

    public synchronized boolean writeDataWithHitagS(int nPage, String hexData) {
        int n;
        char[] cArray;
        if (StringUtility.isEmpty(hexData) || !StringUtility.isHexNumberRex(hexData)) {
            return false;
        }
        cArray = StringUtility.hexString2Chars((String)cArray);
        n = this.getDeviceAPI().EM125k_WriteHitagPage(n, cArray);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithLF", (String)("writeDataWithHitagS() err:" + n));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized String readDataWith4305Card(int nPage) {
        void var1_1;
        char[] cArray = this.getDeviceAPI().EM125k_Read4305((int)var1_1);
        if (cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithLF", (String)("readDataWith4305Card() err:" + Integer.valueOf(cArray[0])));
            return null;
        }
        cArray = Arrays.copyOfRange(cArray, 2, cArray[1] + 2);
        return StringUtility.chars2HexString(cArray, cArray.length);
    }

    public synchronized boolean writeDataWith4305Card(int nPage, String hexData) {
        int n;
        char[] cArray;
        if (StringUtility.isEmpty(hexData) || !StringUtility.isHexNumberRex(hexData)) {
            return false;
        }
        cArray = StringUtility.hexString2Chars((String)cArray);
        n = this.getDeviceAPI().EM125k_Write4305(n, cArray);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithLF", (String)("writeDataWith4305Card() err:" + n));
        return false;
    }

    public synchronized int getUIDWithHID() {
        return this.getDeviceAPI().HID_GetUid();
    }

    public synchronized String getUIDWithHitagS() {
        char[] cArray = this.getDeviceAPI().EM125k_UID_REQ();
        if (cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithLF", (String)("getUIDWithHitagS() err:" + Integer.valueOf(cArray[0])));
            return null;
        }
        cArray = Arrays.copyOfRange(cArray, 2, cArray[1] + 2);
        return StringUtility.chars2HexString(cArray, cArray.length);
    }

    public synchronized String getUIDWith4450Card() {
        char[] cArray = this.getDeviceAPI().EM125K_GetEm4450UID();
        if (cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithLF", (String)("getUIDWith4450Card() err:" + Integer.valueOf(cArray[0])));
            return null;
        }
        cArray = Arrays.copyOfRange(cArray, 2, cArray[1] + 2);
        return StringUtility.chars2HexString(cArray, cArray.length);
    }

    public synchronized boolean initWithNeedleTag() {
        int n = this.getDeviceAPI().EM125k_init_Ex(this.config_LF.k(), this.config_LF.l(), this.config_LF.m());
        if (n == 0) {
            this.setPowerOn(true);
            return true;
        }
        Log.e((String)"RFIDWithLF", (String)("init() err:" + n));
        return false;
    }

    public synchronized String readWithNeedleTag() {
        char[] cArray = this.getDeviceAPI().EM125k_read_Ex();
        if (cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithLF", (String)("readWithNeedleTag() err:" + Integer.valueOf(cArray[0])));
            return null;
        }
        cArray = Arrays.copyOfRange(cArray, 2, cArray[1] + 2);
        return new String(cArray);
    }
}

