/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.util.Log;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.UHFProtocolParse;
import com.rscja.deviceapi.interfaces.ConnectionStatus;
import com.rscja.deviceapi.interfaces.ConnectionStatusCallback;
import com.rscja.deviceapi.interfaces.IBluetoothReader;
import com.rscja.deviceapi.interfaces.IUHFProtocolParse;
import com.rscja.deviceapi.interfaces.KeyEventCallback;
import com.rscja.deviceapi.interfaces.ScanBTCallback;
import com.rscja.deviceapi.service.BLEService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;

public class BluetoothReader
implements IBluetoothReader {
    private String TAG = "DeviceAPI_BluetoothReader";
    private static BluetoothReader single = null;
    protected BLEService mService = null;
    protected Context context = null;
    protected boolean isComplete = false;
    protected LinkedBlockingQueue<Byte> queueReceive = new LinkedBlockingQueue(4096);
    protected boolean isDebug = false;
    protected boolean isSelfProtocolParse = false;
    OnDataChangeListener onDataChangeListener = null;
    private ArrayList<Byte> tempData = new ArrayList();
    protected final int TimeOut = 1000;
    private String[] msg = new String[1];
    protected IUHFProtocolParse uhfProtocolParse = null;
    private byte lastByte = 0;
    private DataCallBack bataCallBack = new DataCallBack();

    protected BluetoothReader() {
        this.uhfProtocolParse = UHFProtocolParse.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized BluetoothReader getInstance() {
        if (single != null) return single;
        Class<BluetoothReader> clazz = BluetoothReader.class;
        synchronized (BluetoothReader.class) {
            if (single != null) return single;
            single = new BluetoothReader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.getInstance();
    }

    @Override
    public boolean init(Context context) {
        this.context = context;
        BluetoothAdapter mBtAdapter = BluetoothAdapter.getDefaultAdapter();
        if (mBtAdapter == null) {
            return false;
        }
        Log.d((String)this.TAG, (String)"init");
        this.service_init(this.context);
        return true;
    }

    @Override
    public boolean free() {
        if (this.mService != null) {
            this.mService.stoptBTScan();
            this.mService.disconnect();
            return true;
        }
        return false;
    }

    @Override
    public void startScanBTDevices(ScanBTCallback scanBTCallback) {
        if (this.mService != null) {
            this.mService.startBTScan(scanBTCallback);
        }
    }

    @Override
    public void stopScanBTDevices() {
        if (this.mService != null) {
            this.mService.stoptBTScan();
        }
    }

    @Override
    public void setStatusCallback(ConnectionStatusCallback<Object> btStatusCallback) {
        this.mService.setStatusCallback(btStatusCallback);
    }

    @Override
    public void connect(String address, ConnectionStatusCallback<Object> btStatusCallback) {
        if (address != null && this.mService != null) {
            this.mService.connect(address, btStatusCallback);
            this.mService.setDataCallBack(this.bataCallBack);
        }
    }

    @Override
    public void setKeyEventCallback(KeyEventCallback KeyEventCallback2) {
        if (this.mService != null) {
            this.mService.setKeyEventCallback(KeyEventCallback2);
        }
    }

    @Override
    public void disconnect() {
        if (this.mService != null) {
            this.mService.disconnect();
        }
    }

    @Override
    public ConnectionStatus getConnectStatus() {
        if (this.mService != null) {
            return this.mService.getBTConnectStatus();
        }
        return ConnectionStatus.DISCONNECTED;
    }

    @Override
    public synchronized int getBattery() {
        byte[] sendData = this.uhfProtocolParse.getBatterySendData();
        byte[] data = this.getBTReceiveData(sendData, 1000);
        if (data != null && data.length > 0) {
            return this.uhfProtocolParse.parseBatteryData(data);
        }
        return -1;
    }

    @Override
    public synchronized boolean setBeep(boolean isOpen) {
        byte[] sendData = this.uhfProtocolParse.getBeepSendData(isOpen);
        byte[] data = this.getBTReceiveData(sendData, 1000);
        if (data != null && data.length > 0) {
            return this.uhfProtocolParse.parseBeepData(data);
        }
        return false;
    }

    @Override
    public synchronized String scanBarcode() {
        byte[] barcode;
        byte[] sendData = this.uhfProtocolParse.getScanBarcodeSendData();
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0 && (barcode = this.uhfProtocolParse.parseBarcodeData(inData)) != null && barcode.length > 0) {
            return new String(barcode);
        }
        return null;
    }

    @Override
    public synchronized byte[] scanBarcodeToBytes() {
        byte[] sendData = this.uhfProtocolParse.getScanBarcodeSendData();
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseBarcodeData(inData);
        }
        return null;
    }

    byte[] getBTReceiveData(byte[] sendData, int timeOut) {
        this.isSelfProtocolParse = true;
        this.cleanCache();
        byte[] result = this.getQueueData(sendData, timeOut);
        this.isSelfProtocolParse = false;
        return result;
    }

    private byte[] getQueueData(byte[] sendData, int timeOut) {
        if (this.mService != null) {
            if (this.mService.writeRXCharacteristic(sendData, this.msg)) {
                long startTime = System.currentTimeMillis();
                while (true) {
                    if (!this.queueReceive.isEmpty()) {
                        byte bData = this.queueReceive.poll();
                        this.tempData.add(bData);
                        if (this.lastByte == 13 && bData == 10) {
                            byte[] b = new byte[this.tempData.size()];
                            int k = 0;
                            while (k < this.tempData.size()) {
                                b[k] = this.tempData.get(k);
                                ++k;
                            }
                            return b;
                        }
                        this.lastByte = bData;
                        if (System.currentTimeMillis() - startTime <= (long)timeOut) {
                            continue;
                        }
                    }
                    if (System.currentTimeMillis() - startTime <= (long)timeOut) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    break;
                }
            } else {
                Log.e((String)this.TAG, (String)("\u5199\u6570\u636e\u5931\u8d25:" + this.msg[0]));
            }
        }
        return null;
    }

    void cleanCache() {
        this.tempData.clear();
        this.queueReceive.clear();
        this.lastByte = 0;
    }

    private void service_init(Context context) {
        if (this.mService == null) {
            this.mService = new BLEService();
        }
        if (this.mService.initialize(context)) {
            if (this.isDebug) {
                Log.d((String)this.TAG, (String)"mService.initialize   ok");
            }
        } else if (this.isDebug) {
            Log.d((String)this.TAG, (String)"mService.initialize   fail");
        }
    }

    public void setOnDataChangeListener(OnDataChangeListener onDataChangeListener) {
        this.onDataChangeListener = onDataChangeListener;
    }

    @Override
    public synchronized boolean sendData(byte[] sendData) {
        if (this.mService.writeRXCharacteristic(sendData, this.msg)) {
            return true;
        }
        Log.e((String)this.TAG, (String)("sendData fail :" + this.msg[0]));
        return false;
    }

    @Override
    public boolean setRemoteBluetoothName(String name) {
        if (this.mService != null) {
            return this.mService.setBtName(name);
        }
        return false;
    }

    @Override
    public synchronized String getSTM32Version() {
        byte[] sendData = this.uhfProtocolParse.getSTM32VersionSendData();
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSTM32VersionData(inData);
        }
        return null;
    }

    @Override
    public HashMap<String, String> getBluetoothVersion() {
        if (this.mService != null) {
            return this.mService.getVersion();
        }
        return null;
    }

    @Override
    public void connect(String address) {
        if (address != null && this.mService != null) {
            this.mService.connect(address);
            this.mService.setDataCallBack(this.bataCallBack);
        }
    }

    class DataCallBack
    implements BLEService.IDataCallBack {
        DataCallBack() {
        }

        @Override
        public void receiveBTData(byte[] txValue, boolean flag) {
            if (txValue != null) {
                if (BluetoothReader.this.isSelfProtocolParse) {
                    int k = 0;
                    while (k < txValue.length) {
                        BluetoothReader.this.queueReceive.add(txValue[k]);
                        ++k;
                    }
                } else if (BluetoothReader.this.onDataChangeListener != null) {
                    BluetoothReader.this.onDataChangeListener.receive(txValue);
                }
            }
            BluetoothReader.this.isComplete = flag;
        }
    }

    public static interface OnDataChangeListener {
        public void receive(byte[] var1);
    }
}

