/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.os.Build;
import android.os.Environment;
import android.util.Log;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.utility.StringUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;

public class DeviceConfiguration {
    private static final String TAG;
    private static String model;
    private static final String uart_mtk = "/dev/ttyMT3";
    private static final String uart_mtk_6735 = "/dev/ttyMT2";
    private static final String uart_mtk_ttyMT0 = "/dev/ttyMT0";
    private static final String uart_mtk_2 = "/dev/ttyMT1";
    private static final String uart_msm = "/dev/ttyHSL1";
    private static final String uart_msm_ttyHS0 = "/dev/ttyHS0";
    private static final String uart_Fingerprint_mtk = "/dev/ttyMT0";
    private static final String uart_Fingerprint_msm = "/dev/ttyHSL1";
    private static final String uart_Fingerprint_ttySHL0 = "/dev/ttyHSL0";
    public static final int PLATFORM_QUACOMM = 0;
    public static final int PLATFORM_MTK = 1;
    private static final int UNKNOWN = -1;
    private static int CURRENT_PLATFORM;
    private static String uartPath_2D;
    private static String uartPath_1D;
    private static String uartPath;
    private static String uartPath_RFID;
    private static String uartPath_Fingerprint;
    public static String C6000_6735;
    public static String H100_6735;
    public static String C70_6735;
    public static String C72_6735;
    public static String C76_6735;
    public static String C70_6763;
    public static String C71_6763;
    public static String C72_6763;
    public static String C6000_8909;
    public static String C4050_8909;
    public static String C4000_6582;
    public static String C4050_6582;
    public static String C4000_6577;
    public static final String P80_8953 = "P80_8953";
    public static final String P80_8953_90 = "P80_8953_90";
    public static final String H100_8953 = "H100_8953";
    public static final String C66_8953 = "C66_8953";
    public static final String C66_SMD450 = "C66_SMD450";
    public static String A8_8909;
    private String deviceName;
    private String uart;
    private int baudrate;

    static {
        Method get;
        Class<?> systemProperties2;
        TAG = String.valueOf(StringUtility.TAG) + "DeviceCon";
        model = Build.DISPLAY.toUpperCase();
        CURRENT_PLATFORM = -1;
        uartPath_2D = uart_mtk;
        uartPath_1D = null;
        uartPath = uart_mtk;
        uartPath_RFID = "";
        uartPath_Fingerprint = "/dev/ttyMT0";
        C6000_6735 = "C6000_6735";
        H100_6735 = "H100_6735";
        C70_6735 = "C70_6735";
        C72_6735 = "C72_6735";
        C76_6735 = "C76_6735";
        C70_6763 = "C70_6763";
        C71_6763 = "C71_6763";
        C72_6763 = "C72_6763";
        C6000_8909 = "C6000_8909";
        C4050_8909 = "C4050_8909";
        C4000_6582 = "C4000_6582";
        C4050_6582 = "C4050_6582";
        C4000_6577 = "C4000_6577";
        A8_8909 = "A8_8909";
        String modelInfo = "";
        DeviceInfo deviceInfo = DeviceConfiguration.getDeviceInfoFromFile();
        if (deviceInfo != null && deviceInfo.getModel() != null && deviceInfo.getModel().length() > 0) {
            modelInfo = deviceInfo.getModel();
        }
        if (modelInfo == null || modelInfo.isEmpty()) {
            try {
                systemProperties2 = Class.forName("android.os.SystemProperties");
                get = systemProperties2.getDeclaredMethod("get", String.class);
                modelInfo = (String)get.invoke(null, "ro.cw.model2");
                Log.d((String)TAG, (String)("cw.model2:" + modelInfo));
            }
            catch (Exception systemProperties2) {
                // empty catch block
            }
        }
        if (modelInfo == null || modelInfo.isEmpty()) {
            try {
                systemProperties2 = Class.forName("android.os.SystemProperties");
                get = systemProperties2.getDeclaredMethod("get", String.class);
                modelInfo = (String)get.invoke(null, "ro.cw.model");
                Log.d((String)TAG, (String)("cw.model:" + modelInfo));
            }
            catch (Exception systemProperties3) {
                // empty catch block
            }
        }
        Log.d((String)TAG, (String)("\u6700\u7ec8cw.model:" + modelInfo));
        if (modelInfo != null && !modelInfo.equals("")) {
            String[] info = null;
            info = modelInfo.split("\\.");
            model = info[2].toUpperCase();
            if (info[0].equals("mtk")) {
                CURRENT_PLATFORM = 1;
                if (info[1].equals("6735") || info[1].contains("6737")) {
                    if (model.contains("C6000")) {
                        uartPath = uart_mtk_6735;
                        uartPath_Fingerprint = "/dev/ttyMT0";
                        model = "C6000_6735";
                    } else if (model.contains("C70")) {
                        uartPath = uart_mtk;
                        uartPath_Fingerprint = uart_mtk;
                        model = "C70_6735";
                    } else if (model.contains("H100")) {
                        model = "H100_6735";
                    } else if (model.contains("C72")) {
                        uartPath_RFID = "/dev/ttyMT0";
                        uartPath = uart_mtk;
                        uartPath_Fingerprint = uart_mtk;
                        model = "C72_6735";
                    } else if (model.contains("C75")) {
                        uartPath = uart_mtk;
                        model = "C75_6735";
                    } else if (model.contains("C76")) {
                        uartPath = uart_mtk;
                        uartPath_Fingerprint = uart_mtk;
                        model = "C76_6735";
                    }
                } else if (info[1].equals("6582")) {
                    if (model.contains("C4000")) {
                        model = "C4000_6582";
                        uartPath = uart_mtk;
                        uartPath_Fingerprint = "/dev/ttyMT0";
                    } else if (model.contains("C4050")) {
                        model = "C4050_6582";
                        uartPath = uart_mtk;
                        uartPath_Fingerprint = "/dev/ttyMT0";
                    }
                } else if (info[1].equals("6577")) {
                    model = "C4000_6577";
                    uartPath = uart_mtk;
                    uartPath_Fingerprint = "/dev/ttyMT0";
                } else if (info[1].contains("6763")) {
                    if (model.contains("C70")) {
                        model = C70_6763;
                        uartPath = uart_mtk_2;
                        uartPath_Fingerprint = uart_mtk_2;
                        uartPath_2D = "/dev/ttyMT0";
                        uartPath_1D = "/dev/ttyMT0";
                    } else if (model.contains("C71")) {
                        model = C71_6763;
                        uartPath = uart_mtk_2;
                        uartPath_Fingerprint = uart_mtk_2;
                        uartPath_2D = "/dev/ttyMT0";
                        uartPath_1D = "/dev/ttyMT0";
                    } else if (model.contains("C72")) {
                        model = C72_6763;
                        uartPath = uart_mtk_2;
                        uartPath_Fingerprint = uart_mtk_2;
                        uartPath_2D = "/dev/ttyMT0";
                        uartPath_1D = "/dev/ttyMT0";
                    }
                }
            } else if (info[0].equals("qualcomm")) {
                CURRENT_PLATFORM = 0;
                if (info[1].equals("8909")) {
                    if (model.contains("C6000")) {
                        model = "C6000_8909";
                        uartPath = "/dev/ttyHSL1";
                        uartPath_Fingerprint = "/dev/ttyHSL1";
                    } else if (model.contains("C4050")) {
                        model = "C4050_8909";
                        uartPath = "/dev/ttyHSL1";
                        uartPath_Fingerprint = "/dev/ttyHSL1";
                    } else if (model.contains("A8")) {
                        model = A8_8909;
                        uartPath = "/dev/ttyHSL1";
                    }
                } else if (info[1].equals("8953")) {
                    if (model.contains("P80")) {
                        if (DeviceConfiguration.isAndroid90()) {
                            Log.d((String)TAG, (String)" cw.model3: P80_8953_90");
                            model = P80_8953_90;
                            uartPath = "/dev/ttyMSM2";
                            uartPath_Fingerprint = "/dev/ttyMSM1";
                        } else {
                            model = P80_8953;
                            uartPath = uart_Fingerprint_ttySHL0;
                            uartPath_Fingerprint = uart_Fingerprint_ttySHL0;
                        }
                    } else if (model.contains("H100Q")) {
                        model = H100_8953;
                        uartPath = uart_Fingerprint_ttySHL0;
                        uartPath_Fingerprint = uart_Fingerprint_ttySHL0;
                    } else if (model.contains("C66")) {
                        model = C66_8953;
                        uartPath = uart_msm_ttyHS0;
                        uartPath_Fingerprint = uart_msm_ttyHS0;
                    }
                } else if (info[1].equals("smd450")) {
                    if (model.contains("C66")) {
                        model = C66_SMD450;
                        uartPath = uart_msm_ttyHS0;
                        uartPath_Fingerprint = uart_msm_ttyHS0;
                    } else if (model.contains("P80")) {
                        model = "P80_SMD450";
                        uartPath = uart_Fingerprint_ttySHL0;
                        uartPath_Fingerprint = uart_Fingerprint_ttySHL0;
                    }
                }
            }
        } else if (model.contains("C4000")) {
            model = "C4000_6577";
            uartPath = uart_mtk;
            uartPath_Fingerprint = "/dev/ttyMT0";
        } else if (model.contains("40006577")) {
            model = "C4000_6577";
            uartPath = uart_mtk;
            uartPath_Fingerprint = "/dev/ttyMT0";
        } else if (model.contains("40006582")) {
            model = "C4000_6582";
            uartPath = uart_mtk;
            uartPath_Fingerprint = "/dev/ttyMT0";
        } else if (model.contains("40506582")) {
            model = "C4050_6582";
            uartPath = uart_mtk;
            uartPath_Fingerprint = "/dev/ttyMT0";
        } else if (model.contains("40508909")) {
            model = "C4050_8909";
            uartPath = "/dev/ttyHSL1";
            uartPath_Fingerprint = "/dev/ttyHSL1";
        } else if (model.contains("60008909")) {
            model = "C6000_8909";
            uartPath = "/dev/ttyHSL1";
            uartPath_Fingerprint = "/dev/ttyHSL1";
        } else if (model.contains("6735")) {
            if (model.contains("6000")) {
                model = "C6000_6735";
                uartPath = uart_mtk_6735;
                uartPath_Fingerprint = "/dev/ttyMT0";
            } else if (model.contains("100")) {
                model = "H100_6735";
            } else if (model.contains("72")) {
                uartPath = uart_mtk;
                uartPath_Fingerprint = uart_mtk;
                model = "C72_6735";
            } else if (model.contains("70S") || model.contains("70E") || model.contains("70F")) {
                uartPath = uart_mtk;
                uartPath_Fingerprint = uart_mtk;
                model = "C70_6735";
            }
        } else if (model.contains("20151118")) {
            model = "C4050_8909";
            uartPath = "/dev/ttyHSL1";
            uartPath_Fingerprint = "/dev/ttyHSL1";
        } else {
            model = "C4000_6735";
            uartPath = uart_mtk;
            uartPath_Fingerprint = "/dev/ttyMT0";
        }
        Log.i((String)TAG, (String)String.format("model=%s,uartPath=%s,uartPath_Fingerprint=%s,uartPath_RFID=%s", model, uartPath, uartPath_Fingerprint, uartPath_RFID));
    }

    public static String getModel() {
        if (model.equals("i760")) {
            return "C4000";
        }
        Log.i((String)TAG, (String)("getModel() model=" + model));
        return model.toUpperCase();
    }

    public static DeviceConfiguration builder1DConfiguration() throws ConfigurationException {
        if (uartPath_1D != null && uartPath_1D.length() > 0) {
            return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath_1D, 9600);
        }
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 9600);
    }

    public static DeviceConfiguration builder2DConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath_2D, 9600);
    }

    public static DeviceConfiguration builderRFIDConfiguration() throws ConfigurationException {
        if (uartPath_RFID.isEmpty()) {
            return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 115200);
        }
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath_RFID, 115200);
    }

    public static DeviceConfiguration builderUHFConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 115200);
    }

    public static DeviceConfiguration builderPrinterConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 9600);
    }

    public static DeviceConfiguration builderFingerprintConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath_Fingerprint, 57600);
    }

    public static DeviceConfiguration builderLFConfiguration() throws ConfigurationException {
        Log.i((String)TAG, (String)("builderLFConfiguration() DeviceName:" + DeviceConfiguration.getModel() + " Uart=" + uartPath + " Baudrate=" + 115200));
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 115200);
    }

    public static DeviceConfiguration builderBDConfiguration() throws ConfigurationException {
        if (model.equals("CJ6008909")) {
            return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 9600);
        }
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uart_mtk_2, 9600);
    }

    public static DeviceConfiguration builderInfraredConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 1200);
    }

    public static DeviceConfiguration builderDefaultConfiguration() throws ConfigurationException {
        return new DeviceConfiguration(DeviceConfiguration.getModel(), uartPath, 115200);
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public void setUart(String uart) {
        this.uart = uart;
    }

    public void setBaudrate(int baudrate) {
        this.baudrate = baudrate;
    }

    private DeviceConfiguration(String deviceName, String uart, int baudrate) {
        this.deviceName = deviceName;
        this.uart = uart;
        this.baudrate = baudrate;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getUart() {
        return this.uart;
    }

    public int getBaudrate() {
        return this.baudrate;
    }

    public static int getPlatform() {
        if (CURRENT_PLATFORM != -1) {
            Log.i((String)TAG, (String)("CURRENT_PLATFORM=" + CURRENT_PLATFORM));
            return CURRENT_PLATFORM;
        }
        String deviceType = DeviceConfiguration.getModel();
        if (deviceType.contains("8953") || deviceType.contains("8909")) {
            Log.i((String)TAG, (String)"quacomm == true;");
            return 0;
        }
        Log.i((String)TAG, (String)"mtk == true;");
        return 1;
    }

    public static DeviceInfo getDeviceInfoFromFile() {
        String configPath = Environment.getExternalStorageDirectory() + File.separator + "PDAConfig.txt";
        Log.i((String)TAG, (String)("getDeviceInfoFromFile configPath=" + configPath));
        File file = new File(configPath);
        if (!file.exists()) {
            return null;
        }
        Properties prop = new Properties();
        FileInputStream fis = null;
        try {
            DeviceInfo deviceinfo = new DeviceInfo();
            fis = new FileInputStream(configPath);
            prop.load(fis);
            String model = prop.getProperty("model");
            if (model != null && !model.isEmpty()) {
                deviceinfo.setModel(model);
            }
            Log.i((String)TAG, (String)("getDeviceInfoFromFile====> model=" + model));
            String uart = prop.getProperty("uart");
            if (model != null && !model.isEmpty()) {
                deviceinfo.setUart(uart);
            }
            Log.i((String)TAG, (String)("getDeviceInfoFromFile====> uart=" + uart));
            DeviceInfo deviceInfo = deviceinfo;
            return deviceInfo;
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static boolean isAndroid90() {
        return Build.VERSION.SDK_INT == 28;
    }

    static class DeviceInfo {
        private String model;
        private String uart;

        DeviceInfo() {
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public String getUart() {
            return this.uart;
        }

        public void setUart(String uart) {
            this.uart = uart;
        }
    }
}

