/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.Device;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.utility.StringUtility;
import java.util.Arrays;

public class Fingerprint
extends Device {
    private static final String TAG = "Fingerprint";
    protected DeviceConfiguration config = DeviceConfiguration.builderFingerprintConfiguration();
    private static Fingerprint single = null;

    protected Fingerprint() throws ConfigurationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Fingerprint getInstance() throws ConfigurationException {
        if (single != null) return single;
        Class<Fingerprint> clazz = Fingerprint.class;
        synchronized (Fingerprint.class) {
            if (single != null) return single;
            single = new Fingerprint();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.getInstance();
    }

    public synchronized boolean init() {
        int result = this.getDeviceAPI().EMFingerInit(this.config.getDeviceName(), this.config.getUart(), this.config.getBaudrate());
        if (result > -1) {
            Log.i((String)TAG, (String)"init() succ");
            String v = this.getVersionString();
            Log.i((String)TAG, (String)("init version=" + v));
            if (v.contains("ChiponeICNT7183")) {
                this.getDeviceAPI().EMFingerMoudleSet(1);
                Log.i((String)TAG, (String)"init new fingerprint");
            }
            this.setPowerOn(true);
            return true;
        }
        Log.e((String)TAG, (String)("init() err:" + result));
        return false;
    }

    public synchronized boolean init(int baudrate) {
        int result = this.getDeviceAPI().EMFingerInit(this.config.getDeviceName(), this.config.getUart(), baudrate);
        if (result > -1) {
            Log.i((String)TAG, (String)("init(" + baudrate + ") succ"));
            String v = this.getVersionString();
            Log.i((String)TAG, (String)("init version=" + v));
            if (v.contains("ChiponeICNT7183")) {
                this.getDeviceAPI().EMFingerMoudleSet(1);
                Log.i((String)TAG, (String)"init new fingerprint");
            }
            this.setPowerOn(true);
            return true;
        }
        Log.e((String)TAG, (String)("init(" + baudrate + ")  err:" + result));
        return false;
    }

    public synchronized boolean free() {
        int result = this.getDeviceAPI().EMFingerFree(this.config.getDeviceName());
        if (result == 0) {
            Log.i((String)TAG, (String)"free() succ");
            this.setPowerOn(false);
            return true;
        }
        Log.e((String)TAG, (String)("free() err:" + result));
        return false;
    }

    public synchronized String getRandomData() {
        char[] result = this.getDeviceAPI().EMGetRandomData();
        if (result[0] == '\u0000') {
            char[] c = new char[result[1]];
            int i = 0;
            while (i < result[1]) {
                c[i] = result[i + 2];
                ++i;
            }
            return StringUtility.chars2HexString(c, c.length);
        }
        Log.e((String)TAG, (String)("getRandomData() err:" + Integer.valueOf(result[0])));
        return null;
    }

    public synchronized boolean getImage() {
        int result = this.getDeviceAPI().EMGetImage();
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("getImage() err:" + result));
        return false;
    }

    public synchronized boolean genChar(BufferEnum buffer) {
        int result = this.getDeviceAPI().EMGenChar(buffer.value);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("genChar() err:" + result));
        return false;
    }

    public synchronized int[] search(BufferEnum buffer, int startPage, int pageNum) {
        int[] iArr = new int[]{-1, -1};
        int[] result = this.getDeviceAPI().EMSearch(buffer.value, startPage, pageNum);
        if (result != null && result[0] == 0) {
            iArr[0] = result[1];
            iArr[1] = result[2];
            return iArr;
        }
        Log.e((String)TAG, (String)("search() err:" + Integer.valueOf(result[0])));
        return null;
    }

    public synchronized int match() {
        int[] result = this.getDeviceAPI().EMMatch();
        if (result != null && result[0] == 0) {
            return result[1];
        }
        Log.e((String)TAG, (String)("match() err:" + Integer.valueOf(result[0])));
        return -1;
    }

    public synchronized boolean regModel() {
        int result = this.getDeviceAPI().EMRegModel();
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("regModel() err:" + result));
        return false;
    }

    public synchronized boolean storChar(BufferEnum buffer, int pageID) {
        int result = this.getDeviceAPI().EMStorChar(buffer.value, pageID);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("storChar() err:" + result));
        return false;
    }

    public synchronized boolean loadChar(BufferEnum buffer, int pageID) {
        int result = this.getDeviceAPI().EMLoadChar(buffer.value, pageID);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("loadChar() err:" + result));
        return false;
    }

    public synchronized String upChar(BufferEnum buffer) {
        char[] result = this.getDeviceAPI().EMUpChar(buffer.value);
        Log.e((String)TAG, (String)("upChar() result[0]:" + Integer.toHexString(result[0]) + " result[1]:" + Integer.toHexString(result[1])));
        if (result[0] == '\u0000') {
            char[] c = new char[result.length - 1];
            int i = 0;
            while (i < c.length) {
                c[i] = result[i + 1];
                ++i;
            }
            return StringUtility.chars2HexString(c, c.length);
        }
        Log.e((String)TAG, (String)("upChar() err:" + Integer.valueOf(result[0])));
        return null;
    }

    public synchronized boolean downChar(BufferEnum buffer, String hexStr) {
        if (StringUtility.isEmpty(hexStr)) {
            return false;
        }
        if (!StringUtility.isHexNumber(hexStr)) {
            return false;
        }
        int result = this.getDeviceAPI().EMDownChar(buffer.value, StringUtility.hexString2Chars(hexStr));
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("downChar() err:" + result));
        return false;
    }

    public synchronized boolean deletChar(int pageID, int num) {
        int result = this.getDeviceAPI().EMDeletChar(pageID, num);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("deletChar() err:" + result));
        return false;
    }

    public synchronized boolean empty() {
        int result = this.getDeviceAPI().EMEmpty();
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("empty() err:" + result));
        return false;
    }

    public synchronized boolean setReg(int regID, int value) {
        int result = this.getDeviceAPI().EMSetReg(regID, value);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setReg() err:" + result));
        return false;
    }

    public synchronized int autoEnroll(int count, int userID) {
        int[] result = this.getDeviceAPI().EMAutoEnroll(count, userID);
        if (result[0] == 0) {
            return result[1];
        }
        Log.e((String)TAG, (String)("autoEnroll() err:" + Integer.valueOf(result[0])));
        return -1;
    }

    public synchronized int[] autoMatch(int count, int startPage, int pageNum) {
        int[] result = this.getDeviceAPI().EMAutoMatch(count, startPage, pageNum);
        int[] iArr = new int[]{-1, -1};
        if (result != null && result[0] == 0) {
            iArr[0] = result[1];
            iArr[1] = result[2];
            return iArr;
        }
        Log.e((String)TAG, (String)("autoMatch() err:" + Integer.valueOf(result[0])));
        return null;
    }

    public synchronized int validTempleteNum() {
        int[] result = this.getDeviceAPI().EMValidTempleteNum();
        if (result[0] == 0) {
            return result[1];
        }
        Log.e((String)TAG, (String)("validTempleteNum() err:" + Integer.valueOf(result[0])));
        return -1;
    }

    public synchronized String readChipSN() {
        char[] result = this.getDeviceAPI().EMReadChipSN();
        if (result[0] == '\u0000') {
            char[] c = new char[result[1]];
            int i = 0;
            while (i < result[1]) {
                c[i] = result[i + 2];
                ++i;
            }
            return StringUtility.chars2HexString(c, c.length);
        }
        Log.e((String)TAG, (String)("readChipSN() err:" + Integer.valueOf(result[0])));
        return null;
    }

    public synchronized boolean setManuFacture(String name) {
        if (StringUtility.isEmpty(name)) {
            return false;
        }
        char[] cname = StringUtility.hexString2Chars(name);
        int result = this.getDeviceAPI().EMSetManuFacture(cname);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setManuFacture() err:" + result));
        return false;
    }

    public synchronized boolean setDeviceName(String name) {
        if (StringUtility.isEmpty(name)) {
            return false;
        }
        char[] cname = StringUtility.hexString2Chars(name);
        int result = this.getDeviceAPI().EMSetDeviceName(cname);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setDeviceName() err:" + result));
        return false;
    }

    public synchronized String readSysPara() {
        char[] result = this.getDeviceAPI().EMReadSysPara();
        if (result[0] == '\u0000') {
            char[] c = new char[result[1]];
            int i = 0;
            while (i < result[1]) {
                c[i] = result[i + 2];
                ++i;
            }
            return StringUtility.chars2HexString(c, c.length);
        }
        Log.e((String)TAG, (String)("readSysPara() err:" + Integer.valueOf(result[0])));
        return null;
    }

    public synchronized String getVersion() {
        String[] result = this.readSysParaMore();
        if (result != null && result.length > 6) {
            return String.valueOf(result[4]) + result[5] + result[6];
        }
        Log.e((String)TAG, (String)("getVersion() err:" + Integer.valueOf(result[0])));
        return null;
    }

    private synchronized String getVersionString() {
        String v = this.getVersion();
        if (v != null && v.length() > 0) {
            char[] version = StringUtility.hexString2Chars(v);
            char[] tempV = new char[version.length];
            int len = 0;
            int k = 0;
            while (k < version.length) {
                if (version[k] > '\u001f') {
                    tempV[len++] = version[k];
                }
                ++k;
            }
            if (len > 0) {
                v = new String(tempV, 0, len);
                return v;
            }
        }
        return null;
    }

    public synchronized int upImage(int mode, String fileName) {
        int[] result = this.getDeviceAPI().EMUpImage(mode, fileName);
        if (result[0] == 0) {
            return result[1];
        }
        Log.e((String)TAG, (String)("upImage() err:" + Integer.valueOf(result[0])));
        return -1;
    }

    synchronized int upImageISO(int mode, String fileName) {
        int[] result = this.getDeviceAPI().EMUpImageISO(mode, fileName);
        if (result[0] == 0) {
            return result[1];
        }
        Log.e((String)TAG, (String)("upImage() err:" + Integer.valueOf(result[0])));
        return -1;
    }

    public boolean setPWD(String passWord) {
        if (StringUtility.isEmpty(passWord)) {
            return false;
        }
        char[] passWordArr = passWord.toCharArray();
        int result = this.getDeviceAPI().EMSetPSW(passWordArr);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setPWD() err:" + result));
        return false;
    }

    public boolean validPWD(String passWord) {
        if (StringUtility.isEmpty(passWord)) {
            return false;
        }
        char[] passWordArr = passWord.toCharArray();
        int result = this.getDeviceAPI().EMVfyPSW(passWordArr);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("validPWD() err:" + result));
        return false;
    }

    public synchronized String[] readSysParaMore() {
        char[] result = this.getDeviceAPI().EMReadSysParaMore();
        if (result == null) {
            Log.e((String)TAG, (String)"readSysParaMore() err: result == null");
            return null;
        }
        if (result[0] == '\u0000') {
            char[] securityLevel = Arrays.copyOfRange(result, 2, 3);
            char[] packetSize = Arrays.copyOfRange(result, 3, 4);
            char[] baudRate = Arrays.copyOfRange(result, 4, 5);
            char[] serialNumber = Arrays.copyOfRange(result, 5, 13);
            char[] version = Arrays.copyOfRange(result, 13, 21);
            char[] vendor = Arrays.copyOfRange(result, 21, 29);
            char[] sensor = Arrays.copyOfRange(result, 29, 37);
            String[] strArr = new String[]{StringUtility.chars2HexString(securityLevel, securityLevel.length), StringUtility.chars2HexString(packetSize, packetSize.length), StringUtility.chars2HexString(baudRate, baudRate.length), StringUtility.chars2HexString(serialNumber, serialNumber.length), StringUtility.chars2HexString(version, version.length), StringUtility.chars2HexString(vendor, vendor.length), StringUtility.chars2HexString(sensor, sensor.length)};
            int i = 0;
            while (i < strArr.length) {
                Log.i((String)TAG, (String)("readSysParaMore() strArr[" + i + "]=" + strArr[i]));
                ++i;
            }
            return strArr;
        }
        Log.e((String)TAG, (String)("readSysParaMore() err:" + Integer.valueOf(result[0])));
        return null;
    }

    public static enum BufferEnum {
        B1(1),
        B2(2),
        B11(17),
        B12(18);

        private final int value;

        public int getValue() {
            return this.value;
        }

        private BufferEnum(int value) {
            this.value = value;
        }
    }
}

