/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.rscja.deviceapi.Device;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.utility.StringUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;

public class FingerprintWithFIPS
extends Device {
    private static final String TAG = "FingerprintWithFIPS";
    private static boolean isDebug = false;
    protected DeviceConfiguration config;
    private Context mContext = null;
    private char mCount = '\u0000';
    private static FingerprintWithFIPS single = null;
    private int Put_finger = 12;
    private int Remove_finger = 15;
    private int PT_guimsg_enroll_progress = 46;
    private boolean isStop = true;
    private GRABCallBack grabCallBack = null;
    private PtCaptureCallBack ptCaptureCallBack = null;
    private EnrollCallBack enrollCallBack = null;
    private IdentificationCallBack identificationCallBack = null;
    private TemplateVerifyCallBack templateVerifyCallBack = null;
    private static boolean runing = false;
    private int iGRAB = 1;
    private int iENROLLL = 2;
    private int iPTCAPTURE = 3;
    private int iIDENTIFICATION = 4;
    private int iTEMPLATEVERIFY = 5;
    private int RESULT_STATUS_SUCCESS = 0;
    private int RESULT_STATUS_CANCEL = -2;
    private int RESULT_STATUS_FAILURE = -1;
    private int RESULT_STATUS_NO_MATCH = -3;
    private final int RESULT_PROGRESS = 3;
    private final int RESULT_MSG = 2;
    private final int RESULT_COMPLETE = 5;
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what == FingerprintWithFIPS.this.iGRAB) {
                if (FingerprintWithFIPS.this.grabCallBack == null) {
                    return;
                }
                switch (msg.arg1) {
                    case 5: {
                        if (msg.obj != null) {
                            FingerprintWithFIPS.this.grabCallBack.onComplete(true, (byte[])msg.obj, msg.arg2);
                            break;
                        }
                        FingerprintWithFIPS.this.grabCallBack.onComplete(false, null, msg.arg2);
                        break;
                    }
                    case 2: {
                        FingerprintWithFIPS.this.grabCallBack.messageInfo(msg.obj.toString());
                        break;
                    }
                    case 3: {
                        FingerprintWithFIPS.this.grabCallBack.progress(msg.arg2);
                    }
                }
            } else if (msg.what == FingerprintWithFIPS.this.iENROLLL) {
                if (FingerprintWithFIPS.this.enrollCallBack == null) {
                    return;
                }
                switch (msg.arg1) {
                    case 5: {
                        if (msg.obj != null) {
                            FingerprintWithFIPS.this.enrollCallBack.onComplete(true, (byte[])msg.obj, msg.arg2, msg.arg2 > 0 ? 0 : msg.arg2);
                            break;
                        }
                        FingerprintWithFIPS.this.enrollCallBack.onComplete(false, null, msg.arg2, msg.arg2 > 0 ? 0 : msg.arg2);
                        break;
                    }
                    case 2: {
                        FingerprintWithFIPS.this.enrollCallBack.messageInfo(msg.obj.toString());
                    }
                }
            } else if (msg.what == FingerprintWithFIPS.this.iPTCAPTURE) {
                if (FingerprintWithFIPS.this.ptCaptureCallBack == null) {
                    return;
                }
                switch (msg.arg1) {
                    case 5: {
                        if (msg.obj != null) {
                            FingerprintWithFIPS.this.ptCaptureCallBack.onComplete(true, (byte[])msg.obj, msg.arg2);
                            break;
                        }
                        FingerprintWithFIPS.this.ptCaptureCallBack.onComplete(false, null, msg.arg2);
                        break;
                    }
                    case 2: {
                        FingerprintWithFIPS.this.ptCaptureCallBack.messageInfo(msg.obj.toString());
                    }
                }
            } else if (msg.what == FingerprintWithFIPS.this.iIDENTIFICATION) {
                if (FingerprintWithFIPS.this.identificationCallBack == null) {
                    return;
                }
                switch (msg.arg1) {
                    case 2: {
                        FingerprintWithFIPS.this.identificationCallBack.messageInfo(msg.obj.toString());
                        break;
                    }
                    case 5: {
                        int fId = msg.arg2;
                        boolean isOK = fId >= 0;
                        FingerprintWithFIPS.this.identificationCallBack.onComplete(isOK, fId, fId > 0 ? 0 : fId);
                    }
                }
            } else if (msg.what == FingerprintWithFIPS.this.iTEMPLATEVERIFY) {
                if (FingerprintWithFIPS.this.templateVerifyCallBack == null) {
                    return;
                }
                switch (msg.arg1) {
                    case 2: {
                        FingerprintWithFIPS.this.templateVerifyCallBack.messageInfo(msg.obj.toString());
                        break;
                    }
                    case 5: {
                        int result = msg.arg2;
                        boolean b = result == 0;
                        FingerprintWithFIPS.this.templateVerifyCallBack.onComplete(b, result);
                    }
                }
            }
        }
    };

    protected FingerprintWithFIPS() throws ConfigurationException {
        this.config = DeviceConfiguration.builderFingerprintConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized FingerprintWithFIPS getInstance() throws ConfigurationException {
        if (single != null) return single;
        Class<FingerprintWithFIPS> clazz = FingerprintWithFIPS.class;
        synchronized (FingerprintWithFIPS.class) {
            if (single != null) return single;
            single = new FingerprintWithFIPS();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.getInstance();
    }

    public synchronized boolean init(Context mContext) {
        int result = this.getDeviceAPI().PTInit(this.config.getDeviceName(), this.config.getUart());
        this.mCount = '\u0000';
        this.mContext = mContext;
        if (result > -1) {
            Log.i((String)TAG, (String)"init() succ");
            this.setPowerOn(true);
            return true;
        }
        Log.e((String)TAG, (String)("init() err:" + result));
        return false;
    }

    public synchronized boolean init() {
        int result = this.getDeviceAPI().PTInit(this.config.getDeviceName(), this.config.getUart());
        this.mCount = '\u0000';
        if (result > -1) {
            Log.i((String)TAG, (String)"init() succ");
            this.setPowerOn(true);
            return true;
        }
        Log.e((String)TAG, (String)("init() err:" + result));
        return false;
    }

    public synchronized boolean free() {
        int result = this.getDeviceAPI().PTExit(this.config.getDeviceName());
        this.mCount = '\u0000';
        if (result == 0) {
            Log.i((String)TAG, (String)"free() succ");
            this.setPowerOn(false);
            return true;
        }
        Log.e((String)TAG, (String)("free() err:" + result));
        return false;
    }

    public synchronized int enroll() {
        return this.getDeviceAPI().PTEnroll(this.getCount());
    }

    public synchronized int verifyALL() {
        return this.getDeviceAPI().PTVerifyALL(this.getCount());
    }

    public synchronized int Verify(char[] data, int len) {
        Log.i((String)TAG, (String)"Verify(char[] data, int len)");
        return this.getDeviceAPI().PTVerify(this.getCount(), data, len);
    }

    public synchronized int deleteAllFingers() {
        return this.getDeviceAPI().PTDeleteAllFingers(this.getCount());
    }

    public synchronized int getFingersCount() {
        int iStatus = -1;
        byte[] result = this.getDeviceAPI().PTListAllFingers(this.getCount());
        byte[] status = Arrays.copyOfRange(result, 0, 4);
        iStatus = StringUtility.bytesToInt(status);
        if (iStatus == 0) {
            byte[] data = Arrays.copyOfRange(result, 8, 12);
            return StringUtility.bytesToInt(data);
        }
        return -1;
    }

    public synchronized int responseCancel() {
        return this.getDeviceAPI().PTGUICancel(this.getCount());
    }

    public synchronized byte[] responseContinue() {
        return this.getDeviceAPI().PTResponseContinue(this.getCount());
    }

    public synchronized int grab() {
        return this.getDeviceAPI().PTGrab(this.getCount());
    }

    public synchronized int ptCapture() {
        return this.getDeviceAPI().PTCapture(this.getCount());
    }

    public synchronized byte[] ptConvertTemplateEx(DataFormat jtarget_type, byte[] srcbuf, int jsrclen) {
        byte type = 16;
        if (jtarget_type == DataFormat.ANSI) {
            type = 16;
        } else if (jtarget_type == DataFormat.ISO_FMR) {
            type = 17;
        } else if (jtarget_type == DataFormat.ISO_FMC_NORMAL) {
            type = 18;
        } else if (jtarget_type == DataFormat.ISO_FMC_COMPACT) {
            type = 19;
        }
        byte[] result = this.getDeviceAPI().PTConvertTemplateEx((byte)this.getCount(), type, srcbuf, jsrclen);
        byte[] status = Arrays.copyOfRange(result, 0, 4);
        int iStatus = StringUtility.bytesToInt(status);
        if (iStatus == 0) {
            byte[] len = Arrays.copyOfRange(result, 4, 8);
            int length = StringUtility.bytesToInt(len);
            return Arrays.copyOfRange(result, 8, length + 8);
        }
        return null;
    }

    private synchronized char getCount() {
        this.mCount = (char)(this.mCount + '\u0001');
        if (this.mCount > '\u00ff') {
            this.mCount = '\u0000';
        }
        return this.mCount;
    }

    public synchronized FingerprintInfo getPTInfo() {
        FingerprintInfo info = new FingerprintInfo();
        byte[] result = this.getDeviceAPI().PTInfo(this.getCount());
        byte[] status = Arrays.copyOfRange(result, 0, 4);
        int iStatus = StringUtility.bytesToInt(status);
        if (iStatus == 0 && result.length >= 12) {
            byte[] version = Arrays.copyOfRange(result, 8, 12);
            if ((version[3] & 0xFF) == 5 && (version[2] & 0xFF) == 0) {
                info.setVersions("TCETC1(TCD58v3)");
            } else {
                int len = 4;
                byte[] temp = new byte[len];
                int k = 0;
                while (k <= len - 1) {
                    temp[k] = version[len - k];
                    ++k;
                }
                info.setVersions(StringUtility.bytes2HexString(temp));
            }
        }
        info.setId(this.getID());
        return info;
    }

    public boolean generateImg(byte[] data, String filePath) {
        if (data == null || data.length == 0) {
            return false;
        }
        if (filePath == null || filePath == "") {
            return false;
        }
        int imageWidth = 256;
        int imageHeight = data.length / imageWidth;
        int alignedWidth = imageWidth;
        byte[] header = new byte[1078];
        header[0] = 66;
        header[1] = 77;
        byte[] len = StringUtility.int2Bytes(data.length + header.length);
        int i = 0;
        while (i < 4) {
            header[2 + i] = len[3 - i];
            ++i;
        }
        header[6] = 0;
        header[7] = 0;
        header[8] = 0;
        header[9] = 0;
        byte[] offset = StringUtility.int2Bytes(1078);
        int i2 = 0;
        while (i2 < 4) {
            header[10 + i2] = offset[3 - i2];
            ++i2;
        }
        byte[] len2 = StringUtility.int2Bytes(40);
        int i3 = 0;
        while (i3 < 4) {
            header[14 + i3] = len2[3 - i3];
            ++i3;
        }
        byte[] widths = StringUtility.int2Bytes(imageWidth);
        int i4 = 0;
        while (i4 < 4) {
            header[18 + i4] = widths[3 - i4];
            ++i4;
        }
        byte[] heights = StringUtility.int2Bytes(imageHeight);
        int i5 = 0;
        while (i5 < 4) {
            header[22 + i5] = heights[3 - i5];
            ++i5;
        }
        header[26] = 1;
        header[27] = 0;
        header[28] = 8;
        header[29] = 0;
        header[30] = 0;
        header[31] = 0;
        header[32] = 0;
        header[33] = 0;
        int lenData = data.length;
        int i6 = 0;
        while (i6 < 4) {
            header[34 + i6] = 0;
            ++i6;
        }
        i6 = 0;
        while (i6 < 16) {
            header[38 + i6] = 0;
            ++i6;
        }
        i6 = 0;
        while (i6 < 256) {
            header[54 + i6 * 4] = (byte)i6;
            header[54 + i6 * 4 + 1] = (byte)i6;
            header[54 + i6 * 4 + 2] = (byte)i6;
            header[54 + i6 * 4 + 3] = 0;
            ++i6;
        }
        byte[] imgData = new byte[header.length + lenData];
        int i7 = 0;
        while (i7 < header.length) {
            imgData[i7] = header[i7];
            ++i7;
        }
        i7 = 0;
        while (i7 < imageHeight) {
            int j = 0;
            while (j < imageWidth) {
                imgData[1078 + i7 * alignedWidth + j] = data[lenData - (i7 + 1) * imageWidth + j];
                ++j;
            }
            ++i7;
        }
        this.writeFile(filePath, imgData);
        return true;
    }

    private void writeFile(String filepath, byte[] data) {
        OutputStream out = null;
        try {
            try {
                File file = new File(filepath);
                if (!file.exists()) {
                    file.createNewFile();
                }
                out = new FileOutputStream(file);
                try {
                    out.write(data, 0, data.length);
                }
                catch (IOException ex1) {
                    ex1.printStackTrace();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    out.close();
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    out.close();
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
            }
        }
    }

    public synchronized boolean setID(String hexID) {
        if (hexID == null || hexID.length() == 0) {
            return false;
        }
        if (!StringUtility.isHexNumberRex(hexID)) {
            return false;
        }
        char[] data = StringUtility.hexString2Chars(hexID);
        int reulst = this.getDeviceAPI().PTSetAppData(this.getCount(), data, (char)data.length);
        return reulst == 0;
    }

    public synchronized String getID() {
        int leng;
        byte[] result = this.getDeviceAPI().PTGetAppData(this.getCount());
        byte[] status = Arrays.copyOfRange(result, 0, 4);
        int iStatus = StringUtility.bytesToInt(status);
        if (iStatus == 0 && (leng = StringUtility.bytesToInt(Arrays.copyOfRange(result, 4, 8))) > 0) {
            byte[] buffID = Arrays.copyOfRange(result, 8, 8 + leng);
            String id = StringUtility.bytes2HexString(buffID);
            return id;
        }
        return "";
    }

    public synchronized void startPtCapture() {
        if (isDebug) {
            Log.i((String)TAG, (String)("StartPtCapture =>runing=" + runing + " ,isStop=" + this.isStop));
        }
        if (runing || !this.isStop) {
            this.sendMsg(202, this.iPTCAPTURE);
            return;
        }
        runing = true;
        new ThreadPtCapture().start();
    }

    public synchronized void startGRAB() {
        if (isDebug) {
            Log.i((String)TAG, (String)("StartGRAB =>runing=" + runing + " ,isStop=" + this.isStop));
        }
        if (runing || !this.isStop) {
            this.sendMsg(202, this.iGRAB);
            return;
        }
        runing = true;
        new ThreadGRAB().start();
    }

    public synchronized void startTemplateVerify(char[] template) {
        if (isDebug) {
            Log.i((String)TAG, (String)("StartTemplateVerify =>runing=" + runing + " ,isStop=" + this.isStop));
        }
        if (runing || !this.isStop) {
            this.sendMsg(202, this.iTEMPLATEVERIFY);
            return;
        }
        runing = true;
        new ThreadTemplateVerify(template).start();
    }

    public synchronized void startEnroll() {
        if (isDebug) {
            Log.i((String)TAG, (String)("StartEnroll =>runing=" + runing + " ,isStop=" + this.isStop));
        }
        if (runing || !this.isStop) {
            this.sendMsg(202, this.iENROLLL);
            return;
        }
        runing = true;
        new ThreadEnroll().start();
    }

    public synchronized void startIdentification() {
        if (isDebug) {
            Log.i((String)TAG, (String)("StartIdentification =>runing=" + runing + " ,isStop=" + this.isStop));
        }
        if (runing || !this.isStop) {
            this.sendMsg(202, this.iIDENTIFICATION);
            return;
        }
        runing = true;
        new ThreadIdentification().start();
    }

    public synchronized void stopGRAB() {
        runing = false;
    }

    public synchronized void stopEnroll() {
        runing = false;
    }

    public synchronized void stopPtCapture() {
        runing = false;
    }

    public synchronized void stopTemplateVerify() {
        runing = false;
    }

    public synchronized void stopIdentification() {
        runing = false;
    }

    public void setGrabCallBack(GRABCallBack callBack) {
        this.grabCallBack = callBack;
    }

    public void setEnrollCallBack(EnrollCallBack callBack) {
        this.enrollCallBack = callBack;
    }

    public void setPtCaptureCallBack(PtCaptureCallBack callBack) {
        this.ptCaptureCallBack = callBack;
    }

    public void setIdentificationCallBack(IdentificationCallBack callBack) {
        this.identificationCallBack = callBack;
    }

    public void setTemplateVerifyCallBack(TemplateVerifyCallBack callBack) {
        this.templateVerifyCallBack = callBack;
    }

    private boolean isCallBackNULL(int what) {
        if (what == this.iGRAB && this.grabCallBack == null) {
            if (isDebug) {
                Log.i((String)TAG, (String)"what==iGRAB && grabCallBack==null");
            }
            return true;
        }
        if (what == this.iENROLLL && this.enrollCallBack == null) {
            if (isDebug) {
                Log.i((String)TAG, (String)"what==iENROLLL && enrollCallBack==null");
            }
            return true;
        }
        if (what == this.iPTCAPTURE && this.ptCaptureCallBack == null) {
            if (isDebug) {
                Log.i((String)TAG, (String)"what==iPTCAPTURE && ptCaptureCallBack==null");
            }
            return true;
        }
        if (what == this.iIDENTIFICATION && this.identificationCallBack == null) {
            if (isDebug) {
                Log.i((String)TAG, (String)"what==iIDENTIFICATION && identificationCallBack==null");
            }
            return true;
        }
        if (what == this.iTEMPLATEVERIFY && this.templateVerifyCallBack == null) {
            if (isDebug) {
                Log.i((String)TAG, (String)"what==iTEMPLATEVERIFY && templateVerifyCallBack==null");
            }
            return true;
        }
        return false;
    }

    private void sendMsg(int msgg, int what) {
        if (this.isCallBackNULL(what)) {
            return;
        }
        if (isDebug) {
            Log.i((String)TAG, (String)("iStatus=" + msgg));
        }
        Message msg = Message.obtain();
        msg.arg1 = 2;
        msg.what = what;
        msg.obj = this.getStatusMsg(msgg);
        this.handler.sendMessage(msg);
    }

    private void sendComplete(int what, Object data, int arg2) {
        if (this.isCallBackNULL(what)) {
            return;
        }
        Message msg = Message.obtain();
        msg.arg1 = 5;
        msg.arg2 = arg2;
        msg.obj = data;
        msg.what = what;
        this.handler.sendMessage(msg);
    }

    private void sendProgress(int progress, int what) {
        if (this.isCallBackNULL(what)) {
            return;
        }
        if (isDebug) {
            Log.i((String)TAG, (String)("progress=" + progress));
        }
        Message msg = Message.obtain();
        msg.arg1 = 3;
        msg.arg2 = progress;
        msg.what = what;
        this.handler.sendMessage(msg);
    }

    private String getStatusMsg(int status) {
        switch (status) {
            case 0: {
                return "Completed";
            }
            case 48: {
                return "NO MATCH";
            }
            case 47: {
                return "Scanned good image";
            }
            case 1: {
                return "No finger detected";
            }
            case 2: {
                return "Finger image is too light";
            }
            case 3: {
                return "Finger is too dry";
            }
            case 4: {
                return "Finger image is too dark";
            }
            case 5: {
                return "Finger is too high";
            }
            case 6: {
                return "Finger is too low";
            }
            case 7: {
                return "Finger is too left";
            }
            case 8: {
                return "Finger is too right";
            }
            case 9: {
                return "Finger image is too small";
            }
            case 10: {
                return "Finger image is too strange";
            }
            case 11: {
                return "Finger has bad quality";
            }
            case 12: {
                return "Put finger";
            }
            case 13: {
                return "Put finger";
            }
            case 14: {
                return "Put finger";
            }
            case 15: {
                return "Remove finger";
            }
            case 16: {
                return "Consolidation failed";
            }
            case 17: {
                return "Consolidation succeed";
            }
            case 18: {
                return "Clean the sensor";
            }
            case 19: {
                return "Keep finger on the sensor";
            }
            case 20: {
                return "Non specific GUI start (not used now)";
            }
            case 21: {
                return "GUI start for verification";
            }
            case 22: {
                return "GUI start for enrollment";
            }
            case 23: {
                return "GUI start for finger detection";
            }
            case 24: {
                return "GUI finished without specification of success of biometric operation";
            }
            case 25: {
                return "GUI finished signaling success of biometric operation";
            }
            case 26: {
                return "GUI finished signaling failure of biometric operation";
            }
            case 27: {
                return "GUI start for sensor calibration";
            }
            case 28: {
                return "Finger was swiped too fast";
            }
            case 29: {
                return "Finger was too skewed during swipe";
            }
            case 30: {
                return "Finger swipe was too short";
            }
            case 31: {
                return "Touch sensor with finger";
            }
            case 32: {
                return "Image processing started";
            }
            case 33: {
                return "Finger swipe is in progress";
            }
            case 34: {
                return "Backward movement detected";
            }
            case 35: {
                return "Finger joint detected";
            }
            case 36: {
                return "Center finger and press harder";
            }
            case 37: {
                return "Image processing finished";
            }
            case 38: {
                return "Put finger 4th time";
            }
            case 39: {
                return "Put finger 5th time";
            }
            case 45: {
                return "Finger doesn't match";
            }
            case 46: {
                return "Signal progress of dynamic enrollment";
            }
            case 101: {
                return "Processing, please keep finger on the sensor";
            }
            case 201: {
                return "stop";
            }
            case 202: {
                return "Fingerprint module busy";
            }
        }
        return "Message codes\uff1a" + status;
    }

    @Deprecated
    public byte[] Encryption(byte[] originalBuf, int jdlen) {
        String strKey = this.getP();
        if (strKey == null || strKey.length() <= 0) {
            return null;
        }
        byte[] key = StringUtility.hexString2Bytes(strKey);
        return this.encryption_decryption(originalBuf, jdlen, (byte)0, key, key.length, 1);
    }

    @Deprecated
    public byte[] Encryption(byte[] originalBuf, int jdlen, String key) {
        if (key == null || key.length() < 0) {
            return null;
        }
        char[] c = key.toCharArray();
        byte[] keyBuff = new byte[c.length];
        int k = 0;
        while (k < c.length) {
            keyBuff[k] = (byte)c[k];
            ++k;
        }
        return this.encryption_decryption(originalBuf, jdlen, (byte)0, keyBuff, keyBuff.length, 0);
    }

    @Deprecated
    public byte[] decryption(byte[] originalBuf, int jdlen) {
        String strKey = this.getP();
        if (strKey == null || strKey.length() <= 0) {
            return null;
        }
        byte[] key = StringUtility.hexString2Bytes(strKey);
        return this.encryption_decryption(originalBuf, jdlen, (byte)1, key, key.length, 1);
    }

    @Deprecated
    public byte[] decryption(byte[] originalBuf, int jdlen, String key) {
        if (key == null || key.length() < 0) {
            return null;
        }
        char[] c = key.toCharArray();
        byte[] keyBuff = new byte[c.length];
        int k = 0;
        while (k < c.length) {
            keyBuff[k] = (byte)c[k];
            ++k;
        }
        return this.encryption_decryption(originalBuf, jdlen, (byte)1, keyBuff, keyBuff.length, 0);
    }

    @Deprecated
    public byte[] decryption(byte[] originalBuf, int jdlen, byte[] key) {
        if (key == null || key.length != 8) {
            return null;
        }
        return this.encryption_decryption(originalBuf, jdlen, (byte)1, key, key.length, 0);
    }

    private byte[] encryption_decryption(byte[] originalBuf, int jdlen, byte jmode, byte[] key, int keyLeng, int type) {
        byte[] data;
        if (originalBuf == null || jdlen <= 0 || key == null) {
            return null;
        }
        int remainder = jdlen % 8;
        if (remainder != 0) {
            byte[] temp = new byte[jdlen + (8 - remainder)];
            int k = 0;
            while (k < temp.length) {
                temp[k] = k < originalBuf.length ? originalBuf[k] : (byte)0;
                ++k;
            }
            data = type == 0 ? this.getDeviceAPI().fips_encryption_decryption(temp, temp.length, key, key.length, jmode) : this.getDeviceAPI().fips_encryption_decryption_EX(temp, temp.length, key, key.length, jmode, this.mContext, type);
        } else {
            data = type == 0 ? this.getDeviceAPI().fips_encryption_decryption(originalBuf, originalBuf.length, key, key.length, jmode) : this.getDeviceAPI().fips_encryption_decryption_EX(originalBuf, originalBuf.length, key, key.length, jmode, this.mContext, type);
        }
        if (data[0] == 0) {
            int end = data[1] * 256 + (data[2] & 0xFF) + 3;
            return Arrays.copyOfRange(data, 3, end);
        }
        return null;
    }

    private String getP() {
        String strResult = "";
        OutputStream outputStream = null;
        BufferedReader successResult = null;
        String cmd = "cat /sys/class/mmc_host/mmc*/mmc1:*/cid";
        try {
            try {
                Runtime runtime = Runtime.getRuntime();
                Process su = runtime.exec("sh");
                outputStream = su.getOutputStream();
                successResult = new BufferedReader(new InputStreamReader(su.getInputStream()));
                if (outputStream != null && successResult != null) {
                    outputStream.write(cmd.getBytes());
                    outputStream.write("\n".getBytes());
                    outputStream.flush();
                    outputStream.write("exit\n".getBytes());
                    String strid = successResult.readLine();
                    if (strid != null && strid.length() > 0) {
                        strResult = strid;
                    }
                }
            }
            catch (IOException e) {
                Log.d((String)TAG, (String)("IOException " + e.getMessage()));
                e.printStackTrace();
                try {
                    if (successResult != null) {
                        successResult.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (successResult != null) {
                    successResult.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return strResult;
    }

    public static enum DataFormat {
        ANSI,
        ISO_FMR,
        ISO_FMC_NORMAL,
        ISO_FMC_COMPACT;

    }

    public static interface EnrollCallBack {
        public void messageInfo(String var1);

        public void onComplete(boolean var1, byte[] var2, int var3, int var4);
    }

    public class FingerprintInfo {
        private String versions;
        private String id;

        public String getVersions() {
            return this.versions;
        }

        public void setVersions(String version) {
            this.versions = version;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static interface GRABCallBack {
        public void messageInfo(String var1);

        public void onComplete(boolean var1, byte[] var2, int var3);

        public void progress(int var1);
    }

    public static interface IdentificationCallBack {
        public void messageInfo(String var1);

        public void onComplete(boolean var1, int var2, int var3);
    }

    public static interface PtCaptureCallBack {
        public void messageInfo(String var1);

        public void onComplete(boolean var1, byte[] var2, int var3);
    }

    public static interface TemplateVerifyCallBack {
        public void messageInfo(String var1);

        public void onComplete(boolean var1, int var2);
    }

    class ThreadEnroll
    extends Thread {
        int id = -1;

        ThreadEnroll() {
        }

        @Override
        public void run() {
            FingerprintWithFIPS.this.isStop = false;
            byte[] data = this.getData();
            FingerprintWithFIPS.this.sendComplete(FingerprintWithFIPS.this.iENROLLL, data, this.id);
            FingerprintWithFIPS.this.isStop = true;
            runing = false;
        }

        private byte[] getData() {
            int iStatus = 0;
            this.id = -1;
            iStatus = FingerprintWithFIPS.this.enroll();
            FingerprintWithFIPS.this.sendMsg(iStatus, FingerprintWithFIPS.this.iENROLLL);
            do {
                byte[] result = FingerprintWithFIPS.this.responseContinue();
                byte[] status = Arrays.copyOfRange(result, 0, 4);
                iStatus = StringUtility.bytesToInt(status);
                FingerprintWithFIPS.this.sendMsg(iStatus, FingerprintWithFIPS.this.iENROLLL);
                if (iStatus == 0) {
                    this.id = StringUtility.bytesToInt(Arrays.copyOfRange(result, 8, 12));
                    int templateSize = StringUtility.bytesToInt(Arrays.copyOfRange(result, 4, 8));
                    byte[] template = Arrays.copyOfRange(result, 12, 12 + templateSize);
                    return template;
                }
                if (iStatus >= 0) continue;
                this.id = FingerprintWithFIPS.this.RESULT_STATUS_FAILURE;
                if (isDebug) {
                    Log.i((String)FingerprintWithFIPS.TAG, (String)"ThreadEnroll==>getData() \u91c7\u96c6\u5b8c\u6210 \u5931\u8d25");
                }
                FingerprintWithFIPS.this.responseCancel();
                FingerprintWithFIPS.this.responseCancel();
                return null;
            } while (runing);
            FingerprintWithFIPS.this.responseCancel();
            FingerprintWithFIPS.this.responseCancel();
            this.id = FingerprintWithFIPS.this.RESULT_STATUS_CANCEL;
            FingerprintWithFIPS.this.sendMsg(201, FingerprintWithFIPS.this.iENROLLL);
            return null;
        }
    }

    class ThreadGRAB
    extends Thread {
        int result_status = -1;

        ThreadGRAB() {
        }

        @Override
        public void run() {
            FingerprintWithFIPS.this.isStop = false;
            byte[] data = this.getData();
            FingerprintWithFIPS.this.sendComplete(FingerprintWithFIPS.this.iGRAB, data, this.result_status);
            FingerprintWithFIPS.this.isStop = true;
            runing = false;
        }

        private byte[] getData() {
            if (isDebug) {
                Log.i((String)FingerprintWithFIPS.TAG, (String)"ThreadGRAB==>getData()");
            }
            byte[] imgArray = new byte[100000];
            int imgLen = 0;
            int iStatus = 0;
            iStatus = FingerprintWithFIPS.this.grab();
            FingerprintWithFIPS.this.sendMsg(iStatus, FingerprintWithFIPS.this.iGRAB);
            FingerprintWithFIPS.this.sendProgress(0, FingerprintWithFIPS.this.iGRAB);
            do {
                byte[] result = FingerprintWithFIPS.this.responseContinue();
                byte[] status = Arrays.copyOfRange(result, 0, 4);
                iStatus = StringUtility.bytesToInt(status);
                FingerprintWithFIPS.this.sendMsg(iStatus, FingerprintWithFIPS.this.iGRAB);
                if (iStatus == 101) {
                    int templateSize = StringUtility.bytesToInt(Arrays.copyOfRange(result, 4, 8));
                    byte[] data = Arrays.copyOfRange(result, 8, 8 + templateSize);
                    int i = 0;
                    while (i < data.length) {
                        imgArray[imgLen] = data[i];
                        ++imgLen;
                        ++i;
                    }
                    float p = (float)imgLen / 95000.0f * 100.0f;
                    if (!(p > 0.0f)) continue;
                    FingerprintWithFIPS.this.sendProgress((int)p, FingerprintWithFIPS.this.iGRAB);
                    continue;
                }
                if (iStatus == 0) {
                    FingerprintWithFIPS.this.sendProgress(100, FingerprintWithFIPS.this.iGRAB);
                    this.result_status = FingerprintWithFIPS.this.RESULT_STATUS_SUCCESS;
                    return Arrays.copyOf(imgArray, imgLen);
                }
                if (iStatus < 0) {
                    FingerprintWithFIPS.this.responseCancel();
                    this.result_status = FingerprintWithFIPS.this.RESULT_STATUS_FAILURE;
                    return null;
                }
                if (iStatus == 47) continue;
                if (isDebug) {
                    Log.i((String)FingerprintWithFIPS.TAG, (String)"ThreadGRAB==>getData() \u91cd\u65b0\u91c7\u96c6\u56fe\u7247");
                }
                FingerprintWithFIPS.this.sendProgress(0, FingerprintWithFIPS.this.iGRAB);
                imgLen = 0;
            } while (runing);
            FingerprintWithFIPS.this.responseCancel();
            FingerprintWithFIPS.this.responseCancel();
            FingerprintWithFIPS.this.sendMsg(201, FingerprintWithFIPS.this.iGRAB);
            this.result_status = FingerprintWithFIPS.this.RESULT_STATUS_CANCEL;
            return null;
        }
    }

    class ThreadIdentification
    extends Thread {
        ThreadIdentification() {
        }

        @Override
        public void run() {
            FingerprintWithFIPS.this.isStop = false;
            int id = this.getData();
            if (isDebug && FingerprintWithFIPS.this.identificationCallBack == null) {
                Log.i((String)FingerprintWithFIPS.TAG, (String)"ThreadVerifyALL==>verifyALLCallBack==null");
            }
            FingerprintWithFIPS.this.sendComplete(FingerprintWithFIPS.this.iIDENTIFICATION, null, id);
            FingerprintWithFIPS.this.isStop = true;
            runing = false;
        }

        public int getData() {
            int iStatus = FingerprintWithFIPS.this.verifyALL();
            do {
                byte[] result = FingerprintWithFIPS.this.responseContinue();
                byte[] status = Arrays.copyOfRange(result, 0, 4);
                iStatus = StringUtility.bytesToInt(status);
                FingerprintWithFIPS.this.sendMsg(iStatus, FingerprintWithFIPS.this.iIDENTIFICATION);
                if (iStatus == 0) {
                    byte[] data = Arrays.copyOfRange(result, 8, 12);
                    int id = StringUtility.bytesToInt(data);
                    return id;
                }
                if (iStatus == 48) {
                    return FingerprintWithFIPS.this.RESULT_STATUS_NO_MATCH;
                }
                if (iStatus >= 0) continue;
                FingerprintWithFIPS.this.responseCancel();
                return FingerprintWithFIPS.this.RESULT_STATUS_FAILURE;
            } while (runing);
            FingerprintWithFIPS.this.responseCancel();
            FingerprintWithFIPS.this.responseCancel();
            FingerprintWithFIPS.this.sendMsg(201, FingerprintWithFIPS.this.iIDENTIFICATION);
            return FingerprintWithFIPS.this.RESULT_STATUS_CANCEL;
        }
    }

    class ThreadPtCapture
    extends Thread {
        int result_status = -1;

        ThreadPtCapture() {
        }

        @Override
        public void run() {
            FingerprintWithFIPS.this.isStop = false;
            byte[] data = this.getData();
            if (isDebug) {
                if (data == null) {
                    Log.i((String)FingerprintWithFIPS.TAG, (String)"ThreadPtCapture==>getData()==null");
                } else {
                    Log.i((String)FingerprintWithFIPS.TAG, (String)("ThreadPtCapture==>getData() data.len=" + data.length));
                }
                if (FingerprintWithFIPS.this.ptCaptureCallBack == null) {
                    Log.i((String)FingerprintWithFIPS.TAG, (String)"ThreadPtCapture==>ptCaptureCallBack==null");
                }
            }
            FingerprintWithFIPS.this.sendComplete(FingerprintWithFIPS.this.iPTCAPTURE, data, this.result_status);
            FingerprintWithFIPS.this.isStop = true;
            runing = false;
        }

        private byte[] getData() {
            int iStatus = 0;
            iStatus = FingerprintWithFIPS.this.ptCapture();
            FingerprintWithFIPS.this.sendMsg(iStatus, FingerprintWithFIPS.this.iPTCAPTURE);
            do {
                byte[] result = FingerprintWithFIPS.this.responseContinue();
                byte[] status = Arrays.copyOfRange(result, 0, 4);
                iStatus = StringUtility.bytesToInt(status);
                FingerprintWithFIPS.this.sendMsg(iStatus, FingerprintWithFIPS.this.iPTCAPTURE);
                if (iStatus == 0) {
                    if (result.length < 10) {
                        FingerprintWithFIPS.this.responseCancel();
                        this.result_status = FingerprintWithFIPS.this.RESULT_STATUS_FAILURE;
                        return null;
                    }
                    int templateSize = StringUtility.bytesToInt(Arrays.copyOfRange(result, 4, 8));
                    if (isDebug) {
                        Log.i((String)FingerprintWithFIPS.TAG, (String)("ThreadPtCapture==>getData() result.leng=" + result.length + " templateSize=" + templateSize));
                    }
                    byte[] template = Arrays.copyOfRange(result, 8, 8 + templateSize);
                    this.result_status = FingerprintWithFIPS.this.RESULT_STATUS_SUCCESS;
                    return template;
                }
                if (iStatus >= 0) continue;
                if (isDebug) {
                    Log.i((String)FingerprintWithFIPS.TAG, (String)"ThreadPtCapture==>getData() \u91c7\u96c6\u5b8c\u6210 \u5931\u8d25");
                }
                FingerprintWithFIPS.this.responseCancel();
                this.result_status = FingerprintWithFIPS.this.RESULT_STATUS_FAILURE;
                return null;
            } while (runing);
            FingerprintWithFIPS.this.responseCancel();
            FingerprintWithFIPS.this.responseCancel();
            FingerprintWithFIPS.this.sendMsg(201, FingerprintWithFIPS.this.iPTCAPTURE);
            this.result_status = FingerprintWithFIPS.this.RESULT_STATUS_CANCEL;
            return null;
        }
    }

    class ThreadTemplateVerify
    extends Thread {
        char[] template_data;

        public ThreadTemplateVerify(char[] template_data) {
            this.template_data = template_data;
        }

        @Override
        public void run() {
            FingerprintWithFIPS.this.isStop = false;
            int result = this.getData(this.template_data);
            if (isDebug && FingerprintWithFIPS.this.templateVerifyCallBack == null) {
                Log.i((String)FingerprintWithFIPS.TAG, (String)"ThreadTemplateVerify==>templateVerifyCallBack==null");
            }
            FingerprintWithFIPS.this.sendComplete(FingerprintWithFIPS.this.iTEMPLATEVERIFY, null, result);
            FingerprintWithFIPS.this.isStop = true;
            runing = false;
        }

        public int getData(char[] template_data) {
            int iStatus = FingerprintWithFIPS.this.Verify(template_data, template_data.length);
            do {
                byte[] result = FingerprintWithFIPS.this.responseContinue();
                byte[] status = Arrays.copyOfRange(result, 0, 4);
                iStatus = StringUtility.bytesToInt(status);
                FingerprintWithFIPS.this.sendMsg(iStatus, FingerprintWithFIPS.this.iTEMPLATEVERIFY);
                if (iStatus == 0) {
                    return FingerprintWithFIPS.this.RESULT_STATUS_SUCCESS;
                }
                if (iStatus == 48) {
                    return FingerprintWithFIPS.this.RESULT_STATUS_NO_MATCH;
                }
                if (iStatus >= 0) continue;
                FingerprintWithFIPS.this.responseCancel();
                return FingerprintWithFIPS.this.RESULT_STATUS_FAILURE;
            } while (runing);
            FingerprintWithFIPS.this.responseCancel();
            FingerprintWithFIPS.this.responseCancel();
            FingerprintWithFIPS.this.sendMsg(201, FingerprintWithFIPS.this.iTEMPLATEVERIFY);
            return FingerprintWithFIPS.this.RESULT_STATUS_CANCEL;
        }
    }
}

