/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.Device;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.utility.StringUtility;
import java.util.Arrays;

public class FingerprintWithZAZ
extends Device {
    private String TAG = "FingerprintWithZAZ";
    protected DeviceConfiguration config = DeviceConfiguration.builderFingerprintConfiguration();
    private static FingerprintWithZAZ single = null;

    protected FingerprintWithZAZ() throws ConfigurationException {
    }

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized FingerprintWithZAZ getInstance() throws ConfigurationException {
        if (single != null) return single;
        Class<FingerprintWithZAZ> clazz = FingerprintWithZAZ.class;
        synchronized (FingerprintWithZAZ.class) {
            if (single != null) return single;
            single = new FingerprintWithZAZ();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public synchronized boolean init() {
        int result = this.getDeviceAPI().ZAZFingerInit(this.config.getDeviceName(), this.config.getUart(), 115200);
        if (result == 0) {
            Log.i((String)this.TAG, (String)"ZAZFingerInit() succ");
            this.setPowerOn(true);
            return true;
        }
        Log.e((String)this.TAG, (String)("ZAZFingerInit() err:" + result));
        return false;
    }

    public boolean free() {
        int result = this.getDeviceAPI().ZAZFingerFree(this.config.getDeviceName());
        if (result == 0) {
            Log.i((String)this.TAG, (String)"free() succ");
            this.setPowerOn(false);
            return true;
        }
        Log.e((String)this.TAG, (String)("free() err:" + result));
        return false;
    }

    public boolean isConnection() {
        int result = this.getDeviceAPI().ZAZfingerTestConnection();
        return result == 0;
    }

    public int getImage(int[] outErrCode) {
        char[] result = this.getDeviceAPI().ZAZfingerGetImage();
        if (outErrCode != null && outErrCode.length > 0) {
            Arrays.fill(outErrCode, 0);
        }
        if (result[0] == '\u0000') {
            char imgQuality = result[2];
            Log.d((String)this.TAG, (String)("getImage() imgQuality:" + imgQuality));
            return imgQuality;
        }
        if (outErrCode != null && outErrCode.length > 0) {
            outErrCode[0] = result[0];
        }
        Log.e((String)this.TAG, (String)("getImage() err:" + result[0]));
        return -1;
    }

    public boolean verify(int templateId, BufferEnum buffer, int[] outTemplateID, int[] outUpStatus, int[] outErrCode) {
        char[] result;
        if (templateId < 0) {
            return false;
        }
        char[] ramBufferId = new char[2];
        ramBufferId[0] = (char)buffer.value;
        char[] templateIdBuff = new char[]{(char)(templateId & 0xFF), (char)(templateId >> 8 & 0xFF)};
        if (outErrCode != null && outErrCode.length > 0) {
            Arrays.fill(outErrCode, 0);
        }
        if ((result = this.getDeviceAPI().ZAZfingerVerify(templateIdBuff, ramBufferId))[0] == '\u0000') {
            if (outUpStatus != null && outUpStatus.length > 0) {
                Arrays.fill(outUpStatus, 0);
                outUpStatus[0] = result[4];
            }
            if (outTemplateID != null && outTemplateID.length > 0) {
                Arrays.fill(outTemplateID, 0);
                char b1 = result[2];
                char b2 = result[3];
                outTemplateID[0] = b1 | b2 << 8;
            }
            return true;
        }
        if (outErrCode != null && outErrCode.length > 0) {
            outErrCode[0] = result[0];
        }
        Log.e((String)this.TAG, (String)("verify() err:" + result[0]));
        return false;
    }

    public boolean search(BufferEnum ramBufferId, int templateIdStart, int templateIdEnd, int[] outTemplateID, int[] outUpStatus, int[] outErrCode) {
        if (templateIdStart < 0 || templateIdEnd < 0) {
            return false;
        }
        if (outErrCode != null && outErrCode.length > 0) {
            Arrays.fill(outErrCode, 0);
        }
        char[] templateIdBuff = new char[2];
        templateIdBuff[0] = (char)ramBufferId.value;
        char[] startBuff = new char[]{(char)(templateIdStart & 0xFF), (char)(templateIdStart >> 8 & 0xFF)};
        char[] endBuff = new char[]{(char)(templateIdEnd & 0xFF), (char)(templateIdEnd >> 8 & 0xFF)};
        char[] result = this.getDeviceAPI().ZAZfingerSearch(templateIdBuff, startBuff, endBuff);
        if (result[0] == '\u0000') {
            if (outUpStatus != null && outUpStatus.length > 0) {
                Arrays.fill(outUpStatus, 0);
                outUpStatus[0] = result[4];
            }
            if (outTemplateID != null && outTemplateID.length > 0) {
                Arrays.fill(outTemplateID, 0);
                char b1 = result[2];
                char b2 = result[3];
                outTemplateID[0] = b1 | b2 << 8;
            }
            return true;
        }
        if (outErrCode != null && outErrCode.length > 0) {
            outErrCode[0] = result[0];
        }
        Log.e((String)this.TAG, (String)("verify() err:" + result[0]));
        return false;
    }

    public boolean match(BufferEnum ramBufferId1, BufferEnum ramBufferId2, int[] outErrCode) {
        if (outErrCode != null && outErrCode.length > 0) {
            Arrays.fill(outErrCode, 0);
        }
        char[] templateIdBuff1 = new char[2];
        templateIdBuff1[0] = (char)ramBufferId1.value;
        char[] templateIdBuff2 = new char[2];
        templateIdBuff2[0] = (char)ramBufferId2.value;
        int result = this.getDeviceAPI().ZAZfingerMatch(templateIdBuff1, templateIdBuff2);
        if (result == 0) {
            return true;
        }
        if (outErrCode != null && outErrCode.length > 0) {
            outErrCode[0] = result;
        }
        return false;
    }

    public boolean merge(BufferEnum ramBufferId, int number, int[] outErrCode) {
        if (number != 2 && number != 3) {
            return false;
        }
        if (outErrCode != null && outErrCode.length > 0) {
            Arrays.fill(outErrCode, 0);
        }
        char[] templateIdBuff1 = new char[2];
        templateIdBuff1[0] = (char)ramBufferId.value;
        int result = this.getDeviceAPI().ZAZfingerMerge(templateIdBuff1, number);
        if (result == 0) {
            return true;
        }
        if (outErrCode != null && outErrCode.length > 0) {
            outErrCode[0] = result;
        }
        return false;
    }

    public boolean generate(BufferEnum ramBufferId, int[] outErrCode) {
        int result;
        char[] templateIdBuff1 = new char[2];
        templateIdBuff1[0] = (char)ramBufferId.value;
        if (outErrCode != null && outErrCode.length > 0) {
            Arrays.fill(outErrCode, 0);
        }
        if ((result = this.getDeviceAPI().ZAZfingerGenerate(templateIdBuff1)) == 0) {
            return true;
        }
        if (outErrCode != null && outErrCode.length > 0) {
            outErrCode[0] = result;
        }
        return false;
    }

    public boolean getEnrollCount(int templateIdStart, int templateIdEnd, int[] outEnrollCount) {
        if (templateIdStart < 0 || templateIdEnd < 0) {
            return false;
        }
        char[] startBuff = new char[]{(char)(templateIdStart & 0xFF), (char)(templateIdStart >> 8 & 0xFF)};
        char[] endBuff = new char[]{(char)(templateIdEnd & 0xFF), (char)(templateIdEnd >> 8 & 0xFF)};
        char[] result = this.getDeviceAPI().ZAZfingerGetEnrollCount(startBuff, endBuff);
        if (result[0] == '\u0000') {
            if (outEnrollCount != null && outEnrollCount.length > 0) {
                Arrays.fill(outEnrollCount, 0);
                char b1 = result[2];
                char b2 = result[3];
                outEnrollCount[0] = b1 | b2 << 8;
            }
            return true;
        }
        return false;
    }

    public boolean getBrokenId(int templateIdStart, int templateIdEnd, int[] outBrokenId) {
        if (templateIdStart < 0 || templateIdEnd < 0) {
            return false;
        }
        char[] startBuff = new char[]{(char)(templateIdStart & 0xFF), (char)(templateIdStart >> 8 & 0xFF)};
        char[] endBuff = new char[]{(char)(templateIdEnd & 0xFF), (char)(templateIdEnd >> 8 & 0xFF)};
        char[] result = this.getDeviceAPI().ZAZfingerGetBrokenId(startBuff, endBuff);
        if (result[0] == '\u0000') {
            if (outBrokenId != null && outBrokenId.length > 1) {
                Arrays.fill(outBrokenId, 0);
                char b1 = result[2];
                char b2 = result[3];
                b1 = result[4];
                b2 = result[5];
                outBrokenId[0] = b1 | b2 << 8;
                outBrokenId[1] = b1 | b2 << 8;
            }
            return true;
        }
        return false;
    }

    public boolean exists(int templateId) {
        if (templateId < 0) {
            return false;
        }
        char[] id = new char[]{(char)(templateId & 0xFF), (char)(templateId >> 8 & 0xFF)};
        char[] result = this.getDeviceAPI().ZAZfingerGetStatus(id);
        if (result[0] == '\u0000') {
            return result[2] == '\u0001';
        }
        return false;
    }

    public int getEmptyId(int templateIdStart, int templateIdEnd) {
        if (templateIdStart < 0 || templateIdEnd < 0) {
            return -1;
        }
        char[] startBuff = new char[]{(char)(templateIdStart & 0xFF), (char)(templateIdStart >> 8 & 0xFF)};
        char[] endBuff = new char[]{(char)(templateIdEnd & 0xFF), (char)(templateIdEnd >> 8 & 0xFF)};
        char[] result = this.getDeviceAPI().ZAZfingerGetEmptyId(startBuff, endBuff);
        if (result[0] == '\u0000') {
            char b1 = result[2];
            char b2 = result[3];
            return b1 | b2 << 8;
        }
        return -1;
    }

    public boolean delete(int templateIdStart, int templateIdEnd) {
        if (templateIdStart < 0 || templateIdEnd < 0) {
            return false;
        }
        char[] startBuff = new char[]{(char)(templateIdStart & 0xFF), (char)(templateIdStart >> 8 & 0xFF)};
        char[] endBuff = new char[]{(char)(templateIdEnd & 0xFF), (char)(templateIdEnd >> 8 & 0xFF)};
        int result = this.getDeviceAPI().ZAZfingerDelChar(startBuff, endBuff);
        return result == 0;
    }

    public boolean loadChar(int templateIdStart, BufferEnum ramBufferId, int[] outErrCode) {
        if (templateIdStart < 0) {
            return false;
        }
        if (outErrCode != null && outErrCode.length > 0) {
            Arrays.fill(outErrCode, 0);
        }
        char[] startBuff = new char[]{(char)(templateIdStart & 0xFF), (char)(templateIdStart >> 8 & 0xFF)};
        char[] ramID = new char[2];
        ramID[0] = (char)ramBufferId.value;
        int result = this.getDeviceAPI().ZAZfingerLoadChar(startBuff, ramID);
        if (result == 0) {
            return true;
        }
        if (outErrCode != null && outErrCode.length > 0) {
            outErrCode[0] = result;
        }
        return false;
    }

    public boolean storeChar(int templateId, BufferEnum ramBufferId, int[] outErrCode) {
        int result;
        if (templateId < 0) {
            return false;
        }
        char[] tempId = new char[]{(char)(templateId & 0xFF), (char)(templateId >> 8 & 0xFF)};
        char[] ramID = new char[2];
        ramID[0] = (char)ramBufferId.value;
        if (outErrCode != null && outErrCode.length > 0) {
            Arrays.fill(outErrCode, 0);
        }
        if ((result = this.getDeviceAPI().ZAZfingerStoreChar(tempId, ramID)) == 0) {
            return true;
        }
        if (outErrCode != null && outErrCode.length > 0) {
            outErrCode[0] = result;
        }
        return false;
    }

    public boolean setParam(int type, int value, int[] outErrCode) {
        if (type < 0 || type > 8) {
            return false;
        }
        switch (type) {
            case 0: {
                if (value < 1 || value > 255) {
                    return false;
                }
            }
            case 1: {
                if (value < 0 || value > 1) {
                    return false;
                }
            }
            case 2: {
                if (value < 1 || value > 8) {
                    return false;
                }
            }
            case 3: {
                if (value < 0 || value > 1) {
                    return false;
                }
            }
            case 4: {
                if (value < 0 || value > 1) {
                    return false;
                }
            }
            case 5: {
                if (value < 0 || value > 100) {
                    return false;
                }
            }
            case 6: {
                if (value < 0 || value > 100) {
                    return false;
                }
            }
            case 7: {
                if (value < 0 || value > 100) {
                    return false;
                }
            }
            case 8: {
                if (value >= 0 && value <= 2) break;
                return false;
            }
        }
        if (outErrCode != null && outErrCode.length > 0) {
            Arrays.fill(outErrCode, 0);
        }
        char[] values = new char[4];
        values[0] = (char)value;
        int result = this.getDeviceAPI().ZAZfingerSetParam(type, values);
        if (result == 0) {
            return true;
        }
        if (outErrCode != null && outErrCode.length > 0) {
            outErrCode[0] = result;
        }
        return false;
    }

    public int getParam(int type) {
        if (type < 0 || type > 8) {
            return -1;
        }
        char[] result = this.getDeviceAPI().ZAZfingerReadParam(type);
        if (result[0] == '\u0000') {
            char value = result[2];
            return value;
        }
        return -2;
    }

    public String getDeviceInfo() {
        char[] result = this.getDeviceAPI().ZAZfingerDeviceInfo();
        if (result[0] == '\u0000') {
            char[] data = Arrays.copyOfRange(result, 2, result[1] + 2);
            return new String(data);
        }
        return null;
    }

    public int upImageData(int imageMode, String lpFileName, int[] outErrCode) {
        int[] result;
        if (imageMode < 0 || imageMode > 1 || lpFileName == null) {
            return -1;
        }
        if (outErrCode != null && outErrCode.length > 0) {
            Arrays.fill(outErrCode, 0);
        }
        if ((result = this.getDeviceAPI().ZAZfingerUpImage(imageMode, lpFileName))[0] == 0) {
            return result[2];
        }
        if (outErrCode != null && outErrCode.length > 0) {
            outErrCode[0] = result[0];
        }
        return -2;
    }

    private boolean startDownImage(int[] outErrCode) {
        int result;
        int imageWidth = 208;
        int imageHeight = 288;
        if (imageWidth <= 0 || imageHeight <= 0) {
            return false;
        }
        char[] charW = new char[]{(char)(imageWidth & 0xFF), (char)(imageWidth >> 8 & 0xFF)};
        char[] charH = new char[]{(char)(imageHeight & 0xFF), (char)(imageHeight >> 8 & 0xFF)};
        if (outErrCode != null && outErrCode.length > 0) {
            Arrays.fill(outErrCode, 0);
        }
        if ((result = this.getDeviceAPI().ZAZfingerDownImageStart(charW, charH)) == 0) {
            return true;
        }
        if (outErrCode != null && outErrCode.length > 0) {
            outErrCode[0] = result;
        }
        return false;
    }

    public boolean downImageData(int imageBlockNumber, byte[] imageData, int[] outErrCode) {
        if (imageBlockNumber < 0 || imageBlockNumber > 116) {
            return false;
        }
        if (imageData == null || imageData.length != 512) {
            return false;
        }
        char[] data = StringUtility.bytesTochars(imageData, imageData.length);
        if (outErrCode != null && outErrCode.length > 0) {
            Arrays.fill(outErrCode, 0);
        }
        if (imageBlockNumber == 0 && !this.startDownImage(outErrCode)) {
            return false;
        }
        char[] charBlock = new char[]{(char)(imageBlockNumber & 0xFF), (char)(imageBlockNumber >> 8 & 0xFF)};
        int result = this.getDeviceAPI().ZAZfingerDownImageData(charBlock, data);
        if (result == 0) {
            return true;
        }
        if (outErrCode != null && outErrCode.length > 0) {
            outErrCode[0] = result;
        }
        return false;
    }

    public boolean sledCtrl(boolean on) {
        int result = this.getDeviceAPI().ZAZfingerSledCtrl(on ? 1 : 0);
        return result == 0;
    }

    public byte[] upChar(BufferEnum ramBufferId, int[] outErrCode) {
        char[] result;
        char[] buff = new char[2];
        buff[0] = (char)ramBufferId.value;
        if (outErrCode != null && outErrCode.length > 0) {
            Arrays.fill(outErrCode, 0);
        }
        if ((result = this.getDeviceAPI().ZAZfingerUpChar(buff))[0] == '\u0000') {
            char[] data = Arrays.copyOfRange(result, 2, 1026);
            byte[] rData = new byte[data.length];
            int k = 0;
            while (k < data.length) {
                rData[k] = (byte)data[k];
                ++k;
            }
            return rData;
        }
        if (outErrCode != null && outErrCode.length > 0) {
            outErrCode[0] = result[0];
        }
        return null;
    }

    public boolean downChar(BufferEnum ramBufferId, byte[] templateData, int[] outErrCode) {
        int result;
        if (templateData == null || templateData.length != 1024) {
            return false;
        }
        char[] data = StringUtility.bytesTochars(templateData, templateData.length);
        char[] buff = new char[2];
        buff[0] = (char)ramBufferId.value;
        char[] templateSize = new char[2];
        int len = data.length;
        templateSize[0] = (char)(len & 0xFF);
        templateSize[1] = (char)(len >> 8 & 0xFF);
        if (outErrCode != null && outErrCode.length > 0) {
            Arrays.fill(outErrCode, 0);
        }
        if ((result = this.getDeviceAPI().ZAZfingerDownChar(templateSize, buff, data)) == 0) {
            return true;
        }
        if (outErrCode != null && outErrCode.length > 0) {
            outErrCode[0] = result;
        }
        return false;
    }

    public String getErrorMsg(int errCode) {
        switch (errCode) {
            case -100: {
                return "ERR_FAlL";
            }
            case -16: {
                return "ERR_VERIFY";
            }
            case -17: {
                return "ERR_IDENTIFY";
            }
            case -18: {
                return "ERR_TMPL_EMPTY";
            }
            case -19: {
                return "ERR_TMPL_NOT_EMPTY";
            }
            case -20: {
                return "ERR_ALL_TMPL_EMPTY";
            }
            case -21: {
                return "ERR_EMPTY_ID_NOEXIST";
            }
            case -22: {
                return "ERR_BROKEN_ID_NOEXIST";
            }
            case -23: {
                return "ERR_INVALID_TMPL_DATA";
            }
            case -24: {
                return "ERR_DUPLICATION_ID";
            }
            case -25: {
                return "ERR_BAD_QUALITY";
            }
            case -26: {
                return "ERR_MERGE_FAIL";
            }
            case -28: {
                return "ERR_MEMORY";
            }
            case -29: {
                return "ERR_INVALID_TMPL_NO";
            }
            case -34: {
                return "ERR_INVALLD_PARAM";
            }
            case -37: {
                return "ERR_GEN_COUNT";
            }
            case -38: {
                return "ERR_INVALID_BUFFER_ID";
            }
            case -40: {
                return "ERR_FP_NOT_DETECTED";
            }
            case -48: {
                return "ERR_FP_SMALL_AREA";
            }
            case -49: {
                return "ERR_FP_WET_FINGER";
            }
            case -50: {
                return "ERR_FP_DRY_FINGER";
            }
        }
        return String.valueOf(errCode);
    }

    public static enum BufferEnum {
        B0(0),
        B1(1),
        B2(2);

        private final int value;

        public int getValue() {
            return this.value;
        }

        private BufferEnum(int value) {
            this.value = value;
        }
    }
}

