/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.RFIDWithUHFUART;
import com.rscja.deviceapi.exception.ConfigurationException;

public class RFIDWithUHFA8
extends RFIDWithUHFUART {
    private String TAG = "DeviceAPI_RFIDWithUHFA8";
    private static RFIDWithUHFA8 single = null;
    private NotifyThread notifyThread = null;
    private boolean isRun = false;
    private final int ON = 1;
    private final int OFF = 0;
    private final int LED_SCAN = 101;
    private final int BUZZER = 102;
    private final int SNIFF = 103;
    private int notifyTime = 50;
    private int interval = 50;

    protected RFIDWithUHFA8() throws ConfigurationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized RFIDWithUHFA8 getInstance() throws ConfigurationException {
        if (single != null) return single;
        Class<RFIDWithUHFA8> clazz = RFIDWithUHFA8.class;
        synchronized (RFIDWithUHFA8.class) {
            if (single != null) return single;
            single = new RFIDWithUHFA8();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    @Override
    public synchronized boolean init() {
        int result = this.getDeviceAPI().UHFInit(this.config.getDeviceName());
        if (result > -1) {
            result = this.getDeviceAPI().UHFOpenAndConnect(this.config.getUart());
            Log.i((String)this.TAG, (String)("init() Uart = " + this.config.getUart()));
            if (result > -1) {
                this.initLed();
                this.setPowerOn(true);
                return true;
            }
        } else {
            Log.e((String)this.TAG, (String)("init() err UHFInit result:" + result));
        }
        return false;
    }

    @Override
    public synchronized boolean free() {
        this.freeSuccessNotify();
        return super.free();
    }

    public synchronized int[] getANT() {
        int size = 8;
        char[] result = DeviceAPI.getInstance().UHFGetANT();
        if (result[0] == '\u0000') {
            int ant = (result[1] & 0xFF) << 8 | result[2] & 0xFF;
            int[] antArray = new int[size];
            antArray[0] = ant & 1;
            antArray[1] = (ant & 2) > 0 ? 1 : 0;
            antArray[2] = (ant & 4) > 0 ? 1 : 0;
            antArray[3] = (ant & 8) > 0 ? 1 : 0;
            antArray[4] = (ant & 0x10) > 0 ? 1 : 0;
            antArray[5] = (ant & 0x20) > 0 ? 1 : 0;
            antArray[6] = (ant & 0x40) > 0 ? 1 : 0;
            antArray[7] = (ant & 0x80) > 0 ? 1 : 0;
            StringBuilder sb = new StringBuilder();
            sb.append("antArray[0]=" + antArray[0]);
            sb.append(",antArray[1]=" + antArray[1]);
            sb.append(",antArray[2]=" + antArray[2]);
            sb.append(",antArray[3]=" + antArray[3]);
            sb.append(",antArray[4]=" + antArray[4]);
            sb.append(",antArray[5]=" + antArray[5]);
            sb.append(",antArray[6]=" + antArray[6]);
            sb.append(",antArray[7]=" + antArray[7]);
            Log.i((String)this.TAG, (String)("getANT() ant=" + ant + "  ," + sb.toString()));
            return antArray;
        }
        Log.i((String)this.TAG, (String)("getANT() err:" + result[0]));
        return null;
    }

    public synchronized boolean setANT(int[] ant) {
        if (ant == null || ant.length == 0) {
            return false;
        }
        int leng = ant.length > 16 ? 16 : ant.length;
        int temp = 0;
        int k = 0;
        while (k < leng) {
            if (ant[k] == 1) {
                temp = k == 0 ? (temp |= 1) : (k == 1 ? (temp |= 2) : (temp |= 2 << k - 1));
            }
            ++k;
        }
        Log.i((String)this.TAG, (String)("SetANT() temp=" + temp));
        char[] buff = new char[]{(char)((char)(temp >> 8) & 0xFF), (char)(temp & 0xFF)};
        int result = DeviceAPI.getInstance().UHFSetANT(1, buff);
        if (result == 0) {
            int k2 = 0;
            while (k2 < ant.length) {
                this.antLedSwitch(k2 + 1, ant[k2] == 1);
                ++k2;
            }
            return true;
        }
        return false;
    }

    public void successNotify() {
        this.blink(100, 20);
    }

    private void openSuccessNotify() {
        Log.d((String)this.TAG, (String)"--openSuccessNotify--");
        DeviceAPI.getInstance().UHFLedOnOff(this.config.getDeviceName(), 102, 1);
        DeviceAPI.getInstance().UHFLedOnOff(this.config.getDeviceName(), 101, 1);
    }

    private void closeSuccessNotify() {
        Log.d((String)this.TAG, (String)"--closeSuccessNotify--");
        DeviceAPI.getInstance().UHFLedOnOff(this.config.getDeviceName(), 102, 0);
        DeviceAPI.getInstance().UHFLedOnOff(this.config.getDeviceName(), 101, 0);
    }

    private void sniffLed(boolean isOn) {
        Log.d((String)this.TAG, (String)"--sniffLed--");
        if (isOn) {
            DeviceAPI.getInstance().UHFLedOnOff(this.config.getDeviceName(), 103, 1);
        } else {
            DeviceAPI.getInstance().UHFLedOnOff(this.config.getDeviceName(), 103, 0);
        }
    }

    private void freeSuccessNotify() {
        if (DeviceConfiguration.getModel().equals(DeviceConfiguration.A8_8909)) {
            if (this.notifyThread != null) {
                this.notifyThread.stopThread();
                this.notifyThread = null;
            }
            this.sniffLed(false);
            this.closeSuccessNotify();
            int k = 1;
            while (k <= 8) {
                this.antLedSwitch(k, false);
                ++k;
            }
        }
    }

    private void antLedSwitch(int ant, boolean isOn) {
        Log.i((String)this.TAG, (String)("SetANT() ant=" + ant + ",isOn=" + isOn + "  " + this.config.getDeviceName()));
        if (ant >= 1 && ant <= 8) {
            DeviceAPI.getInstance().UHFLedOnOff(this.config.getDeviceName(), ant, isOn ? 1 : 0);
        }
    }

    private void blink(int notifyTime, int interval) {
        if (DeviceConfiguration.getModel().equals(DeviceConfiguration.A8_8909)) {
            if (interval < 20) {
                interval = 20;
            }
            if (notifyTime < 20) {
                notifyTime = 20;
            }
            this.notifyTime = notifyTime;
            this.interval = interval;
            Log.d((String)this.TAG, (String)("blink  notifyTime=" + notifyTime + "  interval=" + interval));
            if (this.notifyThread == null) {
                Log.d((String)this.TAG, (String)"--notifyThread.start()----");
                this.isRun = true;
                this.notifyThread = new NotifyThread();
                this.notifyThread.start();
            }
            this.notifyThread.activatorNotify();
        }
    }

    private void initLed() {
        this.sniffLed(true);
        if (DeviceConfiguration.getModel().equals(DeviceConfiguration.A8_8909)) {
            int[] antStatus = this.getANT();
            int k = 0;
            while (k < antStatus.length) {
                if (antStatus[k] == 1) {
                    this.antLedSwitch(k + 1, true);
                } else {
                    this.antLedSwitch(k + 1, false);
                }
                ++k;
            }
        }
    }

    public static /* bridge */ /* synthetic */ RFIDWithUHFUART getInstance() throws ConfigurationException {
        return RFIDWithUHFA8.getInstance();
    }

    private class NotifyThread
    extends Thread {
        private long endtime = 0L;
        private Object object = new Object();
        private boolean isPlay = false;

        private NotifyThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (RFIDWithUHFA8.this.isRun) {
                try {
                    if (this.isPlay && System.currentTimeMillis() - this.endtime >= (long)RFIDWithUHFA8.this.interval) {
                        RFIDWithUHFA8.this.openSuccessNotify();
                        Thread.sleep(RFIDWithUHFA8.this.notifyTime);
                        RFIDWithUHFA8.this.closeSuccessNotify();
                        this.endtime = System.currentTimeMillis();
                        this.isPlay = false;
                    }
                    Object object = this.object;
                    synchronized (object) {
                        this.object.wait(10L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void activatorNotify() {
            this.isPlay = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopThread() {
            this.isPlay = false;
            RFIDWithUHFA8.this.isRun = false;
            Object object = this.object;
            synchronized (object) {
                this.object.notifyAll();
            }
        }
    }
}

