/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.BluetoothReader;
import com.rscja.deviceapi.entity.UHFTAGInfo;
import com.rscja.deviceapi.interfaces.IUHF;
import com.rscja.deviceapi.interfaces.IUhfReader;
import com.rscja.utility.StringUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RFIDWithUHFBLE
extends BluetoothReader
implements IUHF,
IUhfReader {
    private final String TAG = "DeviceAPI_RFIDWithUHFBLE";
    private List<UHFTAGInfo> TempTagList = null;
    private final char UPDATE_UHF = '\u0001';
    private final char UPDATE_STM32 = '\u0000';
    protected final int InventoryTimeOut = 600;
    private static RFIDWithUHFBLE single = null;

    private RFIDWithUHFBLE() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized RFIDWithUHFBLE getInstance() {
        if (single != null) return single;
        Class<RFIDWithUHFBLE> clazz = RFIDWithUHFBLE.class;
        synchronized (RFIDWithUHFBLE.class) {
            if (single != null) return single;
            single = new RFIDWithUHFBLE();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    @Override
    public String getVersion() {
        byte[] sendData = this.uhfProtocolParse.getVersionSendData();
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseVersionData(inData);
        }
        return null;
    }

    @Override
    public int getPower() {
        byte[] sendData = this.uhfProtocolParse.getPowerSendData();
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseGetPowerData(inData);
        }
        return -1;
    }

    @Override
    public boolean setPower(int power) {
        byte[] sendData = this.uhfProtocolParse.setPowerSendData(power);
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSetPowerData(inData);
        }
        return false;
    }

    @Override
    public int getFrequencyMode() {
        byte[] sendData = this.uhfProtocolParse.getFrequencyModeSendData();
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseGetFrequencyModeData(inData);
        }
        return -1;
    }

    @Override
    public boolean setFrequencyMode(int freMode) {
        byte[] sendData = this.uhfProtocolParse.setFrequencyModeSendData(freMode);
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSetFrequencyModeData(inData);
        }
        return false;
    }

    @Override
    public boolean startInventoryTag() {
        this.TempTagList = null;
        byte[] sendData = this.uhfProtocolParse.getStartInventoryTagSendData();
        byte[] inData = this.getBTReceiveData(sendData, 10);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public synchronized UHFTAGInfo readTagFromBuffer() {
        if (this.TempTagList != null && this.TempTagList.size() > 0) {
            UHFTAGInfo info = this.TempTagList.get(0);
            this.TempTagList.remove(0);
            return info;
        }
        this.TempTagList = this.readTagFromBufferList();
        if (this.TempTagList != null && this.TempTagList.size() > 0) {
            UHFTAGInfo info = this.TempTagList.get(0);
            this.TempTagList.remove(0);
            return info;
        }
        return null;
    }

    @Override
    public synchronized List<UHFTAGInfo> readTagFromBufferList() {
        byte[] sendData = this.uhfProtocolParse.getReadTagSendData();
        byte[] inData = this.getBTReceiveData(sendData, 600);
        if (inData != null && inData.length > 0) {
            List<UHFTAGInfo> list = this.uhfProtocolParse.parseReadTagData_EPC(inData);
            if ((list == null || list.size() == 0) && this.isDebug) {
                Log.e((String)"DeviceAPI_RFIDWithUHFBLE", (String)("readTagFromBufferList \u89e3\u6790\u6570\u636e\u5931\u8d25,\u539f\u59cb\u6570\u636e:" + StringUtility.bytes2HexString2(inData, inData.length)));
            }
            return list;
        }
        return null;
    }

    @Override
    public synchronized List<UHFTAGInfo> readTagFromBufferList_EpcTidUser() {
        byte[] sendData = this.uhfProtocolParse.getReadTagSendData();
        byte[] inData = this.getBTReceiveData(sendData, 600);
        if (inData != null && inData.length > 0) {
            List<UHFTAGInfo> list = this.uhfProtocolParse.parseReadTagDataEPC_TID_USER(inData);
            if ((list == null || list.size() == 0) && this.isDebug) {
                Log.e((String)"DeviceAPI_RFIDWithUHFBLE", (String)("readTagFromBufferList_EpcTidUser \u89e3\u6790\u6570\u636e\u5931\u8d25,\u539f\u59cb\u6570\u636e:" + StringUtility.bytes2HexString2(inData, inData.length)));
            }
            return list;
        }
        return null;
    }

    @Override
    public synchronized boolean stopInventory() {
        byte[] sendData = this.uhfProtocolParse.getStopInventorySendData();
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null) {
            int cfr_ignored_0 = inData.length;
        }
        return true;
    }

    @Override
    public String generateLockCode(ArrayList<Integer> lockBank, int lockMode) {
        return this.uhfProtocolParse.generateLockCode(lockBank, lockMode);
    }

    @Override
    public boolean lockMem(String accessPwd, int bank, int ptr, int cnt, String filterData, String lockCode) {
        byte[] sendData = this.uhfProtocolParse.getLockSendData(accessPwd, bank, ptr, cnt, filterData, lockCode);
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseLockData(inData);
        }
        return false;
    }

    @Override
    public boolean lockMem(String accessPwd, String lockCode) {
        int bank = 0;
        int ptr = 0;
        int cnt = 0;
        String filterData = "00";
        return this.lockMem(accessPwd, bank, ptr, cnt, filterData, lockCode);
    }

    @Override
    public boolean uhfGBTagLock(String accessPwd, int memory, int config, int action) {
        int filterBank = 0;
        int filterPtr = 0;
        int filterCnt = 0;
        String filterData = "00";
        return this.uhfGBTagLock(accessPwd, filterBank, filterPtr, filterCnt, filterData, memory, config, action);
    }

    @Override
    public boolean uhfGBTagLock(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData, int memory, int config, int action) {
        byte[] sendData = this.uhfProtocolParse.GBTagLockSendData(accessPwd, (char)filterBank, filterPtr, filterCnt, filterData, (char)memory, (char)config, (char)action);
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseLockData(inData);
        }
        return false;
    }

    @Override
    public UHFTAGInfo inventorySingleTag() {
        byte[] sendData = this.uhfProtocolParse.getInventorySingleTagSendData();
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseInventorySingleTagData(inData);
        }
        return null;
    }

    @Override
    public String readData(String accessPwd, int bank, int ptr, int cnt) {
        int filterBank = 0;
        int filterPtr = 0;
        int filterCnt = 0;
        String filterData = "00";
        return this.readData(accessPwd, filterBank, filterPtr, filterCnt, filterData, bank, ptr, cnt);
    }

    @Override
    public String readData(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData, int bank, int ptr, int cnt) {
        byte[] sendData = this.uhfProtocolParse.getReadSendData(accessPwd, filterBank, filterPtr, filterCnt, filterData, bank, ptr, cnt);
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseReadData(inData);
        }
        return null;
    }

    @Override
    public boolean writeData(String accessPwd, int bank, int ptr, int cnt, String data) {
        int filterBank = 0;
        int filterPtr = 0;
        int filterCnt = 0;
        String filterData = "00";
        return this.writeData(accessPwd, filterBank, filterPtr, filterCnt, filterData, bank, ptr, cnt, data);
    }

    @Override
    public boolean writeData(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData, int bank, int ptr, int cnt, String writeData) {
        byte[] sendData = this.uhfProtocolParse.getWriteSendData(accessPwd, filterBank, filterPtr, filterCnt, filterData, bank, ptr, cnt, writeData);
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseWriteData(inData);
        }
        return false;
    }

    @Override
    public boolean blockWriteData(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData, int bank, int ptr, int cnt, String writeData) {
        byte[] sendData = this.uhfProtocolParse.blockWriteDataSendData(accessPwd, (char)filterBank, filterPtr, filterCnt, filterData, (char)bank, ptr, (char)cnt, writeData);
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseBlockWriteData(inData);
        }
        return false;
    }

    @Override
    public boolean eraseData(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData, int bank, int ptr, int cnt) {
        byte[] sendData = this.uhfProtocolParse.blockEraseDataSendData(accessPwd, (char)filterBank, filterPtr, filterCnt, filterData, (char)bank, ptr, (char)cnt);
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseBlockEraseDataData(inData);
        }
        return false;
    }

    @Override
    public boolean eraseData(String accessPwd, int bank, int ptr, int cnt) {
        int filterBank = 1;
        int filterPtr = 0;
        int filterCnt = 0;
        String filterData = "00";
        return this.eraseData(accessPwd, filterBank, filterPtr, filterCnt, filterData, bank, ptr, cnt);
    }

    @Override
    public boolean setFilter(int bank, int ptr, int cnt, String data) {
        byte[] sendData = this.uhfProtocolParse.setFilterSendData((char)bank, ptr, cnt, data);
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSetFilterData(inData);
        }
        return false;
    }

    @Override
    public boolean killTag(String killPwd) {
        int filterBank = 0;
        int filterPtr = 0;
        int filterCnt = 0;
        String filterData = "00";
        return this.killTag(killPwd, filterBank, filterPtr, filterCnt, filterData);
    }

    @Override
    public boolean killTag(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData) {
        byte[] sendData = this.uhfProtocolParse.getKillSendData(accessPwd, filterBank, filterPtr, filterCnt, filterData);
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseKillData(inData);
        }
        return false;
    }

    @Override
    public boolean setProtocol(int protocol) {
        byte[] sendData = this.uhfProtocolParse.setProtocolSendData(protocol);
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSetProtocolData(inData);
        }
        return false;
    }

    @Override
    public int getProtocol() {
        byte[] sendData = this.uhfProtocolParse.getProtocolSendData();
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseGetProtocolData(inData);
        }
        return -1;
    }

    @Override
    public boolean setFreHop(float fre) {
        int f = (int)(fre * 1000.0f);
        byte[] sendData = this.uhfProtocolParse.setJumpFrequencySendData(f);
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSetJumpFrequencyData(inData);
        }
        return false;
    }

    @Override
    public boolean setRFLink(int mode) {
        return false;
    }

    @Override
    public int getRFLink() {
        return 0;
    }

    @Override
    public boolean setFastID(boolean enalbe) {
        return false;
    }

    @Override
    public boolean setTagFocus(boolean enalbe) {
        return false;
    }

    @Override
    public boolean setEPCMode() {
        byte[] sendData = this.uhfProtocolParse.setEPCModeSendData();
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSetEPCModeData(inData);
        }
        return false;
    }

    @Override
    public boolean setEPCAndTIDMode() {
        byte[] sendData = this.uhfProtocolParse.setEPCAndTIDModeSendData();
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSetEPCAndTIDModeData(inData);
        }
        return false;
    }

    @Override
    public boolean setEPCAndTIDUserMode(int user_prt, int user_len) {
        byte[] sendData = this.uhfProtocolParse.setEPCAndTIDUserModeSendData(user_prt, user_len);
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSetEPCAndTIDUserModeData(inData);
        }
        return false;
    }

    @Override
    public int getTemperature() {
        byte[] sendData = this.uhfProtocolParse.getTemperatureSendData();
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseTemperatureData(inData);
        }
        return -1;
    }

    @Override
    public boolean uhfBlockPermalock(String accessPwd, int FilterBank, int FilterStartaddr, int FilterLen, String FilterData, int ReadLock, int uBank, int uPtr, int uRange, byte[] uMaskbuf) {
        return false;
    }

    @Override
    public boolean setGen2(int target, int action, int t, int q, int startQ, int minQ, int maxQ, int dr, int coding, int p, int Sel, int Session, int g, int linkFrequency) {
        byte[] sendData = this.uhfProtocolParse.setGen2SendData((char)target, (char)action, (char)t, (char)q, (char)startQ, (char)minQ, (char)maxQ, (char)dr, (char)coding, (char)p, (char)Sel, (char)Session, (char)g, (char)linkFrequency);
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSetGen2Data(inData);
        }
        return false;
    }

    @Override
    public char[] getGen2() {
        byte[] data;
        byte[] sendData = this.uhfProtocolParse.getGen2SendData();
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0 && (data = this.uhfProtocolParse.parseGetGen2Data(inData)) != null && data.length > 0) {
            return StringUtility.bytesTochars(data, data.length);
        }
        return null;
    }

    @Override
    public boolean setPwm(int WorkTime, int WaitTime) {
        return false;
    }

    @Override
    public int[] getPwm() {
        return null;
    }

    @Override
    public boolean setQTPara(boolean enable) {
        return false;
    }

    @Override
    public int[] getQTPara() {
        return null;
    }

    @Override
    public boolean setCW(int flag) {
        byte[] sendData = this.uhfProtocolParse.setCWSendData((char)flag);
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSetCWData(inData);
        }
        return false;
    }

    @Override
    public int getCW() {
        byte[] sendData = this.uhfProtocolParse.getCWSendData();
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseGetCWData(inData);
        }
        return -1;
    }

    public boolean uhfJump2BootSTM32() {
        byte[] sendData = this.uhfProtocolParse.uhfJump2BootSendData('\u0000');
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseUHFJump2BootData(inData);
        }
        return false;
    }

    @Override
    public boolean uhfJump2Boot() {
        byte[] sendData = this.uhfProtocolParse.uhfJump2BootSendData('\u0001');
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseUHFJump2BootData(inData);
        }
        return false;
    }

    @Override
    public boolean uhfStartUpdate() {
        byte[] sendData = this.uhfProtocolParse.uhfStartUpdateSendData();
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseUHFStartUpdateData(inData);
        }
        return false;
    }

    @Override
    public boolean uhfUpdating(byte[] buff) {
        byte[] sendData = this.uhfProtocolParse.uhfUpdatingSendData(buff);
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseUHFUpdatingData(inData);
        }
        return false;
    }

    @Override
    public boolean uhfStopUpdate() {
        byte[] sendData = this.uhfProtocolParse.UHFStopUpdateSendData();
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseUHFStopUpdateData(inData);
        }
        return false;
    }

    public synchronized boolean setR6Workmode(int mode) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException();
        }
        byte[] sendData = this.uhfProtocolParse.setR6WorkmodeSendData((char)mode);
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSetR6WorkModeData(inData);
        }
        return false;
    }

    @Override
    public byte[] getEPCAndTIDUserMode() {
        byte[] sendData = this.uhfProtocolParse.getEPCTIDModeSendData('\u0000', '\u0000');
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            byte[] data = this.uhfProtocolParse.parseGetEPCTIDModeData(inData);
            return data;
        }
        return null;
    }

    @Override
    public int getAllTagTotalFromFlash() {
        byte[] sendData = this.uhfProtocolParse.btGetAllTagNumFromFlashSendData();
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseBtGetAllTagNumFromFlashData(inData);
        }
        return -1;
    }

    @Override
    public boolean deleteAllTagToFlash() {
        byte[] sendData = this.uhfProtocolParse.btDeleteAllTagToFlashSendData();
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseBtDeleteAllTagToFlashData(inData);
        }
        return false;
    }

    @Override
    public List<UHFTAGInfo> getTagDataFromFlash() {
        byte[] tagBuff;
        byte[] sendData = this.uhfProtocolParse.btGetTagDataFromFlashSendData();
        byte[] inData = this.getBTReceiveData(sendData, 1000);
        if (inData != null && inData.length > 0 && (tagBuff = this.uhfProtocolParse.parseBtGetTagDataFromFlashData(inData)) != null && tagBuff.length > 0) {
            ArrayList<UHFTAGInfo> list = new ArrayList<UHFTAGInfo>();
            int tagCount = tagBuff[0] & 0xFF;
            int start = 0;
            int end = 1;
            int k = 0;
            while (k < tagCount) {
                UHFTAGInfo info = new UHFTAGInfo();
                byte epcLen = tagBuff[end];
                start = end + 1;
                end = start + epcLen;
                byte[] epcBuff = Arrays.copyOfRange(tagBuff, start, end);
                info.setEPC(StringUtility.bytes2HexString2(epcBuff, epcBuff.length));
                list.add(info);
                ++k;
            }
            return list;
        }
        return null;
    }

    public static /* bridge */ /* synthetic */ BluetoothReader getInstance() {
        return RFIDWithUHFBLE.getInstance();
    }
}

