/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.os.Environment;
import android.util.Log;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.RFIDWithUHF;
import com.rscja.deviceapi.entity.UHFTAGInfo;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.deviceapi.service.BTService;
import com.rscja.utility.StringUtility;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;

@Deprecated
public class RFIDWithUHFBluetooth {
    private static RFIDWithUHFBluetooth single;
    private BTService mService = null;
    private BluetoothAdapter mBtAdapter = null;
    private String TAG = "DeviceAPI_UHFBluetooth";
    private static boolean isDebug;
    private ScanBTCallback scanBTCallback = null;
    private BTStatusCallback btStatusCallback = null;
    public static String deviceAddress;
    public static byte[] tempData;
    public static int wIndex;
    public static int rIndex;
    public static boolean isStop;
    KeyEventCallback KeyEventCallback = null;
    DataReceiveBTData datareceive = new DataReceiveBTData();
    public static byte[] tempDataTAG;
    public static int wIndexTAG;
    public static int rIndexTAG;
    private Context context = null;
    private static boolean isBluetooth;
    private RFIDWithUHF rfidWithUHF = null;
    private byte[] tempEpcData = new byte[1024];
    private String[] msg = new String[1];
    private byte[] tempTestData = new byte[512];
    private int tempTagDataIndex = 0;
    private long startTime = 0L;
    private int timeOut = 400;
    public static final String VERSION_BT_FIRMWARE = "FIRMWARE";
    public static final String VERSION_BT_HARDWARE = "HARDWARE";
    public static final String VERSION_BT_SOFTWARE = "SOFTWARE";
    boolean isFlag = false;
    private static boolean isLog;
    private static boolean isLog2;
    private static String rootPath;
    private File bleResultLog = new File(String.valueOf(rootPath) + File.separator + "bleResultLog.txt");
    private File bleDataLog = new File(String.valueOf(rootPath) + File.separator + "bleDataLog.txt");
    private File bleRawDataLog = new File(String.valueOf(rootPath) + File.separator + "bleRawDataLog.txt");

    static {
        File file;
        single = null;
        isDebug = false;
        tempData = new byte[1024];
        wIndex = 0;
        rIndex = 0;
        isStop = false;
        tempDataTAG = new byte[4096];
        wIndexTAG = -1;
        rIndexTAG = -1;
        isBluetooth = true;
        isLog = false;
        isLog2 = false;
        rootPath = Environment.getExternalStorageDirectory() + File.separator + "UhfTestData" + File.separator + "log";
        if ((isLog || isLog2) && !(file = new File(rootPath)).exists()) {
            file.mkdirs();
        }
    }

    private RFIDWithUHFBluetooth() {
    }

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized RFIDWithUHFBluetooth getInstance() {
        if (single != null) return single;
        Class<RFIDWithUHFBluetooth> clazz = RFIDWithUHFBluetooth.class;
        synchronized (RFIDWithUHFBluetooth.class) {
            if (single != null) return single;
            single = new RFIDWithUHFBluetooth();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public synchronized void init(Context context) {
        if (isBluetooth) {
            rIndex = 0;
            this.context = context;
            this.mBtAdapter = BluetoothAdapter.getDefaultAdapter();
            if (this.mBtAdapter == null) {
                return;
            }
            Log.d((String)this.TAG, (String)"----init------");
            this.service_init(this.context);
        } else if (this.rfidWithUHF == null) {
            try {
                this.rfidWithUHF = RFIDWithUHF.getInstance();
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void free() {
        if (isBluetooth) {
            rIndex = 0;
            if (this.mService != null) {
                this.mService.stoptBTScan();
                this.mService.disconnect();
            }
        } else {
            if (this.rfidWithUHF != null) {
                this.rfidWithUHF.free();
            }
            if (this.btStatusCallback != null) {
                this.btStatusCallback.getStatus(StatusEnum.DISCONNECTED, null);
            }
        }
    }

    public void scanBTDevices(ScanBTCallback scanBTCallback) {
        if (isBluetooth) {
            this.scanBTCallback = scanBTCallback;
            if (this.mService != null) {
                this.mService.startBTScan(scanBTCallback);
            }
        }
    }

    public void stopScanBTDevices() {
        if (isBluetooth && this.mService != null) {
            this.mService.stoptBTScan();
        }
    }

    public void setStatusCallback(BTStatusCallback btStatusCallback) {
        this.btStatusCallback = btStatusCallback;
        this.mService.setStatusCallback(btStatusCallback);
    }

    public synchronized void connect(String address, BTStatusCallback btStatusCallback) {
        if (isBluetooth) {
            if (address != null && this.mService != null && btStatusCallback != null) {
                deviceAddress = address;
                this.btStatusCallback = btStatusCallback;
                this.mService.connect(deviceAddress, btStatusCallback);
                this.mService.setKeyEventCallback(this.KeyEventCallback);
                this.mService.setDataCallBack(this.datareceive);
            }
        } else {
            if (this.rfidWithUHF == null) {
                try {
                    this.rfidWithUHF = RFIDWithUHF.getInstance();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
            }
            this.btStatusCallback = btStatusCallback;
            if (this.rfidWithUHF != null) {
                if (this.btStatusCallback != null) {
                    this.btStatusCallback.getStatus(StatusEnum.CONNECTING, null);
                }
                if (this.rfidWithUHF.init_R2000()) {
                    if (this.btStatusCallback != null) {
                        this.btStatusCallback.getStatus(StatusEnum.CONNECTED, null);
                    }
                } else {
                    this.rfidWithUHF.free();
                    if (this.btStatusCallback != null) {
                        this.btStatusCallback.getStatus(StatusEnum.DISCONNECTED, null);
                    }
                }
            }
        }
    }

    public synchronized boolean setR6Workmode(int mode) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException();
        }
        return isBluetooth && this.getDeviceAPI().UHFBTSetR6Workmode(mode) == 0;
    }

    public synchronized void setKeyEventCallback(KeyEventCallback KeyEventCallback2) {
        if (isBluetooth) {
            if (this.mService != null) {
                this.mService.setKeyEventCallback(KeyEventCallback2);
            }
            this.KeyEventCallback = KeyEventCallback2;
        }
    }

    public synchronized void disconnect() {
        if (isBluetooth) {
            if (this.mService != null) {
                this.mService.disconnect();
            }
        } else {
            if (this.rfidWithUHF != null) {
                this.rfidWithUHF.free();
            }
            if (this.btStatusCallback != null) {
                this.btStatusCallback.getStatus(StatusEnum.DISCONNECTED, null);
            }
        }
    }

    public synchronized StatusEnum getConnectStatus() {
        if (isBluetooth) {
            if (this.mService != null) {
                return this.mService.getBTConnectStatus();
            }
            return StatusEnum.DISCONNECTED;
        }
        if (this.rfidWithUHF != null && this.rfidWithUHF.powerOn) {
            return StatusEnum.CONNECTED;
        }
        return StatusEnum.DISCONNECTED;
    }

    public boolean setRemoteBluetoothName(String name) {
        if (isBluetooth && this.mService != null) {
            return this.mService.setBtName(name);
        }
        return false;
    }

    public synchronized int getBattery() {
        if (isBluetooth) {
            return this.getDeviceAPI().UHFBTGetBattery();
        }
        return -1;
    }

    public boolean setBeep(boolean isBeep) {
        if (isBluetooth) {
            boolean falg;
            boolean bl = falg = isBeep;
            return this.getDeviceAPI().UHFBTSetBeep((byte)(falg ? 1 : 0)) == 0;
        }
        return false;
    }

    public synchronized String scanBarcode() {
        if (isBluetooth) {
            byte[] barcode = new byte[2048];
            int len = this.getDeviceAPI().UHFBTGetBarcode(barcode);
            if (len <= 0) {
                return "";
            }
            return new String(barcode, 0, len);
        }
        return "";
    }

    public synchronized byte[] scanBarcodeToBytes() {
        if (isBluetooth) {
            byte[] barcode = new byte[2048];
            int len = this.getDeviceAPI().UHFBTGetBarcode(barcode);
            if (len <= 0) {
                return null;
            }
            if (len == 1 && barcode[0] == 1) {
                return null;
            }
            return Arrays.copyOf(barcode, len);
        }
        return null;
    }

    private void cleanData() {
        if (isBluetooth) {
            wIndex = 0;
            rIndex = 0;
            int k = 0;
            while (k < tempData.length) {
                RFIDWithUHFBluetooth.tempData[k] = 0;
                ++k;
            }
        }
    }

    private void cleanDataTAG() {
        if (isBluetooth) {
            wIndexTAG = -1;
            rIndexTAG = -1;
            int k = 0;
            while (k < tempDataTAG.length) {
                RFIDWithUHFBluetooth.tempDataTAG[k] = 0;
                ++k;
            }
        }
    }

    int sendAndReceiveData(byte[] sendData, int sendDataLen, int timeOut, byte[] outData) {
        if (isBluetooth) {
            if (timeOut < 10) {
                timeOut = 10;
            }
            if (this.mService != null) {
                this.isFlag = false;
                this.cleanData();
                byte[] tempSend = Arrays.copyOf(sendData, sendDataLen);
                if (this.mService.writeRXCharacteristic(tempSend, this.msg)) {
                    int k = 0;
                    while (k < timeOut) {
                        if (this.isFlag) break;
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        ++k;
                    }
                    if (wIndex > 0) {
                        byte[] result = Arrays.copyOf(tempData, wIndex);
                        int index = 0;
                        while (index < wIndex) {
                            if (outData.length > index) {
                                outData[index] = tempData[index];
                            }
                            ++index;
                        }
                        this.cleanData();
                        return index;
                    }
                    return 0;
                }
                Log.e((String)this.TAG, (String)"sendAndReceiveData  ==> \u53d1\u9001\u6570\u636e\u5931\u8d25!");
                return -1;
            }
        }
        return -1;
    }

    boolean sendData(byte[] data, int len) {
        Log.d((String)this.TAG, (String)"sendData");
        if (isBluetooth) {
            this.isFlag = false;
            if (this.mService != null) {
                this.cleanData();
                byte[] tempSend = Arrays.copyOf(data, len);
                if (this.mService.writeRXCharacteristic(tempSend, this.msg)) {
                    return true;
                }
            }
        }
        return false;
    }

    byte[] receiveData() {
        if (isBluetooth) {
            int len = wIndex;
            if (len > rIndex) {
                byte[] result = Arrays.copyOfRange(tempData, rIndex, len);
                if (isDebug) {
                    Log.d((String)this.TAG, (String)("\u8fd4\u56de\u7684\u6570\u636e receiveData ===> receiveData:" + StringUtility.bytes2HexString2(result, result.length)));
                }
                rIndex = len;
                return result;
            }
            return null;
        }
        return null;
    }

    byte[] receiveDataTAG(int[] time) {
        if (isBluetooth) {
            int temp = wIndexTAG;
            time[0] = (int)(System.currentTimeMillis() - this.startTime);
            if (temp > rIndexTAG) {
                byte[] result = Arrays.copyOfRange(tempDataTAG, rIndexTAG + 1, temp + 1);
                if (isDebug || isLog) {
                    String data = StringUtility.bytes2HexString2(result, result.length);
                    Log.d((String)this.TAG, (String)("\u8fd4\u56de\u7684\u6570\u636e receiveData ===> receiveData:" + data));
                    if (isLog) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(data);
                        sb.append("  ,rIndexTAG=");
                        sb.append(rIndexTAG + 1);
                        sb.append("  ,end=");
                        sb.append(temp + 1);
                        this.writeLog2(sb.toString(), true);
                    }
                }
                if (isLog || isLog2) {
                    this.writeData(result, 0, result.length);
                }
                rIndexTAG = temp;
                return result;
            }
            if (temp < rIndexTAG) {
                byte[] result = Arrays.copyOfRange(tempDataTAG, rIndexTAG + 1, tempDataTAG.length);
                if (isDebug || isLog) {
                    String data = StringUtility.bytes2HexString2(result, result.length);
                    Log.d((String)this.TAG, (String)("\u8fd4\u56de\u7684\u6570\u636e receiveData ===> receiveData:" + data));
                    if (isLog) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(data);
                        sb.append("  ,rIndexTAG=");
                        sb.append(rIndexTAG + 1);
                        sb.append("  ,end=");
                        sb.append(tempDataTAG.length);
                        this.writeLog2(sb.toString(), true);
                    }
                }
                if (isLog || isLog2) {
                    this.writeData(result, 0, result.length);
                }
                rIndexTAG = -1;
                return result;
            }
            return null;
        }
        return null;
    }

    private void receiveData(byte[] txValue, boolean flag) {
        if (isBluetooth) {
            if (txValue != null) {
                int k = 0;
                while (k < txValue.length) {
                    if (wIndex >= tempData.length) break;
                    RFIDWithUHFBluetooth.tempData[RFIDWithUHFBluetooth.wIndex] = txValue[k];
                    ++wIndex;
                    ++k;
                }
                if (isLog) {
                    this.writeLog3(StringUtility.bytes2HexString2(txValue, txValue.length), true);
                }
                int temp = wIndexTAG;
                int start = wIndexTAG;
                int k2 = 0;
                while (k2 < txValue.length) {
                    if (wIndexTAG >= tempDataTAG.length - 1) {
                        wIndexTAG = -1;
                        temp = -1;
                    }
                    RFIDWithUHFBluetooth.tempDataTAG[++temp] = txValue[k2];
                    ++wIndexTAG;
                    ++k2;
                }
                if (isLog) {
                    String msg = "    start=" + start + ", end=" + wIndexTAG;
                    this.writeLog3(msg, true);
                }
            }
            this.isFlag = flag;
        }
    }

    private void service_init(Context context) {
        if (this.mService == null) {
            this.mService = new BTService();
        }
        if (this.mService.initialize(context)) {
            if (isDebug) {
                Log.d((String)this.TAG, (String)"mService.initialize   ok");
            }
        } else if (isDebug) {
            Log.d((String)this.TAG, (String)"mService.initialize   fail");
        }
    }

    public synchronized boolean uhfEncryptSM4(String pszdata, StringBuilder outdata) {
        if (pszdata == null || pszdata.isEmpty()) {
            return false;
        }
        if (!StringUtility.isHexNumberRex(pszdata)) {
            Log.e((String)this.TAG, (String)"uhfEncryptSM4 error pszkeydata fail!");
            return false;
        }
        int len = pszdata.length() / 2;
        byte[] newData = new byte[len];
        if (isBluetooth) {
            char[] oldData = StringUtility.hexString2Chars(pszdata);
            if (this.getDeviceAPI().UHFEncryptSM4((char)len, oldData, newData) == 0) {
                if (outdata != null) {
                    outdata.append(StringUtility.bytes2HexString(newData));
                }
                return true;
            }
            return false;
        }
        byte[] oldData = StringUtility.hexString2Bytes(pszdata);
        newData = this.getDeviceAPI().UHFEncSM4(oldData, len);
        if (newData != null && newData[0] == 0) {
            if (outdata != null) {
                int datalen = newData[1] & 0xFF;
                byte[] temp = Arrays.copyOfRange(newData, 2, 2 + datalen);
                outdata.append(StringUtility.bytes2HexString(temp));
            }
            return true;
        }
        return false;
    }

    public synchronized boolean uhfDecryptSM4(String pszdata, StringBuilder outdata) {
        if (pszdata == null || pszdata.isEmpty()) {
            return false;
        }
        if (!StringUtility.isHexNumberRex(pszdata)) {
            Log.e((String)this.TAG, (String)"uhfDecryptSM4 error pszkeydata fail!");
            return false;
        }
        int len = pszdata.length() / 2;
        byte[] newData = new byte[len];
        if (isBluetooth) {
            char[] oldData = StringUtility.hexString2Chars(pszdata);
            if (this.getDeviceAPI().UHFDecryptSM4((char)len, oldData, newData) == 0) {
                if (outdata != null) {
                    outdata.append(StringUtility.bytes2HexString(newData));
                }
                return true;
            }
            return false;
        }
        byte[] oldData = StringUtility.hexString2Bytes(pszdata);
        newData = this.getDeviceAPI().UHFDecSM4(oldData, len);
        if (newData != null && newData[0] == 0) {
            if (outdata != null) {
                int datalen = newData[1] & 0xFF;
                byte[] temp = Arrays.copyOfRange(newData, 2, 2 + datalen);
                outdata.append(StringUtility.bytes2HexString(temp));
            }
            return true;
        }
        return false;
    }

    public synchronized boolean uhfGetSMKey(byte[] mode, StringBuilder keydata, StringBuilder lvdata) {
        if (mode == null || mode.length == 0) {
            return false;
        }
        byte[] bKeyData = new byte[16];
        byte[] blvData = new byte[16];
        if (isBluetooth) {
            if (this.getDeviceAPI().UHFGETSM4(mode, bKeyData, blvData) == 0) {
                if (keydata != null) {
                    keydata.append(StringUtility.bytes2HexString(bKeyData));
                }
                if (lvdata != null) {
                    lvdata.append(StringUtility.bytes2HexString(blvData));
                }
                return true;
            }
            return false;
        }
        byte[] data = this.getDeviceAPI().UHFGetSM4();
        if (data != null && data[0] == 0) {
            if (mode != null && mode.length > 0) {
                mode[0] = data[2];
            }
            if (keydata != null) {
                bKeyData = Arrays.copyOfRange(data, 3, 19);
                keydata.append(StringUtility.bytes2HexString(bKeyData));
            }
            if (lvdata != null) {
                blvData = Arrays.copyOfRange(data, 19, 35);
                lvdata.append(StringUtility.bytes2HexString(blvData));
            }
            return true;
        }
        return false;
    }

    public synchronized boolean uhfSetSM4Key(int mode, String pszkeydata, String pszlvdata) {
        if (mode != 0 && mode != 2 && mode != 4 && mode != 6) {
            Log.e((String)this.TAG, (String)("uhfSetSM4Key error  mode=" + mode));
            return false;
        }
        if (pszkeydata == null || pszkeydata.isEmpty() || pszlvdata == null || pszlvdata.isEmpty()) {
            Log.e((String)this.TAG, (String)"uhfSetSM4Key error 1");
            return false;
        }
        if (!StringUtility.isHexNumberRex(pszlvdata) || !StringUtility.isHexNumberRex(pszkeydata)) {
            Log.e((String)this.TAG, (String)"uhfSetSM4Key error 2!");
            return false;
        }
        if (isBluetooth) {
            char[] ckeyData = StringUtility.hexString2Chars(pszkeydata);
            char[] cpszlvData = StringUtility.hexString2Chars(pszlvdata);
            if (ckeyData.length != 16 || cpszlvData.length != 16) {
                Log.e((String)this.TAG, (String)"uhfSetSM4Key error 3!");
                return false;
            }
            return this.getDeviceAPI().UHFSETSM4((char)mode, ckeyData, cpszlvData) == 0;
        }
        byte[] ckeyData = StringUtility.hexString2Bytes(pszkeydata);
        byte[] cpszlvData = StringUtility.hexString2Bytes(pszlvdata);
        if (ckeyData.length != 16 || cpszlvData.length != 16) {
            Log.e((String)this.TAG, (String)"uhfSetSM4Key error 3!");
            return false;
        }
        return this.getDeviceAPI().UHFSetSM4((char)mode, ckeyData, cpszlvData) == 0;
    }

    public synchronized boolean uhfEncWriteUser(int ptr, int len, String pszdata) {
        if (ptr < 0 || pszdata == null || pszdata.isEmpty()) {
            return false;
        }
        if (!StringUtility.isHexNumberRex(pszdata)) {
            Log.e((String)this.TAG, (String)"uhfEncWriteUser error pszkeydata fail!");
            return false;
        }
        byte[] data = StringUtility.hexString2Bytes(pszdata);
        if (data.length < len) {
            Log.e((String)this.TAG, (String)"uhfEncWriteUser  len  error!");
            return false;
        }
        if (isBluetooth) {
            return this.getDeviceAPI().UHFBTEncWriteUser(ptr, len, data) == 0;
        }
        return this.getDeviceAPI().UHFEncUSER(ptr, len, data) == 0;
    }

    public synchronized boolean uhfEncReadUser(int ptr, int len, StringBuilder outdata) {
        if (ptr < 0 || len <= 0) {
            return false;
        }
        byte[] newData = new byte[len];
        if (isBluetooth) {
            if (this.getDeviceAPI().UHFBTEncReadUser(ptr, len, newData) == 0) {
                if (outdata != null) {
                    outdata.append(StringUtility.bytes2HexString(newData));
                }
                return true;
            }
            return false;
        }
        newData = this.getDeviceAPI().UHFDecUSER(ptr, len);
        if (newData != null && newData[0] == 0) {
            if (outdata != null) {
                int datalen = newData[1] & 0xFF;
                byte[] temp = Arrays.copyOfRange(newData, 2, 2 + datalen);
                outdata.append(StringUtility.bytes2HexString(temp));
            }
            return true;
        }
        return false;
    }

    public synchronized boolean uhfReBoot(int flag) {
        if (isBluetooth) {
            return this.getDeviceAPI().UHFBTReBootAPP((char)flag) == 0;
        }
        if (flag == 0) {
            if (this.rfidWithUHF == null) {
                return false;
            }
            return this.rfidWithUHF.uhfJump2Boot();
        }
        return this.getDeviceAPI().UHFJump2BootSTM32() == 0;
    }

    public synchronized boolean uhfStartUpdate() {
        if (isBluetooth) {
            return this.getDeviceAPI().UHFBTStartUpdate() == 0;
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        return this.rfidWithUHF.uhfStartUpdate();
    }

    public synchronized boolean uhfUpdateData(byte[] buff) {
        if (buff == null || buff.length == 0) {
            return false;
        }
        byte[] data = new byte[64];
        if (buff.length < 64) {
            int k = 0;
            while (k < buff.length) {
                data[k] = buff[k];
                ++k;
            }
        } else {
            int k = 0;
            while (k < 64) {
                data[k] = buff[k];
                ++k;
            }
        }
        if (isBluetooth) {
            return this.getDeviceAPI().UHFBTUpdateData(data) == 0;
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        return this.rfidWithUHF.uhfUpdating(data);
    }

    public synchronized boolean uhfEndUpdate() {
        if (isBluetooth) {
            return this.getDeviceAPI().UHFBTEndUpdate() == 0;
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        return this.rfidWithUHF.uhfStopUpdate();
    }

    public synchronized boolean writeData(String accessPwd, BankEnum bank, int ptr, int cnt, String data) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data)) {
            return false;
        }
        int filter_ptr = 32;
        int filter_cnt = 0;
        String filter_data = "00";
        if (isBluetooth) {
            BankEnum filter_bank = BankEnum.EPC;
            boolean result = this.writeData(accessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, bank, ptr, cnt, data);
            return result;
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        RFIDWithUHF.BankEnum filter_bank = RFIDWithUHF.BankEnum.UII;
        RFIDWithUHF.BankEnum uhfbank = RFIDWithUHF.BankEnum.UII;
        if (bank == BankEnum.RESERVED) {
            uhfbank = RFIDWithUHF.BankEnum.RESERVED;
        } else if (bank == BankEnum.TID) {
            uhfbank = RFIDWithUHF.BankEnum.TID;
        } else if (bank == BankEnum.USER) {
            uhfbank = RFIDWithUHF.BankEnum.USER;
        }
        boolean result = this.rfidWithUHF.writeData(accessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, uhfbank, ptr, cnt, data);
        return result;
    }

    public synchronized boolean writeData(String accessPwd, BankEnum filterBank, int filterPtr, int filterCnt, String filterData, BankEnum bank, int ptr, int cnt, String writeData) {
        if (StringUtility.isEmpty(accessPwd) || !StringUtility.isHexNumberRex(accessPwd)) {
            return false;
        }
        if (StringUtility.isEmpty(writeData) || !StringUtility.isHexNumberRex(writeData)) {
            return false;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return false;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return false;
            }
        } else {
            filterData = "00";
            filterCnt = 0;
        }
        int filter_ptr = filterPtr;
        int filter_cnt = filterCnt;
        char uBank = (char)bank.value;
        int uPtr = ptr;
        char uCnt = (char)cnt;
        if (isBluetooth) {
            char[] pszuAccessPwd = StringUtility.hexString2Chars(accessPwd);
            char[] filter_data = StringUtility.hexString2Chars(filterData);
            char[] ufData_write = StringUtility.hexString2Chars(writeData);
            char filter_bank = (char)filterBank.value;
            int result = this.getDeviceAPI().UHFBTWriteData(pszuAccessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, uBank, uPtr, uCnt, ufData_write);
            return result == 0;
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        RFIDWithUHF.BankEnum filter_bank = RFIDWithUHF.BankEnum.UII;
        if (filterBank == BankEnum.RESERVED) {
            filter_bank = RFIDWithUHF.BankEnum.RESERVED;
        } else if (filterBank == BankEnum.TID) {
            filter_bank = RFIDWithUHF.BankEnum.TID;
        } else if (filterBank == BankEnum.USER) {
            filter_bank = RFIDWithUHF.BankEnum.USER;
        }
        RFIDWithUHF.BankEnum uhfbank = RFIDWithUHF.BankEnum.UII;
        if (bank == BankEnum.RESERVED) {
            uhfbank = RFIDWithUHF.BankEnum.RESERVED;
        } else if (bank == BankEnum.TID) {
            uhfbank = RFIDWithUHF.BankEnum.TID;
        } else if (bank == BankEnum.USER) {
            uhfbank = RFIDWithUHF.BankEnum.USER;
        }
        boolean result = this.rfidWithUHF.writeData(accessPwd, filter_bank, filter_ptr, filter_cnt, filterData, uhfbank, uPtr, uCnt, writeData);
        return result;
    }

    public synchronized boolean authentication(String accessPwd, BankEnum filterBank, int filterPtr, int filterCnt, String filterData, BankEnum bank, int ptr, int cnt, String writeData, StringBuffer rev) {
        if (StringUtility.isEmpty(accessPwd) || !StringUtility.isHexNumberRex(accessPwd)) {
            return false;
        }
        if (StringUtility.isEmpty(writeData) || !StringUtility.isHexNumberRex(writeData)) {
            return false;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return false;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return false;
            }
        } else {
            filterData = "00";
            filterCnt = 0;
        }
        int filter_ptr = filterPtr;
        int filter_cnt = filterCnt;
        char uBank = (char)bank.value;
        int uPtr = ptr;
        char uCnt = (char)cnt;
        if (isBluetooth) {
            char[] crev = new char[60];
            char[] pszuAccessPwd = StringUtility.hexString2Chars(accessPwd);
            char[] filter_data = StringUtility.hexString2Chars(filterData);
            char[] ufData_write = StringUtility.hexString2Chars(writeData);
            char filter_bank = (char)filterBank.value;
            int len = this.getDeviceAPI().UHFBTAuthentication(pszuAccessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, uBank, uPtr, uCnt, ufData_write, crev);
            if (len > 0) {
                if (rev != null) {
                    rev.append(StringUtility.chars2HexString(crev, len));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public synchronized boolean authentication(String accessPwd, BankEnum bank, int ptr, int cnt, String data, StringBuffer rev) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data)) {
            return false;
        }
        int filter_ptr = 32;
        int filter_cnt = 0;
        String filter_data = "00";
        if (isBluetooth) {
            BankEnum filter_bank = BankEnum.EPC;
            boolean result = this.authentication(accessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, bank, ptr, cnt, data, rev);
            return result;
        }
        return false;
    }

    public synchronized boolean uhfKeydataMac(byte[] keyData, byte[] mac) {
        if (isBluetooth) {
            if (keyData == null || keyData.length != 16) {
                return false;
            }
            if (mac == null || mac.length != 4) {
                return false;
            }
            return this.getDeviceAPI().UHFBTKeydataMac(keyData, mac) == 0;
        }
        return false;
    }

    public synchronized String readData(String accessPwd, BankEnum bank, int ptr, int cnt) {
        if (StringUtility.isEmpty(accessPwd)) {
            return null;
        }
        int filterPtr = 0;
        int filterCnt = 0;
        String filterData = "00";
        if (isBluetooth) {
            BankEnum filterBank = BankEnum.EPC;
            return this.readData(accessPwd, filterBank, filterPtr, filterCnt, filterData, bank, ptr, cnt);
        }
        if (this.rfidWithUHF == null) {
            return "";
        }
        RFIDWithUHF.BankEnum filter_bank = RFIDWithUHF.BankEnum.UII;
        RFIDWithUHF.BankEnum uhfbank = RFIDWithUHF.BankEnum.UII;
        if (bank == BankEnum.RESERVED) {
            uhfbank = RFIDWithUHF.BankEnum.RESERVED;
        } else if (bank == BankEnum.TID) {
            uhfbank = RFIDWithUHF.BankEnum.TID;
        } else if (bank == BankEnum.USER) {
            uhfbank = RFIDWithUHF.BankEnum.USER;
        }
        return this.rfidWithUHF.readData(accessPwd, filter_bank, filterPtr, filterCnt, filterData, uhfbank, ptr, cnt);
    }

    public synchronized String readData(String accessPwd, BankEnum filterBank, int filterPtr, int filterCnt, String filterData, BankEnum bank, int ptr, int cnt) {
        if (StringUtility.isEmpty(accessPwd) || !StringUtility.isHexNumberRex(accessPwd)) {
            return null;
        }
        if (StringUtility.isEmpty(filterData) || !StringUtility.isHexNumberRex(filterData)) {
            return null;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return null;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return null;
            }
        } else {
            filterData = "00";
            filterCnt = 0;
        }
        int filter_ptr = filterPtr;
        int filter_cnt = filterCnt;
        int uPtr = ptr;
        char uCnt = (char)cnt;
        if (isBluetooth) {
            char filter_bank = (char)filterBank.value;
            char uBank = (char)bank.value;
            char[] pszuAccessPwd = StringUtility.hexString2Chars(accessPwd);
            char[] filter_data = StringUtility.hexString2Chars(filterData);
            char[] result = this.getDeviceAPI().UHFBTReadData(pszuAccessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, uBank, uPtr, uCnt);
            if (result[0] != '\u0000') {
                Log.e((String)this.TAG, (String)("readData() err :" + result[0]));
                return null;
            }
            char[] data = Arrays.copyOfRange(result, 2, result[1] + 2);
            return StringUtility.chars2HexString(data, data.length);
        }
        if (this.rfidWithUHF == null) {
            return "";
        }
        RFIDWithUHF.BankEnum filter_bank = RFIDWithUHF.BankEnum.UII;
        if (filterBank == BankEnum.RESERVED) {
            filter_bank = RFIDWithUHF.BankEnum.RESERVED;
        } else if (filterBank == BankEnum.TID) {
            filter_bank = RFIDWithUHF.BankEnum.TID;
        } else if (filterBank == BankEnum.USER) {
            filter_bank = RFIDWithUHF.BankEnum.USER;
        }
        RFIDWithUHF.BankEnum uhfbank = RFIDWithUHF.BankEnum.UII;
        if (bank == BankEnum.RESERVED) {
            uhfbank = RFIDWithUHF.BankEnum.RESERVED;
        } else if (bank == BankEnum.TID) {
            uhfbank = RFIDWithUHF.BankEnum.TID;
        } else if (bank == BankEnum.USER) {
            uhfbank = RFIDWithUHF.BankEnum.USER;
        }
        return this.rfidWithUHF.readData(accessPwd, filter_bank, filter_ptr, filter_cnt, filterData, uhfbank, uPtr, uCnt);
    }

    public synchronized boolean lockMem(String accessPwd, String lockCode) {
        boolean result = false;
        if (isBluetooth) {
            result = this.lockMem(accessPwd, BankEnum.EPC, 0, 0, "00", lockCode);
        } else {
            if (this.rfidWithUHF == null) {
                return false;
            }
            result = this.rfidWithUHF.lockMem(accessPwd, RFIDWithUHF.BankEnum.UII, 0, 0, "00", lockCode);
        }
        if (result) {
            return true;
        }
        Log.e((String)this.TAG, (String)("lockMem() err :" + result));
        return false;
    }

    public synchronized boolean lockMem(String accessPwd, BankEnum filterBank, int filterPtr, int filterCnt, String filterData, String lockCode) {
        if (StringUtility.isEmpty(accessPwd)) {
            return false;
        }
        if (StringUtility.isEmpty(lockCode)) {
            return false;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return false;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return false;
            }
        } else {
            filterData = "00";
        }
        if (isBluetooth) {
            char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
            char[] filter = StringUtility.hexString2Chars(filterData);
            char[] bLockData = StringUtility.hexString2Chars(lockCode);
            return DeviceAPI.getInstance().UHFBTLockMemEx(bAccessPwd, (char)filterBank.value, filterPtr, filterCnt, filter, bLockData) == 0;
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        RFIDWithUHF.BankEnum uhfbank = RFIDWithUHF.BankEnum.UII;
        if (filterBank == BankEnum.RESERVED) {
            uhfbank = RFIDWithUHF.BankEnum.RESERVED;
        } else if (filterBank == BankEnum.TID) {
            uhfbank = RFIDWithUHF.BankEnum.TID;
        } else if (filterBank == BankEnum.USER) {
            uhfbank = RFIDWithUHF.BankEnum.USER;
        }
        return this.rfidWithUHF.lockMem(accessPwd, uhfbank, filterPtr, filterCnt, filterData, lockCode);
    }

    public synchronized boolean uhfGBTagLock(String accessPwd, int memory, int config, int action) {
        String _accessPwd = accessPwd;
        BankEnum _filterBank = BankEnum.EPC;
        int _filterPtr = 0;
        int _filterCnt = 0;
        String _filterData = "00";
        int _memory = memory;
        int _config = config;
        int _action = action;
        return this.uhfGBTagLock(_accessPwd, _filterBank, _filterPtr, _filterCnt, _filterData, _memory, _config, _action);
    }

    public synchronized boolean uhfGBTagLock(String accessPwd, BankEnum filterBank, int filterPtr, int filterCnt, String filterData, int memory, int config, int action) {
        if (accessPwd.length() != 8) {
            Log.e((String)this.TAG, (String)"uhfGBTagLock==> accessPwd.length()!=8");
            return false;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return false;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return false;
            }
        } else {
            filterData = "00";
        }
        char[] pszuAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char bank = (char)filterBank.value;
        int ptr = filterPtr;
        int len = filterCnt;
        char[] data = StringUtility.hexString2Chars(filterData);
        int iMemory = memory;
        int iConfig = config;
        int iAction = action;
        if (isBluetooth) {
            StringBuilder sb = new StringBuilder();
            sb.append("UHFBTUHFGBTagLock==>");
            sb.append("accessPwd:" + accessPwd);
            sb.append(",filterBank:" + bank);
            sb.append(",filterPtr:" + ptr);
            sb.append(",filterCnt:" + len);
            sb.append(",filterdata:" + filterData);
            sb.append(",iMemory:" + iMemory);
            sb.append(",iConfig:" + iConfig);
            sb.append(",iAction:" + iAction);
            Log.d((String)this.TAG, (String)sb.toString());
        }
        return DeviceAPI.getInstance().UHFBTUHFGBTagLock(pszuAccessPwd, bank, ptr, len, data, iMemory, iConfig, iAction) == 0;
    }

    public synchronized boolean kill(String accessPwd) {
        boolean filterPtr = false;
        boolean filterCnt = false;
        String filterData = "00";
        if (isBluetooth) {
            BankEnum filterBank = BankEnum.EPC;
            return this.kill(accessPwd, filterBank, 0, 0, filterData);
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        return this.rfidWithUHF.killTag_Ex(accessPwd);
    }

    public synchronized boolean kill(String accessPwd, BankEnum filterBank, int filterPtr, int filterCnt, String filterData) {
        if (StringUtility.isEmpty(accessPwd)) {
            return false;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return false;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return false;
            }
        } else {
            filterData = "00";
        }
        if (isBluetooth) {
            char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
            char[] filter = StringUtility.hexString2Chars(filterData);
            return DeviceAPI.getInstance().UHFBTKill(bAccessPwd, (char)filterBank.value, filterPtr, filterCnt, filter) == 0;
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        RFIDWithUHF.BankEnum uhfbank = RFIDWithUHF.BankEnum.UII;
        if (filterBank == BankEnum.RESERVED) {
            uhfbank = RFIDWithUHF.BankEnum.RESERVED;
        } else if (filterBank == BankEnum.TID) {
            uhfbank = RFIDWithUHF.BankEnum.TID;
        } else if (filterBank == BankEnum.USER) {
            uhfbank = RFIDWithUHF.BankEnum.USER;
        }
        return this.rfidWithUHF.killTag(accessPwd, uhfbank, filterPtr, filterCnt, filterData);
    }

    public synchronized boolean setProtocol(int protocol) {
        int result = this.getDeviceAPI().UHFBTSetProtocolType(protocol);
        if (result == 0) {
            return true;
        }
        Log.e((String)this.TAG, (String)("setProtocol() err :" + result));
        return false;
    }

    public synchronized int getProtocol() {
        return this.getDeviceAPI().UHFBTUHFGetProtocolType();
    }

    public synchronized int getFrequencyMode() {
        if (isBluetooth) {
            return this.getDeviceAPI().UHFGetBTFrequency();
        }
        if (this.rfidWithUHF == null) {
            return -1;
        }
        int mode = this.rfidWithUHF.getFrequencyMode();
        switch (mode) {
            case 0: {
                mode = 2;
                break;
            }
            case 1: {
                mode = 1;
                break;
            }
            case 2: {
                mode = 4;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                mode = 8;
                break;
            }
            case 5: {
                mode = 22;
                break;
            }
            case 6: {
                mode = 50;
                break;
            }
            case 7: {
                mode = 128;
            }
        }
        return mode;
    }

    public synchronized boolean setFreHop(float fre) {
        int result;
        int ifre = (int)(fre * 1000.0f);
        if (isBluetooth) {
            result = this.getDeviceAPI().UHFBTFreHopSet(ifre);
            if (result == 0) {
                return true;
            }
        } else {
            if (this.rfidWithUHF == null) {
                return false;
            }
            return this.rfidWithUHF.setFreHop(fre);
        }
        Log.e((String)this.TAG, (String)("setFreHop() err :" + result));
        return false;
    }

    public synchronized boolean setFrequencyMode(byte freMode) {
        if (isBluetooth) {
            int result = this.getDeviceAPI().UHFSetBTFrequency(freMode);
            if (result == 0) {
                return true;
            }
            Log.e((String)this.TAG, (String)("setFrequencyMode() err :" + result));
            return false;
        }
        switch (freMode & 0xFF) {
            case 1: {
                freMode = 1;
                break;
            }
            case 2: {
                freMode = 0;
                break;
            }
            case 4: {
                freMode = (byte)2;
                break;
            }
            case 8: {
                freMode = (byte)4;
                break;
            }
            case 22: {
                freMode = (byte)5;
                break;
            }
            case 50: {
                freMode = (byte)6;
                break;
            }
            case 128: {
                freMode = (byte)7;
            }
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        Log.e((String)this.TAG, (String)("setFrequencyMode() freMode :" + freMode));
        return this.rfidWithUHF.setFrequencyMode(freMode);
    }

    public synchronized int getPower() {
        if (isBluetooth) {
            return this.getDeviceAPI().UHFBTGetPower();
        }
        if (this.rfidWithUHF == null) {
            return -1;
        }
        return this.rfidWithUHF.getPower();
    }

    public synchronized boolean setPower(int power) {
        if (isBluetooth) {
            int result = this.getDeviceAPI().UHFBTSetPower((byte)power);
            if (result == 0) {
                return true;
            }
            Log.e((String)this.TAG, (String)("setPower() err :" + result));
            return false;
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        return this.rfidWithUHF.setPower(power);
    }

    public synchronized String getR2000Version() {
        if (isBluetooth) {
            byte[] version = new byte[256];
            Log.d((String)"DeviceAPI", (String)"getVersion");
            int len = this.getDeviceAPI().UHFBTR2000Version(version);
            if (len > 0) {
                Log.d((String)"DeviceAPI", (String)("UHFBTR2000Version result ver=" + StringUtility.bytes2HexString2(version, len)));
                String ver = new String(version, 0, len);
                return ver;
            }
            return "";
        }
        if (this.rfidWithUHF == null) {
            return "";
        }
        return this.rfidWithUHF.getHardwareType();
    }

    public synchronized String getSTM32Version() {
        if (isBluetooth) {
            byte[] version = new byte[256];
            Log.d((String)"DeviceAPI", (String)"getSTM32Version");
            int len = this.getDeviceAPI().UHFBTSTM32Version(version);
            if (len > 0) {
                Log.d((String)"DeviceAPI", (String)("getSTM32Version result ver=" + StringUtility.bytes2HexString2(version, len)));
                String ver = new String(version, 0, len);
                return ver;
            }
            return "";
        }
        char[] result = this.getDeviceAPI().UHFGetHwTypeM3();
        if (result != null && result[0] == '\u0000') {
            char[] arrs = Arrays.copyOfRange(result, 2, result[1] + 2);
            return new String(arrs);
        }
        return "";
    }

    public synchronized boolean startInventoryTag() {
        if (isBluetooth) {
            Log.d((String)this.TAG, (String)"startInventoryTag\u5f00\u59cb\u5faa\u73af\u8bc6\u522b\u6807\u7b7e");
            if (this.getDeviceAPI().UHFBTStartInventory() == 0) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.cleanDataTAG();
                this.deleteLogFile();
                isStop = false;
                return true;
            }
            return false;
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        return this.rfidWithUHF.startInventoryTag(0, 0, 4);
    }

    public synchronized boolean stopInventoryTag() {
        if (isBluetooth) {
            isStop = true;
            boolean result = false;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            rIndex = 0;
            if (this.getConnectStatus() == StatusEnum.CONNECTED) {
                result = this.getDeviceAPI().UHFBTStopInventory() == 0;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            isStop = false;
            return result;
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        return this.rfidWithUHF.stopInventory();
    }

    public synchronized int getR2000Temperature() {
        if (isBluetooth) {
            byte[] result = new byte[256];
            Log.d((String)"DeviceAPI", (String)"getR2000Temperature");
            int len = this.getDeviceAPI().UHFBTR2000Temperature(result);
            if (len > 1) {
                String hex = StringUtility.bytes2HexString(result, 2);
                return Integer.valueOf(hex, 16) / 100;
            }
            return -1;
        }
        if (this.rfidWithUHF == null) {
            return -1;
        }
        return this.rfidWithUHF.getTemperature();
    }

    public synchronized String inventorySingleTag() {
        if (isBluetooth) {
            byte[] outData = new byte[100];
            int len = this.getDeviceAPI().UHFBTInventorySingle(outData);
            if (len > 0) {
                byte[] pcBuff = Arrays.copyOfRange(outData, 0, 2);
                int pc = pcBuff[0] & 0xFF | (pcBuff[1] & 0xFF) << 8;
                int epclen = (pc >> 3) * 2;
                byte[] uii = Arrays.copyOfRange(outData, 0, 2 + epclen);
                String strUii = StringUtility.bytes2HexString2(uii, uii.length);
                return strUii;
            }
            return null;
        }
        return this.rfidWithUHF.inventorySingleTag();
    }

    public synchronized UHFTAGInfo inventorySingleTag_EpcTidUser() {
        if (isBluetooth) {
            byte[] outData = new byte[1000];
            int len = this.getDeviceAPI().UHFBTInventorySingle(outData);
            if (len > 0) {
                Log.d((String)this.TAG, (String)("inventorySingleTagEx==>" + StringUtility.bytes2HexString2(outData, len)));
                byte[] pcBuff = Arrays.copyOfRange(outData, 0, len - 1);
                return this.parserUhfTagBuff(pcBuff);
            }
            return null;
        }
        String[] data = this.rfidWithUHF.inventorySingleTagEPC_TID_USER();
        if (data != null) {
            UHFTAGInfo uhfInfo = new UHFTAGInfo();
            uhfInfo.setEPC(data[0]);
            if (data.length == 2) {
                uhfInfo.setTid(data[1]);
            } else if (data.length == 3) {
                uhfInfo.setUser(data[2]);
            }
            return uhfInfo;
        }
        return null;
    }

    public boolean setEpcTidUserMode(int mode, int userStart, int userLen) {
        if (mode < 0 || mode > 2) {
            return false;
        }
        if (isBluetooth) {
            int reuslt = this.getDeviceAPI().UHFBTSetEpcTidUserMode(0, mode, userStart, userLen);
            return reuslt == 0;
        }
        if (mode == 1) {
            return this.rfidWithUHF.setEPCTIDMode(true);
        }
        if (mode == 2) {
            return this.rfidWithUHF.setEPCTIDUserMode(true, userStart, userLen);
        }
        return this.rfidWithUHF.setEPCTIDUserMode(false, userStart, userLen);
    }

    public boolean getEpcTidUserMode(int[] outMode, int[] outUserStart, int[] outUserLen) {
        if (isBluetooth) {
            byte[] outData = new byte[5];
            int reuslt = this.getDeviceAPI().UHFBTReadEpcTidUserMode(0, 0, outData);
            if (outData[0] == 1) {
                if (outMode != null && outMode.length > 0) {
                    Arrays.fill(outMode, 0);
                    outMode[0] = outData[1];
                }
                if (outUserStart != null && outUserStart.length > 0) {
                    Arrays.fill(outUserStart, 0);
                    outUserStart[0] = outData[2];
                }
                if (outUserLen != null && outUserLen.length > 0) {
                    Arrays.fill(outUserLen, 0);
                    outUserLen[0] = outData[3];
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public String convertUiiToEPC(String uii) {
        if (StringUtility.isEmpty(uii)) {
            return "";
        }
        String sUii = uii.replace("-", "").toUpperCase();
        sUii = sUii.substring(4, sUii.length());
        return sUii;
    }

    public synchronized ArrayList<UHFTAGInfo> readTagFromBuffer() {
        if (isBluetooth) {
            if (!isStop) {
                String hexCmd = "A55A0008E0E80D0A";
                byte[] cmd = StringUtility.hexString2Bytes(hexCmd);
                if (isLog) {
                    Log.d((String)"DeviceAPI", (String)"writeRXCharacteristic");
                }
                this.cleanTestData();
                if (this.mService.writeRXCharacteristic(cmd, this.msg)) {
                    if (isDebug) {
                        Log.d((String)"DeviceAPI", (String)"readTagFromBuffer \u53d1\u9001\u6570\u636e\u6210\u529f(A55A0008E0E80D0A)!");
                    }
                    int k = 0;
                    while (k < this.tempEpcData.length) {
                        this.tempEpcData[k] = 0;
                        ++k;
                    }
                    if (isLog) {
                        this.writeLog("\u5f00\u59cb\u83b7\u53d6\u6807\u7b7e", true);
                        Log.d((String)"DeviceAPI", (String)"UHFBTGetTag begin");
                    }
                    this.startTime = System.currentTimeMillis();
                    int len = this.getDeviceAPI().UHFBTGetTag(this.tempEpcData, this.timeOut);
                    if (isLog || isLog2) {
                        Log.d((String)"DeviceAPI", (String)"UHFBTGetTag end");
                        this.writeLog(String.format("\u83b7\u53d6\u6807\u7b7e\u8fd4\u56de\u957f\u5ea6 len={%d} \u8017\u65f6={%d}", len, System.currentTimeMillis() - this.startTime), true);
                        if (len <= 0) {
                            if (this.tempTagDataIndex > 0) {
                                this.writeLog("\u9519\u8bef\u6570\u636e:" + StringUtility.bytes2HexString2(this.tempTestData, this.tempTagDataIndex), true);
                            } else {
                                this.writeLog("\u84dd\u7259\u65e0\u6570\u636e\u8fd4\u56de!", true);
                            }
                        }
                    }
                    Log.d((String)"DeviceAPI", (String)("\u8bfb\u53d6\u6807\u7b7e\u8fd4\u56de\u957f\u5ea6:" + len));
                    if (len < 0 && len != -2) {
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (len > 2) {
                        byte[] result = Arrays.copyOf(this.tempEpcData, len);
                        ArrayList<UHFTAGInfo> list = new ArrayList<UHFTAGInfo>();
                        if (result != null) {
                            String strData = StringUtility.bytes2HexString2(result, result.length);
                            int count = result[2];
                            int begin = 6;
                            int end = 0;
                            int k2 = 0;
                            while (k2 < count) {
                                String strEPCLen;
                                int epcLen;
                                UHFTAGInfo tag = new UHFTAGInfo();
                                end = begin + 2;
                                if (end > strData.length() || (end = (begin = end) + (epcLen = Integer.parseInt(strEPCLen = strData.substring(begin, end), 16)) * 2) > strData.length()) break;
                                String epc = strData.substring(begin, end);
                                tag.setEPC(epc);
                                list.add(tag);
                                begin = end;
                                ++k2;
                            }
                        }
                        if (list.size() > 0) {
                            return list;
                        }
                        return null;
                    }
                } else {
                    if (isLog) {
                        this.writeLog2("readTagFromBuffer \u53d1\u9001\u6570\u636e\u5931\u8d25(A55A0008E0E80D0A)! msg=" + this.msg[0], true);
                    }
                    Log.d((String)"DeviceAPI", (String)"readTagFromBuffer \u53d1\u9001\u6570\u636e\u5931\u8d25(A55A0008E0E80D0A)!");
                }
            }
            return null;
        }
        if (this.rfidWithUHF == null) {
            return null;
        }
        String[] data = this.rfidWithUHF.readTagFromBuffer();
        if (data != null) {
            ArrayList<UHFTAGInfo> list = new ArrayList<UHFTAGInfo>();
            String epc = this.rfidWithUHF.convertUiiToEPC(data[1]);
            UHFTAGInfo uhfINfo = new UHFTAGInfo();
            uhfINfo.setEPC(epc);
            list.add(uhfINfo);
            return list;
        }
        return null;
    }

    public synchronized ArrayList<UHFTAGInfo> readTagFromBuffer_EpcTidUser() {
        if (isBluetooth) {
            if (!isStop) {
                String hexCmd = "A55A0008E0E80D0A";
                byte[] cmd = StringUtility.hexString2Bytes(hexCmd);
                if (isLog) {
                    Log.d((String)"DeviceAPI", (String)"writeRXCharacteristic");
                }
                this.cleanTestData();
                if (this.mService.writeRXCharacteristic(cmd, this.msg)) {
                    if (isDebug) {
                        Log.d((String)this.TAG, (String)"readTagFromBuffer \u53d1\u9001\u6570\u636e\u6210\u529f(A55A0008E0E80D0A)!");
                    }
                    int k = 0;
                    while (k < this.tempEpcData.length) {
                        this.tempEpcData[k] = 0;
                        ++k;
                    }
                    if (isLog) {
                        this.writeLog("\u5f00\u59cb\u83b7\u53d6\u6807\u7b7e", true);
                    }
                    this.startTime = System.currentTimeMillis();
                    int len = this.getDeviceAPI().UHFBTGetTag(this.tempEpcData, this.timeOut);
                    if (isLog) {
                        this.writeLog("\u83b7\u53d6\u6807\u7b7e\u8fd4\u56de\u957f\u5ea6 len=" + len, true);
                    }
                    Log.d((String)this.TAG, (String)("\u8bfb\u53d6\u6807\u7b7e\u8fd4\u56de\u957f\u5ea6:" + len));
                    if (len < 0 && len != -2) {
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (len > 2) {
                        byte[] result = Arrays.copyOf(this.tempEpcData, len);
                        ArrayList<UHFTAGInfo> list = new ArrayList<UHFTAGInfo>();
                        if (result != null) {
                            if (isDebug) {
                                Log.d((String)this.TAG, (String)("\u8bfb\u53d6\u6807\u7b7e\u8fd4\u56de:" + StringUtility.bytes2HexString2(result, result.length)));
                            }
                            int count = result[2];
                            int epc_lenIndex = 3;
                            int epc_startIndex = 4;
                            int epc_endIndex = 0;
                            if (isDebug) {
                                Log.d((String)this.TAG, (String)("\u8bfb\u53d6\u5230\u7684\u6807\u7b7e\u4e2a\u6570:" + count));
                            }
                            int k2 = 0;
                            while (k2 < count) {
                                UHFTAGInfo info;
                                epc_startIndex = epc_lenIndex + 1;
                                epc_endIndex = epc_startIndex + (result[epc_lenIndex] & 0xFF);
                                if (epc_endIndex > result.length) break;
                                byte[] epcBuff = Arrays.copyOfRange(result, epc_startIndex, epc_endIndex);
                                if (isDebug) {
                                    Log.d((String)this.TAG, (String)("epcBuff:" + StringUtility.bytes2HexString2(epcBuff, epcBuff.length)));
                                }
                                if ((info = this.parserUhfTagBuff(epcBuff)) != null) {
                                    list.add(info);
                                }
                                if ((epc_lenIndex = epc_endIndex) >= result.length) break;
                                ++k2;
                            }
                        }
                        if (isDebug) {
                            Log.d((String)this.TAG, (String)("\u89e3\u6790\u6570\u636e\u83b7\u53d6\u7684\u7684\u6807\u7b7e\u4e2a\u6570:" + list.size()));
                        }
                        if (list.size() > 0) {
                            return list;
                        }
                        return null;
                    }
                } else {
                    Log.d((String)this.TAG, (String)"readTagFromBuffer \u53d1\u9001\u6570\u636e\u5931\u8d25(A55A0008E0E80D0A)!");
                    if (isLog) {
                        this.writeLog2("readTagFromBuffer \u53d1\u9001\u6570\u636e\u5931\u8d25(A55A0008E0E80D0A)! msg=" + this.msg[0], true);
                    }
                }
            }
            return null;
        }
        if (this.rfidWithUHF == null) {
            return null;
        }
        String[] data = this.rfidWithUHF.readTagFromBuffer();
        if (data != null) {
            ArrayList<UHFTAGInfo> list = new ArrayList<UHFTAGInfo>();
            String epc = this.rfidWithUHF.convertUiiToEPC(data[1]);
            UHFTAGInfo uhfINfo = new UHFTAGInfo();
            uhfINfo.setEPC(epc);
            list.add(uhfINfo);
            return list;
        }
        return null;
    }

    private UHFTAGInfo parserUhfTagBuff(byte[] tagsBuff) {
        UHFTAGInfo info = new UHFTAGInfo();
        int len = tagsBuff.length;
        byte[] pcBuff = Arrays.copyOfRange(tagsBuff, 0, 2);
        int pc = pcBuff[0] & 0xFF | (pcBuff[1] & 0xFF) << 8;
        info.setPc(StringUtility.bytes2HexString2(pcBuff, pcBuff.length));
        int epclen = (pc >> 3) * 2;
        byte[] uii = Arrays.copyOfRange(tagsBuff, 0, 2 + epclen);
        String strUii = StringUtility.bytes2HexString2(uii, uii.length);
        info.setEPC(this.convertUiiToEPC(strUii));
        byte[] rssi = null;
        Object ant_data = null;
        String strAnt = "";
        if (len >= uii.length + 12) {
            int tidStart = uii.length;
            int tidEnd = tidStart + 12;
            byte[] tidBuff = Arrays.copyOfRange(tagsBuff, tidStart, tidEnd);
            info.setTid(StringUtility.bytes2HexString2(tidBuff, tidBuff.length));
            if (len - 3 > tidEnd) {
                int userStart = tidEnd;
                int userEnd = len - 2;
                byte[] userBuff = Arrays.copyOfRange(tagsBuff, userStart, userEnd);
                info.setUser(StringUtility.bytes2HexString2(userBuff, userBuff.length));
                if (len >= userEnd + 2) {
                    int rssiStart = userEnd;
                    int rssiEnd = userEnd + 2;
                    rssi = Arrays.copyOfRange(tagsBuff, rssiStart, rssiEnd);
                }
            } else if (len >= tidEnd + 2) {
                int rssiStart = tidEnd;
                int rssiEnd = tidEnd + 2;
                rssi = Arrays.copyOfRange(tagsBuff, rssiStart, rssiEnd);
            }
        } else if (len >= uii.length + 2) {
            int rssiStart = uii.length;
            int rssiEnd = 2 + uii.length;
            rssi = Arrays.copyOfRange(tagsBuff, rssiStart, rssiEnd);
        }
        if (rssi != null) {
            String strRssi = StringUtility.bytes2HexString2(rssi, rssi.length);
            float dBm = (float)(65535 - Integer.parseInt(strRssi, 16)) / 10.0f;
            String strdBm = "N/A";
            if (dBm < 200.0f && dBm > 0.0f) {
                DecimalFormat fnum = new DecimalFormat("##0.00");
                strdBm = "-" + fnum.format(dBm);
            }
            info.setRssi(strdBm);
        }
        if (ant_data != null) {
            strAnt = String.valueOf(ant_data[0] & 0xFF);
            info.setAnt(strAnt);
        }
        return info;
    }

    public boolean eraseData(String accessPwd, BankEnum bank, int ptr, int cnt) {
        BankEnum filterBank = BankEnum.EPC;
        int filterPtr = 0;
        int filterCnt = 0;
        String filterData = "00";
        return this.eraseData(accessPwd, filterBank, filterPtr, filterCnt, filterData, bank, ptr, cnt);
    }

    public synchronized boolean eraseData(String accessPwd, BankEnum filterBank, int filterPtr, int filterCnt, String filterData, BankEnum bank, int ptr, int cnt) {
        if (StringUtility.isEmpty(accessPwd) || !StringUtility.isHexNumberRex(accessPwd)) {
            return false;
        }
        if (StringUtility.isEmpty(filterData) || !StringUtility.isHexNumberRex(filterData)) {
            return false;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return false;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return false;
            }
        } else {
            filterData = "00";
            filterCnt = 0;
        }
        char[] pszuAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char filter_bank = (char)filterBank.value;
        int filter_ptr = filterPtr;
        char filter_cnt = (char)filterCnt;
        char[] filter_data = StringUtility.hexString2Chars(filterData);
        char uBank = (char)bank.value;
        int uPtr = ptr;
        int uCnt = cnt;
        int result = this.getDeviceAPI().UHFBTEraseData(pszuAccessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, uBank, uPtr, uCnt);
        if (result == 0) {
            return true;
        }
        Log.e((String)this.TAG, (String)("eraseData() err :" + result));
        return false;
    }

    public boolean getBluetoothMode() {
        return isBluetooth;
    }

    public void setBluetoothMode(boolean isBluetoothMode) {
        isBluetooth = isBluetoothMode;
    }

    public int getAllTagTotalFromFlash() {
        return this.getDeviceAPI().UHFBTGetAllTagNumFromFlash();
    }

    public boolean deleteAllTagToFlash() {
        return this.getDeviceAPI().UHFBTDeleteAllTagToFlash() == 0;
    }

    public ArrayList<UHFTAGInfo> getTagDataFromFlash() {
        byte[] outData = new byte[1024];
        int result = this.getDeviceAPI().UHFBTGetTagDataFromFlash(outData);
        if (result <= 0) {
            return null;
        }
        ArrayList<UHFTAGInfo> list = new ArrayList<UHFTAGInfo>();
        byte[] tagBuff = Arrays.copyOfRange(outData, 0, result);
        int tagCount = tagBuff[0] & 0xFF;
        int start = 0;
        int end = 1;
        int k = 0;
        while (k < tagCount) {
            UHFTAGInfo info = new UHFTAGInfo();
            byte epcLen = tagBuff[end];
            start = end + 1;
            end = start + epcLen;
            byte[] epcBuff = Arrays.copyOfRange(tagBuff, start, end);
            info.setEPC(StringUtility.bytes2HexString2(epcBuff, epcBuff.length));
            list.add(info);
            ++k;
        }
        return list;
    }

    public boolean setCW(int flag) {
        if (flag != 0 && flag != 1) {
            throw new IllegalArgumentException();
        }
        int result = this.getDeviceAPI().UHFBTSetCW(flag);
        return result == 0;
    }

    public int getCW() {
        return this.getDeviceAPI().UHFBTGetCW();
    }

    public boolean setGen2(int target, int action, int t, int q, int startQ, int minQ, int maxQ, int dr, int coding, int p, int Sel, int Session, int g, int linkFrequency) {
        StringBuilder sb = new StringBuilder();
        sb.append("target=");
        sb.append(String.valueOf(target));
        sb.append("\naction=");
        sb.append(String.valueOf(action));
        sb.append("\nt=");
        sb.append(String.valueOf(t));
        sb.append("\nq=");
        sb.append(String.valueOf(q));
        sb.append("\nstartQ=");
        sb.append(String.valueOf(startQ));
        sb.append("\nminQ=");
        sb.append(String.valueOf(minQ));
        sb.append("\nmaxQ=");
        sb.append(String.valueOf(maxQ));
        sb.append("\ndr=");
        sb.append(String.valueOf(dr));
        sb.append("\ncoding=");
        sb.append(String.valueOf(coding));
        sb.append("\n p=");
        sb.append(String.valueOf(p));
        sb.append("\nSel=");
        sb.append(String.valueOf(Sel));
        sb.append("\nSession=");
        sb.append(String.valueOf(Session));
        sb.append("\ng=");
        sb.append(String.valueOf(g));
        sb.append("\nlinkFrequency=");
        sb.append(String.valueOf(linkFrequency));
        Log.i((String)this.TAG, (String)sb.toString());
        int result = this.getDeviceAPI().UHFBTSetGen2((char)target, (char)action, (char)t, (char)q, (char)startQ, (char)minQ, (char)maxQ, (char)dr, (char)coding, (char)p, (char)Sel, (char)Session, (char)g, (char)linkFrequency);
        return result == 0;
    }

    public char[] getGen2() {
        Log.d((String)this.TAG, (String)"GetGen2()=========");
        byte[] data = new byte[14];
        int result = this.getDeviceAPI().UHFBTGetGen2(data);
        if (result == 14) {
            StringBuilder sb = new StringBuilder();
            sb.append("target data[0]=");
            sb.append(String.valueOf(0xFF & data[0]));
            sb.append("\naction data[1]=");
            sb.append(String.valueOf(0xFF & data[1]));
            sb.append("\nt data[2]=");
            sb.append(String.valueOf(0xFF & data[2]));
            sb.append("\nq data[3]=");
            sb.append(String.valueOf(0xFF & data[3]));
            sb.append("\nstartQ data[4]=");
            sb.append(String.valueOf(0xFF & data[4]));
            sb.append("\nminQ data[5]=");
            sb.append(String.valueOf(0xFF & data[5]));
            sb.append("\nmaxQ data[6]=");
            sb.append(String.valueOf(0xFF & data[6]));
            sb.append("\ndr data[7]=");
            sb.append(String.valueOf(0xFF & data[7]));
            sb.append("\ncoding data[8]=");
            sb.append(String.valueOf(0xFF & data[8]));
            sb.append("\n p data[9]=");
            sb.append(String.valueOf(0xFF & data[9]));
            sb.append("\nSel data[10]=");
            sb.append(String.valueOf(0xFF & data[10]));
            sb.append("\nSession data[11]=");
            sb.append(String.valueOf(0xFF & data[11]));
            sb.append("\ng data[12]=");
            sb.append(String.valueOf(0xFF & data[12]));
            sb.append("\nlinkFrequency data[13]=");
            sb.append(String.valueOf(0xFF & data[13]));
            Log.d((String)this.TAG, (String)sb.toString());
            return StringUtility.bytesTochars(data, data.length);
        }
        return null;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public HashMap<String, String> getBTVersion() {
        if (this.mService != null) {
            return this.mService.getVersion();
        }
        return null;
    }

    private void writeLog(String data, boolean isAppend) {
        block16: {
            if (isLog || isLog2) {
                if (!this.bleResultLog.exists()) {
                    try {
                        this.bleResultLog.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                BufferedWriter bufferedWriter = null;
                try {
                    try {
                        bufferedWriter = new BufferedWriter(new FileWriter(this.bleResultLog, isAppend));
                        bufferedWriter.write(RFIDWithUHFBluetooth.getDateTime1());
                        bufferedWriter.write(" ");
                        bufferedWriter.write(data);
                        bufferedWriter.newLine();
                        bufferedWriter.close();
                    }
                    catch (Exception exception) {
                        if (bufferedWriter == null) break block16;
                        try {
                            bufferedWriter.close();
                        }
                        catch (Exception exception2) {}
                    }
                }
                finally {
                    if (bufferedWriter != null) {
                        try {
                            bufferedWriter.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    private void writeLog2(String data, boolean isAppend) {
        block16: {
            if (isLog) {
                if (!this.bleDataLog.exists()) {
                    try {
                        this.bleDataLog.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                BufferedWriter bufferedWriter = null;
                try {
                    try {
                        bufferedWriter = new BufferedWriter(new FileWriter(this.bleDataLog, isAppend));
                        bufferedWriter.write(RFIDWithUHFBluetooth.getDateTime2());
                        bufferedWriter.write(" ");
                        bufferedWriter.write(data);
                        bufferedWriter.newLine();
                        bufferedWriter.close();
                    }
                    catch (Exception exception) {
                        if (bufferedWriter == null) break block16;
                        try {
                            bufferedWriter.close();
                        }
                        catch (Exception exception2) {}
                    }
                }
                finally {
                    if (bufferedWriter != null) {
                        try {
                            bufferedWriter.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    private void writeLog3(String data, boolean isAppend) {
        block16: {
            if (isLog) {
                if (!this.bleRawDataLog.exists()) {
                    try {
                        this.bleRawDataLog.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                BufferedWriter bufferedWriter = null;
                try {
                    try {
                        bufferedWriter = new BufferedWriter(new FileWriter(this.bleRawDataLog, isAppend));
                        bufferedWriter.write(RFIDWithUHFBluetooth.getDateTime2());
                        bufferedWriter.write(" ");
                        bufferedWriter.write(data);
                        bufferedWriter.newLine();
                        bufferedWriter.close();
                    }
                    catch (Exception exception) {
                        if (bufferedWriter == null) break block16;
                        try {
                            bufferedWriter.close();
                        }
                        catch (Exception exception2) {}
                    }
                }
                finally {
                    if (bufferedWriter != null) {
                        try {
                            bufferedWriter.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    private static String getDateTime1() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return simpleDateFormat.format(date);
    }

    private static String getDateTime2() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return simpleDateFormat.format(date);
    }

    private void deleteLogFile() {
        this.bleResultLog.exists();
        this.bleDataLog.exists();
        this.bleRawDataLog.exists();
    }

    private void writeData(byte[] data, int start, int len) {
        if (isLog || isLog2) {
            int k = 0;
            while (k < data.length) {
                if (this.tempTagDataIndex <= this.tempTestData.length - 2) {
                    this.tempTestData[this.tempTagDataIndex++] = data[k];
                }
                ++k;
            }
        }
    }

    private void cleanTestData() {
        this.tempTagDataIndex = 0;
        int k = 0;
        while (k < this.tempTestData.length) {
            this.tempTestData[k] = 0;
            ++k;
        }
    }

    public static interface BTStatusCallback {
        public void getStatus(StatusEnum var1, BluetoothDevice var2);
    }

    public static enum BankEnum {
        RESERVED(0),
        EPC(1),
        TID(2),
        USER(3);

        private final byte value;

        public byte getValue() {
            return this.value;
        }

        private BankEnum(byte value) {
            this.value = value;
        }
    }

    class DataReceiveBTData
    implements BTService.IDataCallBack {
        DataReceiveBTData() {
        }

        @Override
        public void receiveBTData(byte[] txValue, boolean flag) {
            RFIDWithUHFBluetooth.this.receiveData(txValue, flag);
        }
    }

    public static interface KeyEventCallback {
        public void getKeyEvent(int var1);
    }

    public static interface ScanBTCallback {
        public void getDevices(BluetoothDevice var1, int var2, byte[] var3);
    }

    public static enum StatusEnum {
        CONNECTED,
        DISCONNECTED,
        CONNECTING;

    }
}

