/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.content.Context;
import android.util.Log;
import com.rscja.deviceapi.Device;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.UHFProtocolParseUSB;
import com.rscja.deviceapi.entity.UHFTAGInfo;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.deviceapi.interfaces.ConnectionStatus;
import com.rscja.deviceapi.interfaces.ConnectionStatusCallback;
import com.rscja.deviceapi.interfaces.IUHF;
import com.rscja.utility.StringUtility;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;

public class RFIDWithUHFUART
extends Device
implements IUHF {
    private static final String TAG = String.valueOf(StringUtility.TAG) + "UHF";
    private static RFIDWithUHFUART single = null;
    private boolean DEBUG = StringUtility.DEBUG;
    protected DeviceConfiguration config;
    private char[] uhfdata = new char[512];
    private ConnectionStatus connectionStatus = ConnectionStatus.DISCONNECTED;
    private ConnectionStatusCallback<Object> btStatusCallback = null;

    protected RFIDWithUHFUART() throws ConfigurationException {
        this.config = DeviceConfiguration.builderUHFConfiguration();
    }

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized RFIDWithUHFUART getInstance() throws ConfigurationException {
        if (single != null) return single;
        Class<RFIDWithUHFUART> clazz = RFIDWithUHFUART.class;
        synchronized (RFIDWithUHFUART.class) {
            if (single != null) return single;
            single = new RFIDWithUHFUART();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public synchronized void setUart(String uart) {
        this.config.setUart(uart);
        this.config.setDeviceName("unknown");
    }

    public synchronized boolean init() {
        this.setConnectStatus(ConnectionStatus.CONNECTING);
        int result = this.getDeviceAPI().UHFInit(this.config.getDeviceName());
        if (result > -1) {
            result = this.getDeviceAPI().UHFOpenAndConnect_Ex(this.config.getUart());
            Log.i((String)TAG, (String)("init() Uart = " + this.config.getUart()));
            if (result > -1) {
                this.setPowerOn(true);
                this.setConnectStatus(ConnectionStatus.CONNECTED);
                return true;
            }
            Log.e((String)TAG, (String)("init() err UHFOpenAndConnect result:" + result));
            String strName = this.config.getDeviceName();
            if (strName.equals(DeviceConfiguration.C4000_6577) || strName.equals(DeviceConfiguration.C4000_6582) || strName.equals(DeviceConfiguration.C4050_6582) || strName.equals(DeviceConfiguration.C4050_8909)) {
                this.getDeviceAPI().UHFCloseAndDisconnect();
                result = this.getDeviceAPI().UHFOpenAndConnect(this.config.getUart());
                if (result > -1) {
                    this.setPowerOn(true);
                    this.setConnectStatus(ConnectionStatus.CONNECTED);
                    return true;
                }
            }
        } else {
            Log.e((String)TAG, (String)("init() err UHFInit result:" + result));
        }
        this.setConnectStatus(ConnectionStatus.DISCONNECTED);
        return false;
    }

    @Override
    public synchronized boolean init(Context context) {
        return this.init_R2000();
    }

    public synchronized boolean init_R2000() {
        this.setConnectStatus(ConnectionStatus.CONNECTING);
        int result = this.getDeviceAPI().UHFInit(this.config.getDeviceName());
        if (result > -1) {
            result = this.getDeviceAPI().UHFOpenAndConnect(this.config.getUart());
            Log.i((String)TAG, (String)("init() Uart = " + this.config.getUart()));
            if (result > -1) {
                this.setPowerOn(true);
                this.setConnectStatus(ConnectionStatus.CONNECTED);
                return true;
            }
            Log.e((String)TAG, (String)("init() err UHFOpenAndConnect result:" + result));
            String strName = this.config.getDeviceName();
            if (strName.equals(DeviceConfiguration.C4000_6577) || strName.equals(DeviceConfiguration.C4000_6582) || strName.equals(DeviceConfiguration.C4050_6582) || strName.equals(DeviceConfiguration.C4050_8909)) {
                this.getDeviceAPI().UHFCloseAndDisconnect();
                result = this.getDeviceAPI().UHFOpenAndConnect(this.config.getUart());
                if (result > -1) {
                    this.setPowerOn(true);
                    this.setConnectStatus(ConnectionStatus.CONNECTED);
                    return true;
                }
            }
        } else {
            Log.e((String)TAG, (String)("init() err UHFInit result:" + result));
        }
        this.setConnectStatus(ConnectionStatus.DISCONNECTED);
        return false;
    }

    @Override
    public synchronized boolean free() {
        this.getDeviceAPI().UHFCloseAndDisconnect();
        int result = this.getDeviceAPI().UHFFree(this.config.getDeviceName());
        if (result == 0) {
            this.setPowerOn(false);
            this.setConnectStatus(ConnectionStatus.DISCONNECTED);
            return true;
        }
        Log.e((String)TAG, (String)("free() err UHFFree result:" + result));
        this.setConnectStatus(ConnectionStatus.DISCONNECTED);
        return false;
    }

    @Override
    public synchronized String getVersion() {
        if (!this.isPowerOn()) {
            return null;
        }
        char[] result = this.getDeviceAPI().UHFGetHwType();
        if (result != null && result[0] == '\u0000') {
            char[] arrs = Arrays.copyOfRange(result, 2, result[1] + 2);
            return new String(arrs);
        }
        Log.e((String)TAG, (String)("getHardwareType() err:" + result[0]));
        return null;
    }

    @Override
    public synchronized int getPower() {
        char[] result = this.getDeviceAPI().UHFGetPower();
        if (result != null && result[0] == '\u0000') {
            return result[1];
        }
        Log.e((String)TAG, (String)("getPower() err :" + result[0]));
        return -1;
    }

    @Override
    public synchronized boolean setPower(int power) {
        int result = this.getDeviceAPI().UHFSetPower((char)power);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setPower() err :" + result));
        return false;
    }

    @Override
    public synchronized int getFrequencyMode() {
        char[] result = this.getDeviceAPI().UHFGetFrequency_Ex();
        if (result != null && result[0] == '\u0000') {
            char freMode = result[1];
            int FreqValue = -1;
            switch (freMode) {
                case '\u0000': {
                    FreqValue = 2;
                    break;
                }
                case '\u0001': {
                    FreqValue = 1;
                    break;
                }
                case '\u0002': {
                    FreqValue = 4;
                    break;
                }
                case '\u0004': {
                    FreqValue = 8;
                    break;
                }
                case '\u0005': {
                    FreqValue = 22;
                    break;
                }
                case '\u0006': {
                    FreqValue = 50;
                    break;
                }
                case '\u0007': {
                    FreqValue = 128;
                    break;
                }
                case '\b': {
                    FreqValue = 51;
                    break;
                }
                case '\t': {
                    FreqValue = 52;
                }
            }
            return FreqValue;
        }
        Log.e((String)TAG, (String)("getFrequencyMode() err :" + result[0]));
        return -1;
    }

    @Override
    public synchronized boolean setFrequencyMode(int freMode) {
        int FreqValue = -1;
        switch (freMode) {
            case 2: {
                FreqValue = 0;
                break;
            }
            case 1: {
                FreqValue = 1;
                break;
            }
            case 4: {
                FreqValue = 2;
                break;
            }
            case 8: {
                FreqValue = 4;
                break;
            }
            case 22: {
                FreqValue = 5;
                break;
            }
            case 50: {
                FreqValue = 6;
                break;
            }
            case 128: {
                FreqValue = 7;
                break;
            }
            case 51: {
                FreqValue = 8;
                break;
            }
            case 52: {
                FreqValue = 9;
            }
        }
        int result = this.getDeviceAPI().UHFSetFrequency_EX((char)FreqValue);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setFrequencyMode() err :" + result));
        return false;
    }

    @Override
    public synchronized boolean startInventoryTag() {
        return this.startInventoryTag(0, 0, 6);
    }

    public synchronized boolean startInventoryTag(int flagAnti, int initQ, int tidLen) {
        int result = this.getDeviceAPI().UHFInventory_EX_cnt((char)flagAnti, (char)initQ, (char)tidLen);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("startInventory() err :" + result));
        return false;
    }

    @Override
    public synchronized UHFTAGInfo readTagFromBuffer() {
        int k = 0;
        while (k < this.uhfdata.length) {
            this.uhfdata[k] = '\u0000';
            ++k;
        }
        int r = this.getDeviceAPI().UHFGetReceived_EX2(this.uhfdata);
        if (r == -1 || this.uhfdata[0] != '\u0000') {
            return null;
        }
        UHFTAGInfo info = new UHFTAGInfo();
        int uiiIndex = 3;
        int uiiEnd = 3 + this.uhfdata[2];
        int tidIndex = uiiEnd + 1;
        int tidEnd = tidIndex + this.uhfdata[uiiEnd];
        int rssiIndex = 0;
        int rssiEnd = 0;
        int antIndex = 0;
        int antEnd = 0;
        if (tidEnd - tidIndex > 4) {
            int tidLen = 12;
            char[] tid = Arrays.copyOfRange(this.uhfdata, tidIndex, tidEnd);
            if (tid.length > 12) {
                char[] user = Arrays.copyOfRange(tid, 12, tid.length);
                info.setUser(StringUtility.chars2HexString(user, user.length));
            }
            info.setTid(StringUtility.chars2HexString(tid, 12));
            rssiIndex = tidEnd;
            antIndex = rssiEnd = rssiIndex + 2;
            antEnd = antIndex + 2;
        } else {
            info.setTid("");
            rssiIndex = uiiEnd + 1;
            antIndex = rssiEnd = rssiIndex + 2;
            antEnd = antIndex + 2;
        }
        char[] ant_data = Arrays.copyOfRange(this.uhfdata, antIndex, antEnd);
        char[] rssi = Arrays.copyOfRange(this.uhfdata, rssiIndex, rssiEnd);
        char[] pc = Arrays.copyOfRange(this.uhfdata, uiiIndex, uiiIndex + 2);
        char[] epc = Arrays.copyOfRange(this.uhfdata, uiiIndex + 2, uiiEnd);
        String strAnt = String.valueOf((ant_data[1] & 0xFF) << 8 | ant_data[0] & 0xFF);
        String strRssi = StringUtility.chars2HexString(rssi, rssi.length);
        String hexPC = StringUtility.chars2HexString(pc, pc.length);
        String hexEPC = StringUtility.chars2HexString(epc, epc.length);
        float dBm = (float)(65535 - Integer.parseInt(strRssi, 16)) / 10.0f;
        String strdBm = "N/A";
        if (dBm < 200.0f && dBm > 0.0f) {
            DecimalFormat fnum = new DecimalFormat("##0.00");
            strdBm = "-" + fnum.format(dBm);
        }
        info.setAnt(strAnt);
        info.setRssi(strdBm);
        info.setPc(hexPC);
        info.setEPC(hexEPC);
        return info;
    }

    @Override
    public synchronized boolean stopInventory() {
        int result = this.getDeviceAPI().UHFStopGet();
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("stopInventory() err :" + result));
        return false;
    }

    @Override
    public String generateLockCode(ArrayList<Integer> lockBank, int lockMode) {
        if (lockBank == null || lockBank.size() == 0 || lockMode < 0) {
            return null;
        }
        switch (lockMode) {
            case 16: 
            case 32: 
            case 48: 
            case 64: {
                break;
            }
            default: {
                throw new IllegalArgumentException("lockMode error");
            }
        }
        return UHFProtocolParseUSB.getInstance().generateLockCode(lockBank, lockMode);
    }

    @Override
    public synchronized boolean lockMem(String accessPwd, String lockCode) {
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] bEpc = new char[1];
        char[] bLockData = StringUtility.hexString2Chars(lockCode);
        boolean result = this.lockMem(accessPwd, 1, 0, 0, "", lockCode);
        if (result) {
            return true;
        }
        Log.e((String)TAG, (String)("lockMem() err :" + result));
        return false;
    }

    @Override
    public boolean lockMem(String accessPwd, int bank, int ptr, int cnt, String filterData, String lockCode) {
        if (StringUtility.isEmpty(accessPwd)) {
            return false;
        }
        if (StringUtility.isEmpty(lockCode)) {
            return false;
        }
        if (cnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return false;
            }
            int tempLen = cnt / 8 + (cnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return false;
            }
        } else {
            filterData = "00";
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] filter = StringUtility.hexString2Chars(filterData);
        char[] bLockData = StringUtility.hexString2Chars(lockCode);
        return DeviceAPI.getInstance().UHFLockMemEx(bAccessPwd, (char)bank, ptr, cnt, filter, bLockData) == 0;
    }

    @Override
    public boolean uhfGBTagLock(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData, int memory, int config, int action) {
        if (accessPwd.length() != 8) {
            Log.e((String)TAG, (String)"uhfGBTagLock==> accessPwd.length()!=8");
            return false;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return false;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return false;
            }
        } else {
            filterData = "00";
        }
        char[] pszuAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char bank = (char)filterBank;
        int ptr = filterPtr;
        int len = filterCnt;
        char[] data = StringUtility.hexString2Chars(filterData);
        int iMemory = memory;
        int iConfig = config;
        int iAction = action;
        if (this.DEBUG) {
            StringBuilder sb = new StringBuilder();
            sb.append("uhfGBTagLock==>");
            sb.append("accessPwd:" + accessPwd);
            sb.append(",filterBank:" + bank);
            sb.append(",filterPtr:" + ptr);
            sb.append(",filterCnt:" + len);
            sb.append(",filterdata:" + filterData);
            sb.append(",iMemory:" + iMemory);
            sb.append(",iConfig:" + iConfig);
            sb.append(",iAction:" + iAction);
            Log.d((String)TAG, (String)sb.toString());
        }
        return DeviceAPI.getInstance().UHFGBTagLock(pszuAccessPwd, bank, ptr, len, data, iMemory, iConfig, iAction) == 0;
    }

    @Override
    public synchronized boolean uhfGBTagLock(String accessPwd, int memory, int config, int action) {
        String _accessPwd = accessPwd;
        int _filterBank = 1;
        int _filterPtr = 0;
        int _filterCnt = 0;
        String _filterData = "00";
        int _memory = memory;
        int _config = config;
        int _action = action;
        return this.uhfGBTagLock(_accessPwd, _filterBank, _filterPtr, _filterCnt, _filterData, _memory, _config, _action);
    }

    @Override
    public synchronized UHFTAGInfo inventorySingleTag() {
        char[] uhfdata = this.getDeviceAPI().UHFInventorySingleEPCTIDUSER();
        if (uhfdata == null || uhfdata[0] != '\u0000') {
            return null;
        }
        Log.i((String)TAG, (String)("data =" + StringUtility.chars2HexString(uhfdata, uhfdata.length)));
        UHFTAGInfo info = new UHFTAGInfo();
        int uiiIndex = 3;
        int uiiEnd = 3 + uhfdata[2];
        int tidIndex = uiiEnd + 1;
        int tidEnd = tidIndex + uhfdata[uiiEnd];
        int rssiIndex = 0;
        int rssiEnd = 0;
        int antIndex = 0;
        int antEnd = 0;
        if (tidEnd - tidIndex > 4) {
            int tidLen = 12;
            char[] tid = Arrays.copyOfRange(uhfdata, tidIndex, tidEnd);
            if (tid.length > 12) {
                char[] user = Arrays.copyOfRange(tid, 12, tid.length);
                info.setUser(StringUtility.chars2HexString(user, user.length));
            }
            info.setTid(StringUtility.chars2HexString(tid, 12));
            if (uhfdata.length >= tidEnd + 2 && uhfdata.length >= (rssiEnd = (rssiIndex = tidEnd) + 2) + 2) {
                antIndex = rssiEnd;
                antEnd = antIndex + 2;
            }
        } else {
            info.setTid("");
            if (uhfdata.length >= rssiIndex + 2 && uhfdata.length >= (rssiEnd = (rssiIndex = uiiEnd + 1) + 2) + 2) {
                antIndex = rssiEnd;
                antEnd = antIndex + 2;
            }
        }
        char[] ant_data = Arrays.copyOfRange(uhfdata, antIndex, antEnd);
        String strRssi = "";
        if (rssiEnd > 0) {
            char[] rssi = Arrays.copyOfRange(uhfdata, rssiIndex, rssiEnd);
            strRssi = StringUtility.chars2HexString(rssi, rssi.length);
        }
        char[] pc = Arrays.copyOfRange(uhfdata, uiiIndex, uiiIndex + 2);
        char[] epc = Arrays.copyOfRange(uhfdata, uiiIndex + 2, uiiEnd);
        if (antEnd > 0) {
            String strAnt = String.valueOf((ant_data[1] & 0xFF) << 8 | ant_data[0] & 0xFF);
            info.setAnt(strAnt);
        }
        String hexPC = StringUtility.chars2HexString(pc, pc.length);
        String hexEPC = StringUtility.chars2HexString(epc, epc.length);
        float dBm = (float)(65535 - Integer.parseInt(strRssi, 16)) / 10.0f;
        String strdBm = "N/A";
        if (dBm < 200.0f && dBm > 0.0f) {
            DecimalFormat fnum = new DecimalFormat("##0.00");
            strdBm = "-" + fnum.format(dBm);
        }
        info.setRssi(strdBm);
        info.setPc(hexPC);
        info.setEPC(hexEPC);
        return info;
    }

    @Override
    public String readData(String accessPwd, int bank, int ptr, int cnt) {
        if (StringUtility.isEmpty(accessPwd) || !StringUtility.isHexNumberRex(accessPwd)) {
            return null;
        }
        int filterBank = 1;
        int filterPtr = 0;
        int filterCnt = 0;
        return this.readData(accessPwd, filterBank, filterPtr, filterCnt, "00", bank, ptr, cnt);
    }

    @Override
    public String readData(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData, int bank, int ptr, int cnt) {
        if (StringUtility.isEmpty(accessPwd) || !StringUtility.isHexNumberRex(accessPwd)) {
            return null;
        }
        if (StringUtility.isEmpty(filterData) || !StringUtility.isHexNumberRex(filterData)) {
            return null;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return null;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return null;
            }
        } else {
            filterData = "00";
            filterCnt = 0;
        }
        char[] pszuAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char filter_bank = (char)filterBank;
        int filter_ptr = filterPtr;
        int filter_cnt = filterCnt;
        char[] filter_data = StringUtility.hexString2Chars(filterData);
        char uBank = (char)bank;
        int uPtr = ptr;
        int uCnt = cnt;
        char[] result = this.getDeviceAPI().UHFReadData_Ex2(pszuAccessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, uBank, uPtr, uCnt);
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("readData() err :" + result[0]));
            return null;
        }
        char[] data = Arrays.copyOfRange(result, 2, result[1] + 2);
        return StringUtility.chars2HexString(data, data.length);
    }

    @Override
    public boolean writeData(String accessPwd, int bank, int ptr, int cnt, String data) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data)) {
            return false;
        }
        int filter_bank = 1;
        int filter_ptr = 32;
        int filter_cnt = 0;
        String filter_data = "00";
        boolean result = this.writeData(accessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, bank, ptr, cnt, data);
        return result;
    }

    @Override
    public boolean writeData(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData, int bank, int ptr, int cnt, String writeData) {
        if (StringUtility.isEmpty(accessPwd) || !StringUtility.isHexNumberRex(accessPwd)) {
            return false;
        }
        if (StringUtility.isEmpty(writeData) || !StringUtility.isHexNumberRex(writeData)) {
            return false;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return false;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return false;
            }
        } else {
            filterData = "00";
            filterCnt = 0;
        }
        char[] pszuAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char filter_bank = (char)filterBank;
        int filter_ptr = filterPtr;
        int filter_cnt = filterCnt;
        char[] filter_data = StringUtility.hexString2Chars(filterData);
        char uBank = (char)bank;
        int uPtr = ptr;
        char uCnt = (char)cnt;
        char[] ufData_write = StringUtility.hexString2Chars(writeData);
        int result = this.getDeviceAPI().UHFWriteData_Ex2(pszuAccessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, uBank, uPtr, uCnt, ufData_write);
        return result == 0;
    }

    @Override
    public boolean blockWriteData(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData, int bank, int ptr, int cnt, String writeData) {
        if (StringUtility.isEmpty(accessPwd) || !StringUtility.isHexNumberRex(accessPwd)) {
            return false;
        }
        if (StringUtility.isEmpty(writeData) || !StringUtility.isHexNumberRex(writeData)) {
            return false;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return false;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return false;
            }
        } else {
            filterData = "00";
            filterCnt = 0;
        }
        char[] pszuAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char filter_bank = (char)filterBank;
        int filter_ptr = filterPtr;
        int filter_cnt = filterCnt;
        char[] filter_data = StringUtility.hexString2Chars(filterData);
        char uBank = (char)bank;
        int uPtr = ptr;
        int uCnt = cnt;
        char[] ufData_write = StringUtility.hexString2Chars(writeData);
        int result = this.getDeviceAPI().UHFBlockWriteData(pszuAccessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, uBank, uPtr, uCnt, ufData_write);
        return result == 0;
    }

    @Override
    public boolean eraseData(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData, int bank, int ptr, int cnt) {
        if (StringUtility.isEmpty(accessPwd) || !StringUtility.isHexNumberRex(accessPwd)) {
            return false;
        }
        if (StringUtility.isEmpty(filterData) || !StringUtility.isHexNumberRex(filterData)) {
            return false;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return false;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return false;
            }
        } else {
            filterData = "00";
            filterCnt = 0;
        }
        char[] pszuAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char filter_bank = (char)filterBank;
        int filter_ptr = filterPtr;
        char filter_cnt = (char)filterCnt;
        char[] filter_data = StringUtility.hexString2Chars(filterData);
        char uBank = (char)bank;
        int uPtr = ptr;
        int uCnt = cnt;
        int result = this.getDeviceAPI().UHFEraseDataEx(pszuAccessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, uBank, uPtr, uCnt);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("eraseData() err :" + result));
        return false;
    }

    @Override
    public boolean setFilter(int bank, int ptr, int cnt, String data) {
        boolean save = false;
        if (cnt < 0 || ptr < 0) {
            return false;
        }
        if (cnt > 0) {
            if (StringUtility.isEmpty(data)) {
                return false;
            }
            int len = cnt / 8 + (cnt % 8 == 0 ? 0 : 1);
            int dataLen = data.replace(" ", "").length() / 2;
            if (dataLen < len) {
                return false;
            }
        } else {
            data = "00";
        }
        boolean flag = save;
        char[] bData = StringUtility.hexString2Chars(data);
        int result = this.getDeviceAPI().UHFSetFilter_Ex((char)(flag ? 1 : 0), (char)bank, ptr, cnt, bData);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setFilter() err :" + result));
        return false;
    }

    @Override
    public synchronized boolean killTag(String killPwd) {
        if (StringUtility.isEmpty(killPwd)) {
            return false;
        }
        char[] bKillPwd = StringUtility.hexString2Chars(killPwd);
        char[] result = this.getDeviceAPI().UHFKillTagSingle(bKillPwd);
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("killTag() err :" + result[0]));
            return false;
        }
        return true;
    }

    @Override
    public boolean killTag(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData) {
        if (StringUtility.isEmpty(accessPwd)) {
            return false;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return false;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return false;
            }
        } else {
            filterData = "00";
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] filter = StringUtility.hexString2Chars(filterData);
        return DeviceAPI.getInstance().UHFKillTagEx(bAccessPwd, (char)filterBank, filterPtr, (char)filterCnt, filter) == 0;
    }

    @Override
    public synchronized boolean setProtocol(int protocol) {
        int result = this.getDeviceAPI().UHFSetProtocolType(protocol);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setProtocol() err :" + result));
        return false;
    }

    @Override
    public synchronized int getProtocol() {
        char[] reuslt = this.getDeviceAPI().UHFGetProtocolType();
        if (reuslt[0] == '\u0000') {
            return reuslt[2];
        }
        return -1;
    }

    @Override
    public synchronized boolean setFreHop(float fre) {
        int ifre = (int)(fre * 1000.0f);
        int result = this.getDeviceAPI().R2000_FreHopSet(ifre);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setFreHop() err :" + result));
        return false;
    }

    @Override
    public synchronized boolean setRFLink(int mode) {
        int result = this.getDeviceAPI().UHFSetRFLink((char)mode);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setRFLink() err :" + result));
        return false;
    }

    @Override
    public synchronized int getRFLink() {
        byte[] result = this.getDeviceAPI().UHFGetRFLink();
        if (result == null || result[0] != 0) {
            Log.e((String)TAG, (String)("getRFLink() err :" + result[0]));
            return -1;
        }
        if (result.length > 1) {
            return result[1];
        }
        return -1;
    }

    @Override
    public synchronized boolean setFastID(boolean enalbe) {
        int result = this.getDeviceAPI().UHFSetFastID((char)(enalbe ? 1 : 0));
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setFastID() err :" + result));
        return false;
    }

    @Override
    public synchronized boolean setTagFocus(boolean enalbe) {
        int result = this.getDeviceAPI().UHFSetTagFocus((char)(enalbe ? 1 : 0));
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setTagFocus() err :" + result));
        return false;
    }

    @Override
    public synchronized boolean setEPCMode() {
        int save = 0;
        int result = this.getDeviceAPI().UHFSetEPCUserMode('\u0000', 0, 0, save);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setEPCUSERMode() err :" + result));
        return false;
    }

    @Override
    public synchronized boolean setEPCAndTIDMode() {
        int save = 0;
        int result = this.getDeviceAPI().UHFSetEPCUserMode('\u0001', 0, 0, save);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setEPCAndTIDMode() err :" + result));
        return false;
    }

    @Override
    public synchronized boolean setEPCAndTIDUserMode(int user_prt, int user_len) {
        int save = 0;
        int result = this.getDeviceAPI().UHFSetEPCUserMode('\u0002', user_prt, user_len, save);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setEPCAndTIDUserMode() err :" + result));
        return false;
    }

    @Override
    public synchronized int getTemperature() {
        char[] result = this.getDeviceAPI().GetTemperature();
        if (result == null || result[0] != '\u0000') {
            return -1;
        }
        if (result[1] >= '\u00f0') {
            String hex = StringUtility.chars2HexString(new char[]{result[1], result[2]}, 2);
            int t = Integer.valueOf(hex, 16);
            return -((65535 - t) / 100);
        }
        String hex = StringUtility.chars2HexString(new char[]{result[1], result[2]}, 2);
        return Integer.valueOf(hex, 16) / 100;
    }

    @Override
    public boolean uhfBlockPermalock(String accessPwd, int FilterBank, int FilterStartaddr, int FilterLen, String FilterData, int ReadLock, int uBank, int uPtr, int uRange, byte[] uMaskbuf) {
        char[] result;
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] data = StringUtility.hexString2Chars(FilterData);
        if (this.DEBUG) {
            Log.i((String)TAG, (String)("accessPwd=" + accessPwd + " FilterBank=" + FilterBank + " FilterStartaddr=" + FilterStartaddr + " FilterLen=" + FilterLen + " FilterData=" + FilterData + " ReadLock=" + ReadLock + " uBank=" + uBank + " uPtr=" + uPtr + " uMaskbuf=" + StringUtility.bytes2HexString(uMaskbuf)));
        }
        if ((result = this.getDeviceAPI().UHFBlockPermalock_Ex(bAccessPwd, (char)FilterBank, FilterStartaddr, FilterLen, data, (char)ReadLock, (char)uBank, uPtr, (char)uRange, uMaskbuf))[0] == '\u0000') {
            if (ReadLock == 0) {
                char[] resultData = Arrays.copyOfRange(result, 2, 2 + result[1]);
                uMaskbuf[0] = (byte)resultData[0];
                uMaskbuf[1] = (byte)resultData[1];
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean setGen2(int target, int action, int t, int q, int startQ, int minQ, int maxQ, int dr, int coding, int p, int Sel, int Session, int g, int linkFrequency) {
        int result;
        if (this.DEBUG) {
            StringBuilder sb = new StringBuilder();
            sb.append("target=");
            sb.append(String.valueOf(target));
            sb.append(",action=");
            sb.append(String.valueOf(action));
            sb.append(",t=");
            sb.append(String.valueOf(t));
            sb.append(",q=");
            sb.append(String.valueOf(q));
            sb.append(",startQ=");
            sb.append(String.valueOf(startQ));
            sb.append(",minQ=");
            sb.append(String.valueOf(minQ));
            sb.append(",maxQ=");
            sb.append(String.valueOf(maxQ));
            sb.append(",dr=");
            sb.append(String.valueOf(dr));
            sb.append(",coding=");
            sb.append(String.valueOf(coding));
            sb.append(", p=");
            sb.append(String.valueOf(p));
            sb.append(",Sel=");
            sb.append(String.valueOf(Sel));
            sb.append(",Session=");
            sb.append(String.valueOf(Session));
            sb.append(",g=");
            sb.append(String.valueOf(g));
            sb.append(",linkFrequency=");
            sb.append(String.valueOf(linkFrequency));
            Log.i((String)TAG, (String)sb.toString());
        }
        return (result = this.getDeviceAPI().SetGen2((char)target, (char)action, (char)t, (char)q, (char)startQ, (char)minQ, (char)maxQ, (char)dr, (char)coding, (char)p, (char)Sel, (char)Session, (char)g, (char)linkFrequency)) == 0;
    }

    @Override
    public char[] getGen2() {
        char[] data;
        if (this.DEBUG) {
            Log.i((String)TAG, (String)"GetGen2()=========");
        }
        if ((data = this.getDeviceAPI().GetGen2())[0] == '\u0000') {
            if (this.DEBUG) {
                StringBuilder sb = new StringBuilder();
                sb.append("result data[0]=");
                sb.append(String.valueOf((int)data[0]));
                sb.append("leng data[1]=");
                sb.append(String.valueOf((int)data[1]));
                sb.append("target data[2]=");
                sb.append(String.valueOf((int)data[2]));
                sb.append(",action data[3]=");
                sb.append(String.valueOf((int)data[3]));
                sb.append(",t data[4]=");
                sb.append(String.valueOf((int)data[4]));
                sb.append(",q data[5]=");
                sb.append(String.valueOf((int)data[5]));
                sb.append(",startQ data[6]=");
                sb.append(String.valueOf((int)data[6]));
                sb.append(",minQ data[7]=");
                sb.append(String.valueOf((int)data[7]));
                sb.append(",maxQ data[8]=");
                sb.append(String.valueOf((int)data[8]));
                sb.append(",dr data[9]=");
                sb.append(String.valueOf((int)data[9]));
                sb.append(",coding data[10]=");
                sb.append(String.valueOf((int)data[10]));
                sb.append(", p data[11]=");
                sb.append(String.valueOf((int)data[11]));
                sb.append(",Sel data[12]=");
                sb.append(String.valueOf((int)data[12]));
                sb.append(",Session data[13]=");
                sb.append(String.valueOf((int)data[13]));
                sb.append(",g data[14]=");
                sb.append(String.valueOf((int)data[14]));
                sb.append(",linkFrequency data[15]=");
                sb.append(String.valueOf((int)data[15]));
                Log.i((String)TAG, (String)sb.toString());
            }
            return Arrays.copyOfRange(data, 2, 2 + data[1]);
        }
        if (this.DEBUG) {
            Log.i((String)TAG, (String)("error=" + data[0]));
        }
        return data;
    }

    @Override
    public synchronized boolean setPwm(int WorkTime, int WaitTime) {
        int result = this.getDeviceAPI().UHFSetPwm(WorkTime, WaitTime);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setPwm() err :" + result));
        return false;
    }

    @Override
    public synchronized int[] getPwm() {
        int[] result = this.getDeviceAPI().UHFGetPwm();
        if (result == null || result[0] != 0) {
            Log.e((String)TAG, (String)("getPwm() err :" + result[0]));
            return null;
        }
        int[] res = Arrays.copyOfRange(result, 1, 3);
        return res;
    }

    @Override
    public synchronized boolean setQTPara(boolean enable) {
        int result = this.getDeviceAPI().SetQTPara(enable ? (char)'\u0001' : '\u0000');
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setQTPara() err :" + result));
        return false;
    }

    @Override
    public synchronized int[] getQTPara() {
        char[] result = this.getDeviceAPI().GetQTPara();
        int[] ires = new int[2];
        if (result != null && result[0] == '\u0000') {
            ires[0] = 1;
            ires[1] = result[1];
            return ires;
        }
        Log.e((String)TAG, (String)("getQTPara() err :" + result[0]));
        return ires;
    }

    @Override
    public synchronized boolean uhfJump2Boot() {
        return DeviceAPI.getInstance().UHFJump2Boot() == 0;
    }

    @Override
    public synchronized boolean uhfStartUpdate() {
        return DeviceAPI.getInstance().UHFStartUpdate() == 0;
    }

    @Override
    public synchronized boolean uhfUpdating(byte[] buff) {
        byte[] data = new byte[64];
        if (buff.length < 64) {
            int k = 0;
            while (k < buff.length) {
                data[k] = buff[k];
                ++k;
            }
        } else {
            int k = 0;
            while (k < 64) {
                data[k] = buff[k];
                ++k;
            }
        }
        return DeviceAPI.getInstance().UHFUpdating(data) == 0;
    }

    @Override
    public synchronized boolean uhfStopUpdate() {
        return DeviceAPI.getInstance().UHFStopUpdate() == 0;
    }

    @Override
    public synchronized int getCW() {
        char[] result = this.getDeviceAPI().UHFGetCW();
        if (result[0] == '\u0000') {
            return result[1];
        }
        return -1;
    }

    @Override
    public boolean setCW(int flag) {
        return this.getDeviceAPI().UHFSetCW((char)flag) == 0;
    }

    @Override
    public byte[] getEPCAndTIDUserMode() {
        return null;
    }

    @Override
    public boolean eraseData(String accessPwd, int bank, int ptr, int cnt) {
        int filterBank = 1;
        int filterPtr = 0;
        int filterCnt = 0;
        String filterData = "00";
        return this.eraseData(accessPwd, filterBank, filterPtr, filterCnt, filterData, bank, ptr, cnt);
    }

    @Override
    public void setStatusCallback(ConnectionStatusCallback<Object> btStatusCallback) {
        this.btStatusCallback = btStatusCallback;
    }

    @Override
    public ConnectionStatus getConnectStatus() {
        return this.connectionStatus;
    }

    private void setConnectStatus(ConnectionStatus status) {
        if (this.btStatusCallback != null) {
            this.btStatusCallback.getStatus(status, "UHF UART");
        }
        this.connectionStatus = status;
    }
}

