/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import com.rscja.deviceapi.UHFProtocolParseUSB;
import com.rscja.deviceapi.entity.UHFTAGInfo;
import com.rscja.deviceapi.interfaces.ConnectionStatus;
import com.rscja.deviceapi.interfaces.ConnectionStatusCallback;
import com.rscja.deviceapi.interfaces.IUHF;
import com.rscja.deviceapi.interfaces.IUHFProtocolParse;
import com.rscja.deviceapi.interfaces.IUhfReader;
import com.rscja.deviceapi.interfaces.KeyEventCallback;
import com.rscja.deviceapi.usb.USBUtil;
import com.rscja.utility.StringUtility;
import java.util.ArrayList;
import java.util.List;

public class RFIDWithUHFUSB
implements IUHF,
IUhfReader {
    public static final String ACTION_USB_PERMISSION = "com.rscja.USB_PERMISSION";
    public static final int OPEN_SUCCESS = 0;
    public static final int OPEN_FAIL = -1;
    public static final int OPEN_REQUEST_PERMISSION = 1;
    private String TAG = "DeviceAPI_UHFUSB";
    private USBUtil usb = new USBUtil();
    private IUHFProtocolParse uhfProtocolParse = null;
    private static RFIDWithUHFUSB single = null;
    List<UHFTAGInfo> listUHFINFO = null;
    private final boolean isDebug = false;
    private int errorCode = -1;
    private ConnectionStatus connectionStatus = ConnectionStatus.DISCONNECTED;
    private ConnectionStatusCallback<Object> btStatusCallback = null;
    private UsbReceiver usbReceiver = null;
    private Context context = null;

    private RFIDWithUHFUSB() {
        this.uhfProtocolParse = UHFProtocolParseUSB.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized RFIDWithUHFUSB getInstance() {
        if (single != null) return single;
        Class<RFIDWithUHFUSB> clazz = RFIDWithUHFUSB.class;
        synchronized (RFIDWithUHFUSB.class) {
            if (single != null) return single;
            single = new RFIDWithUHFUSB();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public int getInitErrCode() {
        return this.errorCode;
    }

    public boolean init(UsbDevice currDevice, Context context) {
        int reuslt;
        if (context == null) {
            return false;
        }
        this.context = context;
        this.registerReceiver(context);
        this.setConnectStatus(ConnectionStatus.CONNECTING, currDevice);
        this.usb.init(context);
        this.errorCode = reuslt = this.usb.openPort(currDevice);
        if (reuslt == 0) {
            this.setConnectStatus(ConnectionStatus.CONNECTED, currDevice);
            return true;
        }
        this.setConnectStatus(ConnectionStatus.DISCONNECTED, currDevice);
        return false;
    }

    @Override
    public boolean init(Context context) {
        int reuslt;
        if (context == null) {
            return false;
        }
        this.context = context;
        this.registerReceiver(context);
        this.usb.init(context);
        List<UsbDevice> deviceList = this.usb.getDeviceList(context);
        if (deviceList == null || deviceList.size() == 0) {
            return false;
        }
        UsbDevice currDevice = deviceList.get(0);
        this.setConnectStatus(ConnectionStatus.CONNECTING, currDevice);
        this.errorCode = reuslt = this.usb.openPort(currDevice);
        if (reuslt == 0) {
            this.setConnectStatus(ConnectionStatus.CONNECTED, currDevice);
            return true;
        }
        this.setConnectStatus(ConnectionStatus.DISCONNECTED, currDevice);
        return false;
    }

    @Override
    public boolean free() {
        UsbDevice device = this.usb.closeport();
        this.setConnectStatus(ConnectionStatus.DISCONNECTED, device);
        this.unRegisterReceiver();
        return true;
    }

    @Override
    public String getVersion() {
        byte[] sendData = this.uhfProtocolParse.getVersionSendData();
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseVersionData(inData);
        }
        return "";
    }

    @Override
    public int getPower() {
        byte[] sendData = this.uhfProtocolParse.getPowerSendData();
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseGetPowerData(inData);
        }
        return -1;
    }

    @Override
    public boolean setPower(int power) {
        byte[] sendData = this.uhfProtocolParse.setPowerSendData(power);
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSetPowerData(inData);
        }
        return false;
    }

    @Override
    public int getFrequencyMode() {
        byte[] sendData = this.uhfProtocolParse.getFrequencyModeSendData();
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseGetFrequencyModeData(inData);
        }
        return -1;
    }

    @Override
    public boolean setFrequencyMode(int freMode) {
        byte[] sendData = this.uhfProtocolParse.setFrequencyModeSendData(freMode);
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSetFrequencyModeData(inData);
        }
        return false;
    }

    @Override
    public boolean startInventoryTag() {
        this.log("\u5f00\u59cb\u76d8\u70b9startInventoryTag");
        this.listUHFINFO = null;
        byte[] sendData = this.uhfProtocolParse.getStartInventoryTagSendData();
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        return true;
    }

    @Override
    public UHFTAGInfo readTagFromBuffer() {
        if (this.listUHFINFO != null && this.listUHFINFO.size() > 0) {
            UHFTAGInfo info = this.listUHFINFO.get(0);
            this.listUHFINFO.remove(0);
            return info;
        }
        this.listUHFINFO = this.readTagFromBufferList();
        if (this.listUHFINFO != null && this.listUHFINFO.size() > 0) {
            UHFTAGInfo info = this.listUHFINFO.get(0);
            this.listUHFINFO.remove(0);
            return info;
        }
        return null;
    }

    @Override
    public List<UHFTAGInfo> readTagFromBufferList() {
        byte[] sendData = this.uhfProtocolParse.getReadTagSendData();
        byte[] inData = this.usb.sendAndReceive(sendData, true);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseReadTagDataEPC_TID_USER(inData);
        }
        return null;
    }

    @Override
    public boolean stopInventory() {
        byte[] sendData = this.uhfProtocolParse.getStopInventorySendData();
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseStopInventoryData(inData);
        }
        return false;
    }

    @Override
    public String generateLockCode(ArrayList<Integer> lockBank, int lockMode) {
        if (lockBank == null || lockBank.size() == 0) {
            throw new IllegalArgumentException();
        }
        switch (lockMode) {
            case 16: 
            case 32: 
            case 48: 
            case 64: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this.uhfProtocolParse.generateLockCode(lockBank, lockMode);
    }

    @Override
    public boolean lockMem(String accessPwd, int bank, int ptr, int cnt, String filterData, String lockCode) {
        byte[] sendData = this.uhfProtocolParse.getLockSendData(accessPwd, bank, ptr, cnt, filterData, lockCode);
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseLockData(inData);
        }
        return false;
    }

    @Override
    public boolean lockMem(String accessPwd, String lockCode) {
        int bank = 1;
        int ptr = 0;
        int cnt = 0;
        String filterData = "00";
        return this.lockMem(accessPwd, bank, ptr, cnt, filterData, lockCode);
    }

    @Override
    public boolean uhfGBTagLock(String accessPwd, int memory, int config, int action) {
        boolean filterBank = false;
        boolean filterPtr = false;
        boolean filterCnt = false;
        String filterData = "00";
        return this.uhfGBTagLock(accessPwd, 0, 0, 0, "00", memory, config, action);
    }

    @Override
    public boolean uhfGBTagLock(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData, int memory, int config, int action) {
        byte[] sendData = this.uhfProtocolParse.GBTagLockSendData(accessPwd, (char)filterBank, filterPtr, filterCnt, filterData, (char)memory, (char)config, (char)action);
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseGBTagLockData(inData);
        }
        return false;
    }

    @Override
    public UHFTAGInfo inventorySingleTag() {
        byte[] sendData = this.uhfProtocolParse.getInventorySingleTagSendData();
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseInventorySingleTagData(inData);
        }
        return null;
    }

    @Override
    public String readData(String accessPwd, int bank, int ptr, int cnt) {
        int filterBank = 1;
        int filterPtr = 0;
        int filterCnt = 0;
        String filterData = "";
        return this.readData(accessPwd, filterBank, filterPtr, filterCnt, filterData, bank, ptr, cnt);
    }

    @Override
    public String readData(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData, int bank, int ptr, int cnt) {
        byte[] sendData = this.uhfProtocolParse.getReadSendData(accessPwd, filterBank, filterPtr, filterCnt, filterData, bank, ptr, cnt);
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseReadData(inData);
        }
        return null;
    }

    @Override
    public boolean writeData(String accessPwd, int bank, int ptr, int cnt, String writeData) {
        int filterBank = 1;
        int filterPtr = 0;
        int filterCnt = 0;
        String filterData = "00";
        return this.writeData(accessPwd, filterBank, filterPtr, filterCnt, filterData, bank, ptr, cnt, writeData);
    }

    @Override
    public boolean writeData(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData, int bank, int ptr, int cnt, String writeData) {
        byte[] sendData = this.uhfProtocolParse.getWriteSendData(accessPwd, filterBank, filterPtr, filterCnt, filterData, bank, ptr, cnt, writeData);
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseWriteData(inData);
        }
        return false;
    }

    @Override
    public boolean blockWriteData(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData, int bank, int ptr, int cnt, String writeData) {
        byte[] sendData = this.uhfProtocolParse.blockWriteDataSendData(accessPwd, (char)filterBank, filterPtr, filterCnt, filterData, (char)bank, ptr, (char)cnt, writeData);
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseBlockWriteData(inData);
        }
        return false;
    }

    @Override
    public boolean eraseData(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData, int bank, int ptr, int cnt) {
        byte[] sendData = this.uhfProtocolParse.blockEraseDataSendData(accessPwd, (char)filterBank, filterPtr, filterCnt, filterData, (char)bank, ptr, (char)cnt);
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseBlockEraseDataData(inData);
        }
        return false;
    }

    @Override
    public boolean setFilter(int bank, int ptr, int cnt, String data) {
        byte[] sendData = this.uhfProtocolParse.setFilterSendData((char)bank, ptr, cnt, data);
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSetFilterData(inData);
        }
        return false;
    }

    @Override
    public boolean killTag(String killPwd) {
        int filterBank = 1;
        int filterPtr = 0;
        int filterCnt = 0;
        return this.killTag(killPwd, filterBank, filterPtr, filterCnt, killPwd);
    }

    @Override
    public boolean killTag(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData) {
        byte[] sendData = this.uhfProtocolParse.getKillSendData(accessPwd, filterBank, filterPtr, filterCnt, filterData);
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseKillData(inData);
        }
        return false;
    }

    @Override
    public boolean setProtocol(int protocol) {
        byte[] sendData = this.uhfProtocolParse.setProtocolSendData(protocol);
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSetProtocolData(inData);
        }
        return false;
    }

    @Override
    public int getProtocol() {
        byte[] sendData = this.uhfProtocolParse.getProtocolSendData();
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseGetProtocolData(inData);
        }
        return -1;
    }

    @Override
    public boolean setEPCMode() {
        byte[] sendData = this.uhfProtocolParse.setEPCModeSendData();
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSetEPCModeData(inData);
        }
        return false;
    }

    @Override
    public boolean setEPCAndTIDMode() {
        byte[] sendData = this.uhfProtocolParse.setEPCAndTIDModeSendData();
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSetEPCAndTIDModeData(inData);
        }
        return false;
    }

    @Override
    public boolean setEPCAndTIDUserMode(int user_prt, int user_len) {
        byte[] sendData = this.uhfProtocolParse.setEPCAndTIDUserModeSendData(user_prt, user_len);
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSetEPCAndTIDUserModeData(inData);
        }
        return false;
    }

    @Override
    public int getTemperature() {
        byte[] sendData = this.uhfProtocolParse.getTemperatureSendData();
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseTemperatureData(inData);
        }
        return -1;
    }

    @Override
    public boolean setGen2(int target, int action, int t, int q, int startQ, int minQ, int maxQ, int dr, int coding, int p, int Sel, int Session, int g, int linkFrequency) {
        byte[] sendData = this.uhfProtocolParse.setGen2SendData((char)target, (char)action, (char)t, (char)q, (char)startQ, (char)minQ, (char)maxQ, (char)dr, (char)coding, (char)p, (char)Sel, (char)Session, (char)g, (char)linkFrequency);
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSetGen2Data(inData);
        }
        return false;
    }

    @Override
    public char[] getGen2() {
        byte[] bData;
        byte[] sendData = this.uhfProtocolParse.getGen2SendData();
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0 && (bData = this.uhfProtocolParse.parseGetGen2Data(inData)) != null && bData.length > 0) {
            return StringUtility.bytesTochars(bData, bData.length);
        }
        return null;
    }

    @Override
    public void setKeyEventCallback(KeyEventCallback KeyEventCallback2) {
        if (this.usb != null) {
            this.usb.setKeyEventCallback(KeyEventCallback2);
        }
    }

    public List<UsbDevice> getUsbDeviceList(Context context) {
        if (this.usb != null) {
            return this.usb.getDeviceList(context);
        }
        return null;
    }

    @Override
    public int getBattery() {
        byte[] sendData = this.uhfProtocolParse.getBatterySendData();
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseBatteryData(inData);
        }
        return -1;
    }

    @Override
    public boolean setBeep(boolean isOpen) {
        byte[] sendData = this.uhfProtocolParse.getBeepSendData(isOpen);
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseBeepData(inData);
        }
        return false;
    }

    @Override
    public String scanBarcode() {
        byte[] barcode = this.scanBarcodeToBytes();
        if (barcode != null) {
            return new String(barcode);
        }
        return null;
    }

    @Override
    public byte[] scanBarcodeToBytes() {
        byte[] sendData = this.uhfProtocolParse.getScanBarcodeSendData();
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseBarcodeData(inData);
        }
        return null;
    }

    @Override
    public boolean setCW(int flag) {
        byte[] sendData = this.uhfProtocolParse.setCWSendData((char)flag);
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSetCWData(inData);
        }
        return false;
    }

    @Override
    public int getCW() {
        byte[] sendData = this.uhfProtocolParse.getCWSendData();
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseGetCWData(inData);
        }
        return -1;
    }

    @Override
    public boolean setFreHop(float fre) {
        int f = (int)(fre * 1000.0f);
        byte[] sendData = this.uhfProtocolParse.setJumpFrequencySendData(f);
        byte[] inData = this.usb.sendAndReceive(sendData, false);
        if (inData != null && inData.length > 0) {
            return this.uhfProtocolParse.parseSetJumpFrequencyData(inData);
        }
        return false;
    }

    @Override
    public boolean uhfBlockPermalock(String accessPwd, int FilterBank, int FilterStartaddr, int FilterLen, String FilterData, int ReadLock, int uBank, int uPtr, int uRange, byte[] uMaskbuf) {
        return false;
    }

    @Override
    public boolean setPwm(int WorkTime, int WaitTime) {
        return false;
    }

    @Override
    public int[] getPwm() {
        return null;
    }

    @Override
    public boolean setQTPara(boolean enable) {
        return false;
    }

    @Override
    public int[] getQTPara() {
        return null;
    }

    @Override
    public boolean setRFLink(int mode) {
        return false;
    }

    @Override
    public int getRFLink() {
        return 0;
    }

    @Override
    public boolean setFastID(boolean enalbe) {
        return false;
    }

    @Override
    public boolean setTagFocus(boolean enalbe) {
        return false;
    }

    @Override
    public boolean uhfJump2Boot() {
        return false;
    }

    @Override
    public boolean uhfStartUpdate() {
        return false;
    }

    @Override
    public boolean uhfUpdating(byte[] buff) {
        return false;
    }

    @Override
    public boolean uhfStopUpdate() {
        return false;
    }

    @Override
    public byte[] getEPCAndTIDUserMode() {
        return null;
    }

    @Override
    public boolean eraseData(String accessPwd, int bank, int ptr, int cnt) {
        int filterBank = 1;
        int filterPtr = 0;
        int filterCnt = 0;
        String filterData = "00";
        return this.eraseData(accessPwd, filterBank, filterPtr, filterCnt, filterData, bank, ptr, cnt);
    }

    @Override
    public void setStatusCallback(ConnectionStatusCallback<Object> btStatusCallback) {
        this.btStatusCallback = btStatusCallback;
    }

    @Override
    public List<UHFTAGInfo> readTagFromBufferList_EpcTidUser() {
        return null;
    }

    @Override
    public int getAllTagTotalFromFlash() {
        return 0;
    }

    @Override
    public boolean deleteAllTagToFlash() {
        return false;
    }

    @Override
    public List<UHFTAGInfo> getTagDataFromFlash() {
        return null;
    }

    @Override
    public ConnectionStatus getConnectStatus() {
        return this.connectionStatus;
    }

    private void setConnectStatus(ConnectionStatus status, UsbDevice usb) {
        if (this.btStatusCallback != null) {
            this.btStatusCallback.getStatus(status, usb);
        }
        this.connectionStatus = status;
    }

    private void registerReceiver(Context context) {
        if (this.usbReceiver == null && context != null) {
            this.usbReceiver = new UsbReceiver();
            IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
            filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
            filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
            context.registerReceiver((BroadcastReceiver)this.usbReceiver, filter);
        }
    }

    private void unRegisterReceiver() {
        if (this.usbReceiver != null) {
            if (this.context != null) {
                this.context.unregisterReceiver((BroadcastReceiver)this.usbReceiver);
            }
            this.usbReceiver = null;
        }
    }

    private void log(String msg) {
    }

    class UsbReceiver
    extends BroadcastReceiver {
        UsbReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            RFIDWithUHFUSB.this.log("UsbReceiver action:" + action);
            if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                RFIDWithUHFUSB.this.log("usb\u62d4\u51fa");
                UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                RFIDWithUHFUSB.this.setConnectStatus(ConnectionStatus.DISCONNECTED, device);
            } else if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                RFIDWithUHFUSB.this.log("usb\u63d2\u5165");
            } else if (RFIDWithUHFUSB.ACTION_USB_PERMISSION.equals(action)) {
                boolean permission = intent.getBooleanExtra("permission", false);
                RFIDWithUHFUSB.this.log("usb \u83b7\u53d6\u6743\u9650\u8fd4\u56de permission= " + permission);
                if (permission) {
                    RFIDWithUHFUSB.this.log("\u7533\u8bf7usb\u6743\u9650\u901a\u8fc7");
                } else {
                    RFIDWithUHFUSB.this.log("\u7533\u8bf7usb\u6743\u9650\u5931\u8d25");
                }
            }
        }
    }
}

