/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.Device;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.exception.ConfigurationException;
import java.util.Arrays;

public class SPI
extends Device {
    private static SPI single = null;
    private static DeviceConfiguration config = null;
    private byte[] outData = new byte[4096];
    private String TAG = "---SPI----";

    private SPI() {
        try {
            config = DeviceConfiguration.builder1DConfiguration();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized SPI getInstance() {
        if (single != null) return single;
        Class<SPI> clazz = SPI.class;
        synchronized (SPI.class) {
            if (single != null) return single;
            single = new SPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public synchronized boolean init() {
        int result = DeviceAPI.getInstance().SpiInit(config.getDeviceName());
        Log.d((String)this.TAG, (String)("init result=" + result));
        if (result == 0) {
            this.setPowerOn(true);
            return true;
        }
        return false;
    }

    public synchronized boolean free() {
        int result = DeviceAPI.getInstance().SpiFree(config.getDeviceName());
        Log.d((String)this.TAG, (String)("free result=" + result));
        if (result == 0) {
            this.setPowerOn(false);
            return true;
        }
        return false;
    }

    public synchronized boolean send(byte[] sendData) {
        if (sendData == null || sendData.length == 0) {
            return false;
        }
        int result = DeviceAPI.getInstance().SpiWrite(sendData, sendData.length);
        Log.d((String)this.TAG, (String)("send result=" + result));
        return result > 0;
    }

    public synchronized byte[] receive() {
        int k = 0;
        while (k < this.outData.length) {
            this.outData[k] = 0;
            ++k;
        }
        int result = DeviceAPI.getInstance().SpiRead(this.outData, this.outData.length);
        Log.d((String)this.TAG, (String)("receive result=" + result));
        if (result > 0) {
            byte[] data = Arrays.copyOfRange(this.outData, 0, result);
            return data;
        }
        return null;
    }
}

