/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.rscja.deviceapi.Device;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;

public class ScanerLedLight
extends Device {
    private static final String TAG = "ScanerLedLight";
    private static boolean DEBUG = false;
    private static ScanerLedLight single = null;
    private static long lastTime = System.currentTimeMillis();
    private Timer mTimer = null;
    private static String curModel = DeviceConfiguration.getModel();
    final String C66LEDPath = "/sys/class/leds/gpio44-led/brightness";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized ScanerLedLight getInstance() {
        if (single != null) return single;
        Class<ScanerLedLight> clazz = ScanerLedLight.class;
        synchronized (ScanerLedLight.class) {
            if (single != null) return single;
            single = new ScanerLedLight();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public synchronized void init() {
        Log.d((String)TAG, (String)("init()  Model=" + curModel));
        if (this.isQualcomm()) {
            DeviceAPI.getInstance().ScanerLed_Init(curModel);
            this.mTimer = new Timer();
        }
        if (this.isMTK()) {
            this.mTimer = new Timer();
        }
        if ("C66_SMD450".equals(curModel)) {
            this.mTimer = new Timer();
        }
    }

    public synchronized void free() {
        if (this.isQualcomm()) {
            DeviceAPI.getInstance().ScanerLed_Free(curModel);
            this.setPowerOn(false);
            this.mTimer = null;
        }
        if (this.isMTK()) {
            this.mTimer = null;
        }
        if ("C66_SMD450".equals(curModel)) {
            this.mTimer = null;
            this.C66_SMD450_90_LEDSwitch(false);
        }
    }

    public synchronized void On(Context context) {
        if (DEBUG) {
            Log.d((String)TAG, (String)"On()");
        }
        if (this.isQualcomm()) {
            if (!this.isPowerOn()) {
                if (DEBUG) {
                    Log.d((String)TAG, (String)"--------On()------------");
                }
                DeviceAPI.getInstance().ScanerLed_On(curModel);
                this.setPowerOn(true);
            }
        } else if (this.isMTK()) {
            this.ScanLED(true, context);
        }
        if (DEBUG) {
            Log.d((String)TAG, (String)("curModel =" + curModel));
        }
        if ("C66_SMD450".equals(curModel)) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"android 90\u626b\u63cf\u706f");
            }
            this.C66_SMD450_90_LEDSwitch(true);
        } else if (DEBUG) {
            Log.d((String)TAG, (String)"\u672a\u77e5");
        }
    }

    public synchronized void off(Context context) {
        if (this.isQualcomm()) {
            if (this.isPowerOn()) {
                if (DEBUG) {
                    Log.d((String)TAG, (String)"--------off()------------");
                }
                DeviceAPI.getInstance().ScanerLed_Off(curModel);
                this.setPowerOn(false);
            }
        } else if (this.isMTK()) {
            this.ScanLED(false, context);
        }
        if ("C66_SMD450".equals(curModel)) {
            this.C66_SMD450_90_LEDSwitch(false);
        }
    }

    public synchronized void blink(Context context) {
        if (this.isQualcomm() && this.isPowerOn()) {
            return;
        }
        this.On(context);
        if (this.mTimer != null) {
            this.mTimer.schedule((TimerTask)new OffTask(context), 500L);
        }
    }

    public synchronized void blink(Context context, int lightTime, int interval) {
        if (this.isQualcomm() && this.isPowerOn()) {
            return;
        }
        if (interval < 50) {
            interval = 50;
        }
        if (lightTime < 50) {
            lightTime = 50;
        }
        if (System.currentTimeMillis() - lastTime < (long)(interval += lightTime)) {
            return;
        }
        ScanerLedLight.getInstance().On(context);
        lastTime = System.currentTimeMillis();
        if (this.mTimer != null) {
            this.mTimer.schedule((TimerTask)new OffTask(context), lightTime);
        }
    }

    private void ScanLED(boolean on, Context context) {
        if (this.isMTK() && context != null) {
            Intent mScanIntent = new Intent("com.chengwei.scanled.statuschanged");
            if (on) {
                mScanIntent.putExtra("value", 255);
            } else {
                mScanIntent.putExtra("value", 0);
            }
            context.sendBroadcast(mScanIntent);
        }
    }

    public void openAuxiliaryLight(Context context) {
        if (this.isMTK()) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"scanAuxiliaryLight begin");
            }
            if (context != null) {
                Intent intent = new Intent("com.chengwei.pupilled.statuschanged");
                intent.putExtra("value", 255);
                context.sendBroadcast(intent);
            }
        }
    }

    public void closeAuxiliaryLight(Context context) {
        if (this.isMTK()) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"scanAuxiliaryLight begin");
            }
            if (context != null) {
                Intent intent = new Intent("com.chengwei.pupilled.statuschanged");
                intent.putExtra("value", 0);
                context.sendBroadcast(intent);
            }
        }
    }

    private boolean isQualcomm() {
        String model = curModel;
        return DeviceConfiguration.C6000_8909.equals(model) || "H100_8953".equals(model) || "P80_8953".equals(model) || "C66_8953".equals(model);
    }

    private boolean isMTK() {
        String model = curModel;
        return DeviceConfiguration.C6000_6735.equals(model) || DeviceConfiguration.H100_6735.equals(model) || DeviceConfiguration.C70_6735.equals(model) || DeviceConfiguration.C72_6735.equals(model) || DeviceConfiguration.C70_6763.equals(model) || DeviceConfiguration.C71_6763.equals(model) || DeviceConfiguration.C72_6763.equals(model);
    }

    private boolean C66_SMD450_90_LEDSwitch(boolean isOpen) {
        File file;
        if (DEBUG) {
            Log.d((String)TAG, (String)("C66_SMD450_90_LEDSwitch begin  isOpen=" + isOpen));
        }
        if (!(file = new File("/sys/class/leds/gpio44-led/brightness")).exists()) {
            Log.e((String)TAG, (String)"\u8def\u5f84\u4e0d\u5b58\u5728\uff1a/sys/class/leds/gpio44-led/brightness");
            return false;
        }
        OutputStream outputStream = null;
        try {
            String value = isOpen ? "1" : "0";
            outputStream = new FileOutputStream(file);
            outputStream.write(value.getBytes());
            outputStream.flush();
            if (DEBUG) {
                Log.d((String)TAG, (String)"C66_SMD450_90_LEDSwitch ok");
            }
            return true;
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("FileNotFoundException e =" + e.toString()));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("IOException e =" + e.toString()));
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private class OffTask
    extends TimerTask {
        Context context;

        public OffTask(Context context) {
            this.context = context;
        }

        @Override
        public void run() {
            if (DEBUG) {
                Log.d((String)ScanerLedLight.TAG, (String)"OffTask off");
            }
            ScanerLedLight.getInstance().off(this.context);
            this.cancel();
        }
    }
}

