/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.entity.UHFTAGInfo;
import com.rscja.utility.StringUtility;
import java.text.DecimalFormat;
import java.util.Arrays;

public class UHFCustomAPI {
    private static UHFCustomAPI single = null;
    private static final String TAG = String.valueOf(StringUtility.TAG) + "UHFUARTUAE";
    private char[] uhfdata = new char[512];

    private UHFCustomAPI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized UHFCustomAPI getInstance() {
        if (single != null) return single;
        Class<UHFCustomAPI> clazz = UHFCustomAPI.class;
        synchronized (UHFCustomAPI.class) {
            if (single != null) return single;
            single = new UHFCustomAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.getInstance();
    }

    public synchronized boolean setEPCAndTamperAlarm() {
        int save = 0;
        int result = this.getDeviceAPI().UHFSetEPCUserMode('\u0003', 32, 1, save);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setEPCAndTamperAlarm() err :" + result));
        return false;
    }

    private UHFTAGInfo ParseEPCAndTamperAlarm(char[] uhfdata) {
        UHFTAGInfo info = new UHFTAGInfo();
        int uiiIndex = 3;
        int uiiEnd = 3 + uhfdata[2];
        int tamperAlarmIndex = uiiEnd + 1;
        int tamperAlarmEnd = tamperAlarmIndex + uhfdata[uiiEnd];
        int rssiIndex = 0;
        int rssiEnd = 0;
        int antIndex = 0;
        int antEnd = 0;
        if (tamperAlarmEnd - tamperAlarmIndex > 1) {
            char[] tamperAlarm = Arrays.copyOfRange(uhfdata, tamperAlarmIndex, tamperAlarmEnd);
            info.setUser(StringUtility.chars2HexString(tamperAlarm, tamperAlarm.length));
            rssiIndex = tamperAlarmEnd;
            antIndex = rssiEnd = rssiIndex + 2;
            antEnd = antIndex + 2;
        } else {
            info.setUser("");
            rssiIndex = uiiEnd + 1;
            antIndex = rssiEnd = rssiIndex + 2;
            antEnd = antIndex + 2;
        }
        char[] ant_data = Arrays.copyOfRange(uhfdata, antIndex, antEnd);
        char[] rssi = Arrays.copyOfRange(uhfdata, rssiIndex, rssiEnd);
        char[] pc = Arrays.copyOfRange(uhfdata, uiiIndex, uiiIndex + 2);
        char[] epc = Arrays.copyOfRange(uhfdata, uiiIndex + 2, uiiEnd);
        String strAnt = String.valueOf((ant_data[1] & 0xFF) << 8 | ant_data[0] & 0xFF);
        String strRssi = StringUtility.chars2HexString(rssi, rssi.length);
        String hexPC = StringUtility.chars2HexString(pc, pc.length);
        String hexEPC = StringUtility.chars2HexString(epc, epc.length);
        float dBm = (float)(65535 - Integer.parseInt(strRssi, 16)) / 10.0f;
        String strdBm = "N/A";
        if (dBm < 200.0f && dBm > 0.0f) {
            DecimalFormat fnum = new DecimalFormat("##0.00");
            strdBm = "-" + fnum.format(dBm);
        }
        info.setAnt(strAnt);
        info.setRssi(strdBm);
        info.setPc(hexPC);
        info.setEPC(hexEPC);
        return info;
    }

    public UHFTAGInfo readTagEPCAndTamperAlarm(boolean single) {
        if (single) {
            char[] uhfdata = this.getDeviceAPI().UHFInventorySingleEPCTIDUSER();
            if (uhfdata == null || uhfdata[0] != '\u0000') {
                return null;
            }
            return this.ParseEPCAndTamperAlarm(uhfdata);
        }
        int k = 0;
        while (k < this.uhfdata.length) {
            this.uhfdata[k] = '\u0000';
            ++k;
        }
        int r = this.getDeviceAPI().UHFGetReceived_EX2(this.uhfdata);
        if (r == -1 || this.uhfdata[0] != '\u0000') {
            return null;
        }
        return this.ParseEPCAndTamperAlarm(this.uhfdata);
    }
}

