/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.text.TextUtils;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.entity.UHFTAGInfo;
import com.rscja.deviceapi.interfaces.IUHFProtocolParse;
import com.rscja.utility.StringUtility;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;

public class UHFProtocolParse
implements IUHFProtocolParse {
    private static UHFProtocolParse single = null;
    private String TAG = "DeviceAPI_UHF_Parse";
    private final boolean isDebug = false;

    protected UHFProtocolParse() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized UHFProtocolParse getInstance() {
        if (single != null) return single;
        Class<UHFProtocolParse> clazz = UHFProtocolParse.class;
        synchronized (UHFProtocolParse.class) {
            if (single != null) return single;
            single = new UHFProtocolParse();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.getInstance();
    }

    @Override
    public byte[] getBeepSendData(boolean isOpen) {
        if (isOpen) {
            String hexString = "A55A000AE40301EC0D0A";
            return StringUtility.hexString2Bytes(hexString);
        }
        String hexString = "A55A000AE40300ED0D0A";
        return StringUtility.hexString2Bytes(hexString);
    }

    @Override
    public boolean parseBeepData(byte[] inData) {
        if (inData == null) {
            return false;
        }
        return this.getDeviceAPI().UHFBTSetBeepRecvData(inData, inData.length) == 0;
    }

    @Override
    public byte[] getScanBarcodeSendData() {
        String hexString = "A55A0009E402EF0D0A";
        return StringUtility.hexString2Bytes(hexString);
    }

    @Override
    public byte[] parseBarcodeData(byte[] inData) {
        if (inData == null) {
            return null;
        }
        byte[] barcode = this.getDeviceAPI().UHFBTOpen2DRecvData(inData, inData.length);
        return barcode;
    }

    @Override
    public byte[] getBatterySendData() {
        String hexString = "A55A0009E401EC0D0A";
        return StringUtility.hexString2Bytes(hexString);
    }

    @Override
    public int parseBatteryData(byte[] inData) {
        if (inData == null) {
            return -1;
        }
        return this.getDeviceAPI().UHFBTGetPowerValueRecvData(inData, inData.length);
    }

    @Override
    public byte[] getWriteSendData(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData, int bank, int ptr, int cnt, String writeData) {
        int tempLen;
        byte[] uAccessPwd = StringUtility.hexString2Bytes(accessPwd);
        byte[] ufilterData = null;
        if (uAccessPwd == null || uAccessPwd.length != 4) {
            throw new IllegalArgumentException("accessPwd illegal !");
        }
        if (bank < 0 || ptr < 0 || cnt < 0) {
            throw new IllegalArgumentException("bank or ptr or cnt error !");
        }
        byte[] uDatabuf = StringUtility.hexString2Bytes(writeData);
        if (uDatabuf.length < (tempLen = cnt / 8 + (cnt % 8 == 0 ? 0 : 1))) {
            throw new IllegalArgumentException("writeData cnt error!");
        }
        if (filterCnt == 0) {
            filterData = "00";
            filterBank = 1;
            filterPtr = 0;
            ufilterData = new byte[1];
        } else {
            if (filterBank < 0 || filterPtr < 0 || filterCnt < 0) {
                throw new IllegalArgumentException("filterBank or filterPtr or filterCnt error!");
            }
            ufilterData = StringUtility.hexString2Bytes(filterData);
            if (ufilterData == null || ufilterData.length == 0) {
                throw new IllegalArgumentException("filterCnt error !");
            }
            tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            if (ufilterData.length < tempLen) {
                throw new IllegalArgumentException("filterCnt error 2!");
            }
        }
        byte[] sendData = DeviceAPI.getInstance().UHFWriteDataSendData(uAccessPwd, (char)filterBank, filterPtr, filterCnt, ufilterData, (char)bank, ptr, (char)cnt, uDatabuf);
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseWriteData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException("inData is null!");
        }
        this.PrintLog(inData);
        int result = DeviceAPI.getInstance().UHFWriteDataRecvData(inData, inData.length);
        return result == 0;
    }

    @Override
    public byte[] getReadSendData(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData, int bank, int ptr, int cnt) {
        byte[] uAccessPwd = StringUtility.hexString2Bytes(accessPwd);
        byte[] ufilterData = null;
        if (uAccessPwd == null || uAccessPwd.length != 4) {
            throw new IllegalArgumentException("accessPwd illegal !");
        }
        if (bank < 0 || ptr < 0 || cnt < 0) {
            throw new IllegalArgumentException("bank or ptr or cnt error !");
        }
        if (filterCnt == 0) {
            filterData = "00";
            filterBank = 1;
            filterPtr = 0;
            ufilterData = new byte[1];
        } else {
            if (filterBank < 0 || filterPtr < 0 || filterCnt < 0) {
                throw new IllegalArgumentException("filterBank or filterPtr or filterCnt error!");
            }
            ufilterData = StringUtility.hexString2Bytes(filterData);
            if (ufilterData == null || ufilterData.length == 0) {
                throw new IllegalArgumentException("filterData cannot be empty!");
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            if (ufilterData.length < tempLen) {
                throw new IllegalArgumentException("filterCnt error !");
            }
        }
        byte[] sendData = DeviceAPI.getInstance().UHFReadDataSendData(uAccessPwd, (char)filterBank, filterPtr, filterCnt, ufilterData, (char)bank, ptr, (char)cnt);
        return this.getSendData(sendData);
    }

    @Override
    public String parseReadData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException("inData is null!");
        }
        byte[] data = DeviceAPI.getInstance().UHFReadDataRecvData(inData, inData.length);
        this.PrintLog(data);
        if (data != null && data[0] == 0) {
            int len = data[1] & 0xFF;
            this.PrintLog("len=" + len);
            data = Arrays.copyOfRange(data, 2, 2 + len);
            return StringUtility.bytes2HexString2(data, data.length);
        }
        return null;
    }

    @Override
    public byte[] getLockSendData(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData, String lockCode) {
        byte[] uAccessPwd = StringUtility.hexString2Bytes(accessPwd);
        byte[] ufilterData = null;
        byte[] bCode = StringUtility.hexString2Bytes(lockCode);
        if (uAccessPwd == null || uAccessPwd.length != 4) {
            throw new IllegalArgumentException("accessPwd illegal !");
        }
        if (bCode == null || bCode.length != 3) {
            throw new IllegalArgumentException("lockCode error !");
        }
        if (filterCnt == 0) {
            filterData = "00";
            filterBank = 1;
            filterPtr = 0;
            ufilterData = new byte[1];
        } else {
            if (filterBank < 0 || filterPtr < 0 || filterCnt < 0) {
                throw new IllegalArgumentException("filterBank or filterPtr or filterCnt error!");
            }
            ufilterData = StringUtility.hexString2Bytes(filterData);
            if (ufilterData == null || ufilterData.length == 0) {
                throw new IllegalArgumentException("ufilterData cannot be empty!");
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            if (ufilterData.length < tempLen) {
                throw new IllegalArgumentException("filterCnt error !");
            }
        }
        byte[] sendData = DeviceAPI.getInstance().UHFLockTagSendData(uAccessPwd, (char)filterBank, filterPtr, filterCnt, ufilterData, bCode);
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseLockData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException("inData is null!");
        }
        int result = DeviceAPI.getInstance().UHFLockTagRecvData(inData, inData.length);
        return result == 0;
    }

    @Override
    public String generateLockCode(ArrayList<Integer> lockBank, int lockMode) {
        if (lockBank == null || lockBank.size() == 0) {
            throw new IllegalArgumentException();
        }
        switch (lockMode) {
            case 16: 
            case 32: 
            case 48: 
            case 64: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int iCode = 0;
        for (Integer bank : lockBank) {
            switch (bank) {
                case 16: {
                    switch (lockMode) {
                        case 16: {
                            iCode |= 0x200;
                            break;
                        }
                        case 32: {
                            break;
                        }
                        case 48: {
                            iCode |= 0x200;
                            iCode |= 0x100;
                            iCode |= 0x40000;
                            break;
                        }
                        case 64: {
                            iCode |= 0x100;
                            iCode |= 0x40000;
                        }
                    }
                    iCode |= 0x80000;
                    break;
                }
                case 32: {
                    switch (lockMode) {
                        case 16: {
                            iCode |= 0x80;
                            break;
                        }
                        case 32: {
                            break;
                        }
                        case 48: {
                            iCode |= 0x80;
                            iCode |= 0x40;
                            iCode |= 0x10000;
                            break;
                        }
                        case 64: {
                            iCode |= 0x40;
                            iCode |= 0x10000;
                        }
                    }
                    iCode |= 0x20000;
                    break;
                }
                case 48: {
                    switch (lockMode) {
                        case 16: {
                            iCode |= 0x20;
                            break;
                        }
                        case 32: {
                            break;
                        }
                        case 48: {
                            iCode |= 0x20;
                            iCode |= 0x10;
                            iCode |= 0x4000;
                            break;
                        }
                        case 64: {
                            iCode |= 0x10;
                            iCode |= 0x4000;
                        }
                    }
                    iCode |= 0x8000;
                    break;
                }
                case 64: {
                    switch (lockMode) {
                        case 16: {
                            iCode |= 8;
                            break;
                        }
                        case 32: {
                            break;
                        }
                        case 48: {
                            iCode |= 8;
                            iCode |= 4;
                            iCode |= 0x1000;
                            break;
                        }
                        case 64: {
                            iCode |= 4;
                            iCode |= 0x1000;
                        }
                    }
                    iCode |= 0x2000;
                    break;
                }
                case 80: {
                    switch (lockMode) {
                        case 16: {
                            iCode |= 2;
                            break;
                        }
                        case 32: {
                            break;
                        }
                        case 48: {
                            iCode |= 2;
                            iCode |= 1;
                            iCode |= 0x400;
                            break;
                        }
                        case 64: {
                            iCode |= 1;
                            iCode |= 0x400;
                        }
                    }
                    iCode |= 0x800;
                }
            }
        }
        String zero = "000000";
        String hexCode = Integer.toHexString(iCode).toUpperCase();
        return hexCode.length() == 6 ? hexCode : String.valueOf(zero.substring(hexCode.length())) + hexCode;
    }

    @Override
    public byte[] getKillSendData(String accessPwd, int filterBank, int filterPtr, int filterCnt, String filterData) {
        byte[] uAccessPwd = StringUtility.hexString2Bytes(accessPwd);
        byte[] ufilterData = null;
        if (uAccessPwd == null || uAccessPwd.length != 4) {
            throw new IllegalArgumentException("accessPwd illegal !");
        }
        if (filterCnt == 0) {
            filterData = "00";
            filterBank = 1;
            filterPtr = 0;
            ufilterData = new byte[1];
        } else {
            if (filterBank < 0 || filterPtr < 0 || filterCnt < 0) {
                throw new IllegalArgumentException("filterBank or filterPtr or filterCnt error!");
            }
            ufilterData = StringUtility.hexString2Bytes(filterData);
            if (ufilterData == null || ufilterData.length == 0) {
                throw new IllegalArgumentException("filterData cannot be empty!");
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            if (ufilterData.length < tempLen) {
                throw new IllegalArgumentException("filterCnt error !");
            }
        }
        byte[] sendData = DeviceAPI.getInstance().UHFKillTagSendData(uAccessPwd, (char)filterBank, filterPtr, filterCnt, ufilterData);
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseKillData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException("inData is null!");
        }
        int result = DeviceAPI.getInstance().UHFKillTagRecvData(inData, inData.length);
        return result == 0;
    }

    @Override
    public byte[] getProtocolSendData() {
        byte[] sendData = DeviceAPI.getInstance().UHFGetProtocolTypeSendData();
        return this.getSendData(sendData);
    }

    @Override
    public int parseGetProtocolData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException("inData is null!");
        }
        byte[] reuslt = DeviceAPI.getInstance().UHFGetProtocolTypeRecvData(inData, inData.length);
        if (reuslt[0] == 0) {
            return reuslt[2];
        }
        return -1;
    }

    @Override
    public byte[] setProtocolSendData(int protocol) {
        byte[] sendData = DeviceAPI.getInstance().UHFSetProtocolTypeSendData((char)protocol);
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseSetProtocolData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException("inData is null!");
        }
        int reuslt = DeviceAPI.getInstance().UHFSetProtocolTypeRecvData(inData, inData.length);
        return reuslt == 0;
    }

    @Override
    public byte[] getPowerSendData() {
        byte[] sendData = DeviceAPI.getInstance().UHFGetPowerSendData();
        return this.getSendData(sendData);
    }

    @Override
    public int parseGetPowerData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        byte[] data = DeviceAPI.getInstance().UHFGetPowerRecvData(inData, inData.length);
        if (data != null && data.length > 2 && data[0] == 0) {
            return data[2] & 0xFF;
        }
        return -1;
    }

    @Override
    public byte[] setPowerSendData(int power) {
        if (power < 1 || power > 30) {
            throw new IllegalArgumentException();
        }
        char saveFlag = '\u0001';
        byte[] sendData = DeviceAPI.getInstance().UHFSetPowerSendData(saveFlag, (char)power);
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseSetPowerData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        return DeviceAPI.getInstance().UHFSetPowerRecvData(inData, inData.length) == 0;
    }

    @Override
    public byte[] getInventorySingleTagSendData() {
        byte[] sendData = DeviceAPI.getInstance().UHFInventorySingleSendData();
        return this.getSendData(sendData);
    }

    @Override
    public UHFTAGInfo parseInventorySingleTagData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        byte[] data = DeviceAPI.getInstance().UHFInventorySingleRecvData(inData, inData.length);
        this.PrintLog(data);
        if (data != null && data.length > 0 && data[0] == 0) {
            int len = data[1] & 0xFF;
            data = Arrays.copyOfRange(data, 2, 2 + len);
            return this.parserUhfTagBuff_EPC_TID_USER(data);
        }
        return null;
    }

    @Override
    public byte[] getStopInventorySendData() {
        byte[] sendData = DeviceAPI.getInstance().UHFStopInventorySendData();
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseStopInventoryData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        return DeviceAPI.getInstance().UHFStopInventoryRecvData(inData, inData.length) == 0;
    }

    @Override
    public byte[] getReadTagSendData() {
        byte[] sendData = DeviceAPI.getInstance().UHFGetTagsDataSendData();
        return this.getSendData(sendData);
    }

    public ArrayList<UHFTAGInfo> parseReadTagData_EPC(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        byte[] data = DeviceAPI.getInstance().UHFGetTagsDataRecvData(inData, inData.length);
        ArrayList<UHFTAGInfo> list = new ArrayList<UHFTAGInfo>();
        if (data != null) {
            int count = data[4];
            int begin = 6;
            int end = 5;
            int k = 0;
            while (k < count) {
                UHFTAGInfo tag = new UHFTAGInfo();
                int tagLen = data[end] & 0xFF;
                if ((end = begin + tagLen) > inData.length) break;
                String epc = StringUtility.bytes2HexString(data, begin, tagLen);
                tag.setEPC(epc);
                list.add(tag);
                begin = end + 1;
                ++k;
            }
        }
        if (list.size() > 0) {
            return list;
        }
        return null;
    }

    public ArrayList<UHFTAGInfo> parseReadTagDataEPC_TID_USER(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        this.PrintLog("parseReadTagDataEPC_TID_USER \u539f\u59cb\u6570\u636e:");
        this.PrintLog(inData, inData.length);
        byte[] data = DeviceAPI.getInstance().UHFGetTagsDataRecvData(inData, inData.length);
        this.PrintLog("parseReadTagDataEPC_TID_USER  data[0]" + data[0]);
        ArrayList<UHFTAGInfo> list = new ArrayList<UHFTAGInfo>();
        if (data != null && data[0] == 0) {
            int len = 2 + (0xFF & data[1]);
            this.PrintLog("parseReadTagDataEPC_TID_USER len:" + len);
            if (data.length < len + 2) {
                return null;
            }
            data = Arrays.copyOfRange(data, 2, len);
            this.PrintLog("parseReadTagDataEPC_TID_USER\u89e3\u6790\u540e\u6570\u636e:");
            this.PrintLog(data, data.length);
            if (data.length < 4) {
                return null;
            }
            int count = data[2] & 0xFF;
            int epc_lenIndex = 3;
            int epc_startIndex = 4;
            int epc_endIndex = 0;
            int k = 0;
            while (k < count) {
                epc_startIndex = epc_lenIndex + 1;
                epc_endIndex = epc_startIndex + (data[epc_lenIndex] & 0xFF);
                if (epc_endIndex > data.length) break;
                byte[] epcBuff = Arrays.copyOfRange(data, epc_startIndex, epc_endIndex);
                UHFTAGInfo info = this.parserUhfTagBuff_EPC_TID_USER(epcBuff);
                if (info != null) {
                    list.add(info);
                }
                if ((epc_lenIndex = epc_endIndex) >= data.length) break;
                ++k;
            }
        }
        if (list.size() > 0) {
            return list;
        }
        return null;
    }

    @Override
    public byte[] getStartInventoryTagSendData() {
        byte[] sendData = this.getDeviceAPI().UHFInventorySendData();
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseStartInventoryTagData(byte[] inData) {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public byte[] getVersionSendData() {
        byte[] sendData = this.getDeviceAPI().UHFGetSoftwareVersionSendData();
        return this.getSendData(sendData);
    }

    @Override
    public String parseVersionData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        byte[] version = this.getDeviceAPI().UHFGetSoftwareVersionRecvData(inData, inData.length);
        if (version != null && version[0] == 0) {
            byte[] arrs = Arrays.copyOfRange(version, 2, version[1] + 2);
            return new String(arrs);
        }
        return null;
    }

    @Override
    public byte[] getFrequencyModeSendData() {
        byte[] sendData = this.getDeviceAPI().UHFGetRegionSendData();
        return this.getSendData(sendData);
    }

    @Override
    public byte[] setFrequencyModeSendData(int freMode) {
        char saveflag = '\u0001';
        char region = (char)freMode;
        byte[] sendData = this.getDeviceAPI().UHFSetRegionSendData(saveflag, region);
        return this.getSendData(sendData);
    }

    @Override
    public byte parseGetFrequencyModeData(byte[] inData) {
        byte[] result = this.getDeviceAPI().UHFGetRegionRecvData(inData, inData.length);
        if (result != null && result[0] == 0) {
            return result[2];
        }
        return -1;
    }

    @Override
    public boolean parseSetFrequencyModeData(byte[] inData) {
        int result = this.getDeviceAPI().UHFSetRegionRecvData(inData, inData.length);
        return result == 0;
    }

    @Override
    public byte[] getTemperatureSendData() {
        byte[] sendData = this.getDeviceAPI().UHFGetTemperatureSendData();
        return this.getSendData(sendData);
    }

    @Override
    public int parseTemperatureData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        byte[] result = this.getDeviceAPI().UHFGetTemperatureRecvData(inData, inData.length);
        if (result != null && result[0] == 0) {
            this.PrintLog(result, 4);
            if ((result[2] & 0xFF) >= 240) {
                String hex = StringUtility.bytes2HexString2(new byte[]{result[2], result[3]}, 2);
                int t = Integer.valueOf(hex, 16);
                return -((65535 - t) / 100);
            }
            String hex = StringUtility.bytes2HexString2(new byte[]{result[2], result[3]}, 2);
            return Integer.valueOf(hex, 16) / 100;
        }
        return -1;
    }

    protected UHFTAGInfo parserUhfTagBuff_EPC_TID_USER(byte[] tagsBuff) {
        if (tagsBuff == null || tagsBuff.length == 0) {
            throw new IllegalArgumentException();
        }
        UHFTAGInfo info = new UHFTAGInfo();
        int len = tagsBuff.length;
        byte[] pcBuff = Arrays.copyOfRange(tagsBuff, 0, 2);
        int pc = pcBuff[0] & 0xFF | (pcBuff[1] & 0xFF) << 8;
        info.setPc(StringUtility.bytes2HexString2(pcBuff, pcBuff.length));
        int epclen = (pc >> 3) * 2;
        byte[] epc = Arrays.copyOfRange(tagsBuff, 2, 2 + epclen);
        String strEPC = StringUtility.bytes2HexString2(epc, epc.length);
        info.setEPC(strEPC);
        int uiiLen = epclen + 2;
        byte[] rssi = null;
        Object ant_data = null;
        String strAnt = "";
        if (len >= uiiLen + 12) {
            int tidStart = uiiLen;
            int tidEnd = tidStart + 12;
            byte[] tidBuff = Arrays.copyOfRange(tagsBuff, tidStart, tidEnd);
            info.setTid(StringUtility.bytes2HexString2(tidBuff, tidBuff.length));
            if (len - 3 > tidEnd) {
                int userStart = tidEnd;
                int userEnd = len - 2;
                byte[] userBuff = Arrays.copyOfRange(tagsBuff, userStart, userEnd);
                info.setUser(StringUtility.bytes2HexString2(userBuff, userBuff.length));
                if (len >= userEnd + 2) {
                    int rssiStart = userEnd;
                    int rssiEnd = userEnd + 2;
                    rssi = Arrays.copyOfRange(tagsBuff, rssiStart, rssiEnd);
                }
            } else if (len >= tidEnd + 2) {
                int rssiStart = tidEnd;
                int rssiEnd = tidEnd + 2;
                rssi = Arrays.copyOfRange(tagsBuff, rssiStart, rssiEnd);
            }
        } else if (len >= uiiLen + 2) {
            int rssiStart = uiiLen;
            int rssiEnd = 2 + uiiLen;
            rssi = Arrays.copyOfRange(tagsBuff, rssiStart, rssiEnd);
        }
        if (rssi != null) {
            String strRssi = StringUtility.bytes2HexString2(rssi, rssi.length);
            float dBm = (float)(65535 - Integer.parseInt(strRssi, 16)) / 10.0f;
            String strdBm = "N/A";
            if (dBm < 200.0f && dBm > 0.0f) {
                DecimalFormat fnum = new DecimalFormat("##0.00");
                strdBm = "-" + fnum.format(dBm);
            }
            info.setRssi(strdBm);
        }
        if (ant_data != null) {
            strAnt = String.valueOf(ant_data[0] & 0xFF);
            info.setAnt(strAnt);
        }
        if (info != null && TextUtils.isEmpty((CharSequence)info.getEPC())) {
            info = null;
        }
        return info;
    }

    @Override
    public byte[] setEPCModeSendData() {
        boolean saveflag = false;
        boolean mode = false;
        boolean address = false;
        boolean length = false;
        byte[] sendData = this.getDeviceAPI().UHFSetEPCTIDModeSendData('\u0000', '\u0000', '\u0000', '\u0000');
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseSetEPCModeData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        int result = this.getDeviceAPI().UHFSetEPCTIDModeRecvData(inData, inData.length);
        return result == 0;
    }

    @Override
    public byte[] setEPCAndTIDModeSendData() {
        boolean saveflag = false;
        boolean mode = true;
        boolean address = false;
        boolean length = false;
        byte[] sendData = this.getDeviceAPI().UHFSetEPCTIDModeSendData('\u0000', '\u0001', '\u0000', '\u0000');
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseSetEPCAndTIDModeData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        int result = this.getDeviceAPI().UHFSetEPCTIDModeRecvData(inData, inData.length);
        return result == 0;
    }

    @Override
    public byte[] setEPCAndTIDUserModeSendData(int user_prt, int user_len) {
        boolean saveflag = false;
        int mode = 2;
        byte[] sendData = this.getDeviceAPI().UHFSetEPCTIDModeSendData('\u0000', '\u0002', (char)user_prt, (char)user_len);
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseSetEPCAndTIDUserModeData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        int result = this.getDeviceAPI().UHFSetEPCTIDModeRecvData(inData, inData.length);
        return result == 0;
    }

    @Override
    public byte[] setGen2SendData(char Target, char Action, char T, char Q_Q, char StartQ, char MinQ, char MaxQ, char D_D, char C_C, char P_P, char Sel, char Session, char G_G, char LF) {
        byte[] sendData = this.getDeviceAPI().UHFSetGen2SendData(Target, Action, T, Q_Q, StartQ, MinQ, MaxQ, D_D, C_C, P_P, Sel, Session, G_G, LF);
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseSetGen2Data(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        int result = this.getDeviceAPI().UHFSetGen2RecvData(inData, inData.length);
        return result == 0;
    }

    @Override
    public byte[] getGen2SendData() {
        byte[] sendData = this.getDeviceAPI().UHFGetGen2SendData();
        return this.getSendData(sendData);
    }

    @Override
    public byte[] parseGetGen2Data(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        byte[] data = this.getDeviceAPI().UHFGetGen2RecvData(inData, inData.length);
        if (data[0] == 0) {
            return Arrays.copyOfRange(data, 2, 2 + data[1]);
        }
        return null;
    }

    @Override
    public byte[] blockWriteDataSendData(String pszuAccessPwd, char ufBank, int ufPtr, int ufCnt, String ufData, char uBank, int uPtr, char uCnt, String writeDatabuf) {
        if (!this.checkFilterData(ufData, ufPtr, ufCnt, ufBank)) {
            return null;
        }
        if (!this.checkPwd(pszuAccessPwd)) {
            return null;
        }
        if (!this.checkWriterData(uBank, uPtr, uCnt, writeDatabuf)) {
            return null;
        }
        byte[] pwd = StringUtility.hexString2Bytes(pszuAccessPwd);
        byte[] filterData = StringUtility.hexString2Bytes(ufData);
        byte[] data = StringUtility.hexString2Bytes(writeDatabuf);
        byte[] sendData = this.getDeviceAPI().UHFBlockWriteDataSendData(pwd, ufBank, ufPtr, ufCnt, filterData, uBank, uPtr, uCnt, data);
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseBlockWriteData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        int data = this.getDeviceAPI().UHFBlockWriteDataRecvData(inData, inData.length);
        return data == 0;
    }

    @Override
    public byte[] blockEraseDataSendData(String pszuAccessPwd, char ufBank, int ufPtr, int ufCnt, String ufData, char uBank, int uPtr, char uCnt) {
        if (!this.checkFilterData(ufData, ufPtr, ufCnt, ufBank)) {
            return null;
        }
        if (!this.checkPwd(pszuAccessPwd)) {
            return null;
        }
        if (uBank < '\u0000' || uPtr < 0 || uCnt < '\u0000') {
            throw new IllegalArgumentException("bank or ptr or cnt error !");
        }
        byte[] pwd = StringUtility.hexString2Bytes(pszuAccessPwd);
        byte[] filterData = StringUtility.hexString2Bytes(ufData);
        byte[] sendData = this.getDeviceAPI().UHFBlockEraseDataSendData(pwd, ufBank, ufPtr, ufCnt, filterData, uBank, uPtr, uCnt);
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseBlockEraseDataData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        int data = this.getDeviceAPI().UHFBlockEraseDataRecvData(inData, inData.length);
        return data == 0;
    }

    @Override
    public byte[] GBTagLockSendData(String pszuAccessPwd, char ufBank, int ufPtr, int ufCnt, String ufData, char jmemory, char jconfig, char jaction) {
        if (!this.checkFilterData(ufData, ufPtr, ufCnt, ufBank)) {
            return null;
        }
        if (!this.checkPwd(pszuAccessPwd)) {
            return null;
        }
        byte[] pwd = StringUtility.hexString2Bytes(pszuAccessPwd);
        byte[] filterData = StringUtility.hexString2Bytes(ufData);
        byte[] sendData = this.getDeviceAPI().UHFGBTagLockSendData(pwd, ufBank, ufPtr, ufCnt, filterData, jmemory, jconfig, jaction);
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseGBTagLockData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        int data = this.getDeviceAPI().UHFGBTagLockRecvData(inData, inData.length);
        return data == 0;
    }

    @Override
    public byte[] setFilterSendData(char ufBank, int ufPtr, int datalen, String databuf) {
        if (!StringUtility.isHexNumberRex(databuf) || databuf.length() % 2 != 0) {
            throw new IllegalArgumentException("filterData not hex!");
        }
        byte[] fData = StringUtility.hexString2Bytes(databuf);
        if (datalen > fData.length / 2) {
            datalen = fData.length / 2;
        }
        boolean saveflag = false;
        byte[] sendData = this.getDeviceAPI().UHFSetFilterSendData('\u0000', ufBank, ufPtr, datalen, fData);
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseSetFilterData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        int data = this.getDeviceAPI().UHFSetFilterRecvData(inData, inData.length);
        return data == 0;
    }

    @Override
    public byte[] setCWSendData(char flag) {
        byte[] sendData = this.getDeviceAPI().UHFSetCWSendData(flag);
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseSetCWData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        int data = this.getDeviceAPI().UHFSetCWRecvData(inData, inData.length);
        return data == 0;
    }

    @Override
    public byte[] getCWSendData() {
        byte[] sendData = this.getDeviceAPI().UHFGetCWSendData();
        return this.getSendData(sendData);
    }

    @Override
    public int parseGetCWData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        byte[] data = this.getDeviceAPI().UHFGetCWRecvData(inData, inData.length);
        if (data != null && data[0] == 0) {
            return data[2];
        }
        return -1;
    }

    @Override
    public byte[] setJumpFrequencySendData(int Freqbuf) {
        boolean nums = true;
        int[] freqbuf = new int[]{Freqbuf};
        byte[] sendData = this.getDeviceAPI().UHFSetJumpFrequencySendData('\u0001', freqbuf);
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseSetJumpFrequencyData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        int result = this.getDeviceAPI().UHFSetJumpFrequencyRecvData(inData, inData.length);
        return result == 0;
    }

    @Override
    public byte[] btDeleteAllTagToFlashSendData() {
        byte[] sendData = this.getDeviceAPI().UHFBTDeleteAllTagToFlashSendData();
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseBtDeleteAllTagToFlashData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        int result = this.getDeviceAPI().UHFBTDeleteAllTagToFlashRecvData(inData, inData.length);
        return result == 0;
    }

    @Override
    public byte[] btGetAllTagNumFromFlashSendData() {
        byte[] sendData = this.getDeviceAPI().UHFBTGetAllTagNumFromFlashSendData();
        return this.getSendData(sendData);
    }

    @Override
    public int parseBtGetAllTagNumFromFlashData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        int result = this.getDeviceAPI().UHFBTGetAllTagNumFromFlashRecvData(inData, inData.length);
        return result;
    }

    @Override
    public byte[] btGetTagDataFromFlashSendData() {
        byte[] sendData = this.getDeviceAPI().UHFBTGetTagDataFromFlashSendData();
        return this.getSendData(sendData);
    }

    @Override
    public byte[] parseBtGetTagDataFromFlashData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        byte[] data = this.getDeviceAPI().UHFBTGetTagDataFromFlashRecvData(inData, inData.length);
        return this.getSendData(data);
    }

    @Override
    public byte[] setR6WorkmodeSendData(char flag) {
        byte[] sendData = this.getDeviceAPI().UHTSetR6WorkmodeSendData(flag);
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseSetR6WorkModeData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        int reuslt = this.getDeviceAPI().UHTSetR6WorkmodeRecvData(inData, inData.length);
        return reuslt == 0;
    }

    @Override
    public byte[] uhfJump2BootSendData(char flag) {
        byte[] sendData = this.getDeviceAPI().UHFJump2BootSendData(flag);
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseUHFJump2BootData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        int reuslt = this.getDeviceAPI().UHFJump2BootRecvData(inData, inData.length);
        return reuslt == 0;
    }

    @Override
    public byte[] uhfStartUpdateSendData() {
        byte[] sendData = this.getDeviceAPI().UHFStartUpdateSendData();
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseUHFStartUpdateData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        int reuslt = this.getDeviceAPI().UHFStartUpdateRecvData(inData, inData.length);
        return reuslt == 0;
    }

    @Override
    public byte[] uhfUpdatingSendData(byte[] buf) {
        if (buf == null || buf.length == 0) {
            throw new IllegalArgumentException();
        }
        byte[] sendData = this.getDeviceAPI().UHFUpdatingSendData(buf);
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseUHFUpdatingData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        int reuslt = this.getDeviceAPI().UHFUpdatingRecvData(inData, inData.length);
        return reuslt == 0;
    }

    @Override
    public byte[] UHFStopUpdateSendData() {
        byte[] sendData = this.getDeviceAPI().UHFStopUpdateSendData();
        return this.getSendData(sendData);
    }

    @Override
    public boolean parseUHFStopUpdateData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        int reuslt = this.getDeviceAPI().UHFStopUpdateRecvData(inData, inData.length);
        return reuslt == 0;
    }

    @Override
    public byte[] getSTM32VersionSendData() {
        byte[] sendData = this.getDeviceAPI().UHFGetSTM32VersionSendData();
        return this.getSendData(sendData);
    }

    @Override
    public String parseSTM32VersionData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        byte[] reuslt = this.getDeviceAPI().UHFGetSTM32VersionRecvData(inData, inData.length);
        if (reuslt != null && reuslt[0] == 0) {
            String ver = new String(reuslt, 2, (int)reuslt[1]);
            return ver;
        }
        return null;
    }

    @Override
    public byte[] getEPCTIDModeSendData(char rev1, char rev2) {
        byte[] sendData = this.getDeviceAPI().UHFGetEPCTIDModeSendData(rev1, rev2);
        return this.getSendData(sendData);
    }

    @Override
    public byte[] parseGetEPCTIDModeData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        byte[] reuslt = this.getDeviceAPI().UHFGetEPCTIDModeRecvData(inData, inData.length);
        return this.getSendData(reuslt);
    }

    public byte[] getSendData(byte[] sendData) {
        if (sendData != null && sendData[0] == 0) {
            byte len = sendData[1];
            return Arrays.copyOfRange(sendData, 2, len + 2);
        }
        return null;
    }

    private boolean checkFilterData(String filterData, int filterPtr, int filterCnt, int filterBank) {
        if (filterBank < 0 || filterPtr < 0 || filterCnt < 0) {
            throw new IllegalArgumentException("filterBank or filterPtr or filterCnt error!");
        }
        if (!StringUtility.isHexNumberRex(filterData) || filterData.length() % 2 != 0) {
            throw new IllegalArgumentException("filterData not hex!");
        }
        int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
        if (filterData.length() / 2 < tempLen) {
            throw new IllegalArgumentException("filterCnt error 2!");
        }
        return true;
    }

    private boolean checkPwd(String accessPwd) {
        if (!StringUtility.isHexNumberRex(accessPwd) || accessPwd.length() % 2 != 0) {
            throw new IllegalArgumentException("accessPwd not hex!");
        }
        if (accessPwd.length() != 8) {
            throw new IllegalArgumentException("accessPwd illegal !");
        }
        return true;
    }

    private boolean checkWriterData(int bank, int ptr, int cnt, String writeData) {
        if (bank < 0 || ptr < 0 || cnt < 0) {
            throw new IllegalArgumentException("bank or ptr or cnt error !");
        }
        if (!StringUtility.isHexNumberRex(writeData) || writeData.length() % 2 != 0) {
            throw new IllegalArgumentException("accessPwd not hex!");
        }
        int tempLen = cnt / 8 + (cnt % 8 == 0 ? 0 : 1);
        if (writeData.length() / 2 < tempLen) {
            throw new IllegalArgumentException("writeData cnt error!");
        }
        return true;
    }

    protected void PrintLog(String msg) {
    }

    protected void PrintLog(byte[] hex) {
    }

    protected void PrintLog(byte[] hex, int len) {
    }
}

