/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.UHFProtocolParse;
import com.rscja.deviceapi.entity.UHFTAGInfo;
import com.rscja.utility.StringUtility;
import java.util.ArrayList;
import java.util.Arrays;

public class UHFProtocolParseUSB
extends UHFProtocolParse {
    private static UHFProtocolParseUSB single = null;

    protected UHFProtocolParseUSB() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized UHFProtocolParseUSB getInstance() {
        if (single != null) return single;
        Class<UHFProtocolParseUSB> clazz = UHFProtocolParseUSB.class;
        synchronized (UHFProtocolParseUSB.class) {
            if (single != null) return single;
            single = new UHFProtocolParseUSB();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    @Override
    public byte[] getReadTagSendData() {
        String hex = "A55A0008EBE30D0A";
        byte[] sendData = StringUtility.hexString2Bytes(hex);
        return sendData;
    }

    @Override
    public ArrayList<UHFTAGInfo> parseReadTagDataEPC_TID_USER(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        byte[] data = DeviceAPI.getInstance().UHFUSBGetTagsDataRecvData(inData, inData.length);
        this.PrintLog("parseReadTagDataEPC_TID_USER  data[0]" + data[0]);
        ArrayList<UHFTAGInfo> list = new ArrayList<UHFTAGInfo>();
        if (data != null && data[0] == 0) {
            int len = 2 + (0xFF & data[1]);
            this.PrintLog("parseReadTagDataEPC_TID_USER len:" + len);
            if (data.length < len + 2) {
                return null;
            }
            data = Arrays.copyOfRange(data, 2, len + 2);
            this.PrintLog("parseReadTagDataEPC_TID_USER Data:");
            this.PrintLog(data, data.length);
            int count = data[0] & 0xFF;
            int tempLen = data[1] & 0xFF;
            int startIndex = 2;
            int endIndex = startIndex + tempLen;
            this.PrintLog("parseReadTagDataEPC_TID_USER \u6807\u7b7e\u4e2a\u6570\uff1a" + count);
            int k = 0;
            while (k < count) {
                if (data.length < endIndex) break;
                byte[] tempData = Arrays.copyOfRange(data, startIndex, endIndex);
                UHFTAGInfo info = this.parserUhfTagBuff_EPC_TID_USER(tempData);
                if (info != null) {
                    list.add(info);
                }
                tempLen = data[endIndex] & 0xFF;
                startIndex = endIndex + 1;
                endIndex = startIndex + tempLen;
                this.PrintLog("parseReadTagDataEPC_TID_USER Data:");
                this.PrintLog("\u7b2c" + k + "\u5f20\u6807\u7b7e\uff1a" + info.getEPC());
                ++k;
            }
        }
        if (list.size() > 0) {
            return list;
        }
        return null;
    }

    @Override
    public UHFTAGInfo parseInventorySingleTagData(byte[] inData) {
        if (inData == null || inData.length == 0) {
            throw new IllegalArgumentException();
        }
        byte[] data = DeviceAPI.getInstance().UHFInventorySingleRecvData(inData, inData.length);
        this.PrintLog("\u89e3\u6790\u540e\u7684\u6570\u636e:");
        this.PrintLog(inData);
        if (data != null && data.length > 0 && data[0] == 0) {
            int len = data[1] & 0xFF;
            data = Arrays.copyOfRange(data, 2, 2 + len);
            return this.parserUhfTagBuff_EPC_TID_USER(data);
        }
        return null;
    }

    public static /* bridge */ /* synthetic */ UHFProtocolParse getInstance() {
        return UHFProtocolParseUSB.getInstance();
    }
}

