/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi.service;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.util.Log;
import com.rscja.deviceapi.RFIDWithUHFBluetooth;
import com.rscja.utility.StringUtility;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

@SuppressLint(value={"NewApi"})
public class BTService {
    private static boolean isDebug = false;
    private static final String TAG = "DeviceAPI_nRFUART";
    private BluetoothManager mBluetoothManager;
    private BluetoothAdapter mBluetoothAdapter;
    private String mBluetoothDeviceAddress;
    private BluetoothGatt mBluetoothGatt;
    private RFIDWithUHFBluetooth.StatusEnum mConnectionState = RFIDWithUHFBluetooth.StatusEnum.DISCONNECTED;
    RFIDWithUHFBluetooth.BTStatusCallback btStatusCallback = null;
    private RFIDWithUHFBluetooth.ScanBTCallback scanBTCallback = null;
    private RFIDWithUHFBluetooth.KeyEventCallback keyEventCallback = null;
    private Context context = null;
    private IDataCallBack dataCallBack = null;
    public static final String BT_RSSI = "rssi";
    public static final String BT_RECORD = "record";
    public static final String BT_DEVICE = "device";
    public static boolean isWrite = false;
    public static boolean isRead = false;
    public static final String ACTION_SEARCH_DEVICES = "com.nordicsemi.nrfUART.ACTION_SEARCH_DEVICES";
    public static final String ACTION_GATT_CONNECTED = "com.nordicsemi.nrfUART.ACTION_GATT_CONNECTED";
    public static final String ACTION_GATT_DISCONNECTED = "com.nordicsemi.nrfUART.ACTION_GATT_DISCONNECTED";
    public static final String ACTION_GATT_SERVICES_DISCOVERED = "com.nordicsemi.nrfUART.ACTION_GATT_SERVICES_DISCOVERED";
    public static final String ACTION_DATA_AVAILABLE = "com.nordicsemi.nrfUART.ACTION_DATA_AVAILABLE";
    public static final String EXTRA_DATA = "com.nordicsemi.nrfUART.EXTRA_DATA";
    public static final String DEVICE_DOES_NOT_SUPPORT_UART = "com.nordicsemi.nrfUART.DEVICE_DOES_NOT_SUPPORT_UART";
    public static final String DEVICE_INITED_BT_COMMUNICATE = "com.nordicsemi.nrfUART.DEVICE_INITED_BT_COMMUNICATE";
    public static final UUID CCCD = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    public static final UUID RX_SERVICE_UUID = UUID.fromString("6e400001-b5a3-f393-e0a9-e50e24dcca9e");
    public static final UUID RX_CHAR_UUID = UUID.fromString("6e400002-b5a3-f393-e0a9-e50e24dcca9e");
    public static final UUID TX_CHAR_UUID = UUID.fromString("6e400003-b5a3-f393-e0a9-e50e24dcca9e");
    public static final UUID BLE_UUID_GAP = UUID.fromString("00001800-0000-1000-8000-00805f9b34fb");
    public static final UUID BLE_UUID_GAP_CHARACTERISTIC_DEVICE_NAME = UUID.fromString("00002a00-0000-1000-8000-00805f9b34fb");
    public static final UUID VERSION_UUID = UUID.fromString("0000180a-0000-1000-8000-00805f9b34fb");
    public static final UUID VERSION_FIRMWARE_UUID = UUID.fromString("00002a26-0000-1000-8000-00805f9b34fb");
    public static final UUID VERSION_HARDWARE_UUID = UUID.fromString("00002a27-0000-1000-8000-00805f9b34fb");
    public static final UUID VERSION_SOFTWARE_UUID = UUID.fromString("00002a28-0000-1000-8000-00805f9b34fb");
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    if (BTService.this.keyEventCallback == null) break;
                    BTService.this.keyEventCallback.getKeyEvent(msg.arg1);
                }
            }
        }
    };
    private final BluetoothGattCallback mGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            Log.i((String)BTService.TAG, (String)("-----------onConnectionStateChange----------------status=" + status + "  newState=" + newState));
            if (newState == 2) {
                String intentAction = BTService.ACTION_GATT_CONNECTED;
                BTService.this.mConnectionState = RFIDWithUHFBluetooth.StatusEnum.CONNECTED;
                BTService.this.setStatus(RFIDWithUHFBluetooth.StatusEnum.CONNECTED, gatt.getDevice());
                BTService.this.broadcastUpdate(intentAction);
                BTService.this.mBluetoothGatt.discoverServices();
                Log.i((String)BTService.TAG, (String)"Connected to GATT server.");
            } else if (newState == 0) {
                String intentAction = BTService.ACTION_GATT_DISCONNECTED;
                BTService.this.mConnectionState = RFIDWithUHFBluetooth.StatusEnum.DISCONNECTED;
                BTService.this.setStatus(RFIDWithUHFBluetooth.StatusEnum.DISCONNECTED, gatt.getDevice());
                BTService.this.broadcastUpdate(intentAction);
                BTService.this.close();
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            Log.i((String)BTService.TAG, (String)"-----------onServicesDiscovered----------------");
            if (status == 0) {
                Log.d((String)BTService.TAG, (String)("mBluetoothGatt = " + BTService.this.mBluetoothGatt));
                BTService.this.broadcastUpdate(BTService.ACTION_GATT_SERVICES_DISCOVERED);
                BTService.this.enableTXNotification();
            } else {
                Log.d((String)BTService.TAG, (String)("onServicesDiscovered received: " + status));
            }
            isRead = true;
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            Log.i((String)BTService.TAG, (String)("-----------onCharacteristicRead----------------status=" + status));
            if (status == 0) {
                BTService.this.broadcastUpdate(BTService.ACTION_DATA_AVAILABLE, characteristic);
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            if (isDebug) {
                Log.i((String)BTService.TAG, (String)"-----------onCharacteristicChanged----------------");
            }
            BTService.this.broadcastUpdate(BTService.ACTION_DATA_AVAILABLE, characteristic);
        }

        public void onReadRemoteRssi(BluetoothGatt gatt, int rssi, int status) {
            Log.i((String)BTService.TAG, (String)("-----------onReadRemoteRssi----------------status=" + status));
            super.onReadRemoteRssi(gatt, rssi, status);
        }

        public void onReliableWriteCompleted(BluetoothGatt gatt, int status) {
            Log.i((String)BTService.TAG, (String)"-----------onReliableWriteCompleted----------------");
            super.onReliableWriteCompleted(gatt, status);
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            Log.i((String)BTService.TAG, (String)"-----------onDescriptorWrite----------------");
            super.onDescriptorWrite(gatt, descriptor, status);
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (isDebug) {
                Log.i((String)BTService.TAG, (String)("-----------onCharacteristicWrite----------------status=" + status));
            }
            super.onCharacteristicWrite(gatt, characteristic, status);
            isWrite = true;
        }

        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            Log.i((String)BTService.TAG, (String)("-----------onDescriptorRead----------------status=" + status));
            super.onDescriptorRead(gatt, descriptor, status);
        }
    };
    private byte lastData = 0;
    private BluetoothAdapter.LeScanCallback mLeScanCallback = new BluetoothAdapter.LeScanCallback(){

        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            Log.d((String)BTService.TAG, (String)"onLeScan ok");
            Bundle bundle = new Bundle();
            bundle.putParcelable(BTService.BT_DEVICE, (Parcelable)device);
            Intent intent = new Intent(BTService.ACTION_SEARCH_DEVICES);
            intent.putExtra(BTService.BT_RSSI, rssi);
            intent.putExtra(BTService.BT_RECORD, scanRecord);
            intent.putExtra(BTService.BT_DEVICE, bundle);
            BTService.this.broadcastUpdate(intent);
            BTService.this.getDevices(device, rssi, scanRecord);
        }
    };

    private void broadcastUpdate(String action) {
        Intent intent = new Intent(action);
        if (this.context != null) {
            this.context.sendBroadcast(intent);
        }
    }

    private void broadcastUpdate(Intent intent) {
        if (this.context != null) {
            this.context.sendBroadcast(intent);
        }
    }

    private void broadcastUpdate(String action, BluetoothGattCharacteristic characteristic) {
        Intent intent = new Intent(action);
        if (isDebug) {
            Log.w((String)"DeviceAPI_nRFUART_ZP", (String)("-------------------------broadcastUpdate action: " + action));
        }
        if (TX_CHAR_UUID.equals(characteristic.getUuid())) {
            intent.putExtra(EXTRA_DATA, characteristic.getValue());
            this.readData(characteristic.getValue());
        }
        if (this.context != null) {
            this.context.sendBroadcast(intent);
        }
    }

    public boolean initialize(Context context) {
        Log.d((String)"DeviceAPI_nRFUART_ZP", (String)"-----\u521d\u59cb\u5316\u84dd\u7259\u670d\u52a1initialize-------");
        if (context == null) {
            Log.d((String)"DeviceAPI_nRFUART_ZP", (String)"-----\u521d\u59cb\u5316\u84dd\u7259\u670d\u52a1initialize context==null------");
            return false;
        }
        this.context = context;
        if (this.mBluetoothManager == null) {
            this.mBluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
            if (this.mBluetoothManager == null) {
                Log.e((String)TAG, (String)"Unable to initialize BluetoothManager.");
                return false;
            }
        }
        this.mBluetoothAdapter = this.mBluetoothManager.getAdapter();
        if (this.mBluetoothAdapter == null) {
            Log.e((String)TAG, (String)"Unable to obtain a BluetoothAdapter.");
            return false;
        }
        return true;
    }

    public boolean setBtName(String name) {
        Log.d((String)TAG, (String)"........setBtName..........");
        if (name == null || name.length() == 0) {
            Log.e((String)TAG, (String)"name==null || name.length()==0");
            return false;
        }
        if (this.mConnectionState == RFIDWithUHFBluetooth.StatusEnum.CONNECTED) {
            BluetoothGattService RxService = this.mBluetoothGatt.getService(BLE_UUID_GAP);
            if (RxService == null) {
                Log.e((String)TAG, (String)"RxService==null");
                return false;
            }
            BluetoothGattCharacteristic RxChar = RxService.getCharacteristic(BLE_UUID_GAP_CHARACTERISTIC_DEVICE_NAME);
            if (RxChar == null) {
                Log.e((String)TAG, (String)"RxChar==null");
                return false;
            }
            RxChar.setValue(name);
            boolean result = this.mBluetoothGatt.writeCharacteristic(RxChar);
            if (result) {
                Log.d((String)TAG, (String)"success");
            } else {
                Log.e((String)TAG, (String)"fail");
            }
            return result;
        }
        return false;
    }

    public HashMap<String, String> getVersion() {
        Log.d((String)TAG, (String)"........getVersion..........");
        if (this.mConnectionState == RFIDWithUHFBluetooth.StatusEnum.CONNECTED) {
            BluetoothGattService RxService = this.mBluetoothGatt.getService(VERSION_UUID);
            if (RxService == null) {
                Log.e((String)TAG, (String)"RxService==null");
                return null;
            }
            BluetoothGattCharacteristic RxChar = RxService.getCharacteristic(VERSION_FIRMWARE_UUID);
            HashMap<String, String> version = new HashMap<String, String>();
            if (RxChar != null) {
                isRead = false;
                this.mBluetoothGatt.readCharacteristic(RxChar);
                int k = 0;
                while (k < 20) {
                    if (isRead) break;
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ++k;
                }
                String firm = RxChar.getStringValue(0);
                Log.d((String)TAG, (String)("........getVersion..........firm=" + firm));
                version.put("FIRMWARE", firm);
            } else {
                Log.e((String)TAG, (String)"RxService.getCharacteristic(VERSION_FIRMWARE_UUID) ==null");
            }
            RxChar = RxService.getCharacteristic(VERSION_HARDWARE_UUID);
            if (RxChar != null) {
                isRead = false;
                this.mBluetoothGatt.readCharacteristic(RxChar);
                int k = 0;
                while (k < 20) {
                    if (isRead) break;
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ++k;
                }
                String hardware = RxChar.getStringValue(0);
                Log.d((String)TAG, (String)("........getVersion..........hardware=" + hardware));
                version.put("HARDWARE", hardware);
            } else {
                Log.e((String)TAG, (String)"RxService.getCharacteristic(VERSION_HARDWARE_UUID) ==null");
            }
            RxChar = RxService.getCharacteristic(VERSION_SOFTWARE_UUID);
            if (RxChar != null) {
                isRead = false;
                this.mBluetoothGatt.readCharacteristic(RxChar);
                int k = 0;
                while (k < 20) {
                    if (isRead) break;
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ++k;
                }
                String soft = RxChar.getStringValue(0);
                Log.d((String)TAG, (String)("........getVersion..........soft=" + soft));
                version.put("SOFTWARE", soft);
            } else {
                Log.e((String)TAG, (String)"RxService.getCharacteristic(VERSION_SOFTWARE_UUID) ==null");
            }
            return version;
        }
        return null;
    }

    public void setStatusCallback(RFIDWithUHFBluetooth.BTStatusCallback btStatusCallback) {
        this.btStatusCallback = btStatusCallback;
    }

    public boolean connect(String address, RFIDWithUHFBluetooth.BTStatusCallback btStatusCallback) {
        Log.v((String)TAG, (String)"-----------\u5f00\u59cb\u8fde\u63a5----------------");
        this.btStatusCallback = btStatusCallback;
        Log.d((String)TAG, (String)("connect(final String address=" + address + ")"));
        if (this.mBluetoothAdapter == null || address == null || address.isEmpty()) {
            Log.w((String)TAG, (String)"BluetoothAdapter not initialized or unspecified address.");
            return false;
        }
        if (this.mBluetoothDeviceAddress != null && address.equals(this.mBluetoothDeviceAddress) && this.mBluetoothGatt != null) {
            Log.d((String)TAG, (String)"Trying to use an existing mBluetoothGatt for connection.");
            this.mConnectionState = RFIDWithUHFBluetooth.StatusEnum.CONNECTING;
            return this.mBluetoothGatt.connect();
        }
        BluetoothDevice device = this.mBluetoothAdapter.getRemoteDevice(address);
        if (device == null) {
            Log.w((String)TAG, (String)"Device not found.  Unable to connect.");
            return false;
        }
        this.mConnectionState = RFIDWithUHFBluetooth.StatusEnum.CONNECTING;
        this.mBluetoothGatt = device.connectGatt(this.context, false, this.mGattCallback);
        Log.d((String)TAG, (String)"Trying to create a new connection.");
        this.mBluetoothDeviceAddress = address;
        return true;
    }

    public void disconnect() {
        if (this.mBluetoothAdapter == null || this.mBluetoothGatt == null) {
            Log.w((String)TAG, (String)"BluetoothAdapter not initialized");
            return;
        }
        this.mBluetoothGatt.disconnect();
    }

    public void close() {
        if (this.mBluetoothGatt == null) {
            return;
        }
        Log.w((String)TAG, (String)"mBluetoothGatt closed");
        this.mBluetoothDeviceAddress = null;
        this.mBluetoothGatt.close();
        this.mBluetoothGatt = null;
    }

    public boolean readCharacteristic(BluetoothGattCharacteristic characteristic) {
        if (this.mBluetoothAdapter == null || this.mBluetoothGatt == null) {
            Log.w((String)TAG, (String)"BluetoothAdapter not initialized");
            return false;
        }
        Log.d((String)"DeviceAPI_nRFUART_ZP", (String)"----mBluetoothGatt.readCharacteristic(characteristic)----");
        return this.mBluetoothGatt.readCharacteristic(characteristic);
    }

    public void enableTXNotification() {
        Log.d((String)TAG, (String)"---------------enableTXNotification-----------------");
        BluetoothGattService RxService = this.mBluetoothGatt.getService(RX_SERVICE_UUID);
        if (RxService == null) {
            this.broadcastUpdate(DEVICE_DOES_NOT_SUPPORT_UART);
            this.discon(null);
            return;
        }
        BluetoothGattCharacteristic TxChar = RxService.getCharacteristic(TX_CHAR_UUID);
        if (TxChar == null) {
            this.broadcastUpdate(DEVICE_DOES_NOT_SUPPORT_UART);
            this.discon(null);
            return;
        }
        this.mBluetoothGatt.setCharacteristicNotification(TxChar, true);
        BluetoothGattDescriptor descriptor = TxChar.getDescriptor(CCCD);
        descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
        this.mBluetoothGatt.writeDescriptor(descriptor);
    }

    public synchronized boolean writeRXCharacteristic(byte[] value, String[] msg) {
        msg[0] = "";
        String strMsg = "";
        if (value == null || value.length == 0) {
            strMsg = "writeRXCharacteristic data=null";
            Log.d((String)TAG, (String)strMsg);
            msg[0] = strMsg;
            return false;
        }
        if (isDebug) {
            String logdata = "\u5199\u5165\u7684\u539f\u59cb\u6570\u636e writeRXCharacteristic data=" + StringUtility.bytes2HexString2(value, value.length);
            Log.d((String)"DeviceAPI_nRFUART_ZP", (String)logdata);
            this.writeLog(logdata);
        }
        if (this.mConnectionState == RFIDWithUHFBluetooth.StatusEnum.CONNECTED) {
            BluetoothGattService RxService = this.mBluetoothGatt.getService(RX_SERVICE_UUID);
            if (RxService == null) {
                strMsg = "BluetoothGattService == null";
                Log.e((String)TAG, (String)strMsg);
                msg[0] = strMsg;
                this.broadcastUpdate(DEVICE_DOES_NOT_SUPPORT_UART);
                return false;
            }
            BluetoothGattCharacteristic RxChar = RxService.getCharacteristic(RX_CHAR_UUID);
            if (RxChar == null) {
                strMsg = "BluetoothGattCharacteristic == null";
                Log.e((String)TAG, (String)strMsg);
                msg[0] = strMsg;
                this.broadcastUpdate(DEVICE_DOES_NOT_SUPPORT_UART);
                this.discon(null);
                return false;
            }
            boolean status = false;
            int cont = value.length / 20 + (value.length % 20 > 0 ? 1 : 0);
            int k = 0;
            k = 0;
            while (k < cont) {
                byte[] sendData = value.length < k * 20 + 20 ? Arrays.copyOfRange(value, k * 20, value.length) : Arrays.copyOfRange(value, k * 20, k * 20 + 20);
                if (isDebug) {
                    Log.d((String)"DeviceAPI_nRFUART_ZP", (String)("\u5206\u6bb5\u5199\u6570\u636e=" + StringUtility.bytes2HexString2(sendData, sendData.length)));
                }
                RxChar.setValue(sendData);
                if (k > 0) {
                    int i = 0;
                    while (i < 20 && !isWrite) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                    Log.d((String)"DeviceAPI_nRFUART_ZP", (String)("\u5199\u5165\u8017\u65f6:" + i));
                }
                isWrite = false;
                status = this.mBluetoothGatt.writeCharacteristic(RxChar);
                if (!status) {
                    msg[0] = strMsg = "\u5199\u5165\u6570\u636e\u5931\u8d25,\u603b\u6b21\u6570" + cont + " \u5b8c\u6210\u6b21\u6570:" + k;
                    Log.e((String)TAG, (String)strMsg);
                    break;
                }
                ++k;
            }
            if (isDebug) {
                Log.d((String)"DeviceAPI_nRFUART_ZP", (String)("\u5199\u5165\u6570\u636e\u5b8c\u6210 write TXchar - status=" + status));
            }
            return status;
        }
        msg[0] = "mConnectionState=" + (Object)((Object)this.mConnectionState);
        Log.e((String)TAG, (String)("mConnectionState=" + (Object)((Object)this.mConnectionState)));
        return false;
    }

    public List<BluetoothGattService> getSupportedGattServices() {
        if (this.mBluetoothGatt == null) {
            return null;
        }
        return this.mBluetoothGatt.getServices();
    }

    public void startBTScan(RFIDWithUHFBluetooth.ScanBTCallback scanBTCallback) {
        this.scanBTCallback = scanBTCallback;
        if (this.mBluetoothAdapter != null) {
            Log.d((String)TAG, (String)"startBTScan begin");
            this.mBluetoothAdapter.startLeScan(this.mLeScanCallback);
        }
    }

    public void setKeyEventCallback(RFIDWithUHFBluetooth.KeyEventCallback KeyEventCallback2) {
        this.keyEventCallback = KeyEventCallback2;
    }

    public void setDataCallBack(IDataCallBack dataCallBack) {
        this.dataCallBack = dataCallBack;
    }

    public RFIDWithUHFBluetooth.StatusEnum getBTConnectStatus() {
        return this.mConnectionState;
    }

    public void stoptBTScan() {
        if (this.mBluetoothAdapter != null) {
            this.mBluetoothAdapter.stopLeScan(this.mLeScanCallback);
        }
    }

    private void readData(byte[] data) {
        if (data != null && data.length > 0) {
            if (isDebug) {
                String logdata = "\u63a5\u6536\u5230\u7684\u539f\u59cb\u6570\u636e:" + StringUtility.bytes2HexString2(data, data.length);
                Log.d((String)"DeviceAPI_nRFUART_ZP", (String)logdata);
                this.writeLog(logdata);
            }
            boolean flag = false;
            if (this.lastData == 13 && data[0] == 10) {
                flag = true;
            }
            this.lastData = data[data.length - 1];
            int k = 0;
            while (k < data.length - 1) {
                if (data[k] == 13 && data[k + 1] == 10) {
                    flag = true;
                }
                ++k;
            }
            this.getKeyData(data);
            if (this.dataCallBack != null) {
                this.dataCallBack.receiveBTData(data, flag);
            }
        }
    }

    private void setStatus(RFIDWithUHFBluetooth.StatusEnum status, BluetoothDevice device) {
        if (this.btStatusCallback != null) {
            this.btStatusCallback.getStatus(status, device);
        }
        if (status == RFIDWithUHFBluetooth.StatusEnum.DISCONNECTED) {
            Log.d((String)TAG, (String)"\u8fde\u63a5\u65ad\u5f00");
            this.close();
        } else {
            this.setMtu();
            Log.d((String)TAG, (String)"\u8fde\u63a5\u6210\u529f");
        }
    }

    private void discon(BluetoothDevice device) {
        this.disconnect();
        if (this.btStatusCallback != null) {
            this.btStatusCallback.getStatus(RFIDWithUHFBluetooth.StatusEnum.DISCONNECTED, device);
        }
    }

    private void getDevices(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (this.scanBTCallback != null) {
            this.scanBTCallback.getDevices(device, rssi, scanRecord);
        }
    }

    private void getKeyData(byte[] data) {
        if (data == null) {
            return;
        }
        int flag = 0;
        int keyCode = 0;
        int checkCode = 0;
        int k = 0;
        while (k < data.length) {
            int temp = data[k] & 0xFF;
            switch (flag) {
                case 0: {
                    int n = flag = temp == 200 ? 1 : 0;
                    if (flag != 0) break;
                    flag = temp == 165 ? 11 : 0;
                    break;
                }
                case 11: {
                    flag = temp == 90 ? 2 : 0;
                    break;
                }
                case 1: {
                    flag = temp == 140 ? 2 : 0;
                    break;
                }
                case 2: {
                    flag = temp == 0 ? 3 : 0;
                    break;
                }
                case 3: {
                    flag = temp == 9 ? 4 : 0;
                    break;
                }
                case 4: {
                    flag = temp == 230 ? 5 : 0;
                    break;
                }
                case 5: {
                    flag = temp == 1 || temp == 2 ? 6 : 0;
                    keyCode = data[k];
                    break;
                }
                case 6: {
                    checkCode ^= 0;
                    checkCode ^= 9;
                    checkCode ^= 0xE6;
                    flag = temp == (checkCode ^= keyCode) ? 7 : 0;
                    break;
                }
                case 7: {
                    flag = temp == 13 ? 8 : 0;
                    break;
                }
                case 8: {
                    int n = flag = temp == 10 ? 9 : 0;
                }
            }
            if (flag == 9) break;
            ++k;
        }
        if (flag == 9) {
            Message msg = this.mHandler.obtainMessage();
            msg.what = 0;
            msg.arg1 = keyCode;
            this.mHandler.sendMessage(msg);
        }
    }

    private void setMtu() {
    }

    private void writeLog(String data) {
    }

    public static interface IDataCallBack {
        public void receiveBTData(byte[] var1, boolean var2);
    }
}

