/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi.usb;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.hardware.usb.UsbRequest;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import com.rscja.deviceapi.interfaces.KeyEventCallback;
import com.rscja.utility.StringUtility;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;

public class USBUtil {
    private PendingIntent mPermissionIntent;
    private UsbManager usbManager;
    private Context context;
    private final int timeOut = 500;
    private UsbInterface usbInterface;
    private UsbEndpoint usbEndpointIn;
    private UsbEndpoint usbEndpointOut;
    private UsbDeviceConnection usbConnection;
    private KeyEventCallback KeyEventCallback = null;
    private UsbReceiver usbReceiver = null;
    private String TAG = "DeviceAPI_USBUtil";
    private boolean isRuning = false;
    private ReceiverData receiverDataThread = null;
    private final boolean isPassive = true;
    private final boolean isDebug = false;
    private final int MSG_KEYDOWN = 0;
    private UsbDevice currDevice = null;
    Handler hand = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    USBUtil.this.log("getKeyData \u6309\u4e0b\u6309\u952e\uff1akeycode=" + msg.arg1);
                    if (USBUtil.this.KeyEventCallback == null) break;
                    USBUtil.this.KeyEventCallback.onKeyDown(msg.arg1);
                }
            }
        }
    };
    private LinkedBlockingQueue<Byte> queueReceive = new LinkedBlockingQueue(10240);
    private boolean isComplete = false;
    private byte lastByte = 0;
    private ArrayList<Byte> tempData = new ArrayList();

    public void setKeyEventCallback(KeyEventCallback KeyEventCallback2) {
        this.KeyEventCallback = KeyEventCallback2;
    }

    public int openPort(UsbDevice device) {
        if (this.usbConnection != null) {
            this.log("usb\u5df2\u7ecf\u8fde\u63a5.");
            return 0;
        }
        this.registerReceiver(this.context);
        if (device == null) {
            return -1;
        }
        this.usbInterface = device.getInterface(0);
        if (!this.hasPermission(device)) {
            this.log("openPort \u6ca1\u6709 USB \u6743\u9650.");
            this.requestPermission(device);
            return 1;
        }
        this.usbConnection = this.usbManager.openDevice(device);
        if (this.usbConnection == null) {
            this.log("openPort usbConnection == null.");
            return -1;
        }
        if (!this.usbConnection.claimInterface(this.usbInterface, true)) {
            this.usbConnection.close();
            this.log("openPort \u6ca1\u6709\u627e\u5230 USB \u8bbe\u5907\u63a5\u53e3.");
            return -1;
        }
        this.log("openPort \u627e\u5230 USB \u8bbe\u5907\u63a5\u53e3.");
        int i = 0;
        while (i < this.usbInterface.getEndpointCount()) {
            UsbEndpoint end = this.usbInterface.getEndpoint(i);
            if (end.getDirection() == 128) {
                this.usbEndpointIn = end;
                this.log("openPort usbEndpointIn = " + end);
            } else {
                this.usbEndpointOut = end;
                this.log("openPort  usbEndpointOut = " + end);
            }
            ++i;
        }
        this.startReceiverThread();
        this.currDevice = device;
        return 0;
    }

    public synchronized UsbDevice closeport() {
        this.stopReceiverThread();
        this.unRegisterReceiver();
        if (this.usbConnection == null) {
            this.log("closeport usbConnection == null");
            return null;
        }
        try {
            this.usbConnection.releaseInterface(this.usbInterface);
            this.usbConnection.close();
            this.usbConnection = null;
            this.usbEndpointIn = null;
            this.usbEndpointOut = null;
            this.usbInterface = null;
            this.log("closeport Device closed.");
        }
        catch (Exception var3) {
            this.log("closeport Exception: " + var3.getMessage());
        }
        UsbDevice device = this.currDevice;
        this.currDevice = null;
        return device;
    }

    public byte[] receive() {
        this.log("receive data==================================>");
        if (this.usbConnection == null || this.usbEndpointIn == null) {
            this.log("receive usbConnection==null || usbEndpointIn==null");
            return null;
        }
        int inMax = this.getInputMax();
        ByteBuffer byteBuffer = ByteBuffer.allocate(inMax);
        UsbRequest usbRequest = new UsbRequest();
        usbRequest.initialize(this.usbConnection, this.usbEndpointIn);
        usbRequest.queue(byteBuffer, inMax);
        this.log("receive usbConnection.requestWait()........");
        if (this.usbConnection.requestWait() == usbRequest) {
            byte[] result = byteBuffer.array();
            if (result != null) {
                this.getKeyData(result);
            } else {
                this.log("receive null");
            }
            return result;
        }
        this.log("receive null (usbConnection.requestWait() != usbRequest)");
        return null;
    }

    public int send(byte[] bytes) {
        this.log("send");
        if (this.usbConnection == null || this.usbEndpointOut == null) {
            this.log("send usbConnection==null || usbEndpointOut==null");
            return -10001;
        }
        int outMax = this.getOutMax();
        if (bytes == null) {
            this.log("send bytes==null");
            return -10002;
        }
        if (bytes.length > outMax) {
            this.log("send  bytes.length=" + bytes.length + "  ,outMax=" + outMax);
            return -10003;
        }
        byte[] sendData = new byte[outMax];
        System.arraycopy(bytes, 0, sendData, 0, bytes.length);
        this.log("send data==================================>");
        this.log("send data=" + StringUtility.bytes2HexString2(sendData, sendData.length));
        int reuslt = this.usbConnection.bulkTransfer(this.usbEndpointOut, sendData, sendData.length, 500);
        this.log("send result=" + reuslt);
        return reuslt;
    }

    private synchronized byte[] sendAndReceive(byte[] bytes) {
        this.log("sendAndReceive");
        int reuslt = this.send(bytes);
        if (reuslt > 0) {
            SystemClock.sleep((long)10L);
            byte[] receiveytes = this.receive();
            if (receiveytes != null && receiveytes.length > 0) {
                return receiveytes;
            }
            return null;
        }
        return null;
    }

    public synchronized byte[] sendAndReceive(byte[] bytes, boolean isInventory) {
        int reuslt;
        this.log("sendAndReceive isInventory=" + isInventory);
        if (!isInventory) {
            this.cleanCache();
        }
        if ((reuslt = this.send(bytes)) > 0) {
            byte[] data = this.getQueueData(500);
            this.log("\u63a5\u53d7\u8fd4\u56de\u7684\u6570\u636e\uff1a");
            this.log(data);
            return data;
        }
        return null;
    }

    private boolean hasPermission(UsbDevice device) {
        return this.usbManager.hasPermission(device);
    }

    private void requestPermission(UsbDevice device) {
        if (device != null) {
            if (this.usbManager.hasPermission(device)) {
                this.log("requestPermission \u5df2\u7ecf\u83b7\u53d6\u5230\u6743\u9650");
            } else if (this.mPermissionIntent != null) {
                this.usbManager.requestPermission(device, this.mPermissionIntent);
                this.log("requestPermission \u8bf7\u6c42USB\u6743\u9650");
            } else {
                this.log("requestPermission \u8bf7\u6ce8\u518cUSB\u5e7f\u64ad");
            }
        }
    }

    private int getOutMax() {
        if (this.usbEndpointOut == null) {
            return 0;
        }
        int inMax = this.usbEndpointOut.getMaxPacketSize();
        this.log("usbEndpointOut   inMax=" + inMax);
        return inMax;
    }

    private int getInputMax() {
        if (this.usbEndpointIn == null) {
            return 0;
        }
        int inMax = this.usbEndpointIn.getMaxPacketSize();
        this.log("usbEndpointIn   inMax=" + inMax);
        return inMax;
    }

    public synchronized void init(Context context) {
        this.context = context;
        this.usbManager = (UsbManager)context.getSystemService("usb");
    }

    public synchronized List<UsbDevice> getDeviceList(Context context) {
        if (context == null) {
            return null;
        }
        if (this.usbManager == null) {
            this.usbManager = (UsbManager)context.getSystemService("usb");
        }
        HashMap deviceList = this.usbManager.getDeviceList();
        Iterator deviceIterator = deviceList.values().iterator();
        ArrayList<UsbDevice> usbDevices = new ArrayList<UsbDevice>();
        while (deviceIterator.hasNext()) {
            UsbDevice device = (UsbDevice)deviceIterator.next();
            usbDevices.add(device);
            this.log("getDeviceList getDeviceName=" + device.getDeviceName());
        }
        return usbDevices;
    }

    public UsbDevice getUsbDevice(int vendorId, int productId) {
        HashMap deviceList = this.usbManager.getDeviceList();
        for (UsbDevice device : deviceList.values()) {
            if (device.getVendorId() != vendorId || device.getProductId() != productId) continue;
            this.log("getUsbDevice getDeviceName= " + device.getDeviceName());
            return device;
        }
        this.log("getUsbDevice \u6ca1\u6709\u5bf9\u5e94\u7684\u8bbe\u5907");
        return null;
    }

    private void registerReceiver(Context context) {
        if (this.mPermissionIntent == null) {
            this.mPermissionIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent("com.rscja.USB_PERMISSION"), (int)0);
        }
        if (this.usbReceiver == null) {
            this.usbReceiver = new UsbReceiver();
            IntentFilter filter = new IntentFilter("com.rscja.USB_PERMISSION");
            filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
            filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
            context.registerReceiver((BroadcastReceiver)this.usbReceiver, filter);
        }
    }

    private void unRegisterReceiver() {
        this.mPermissionIntent = null;
        if (this.usbReceiver != null) {
            this.context.unregisterReceiver((BroadcastReceiver)this.usbReceiver);
            this.usbReceiver = null;
        }
    }

    private void getKeyData(byte[] data) {
        if (data == null) {
            return;
        }
        int flag = 0;
        int keyCode = 0;
        int checkCode = 0;
        int k = 0;
        while (k < data.length) {
            int temp = data[k] & 0xFF;
            switch (flag) {
                case 0: {
                    int n = flag = temp == 200 ? 1 : 0;
                    if (flag != 0) break;
                    flag = temp == 165 ? 11 : 0;
                    break;
                }
                case 11: {
                    flag = temp == 90 ? 2 : 0;
                    break;
                }
                case 1: {
                    flag = temp == 140 ? 2 : 0;
                    break;
                }
                case 2: {
                    flag = temp == 0 ? 3 : 0;
                    break;
                }
                case 3: {
                    flag = temp == 9 ? 4 : 0;
                    break;
                }
                case 4: {
                    flag = temp == 230 ? 5 : 0;
                    break;
                }
                case 5: {
                    flag = temp == 1 || temp == 2 ? 6 : 0;
                    keyCode = data[k];
                    break;
                }
                case 6: {
                    checkCode ^= 0;
                    checkCode ^= 9;
                    checkCode ^= 0xE6;
                    flag = temp == (checkCode ^= keyCode) ? 7 : 0;
                    break;
                }
                case 7: {
                    flag = temp == 13 ? 8 : 0;
                    break;
                }
                case 8: {
                    int n = flag = temp == 10 ? 9 : 0;
                }
            }
            if (flag == 9) break;
            ++k;
        }
        if (flag == 9) {
            Message msg = this.hand.obtainMessage(0, keyCode, -1);
            this.hand.sendMessage(msg);
        }
    }

    private void startReceiverThread() {
        this.log("startReceiverThread receiverDataThread=" + this.receiverDataThread);
        if (this.receiverDataThread == null) {
            this.cleanCache();
            this.isRuning = true;
            this.receiverDataThread = new ReceiverData();
            this.receiverDataThread.start();
        }
    }

    private void stopReceiverThread() {
        this.isRuning = false;
        if (this.receiverDataThread != null) {
            this.receiverDataThread.interrupt();
            this.receiverDataThread = null;
        }
    }

    private void setQueueData(byte[] data) {
        int k = 0;
        while (k < data.length) {
            try {
                this.queueReceive.add(data[k]);
            }
            catch (IllegalStateException ex) {
                this.logE("\u6570\u636e\u6ee1\u4e86\u53d1\u751f\u5f02\u5e38,\u6e05\u7a7a\u5217\u8868\u6570\u636e. setQueueData ex=" + ex.toString());
                this.queueReceive.clear();
            }
            ++k;
        }
    }

    /*
     * Unable to fully structure code
     */
    private byte[] getQueueData(int timeOut) {
        startTime = System.currentTimeMillis();
        this.tempData.clear();
        ** GOTO lbl25
        {
            bData = this.queueReceive.poll();
            this.tempData.add(bData);
            if (this.lastByte == 13 && bData == 10) {
                b = new byte[this.tempData.size()];
                k = 0;
                while (k < this.tempData.size()) {
                    b[k] = this.tempData.get(k);
                    ++k;
                }
                return b;
            }
            this.lastByte = bData;
            if (System.currentTimeMillis() - startTime > (long)timeOut) ** GOTO lbl19
            do {
                if (!this.queueReceive.isEmpty()) continue block2;
lbl19:
                // 2 sources

                if (System.currentTimeMillis() - startTime > (long)timeOut) break block2;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
lbl25:
                // 3 sources

            } while (this.isRuning);
        }
        return null;
    }

    void cleanCache() {
        this.log("cleanCache()");
        this.tempData.clear();
        this.queueReceive.clear();
        this.lastByte = 0;
    }

    private void log(String msg) {
    }

    private void log(byte[] hexData) {
    }

    private void logE(String msg) {
        if (msg != null) {
            Log.e((String)this.TAG, (String)msg);
        }
    }

    class ReceiverData
    extends Thread {
        ReceiverData() {
        }

        @Override
        public void run() {
            byte[] receiveytes = new byte[USBUtil.this.getInputMax()];
            int timeOut = 200;
            while (USBUtil.this.isRuning) {
                try {
                    if (USBUtil.this.usbEndpointIn != null) {
                        Arrays.fill(receiveytes, (byte)0);
                        int len = USBUtil.this.usbConnection.bulkTransfer(USBUtil.this.usbEndpointIn, receiveytes, receiveytes.length, 200);
                        if (len > 0) {
                            byte[] data = Arrays.copyOfRange(receiveytes, 0, len);
                            USBUtil.this.log(data);
                            USBUtil.this.getKeyData(data);
                            USBUtil.this.setQueueData(data);
                        }
                    } else {
                        USBUtil.this.log("ReceiverData == null");
                        return;
                    }
                    Thread.sleep(2L);
                }
                catch (Exception ex) {
                    USBUtil.this.logE("ReceiverData == ex=" + ex.toString());
                }
            }
        }
    }

    class UsbReceiver
    extends BroadcastReceiver {
        UsbReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            USBUtil.this.log("UsbReceiver action:" + action);
            if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                USBUtil.this.log("usb\u62d4\u51fa");
                UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                if (device != null) {
                    USBUtil.this.closeport();
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                USBUtil.this.log("usb\u63d2\u5165");
            } else if ("com.rscja.USB_PERMISSION".equals(action)) {
                boolean permission = intent.getBooleanExtra("permission", false);
                USBUtil.this.log("usb \u83b7\u53d6\u6743\u9650\u8fd4\u56de permission= " + permission);
            }
        }
    }
}

