/*
 * Decompiled with CFR 0.152.
 */
package com.scanner.utility;

import android.content.Context;
import android.content.Intent;
import com.scanner.IScanner;

class ScannerOldActionUtility
implements IScanner {
    private String TAG = "ScannerInerface";
    private boolean isDebug = false;
    private static final String ACTION_OPEN = "android.intent.action.OPEN_BARCODE_RFID";
    private static final String ACTION_CLOSE = "android.intent.action.CLOSE_BARCODE_RFID";
    private static final String ACTION_ENABLE_FUNCTION = "android.intent.action.ENABLE_FUNCTION_BARCODE_RFID";
    private static final String ACTION_DISABLE_FUNCTION = "android.intent.action.DISABLE_FUNCTION_BARCODE_RFID";
    private static final String ACTION_START = "android.intent.action.START_BARCODE_RFID";
    private static final String ACTION_STOP = "android.intent.action.STOP_BARCODE_RFID";
    private static final String ACTION_SUCCESS_SOUND = "android.intent.action.SUCCESS_SOUND_BARCODE_RFID";
    private static final String ACTION_FAIL_SOUND = "android.intent.action.FAIL_SOUND_BARCODE_RFID";
    private static final String ACTION_VIBRATE = "android.intent.action.VIBRATE_BARCODE_RFID";
    private static final String ACTION_OUTPUT = "android.intent.action.OUTPUT_BARCODE_RFID";
    private static final String ACTION_FORMAT_BARCODE = "android.intent.action.FORMAT_BARCODE";
    private static final String ACTION_FORMAT_RFID = "android.intent.action.FORMAT_RFID";
    private static final String ACTION_ENABLE_ENTER = "android.intent.action.ENABLE_ENTER_BARCODE_RFID";
    private static final String ACTION_ENABLE_TAB = "android.intent.action.ENABLE_TAB_BARCODE_RFID";
    private static final String ACTION_PREFIX_CHARACTER = "android.intent.action.PREFIX_CHARACTER_BARCODE_RFID";
    private static final String ACTION_SUFFIX_CHARACTER = "android.intent.action.SUFFIX_CHARACTER_BARCODE_RFID";
    private static final String ACTION_TRIM_LEFT_CHARACTER = "android.intent.action.TRIM_LEFT_CHARACTER_BARCODE_RFID";
    private static final String ACTION_TRIM_RIGHT_CHARACTER = "android.intent.action.TRIM_RIGHT_CHARACTER_BARCODE_RFID";
    private static final String ACTION_TIMEOUT = "android.intent.action.TIMEOUT_BARCODE_RFID";
    private static final String ACTION_FILTER_CHARACTER = "android.intent.action.FILTER_CHARACTER_BARCODE_RFID";
    private static final String ACTION_CONTINUOUS_SCAN = "android.intent.action.CONTINUOUS_SCAN_BARCODE_RFID";
    private static final String ACTION_CONTINUOUS_SCAN_INTERVAL_TIME = "android.intent.action.CONTINUOUS_SCAN_INTERVAL_TIME_BARCODE_RFID";
    private static final String ACTION_CONTINUOUS_SCAN_TIMEOUT = "android.intent.action.CONTINUOUS_SCAN_TIMEOUT_BARCODE_RFID";
    private static final String ACTION_CONTINUOUS_SCAN_RFID = "android.intent.action.CONTINUOUS_SCAN_RFID";
    private static final String ACTION_CONTINUOUS_SCAN_INTERVAL_TIME_RFID = "android.intent.action.CONTINUOUS_SCAN_INTERVAL_TIME_RFID";
    private static final String ACTION_UHF_POWER = "android.intent.action.UHF_POWER";
    private static final String ACTION_CONTINUOUS_SCAN_TIMEOUT_RFID = "android.intent.action.CONTINUOUS_SCAN_TIMEOUT_RFID";
    private static final String ACTION_RESET_CONFIG = "android.intent.action.RESET_CONFIG_BARCODE_RFID";
    private static final String ACTION_SCAN_KEY_CONFIG = "android.intent.action.SCAN_KEY_CONFIG_BARCODE_RFID";
    private static final String ACTION_SCAN_FAILURE_BROADCAST = "android.intent.action.SCAN_FAILURE_BROADCAST";
    private static final String ACTION_SCAN_RESULT_BROADCAST = "android.intent.action.SCAN_RESULT_BROADCAST";
    private static final String ACTION_SCAN_RESULT_BROADCAST_RFID = "android.intent.action.SCAN_RESULT_BROADCAST_RFID";
    private static final String ACTION_SCAN_RELEASESCAN = "android.intent.action.SCAN_RELEASESCAN";
    private static final String ACTION_SCAN_GROUPSEPARATOR = "android.intent.action.SCAN_GROUPSEPARATOR";
    private static final String ACTION_SCAN_AUXILIARYLIGHT = "android.intent.action.SCAN_AUXILIARYLIGHT";
    private static final String ACTION_SCAN_ZEBRA_PARAM_SET = "android.intent.action.SCAN_ZEBRA_PARAM_SET";
    private static final String ACTION_SCAN_KEYBOARD_HELPER_PARAM_REQUEST = "android.intent.action.SCAN_KEYBOARD_HELPER_PARAM_REQUEST";
    private static final String ACTION_SCAN_KEYBOARD_HELPER_PARAM_RESPONSE = "android.intent.action.SCAN_KEYBOARD_HELPER_PARAM_RESPONSE";
    private static final String ACTION_SCAN_BEGIN_SCANING = "android.intent.action.SCAN_BEGIN_SCANING";
    private static final String ACTION_SCAN_BEGIN_SCANING_NEW = "com.rscja.SCAN_BEGIN_SCANING";
    private static final String ACTION_SCAN_END_SCANING = "android.intent.action.SCAN_END_SCANING";
    private static final String ACTION_SCAN_END_SCANING_NEW = "com.rscja.SCAN_END_SCANING";
    private static final String ACTION_BARCODE_NOT_REPEAT = "android.intent.action.BARCODE_NOT_REPEAT";
    private static ScannerOldActionUtility scannerInerface = null;

    private ScannerOldActionUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ScannerOldActionUtility getScannerInerface() {
        if (scannerInerface != null) return scannerInerface;
        Class<ScannerOldActionUtility> clazz = ScannerOldActionUtility.class;
        synchronized (ScannerOldActionUtility.class) {
            if (scannerInerface != null) return scannerInerface;
            scannerInerface = new ScannerOldActionUtility();
            // ** MonitorExit[var0] (shouldn't be in output)
            return scannerInerface;
        }
    }

    @Override
    public void Open(Context context) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u6253\u5f00\u952e\u76d8\u52a9\u624b\u603b\u5f00\u5173");
        }
        Intent intent = new Intent(ACTION_OPEN);
        context.sendBroadcast(intent);
    }

    @Override
    public void Close(Context context) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u5173\u95ed\u952e\u76d8\u52a9\u624b\u603b\u5f00\u5173");
        }
        Intent intent = new Intent(ACTION_CLOSE);
        context.sendBroadcast(intent);
    }

    @Override
    public void enableFunction(Context context, int function) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u6253\u5f00\u529f\u80fd\u6a21\u5757 function=" + function);
        }
        Intent intent = new Intent(ACTION_ENABLE_FUNCTION);
        intent.putExtra("function", function);
        context.sendBroadcast(intent);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void disableFunction(Context context, int function) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u5173\u95ed\u529f\u80fd\u6a21\u5757 function=" + function);
        }
        Intent intent = new Intent(ACTION_DISABLE_FUNCTION);
        intent.putExtra("function", function);
        context.sendBroadcast(intent);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startScan(Context context, int function) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u5f00\u59cb\u626b\u63cf\u6216\u8005\u8bfb\u5361 function=" + function);
        }
        Intent intent = new Intent(ACTION_START);
        intent.putExtra("function", function);
        context.sendBroadcast(intent);
    }

    @Override
    public void stopScan(Context context, int function) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u505c\u6b62\u626b\u63cf function=" + function);
        }
        Intent intent = new Intent(ACTION_STOP);
        intent.putExtra("function", function);
        context.sendBroadcast(intent);
    }

    @Override
    public void enablePlaySuccessSound(Context context, boolean successSound) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u64ad\u653e\u63d0\u793a\u97f3 successSound=" + successSound);
        }
        Intent intent = new Intent(ACTION_SUCCESS_SOUND);
        intent.putExtra("successSound", successSound);
        context.sendBroadcast(intent);
    }

    @Override
    public void enablePlayFailureSound(Context context, boolean failureSound) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u64ad\u653e\u63d0\u793a\u97f3  failureSound=" + failureSound);
        }
        Intent intent = new Intent(ACTION_FAIL_SOUND);
        intent.putExtra("failureSound", failureSound);
        context.sendBroadcast(intent);
    }

    @Override
    public void enableVibrate(Context context, boolean vibrate) {
        if (context == null) {
            return;
        }
        if (this.isDebug && this.isDebug) {
            this.logI(this.TAG, "\u626b\u63cf\u6210\u529f\u662f\u5426\u9707\u52a8\u63d0\u793a vibrate=" + vibrate);
        }
        Intent intent = new Intent(ACTION_VIBRATE);
        intent.putExtra("vibrate", vibrate);
        context.sendBroadcast(intent);
    }

    @Override
    public void setOutputMode(Context context, int outputMode) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u8f93\u51fa\u6a21\u5f0f mode=" + outputMode);
        }
        Intent intent = new Intent(ACTION_OUTPUT);
        intent.putExtra("mode", outputMode);
        context.sendBroadcast(intent);
    }

    @Override
    public void setBarcodeEncodingFormat(Context context, int format) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u8bbe\u7f6e\u6761\u7801\u7f16\u7801\u683c\u5f0f format=" + format);
        }
        Intent intent = new Intent(ACTION_FORMAT_BARCODE);
        intent.putExtra("format", format);
        context.sendBroadcast(intent);
    }

    @Override
    public void setRFIDEncodingFormat(Context context, int format) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u8bbe\u7f6eRFID\u7f16\u7801\u683c\u5f0f format=" + format);
        }
        Intent intent = new Intent(ACTION_FORMAT_RFID);
        intent.putExtra("format", format);
        context.sendBroadcast(intent);
    }

    @Override
    public void enableEnter(Context context, boolean enter) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u662f\u5426\u542f\u7528\u56de\u8f66 enter=" + enter);
        }
        Intent intent = new Intent(ACTION_ENABLE_ENTER);
        intent.putExtra("enter", enter);
        context.sendBroadcast(intent);
    }

    @Override
    public void enableTAB(Context context, boolean tab) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u662f\u5426\u542f\u7528TAB tab=" + tab);
        }
        Intent intent = new Intent(ACTION_ENABLE_TAB);
        intent.putExtra("tab", tab);
        context.sendBroadcast(intent);
    }

    @Override
    public void setSuffix(Context context, String suffix) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u8bbe\u7f6e\u540e\u7f00\u5b57\u7b26 suffix=" + suffix);
        }
        Intent intent = new Intent(ACTION_SUFFIX_CHARACTER);
        intent.putExtra("suffix", suffix);
        context.sendBroadcast(intent);
    }

    @Override
    public void setPrefix(Context context, String prefix) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u8bbe\u7f6e\u524d\u7f00\u5b57\u7b26 prefix=" + prefix);
        }
        Intent intent = new Intent(ACTION_PREFIX_CHARACTER);
        intent.putExtra("prefix", prefix);
        context.sendBroadcast(intent);
    }

    @Override
    public void interceptTrimLeft(Context context, int num) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u622a\u53d6\u5de6\u8fb9\u5b57\u7b26\u4e32 num=" + num);
        }
        Intent intent = new Intent(ACTION_TRIM_LEFT_CHARACTER);
        intent.putExtra("num", num);
        context.sendBroadcast(intent);
    }

    @Override
    public void interceptTrimRight(Context context, int num) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u622a\u53d6\u53f3\u8fb9\u5b57\u7b26\u4e32 num=" + num);
        }
        Intent intent = new Intent(ACTION_TRIM_RIGHT_CHARACTER);
        intent.putExtra("num", num);
        context.sendBroadcast(intent);
    }

    @Override
    public void setScanOutTime(Context context, int time) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u8bbe\u7f6e\u8d85\u65f6\u65f6\u95f4 time=" + time);
        }
        Intent intent = new Intent(ACTION_TIMEOUT);
        intent.putExtra("time", time);
        context.sendBroadcast(intent);
    }

    @Override
    public void filterCharacter(Context context, String chars) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u8fc7\u6ee4\u5b57\u7b26 chars=" + chars);
        }
        Intent intent = new Intent(ACTION_FILTER_CHARACTER);
        intent.putExtra("chars", chars);
        context.sendBroadcast(intent);
    }

    @Override
    public void setContinuousScanRFID(Context context, boolean isContinuous) {
        if (context == null) {
            return;
        }
        if (this.isDebug && this.isDebug) {
            this.logI(this.TAG, "\u8bbe\u7f6e\u8fde\u7eed\u626b\u63cf isContinuous=" + isContinuous);
        }
        Intent intent = new Intent(ACTION_CONTINUOUS_SCAN_RFID);
        intent.putExtra("isContinuous", isContinuous);
        context.sendBroadcast(intent);
    }

    @Override
    public void setContinuousScanIntervalTimeRFID(Context context, int intervalTime) {
        if (context == null) {
            return;
        }
        if (this.isDebug && this.isDebug) {
            this.logI(this.TAG, "\u8bbe\u7f6e\u8fde\u7eed\u626b\u63cf\u95f4\u9694\u65f6\u95f4 intervalTime=" + intervalTime);
        }
        Intent intent = new Intent(ACTION_CONTINUOUS_SCAN_INTERVAL_TIME_RFID);
        intent.putExtra("intervalTime", intervalTime);
        context.sendBroadcast(intent);
    }

    @Override
    public void setContinuousScanTimeOutRFID(Context context, int timeOut) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u8bbe\u7f6e\u8fde\u7eed\u626b\u63cf\u8d85\u65f6\u65f6\u95f4 intervalTime=" + timeOut);
        }
        Intent intent = new Intent(ACTION_CONTINUOUS_SCAN_TIMEOUT_RFID);
        intent.putExtra("timeOut", timeOut);
        context.sendBroadcast(intent);
    }

    @Override
    public void setUHFPower(Context context, int power) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "uhf \u529f\u7387=" + power);
        }
        Intent intent = new Intent(ACTION_UHF_POWER);
        intent.putExtra("power", power);
        context.sendBroadcast(intent);
    }

    @Override
    public void setContinuousScan(Context context, boolean isContinuous) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u8bbe\u7f6e\u8fde\u7eed\u626b\u63cf isContinuous=" + isContinuous);
        }
        Intent intent = new Intent(ACTION_CONTINUOUS_SCAN);
        intent.putExtra("isContinuous", isContinuous);
        context.sendBroadcast(intent);
    }

    @Override
    public void setContinuousScanIntervalTime(Context context, int intervalTime) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u8bbe\u7f6e\u8fde\u7eed\u626b\u63cf\u95f4\u9694\u65f6\u95f4 intervalTime=" + intervalTime);
        }
        Intent intent = new Intent(ACTION_CONTINUOUS_SCAN_INTERVAL_TIME);
        intent.putExtra("intervalTime", intervalTime);
        context.sendBroadcast(intent);
    }

    @Override
    public void setContinuousScanTimeOut(Context context, int timeOut) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u8bbe\u7f6e\u8fde\u7eed\u626b\u63cf\u8d85\u65f6\u65f6\u95f4 intervalTime=" + timeOut);
        }
        Intent intent = new Intent(ACTION_CONTINUOUS_SCAN_TIMEOUT);
        intent.putExtra("timeOut", timeOut);
        context.sendBroadcast(intent);
    }

    @Override
    public void resetScan(Context context) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u6062\u590d\u51fa\u5382\u8bbe\u7f6e");
        }
        Intent intent = new Intent(ACTION_RESET_CONFIG);
        context.sendBroadcast(intent);
    }

    @Override
    public void setScanKey(Context context, int type, int[] scanKey) {
        if (context == null) {
            return;
        }
        if (scanKey != null && scanKey.length > 1) {
            int keycode1 = scanKey[0];
            int keycode2 = scanKey[1];
            scanKey = new int[]{keycode1, keycode1, keycode2, keycode2};
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u8bbe\u7f6e\u626b\u63cf\u6309\u952e");
        }
        Intent intent = new Intent(ACTION_SCAN_KEY_CONFIG);
        intent.putExtra("type", type);
        intent.putExtra("scanKey", scanKey);
        context.sendBroadcast(intent);
    }

    @Override
    public void setScanFailureBroadcast(Context context, boolean enable) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u626b\u63cf\u5931\u8d25\u662f\u5426\u53d1\u9001\u5e7f\u64ad  enable" + enable);
        }
        Intent intent = new Intent(ACTION_SCAN_FAILURE_BROADCAST);
        intent.putExtra("enable", enable);
        context.sendBroadcast(intent);
    }

    @Override
    public void setScanResultBroadcast(Context context, String broadcastAction, String data) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u626b\u63cf\u7ed3\u679c\u63a5\u6536\u5e7f\u64ad  broadcastAction" + broadcastAction + "  data=" + data);
        }
        Intent intent = new Intent(ACTION_SCAN_RESULT_BROADCAST);
        intent.putExtra("resultAction", broadcastAction);
        intent.putExtra("data", data);
        context.sendBroadcast(intent);
    }

    @Override
    public void setScanResultBroadcastRFID(Context context, String broadcastAction, String data) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u626b\u63cf\u7ed3\u679c\u63a5\u6536\u5e7f\u64adRFID  broadcastAction" + broadcastAction + "  data=" + data);
        }
        Intent intent = new Intent(ACTION_SCAN_RESULT_BROADCAST_RFID);
        intent.putExtra("resultAction", broadcastAction);
        intent.putExtra("data", data);
        context.sendBroadcast(intent);
    }

    @Override
    public void setGroupSeparator(Context context, boolean disable) {
        if (context == null) {
            return;
        }
        if (this.isDebug && this.isDebug) {
            this.logI(this.TAG, "\u662f\u5426\u53bb\u6389\u626b\u63cf\u5206\u7ec4\u7b26  enable" + disable);
        }
        Intent intent = new Intent(ACTION_SCAN_GROUPSEPARATOR);
        intent.putExtra("disable", disable);
        context.sendBroadcast(intent);
    }

    @Override
    public void setReleaseScan(Context context, boolean enable) {
        if (context == null) {
            return;
        }
        if (this.isDebug && this.isDebug) {
            this.logI(this.TAG, "\u677e\u5f00\u626b\u63cf\u6309\u952e\u662f\u5426\u505c\u6b62\u626b\u63cf  enable" + enable);
        }
        Intent intent = new Intent(ACTION_SCAN_RELEASESCAN);
        intent.putExtra("enable", enable);
        context.sendBroadcast(intent);
    }

    @Override
    public void enableAuxiliaryLight(Context context, boolean enable) {
        if (context == null) {
            return;
        }
        if (this.isDebug) {
            this.logI(this.TAG, "\u5f00\u542f\u626b\u63cf\u8f85\u52a9\u706f  enable" + enable);
        }
        Intent intent = new Intent(ACTION_SCAN_AUXILIARYLIGHT);
        intent.putExtra("enable", enable);
        context.sendBroadcast(intent);
    }

    @Override
    public void enableBarcodeNotRepeat(Context context, boolean enable) {
        if (context == null) {
            return;
        }
        if (this.isDebug && this.isDebug) {
            this.logI(this.TAG, "\u662f\u5426\u53ef\u4ee5\u8f93\u51fa\u91cd\u590d\u6807\u7b7e  enable" + enable);
        }
        Intent intent = new Intent(ACTION_BARCODE_NOT_REPEAT);
        intent.putExtra("enable", enable);
        context.sendBroadcast(intent);
    }

    private void logI(String tag, String msg) {
    }

    @Override
    public void setParam_zebra(Context context, int paramId, int paramValue) {
        if (context == null) {
            return;
        }
        this.logI(this.TAG, "setParam_zebra paramId=" + paramId + " ,paramValue=" + paramValue);
        Intent intent = new Intent(ACTION_SCAN_ZEBRA_PARAM_SET);
        intent.putExtra("paramId", paramId);
        intent.putExtra("paramValue", paramValue);
        context.sendBroadcast(intent);
    }

    @Override
    public void setUHFMode(Context context, int mode) {
    }

    @Override
    public void setBarcodeContinuousMode(Context context, int mode) {
    }

    @Override
    public void enableBlockScankey(Context context, boolean enable) {
    }
}

