/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.adc.decoder;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.custom.BarcodeScanCallback;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class BarCodeReader {
    private static final String TAG = "BarCodeReader";
    private static final int BCRDR_MSG_ERROR = 1;
    private static final int BCRDR_MSG_SHUTTER = 2;
    private static final int BCRDR_MSG_FOCUS = 4;
    private static final int BCRDR_MSG_ZOOM = 8;
    private static final int BCRDR_MSG_PREVIEW_FRAME = 16;
    private static final int BCRDR_MSG_VIDEO_FRAME = 32;
    private static final int BCRDR_MSG_POSTVIEW_FRAME = 64;
    private static final int BCRDR_MSG_RAW_IMAGE = 128;
    private static final int BCRDR_MSG_COMPRESSED_IMAGE = 256;
    private static final int BCRDR_MSG_LAST_DEC_IMAGE = 512;
    private static final int BCRDR_MSG_DEC_COUNT = 1024;
    private static final int BCRDR_MSG_DECODE_COMPLETE = 65536;
    private static final int BCRDR_MSG_DECODE_TIMEOUT = 131072;
    private static final int BCRDR_MSG_DECODE_CANCELED = 262144;
    private static final int BCRDR_MSG_DECODE_ERROR = 524288;
    private static final int BCRDR_MSG_DECODE_EVENT = 0x100000;
    private static final int BCRDR_MSG_FRAME_ERROR = 0x200000;
    private static final int BCRDR_MSG_ALL_MSGS = 0x3F03FF;
    private static final int DECODE_MODE_PREVIEW = 1;
    private static final int DECODE_MODE_VIEWFINDER = 2;
    private static final int DECODE_MODE_VIDEO = 3;
    private long mNativeContext;
    private EventHandler mEventHandler = null;
    private AutoFocusCallback mAutoFocusCallback = null;
    private DecodeCallback mDecodeCallback = null;
    private static BarcodeScanCallback barcodeScanCallback = null;
    private ErrorCallback mErrorCallback;
    private VideoCallback mVideoCallback;
    private PictureCallback mSnapshotCallback;
    private PreviewCallback mPreviewCallback;
    private OnZoomChangeListener mZoomListener;
    private boolean mOneShot;
    private boolean mWithBuffer;
    static final int BCR_SUCCESS = 0;
    static final int BCR_ERROR = -1;
    public static final int DECODE_STATUS_TIMEOUT = 0;
    public static final int DECODE_STATUS_CANCELED = -1;
    public static final int DECODE_STATUS_ERROR = -2;
    public static final int DECODE_STATUS_MULTI_DEC_COUNT = -3;
    static final int BCRDR_EVENT_SCAN_MODE_CHANGED = 5;
    static final int BCRDR_EVENT_MOTION_DETECTED = 6;
    static final int BCRDR_EVENT_SCANNER_RESET = 7;
    static final int BCRDR_ERROR_UNKNOWN = 1;
    static final int BCRDR_ERROR_SERVER_DIED = 100;

    private final native void native_autoFocus();

    private final native void native_cancelAutoFocus();

    private final native String native_getParameters();

    private final native void native_release();

    private final native int setNumParameter(int var1, int var2);

    private final native int setStrParameter(int var1, String var2);

    private final native void native_setParameters(String var1);

    private final native void native_setup(Object var1, int var2);

    private final native void native_setup(Object var1, int var2, Object var3);

    private final native void native_startPreview(int var1);

    private final native void native_takePicture();

    private final native void setHasPreviewCallback(boolean var1, boolean var2);

    private final native void setPreviewDisplay(Surface var1);

    static native int getNumberOfReaders();

    static native void getReaderInfo(int var0, ReaderInfo var1);

    public final native void lock();

    public final native void unlock();

    public final native void reconnect() throws IOException;

    public final native int getNumProperty(int var1);

    public final native String getStrProperty(int var1);

    public final native int getNumParameter(int var1);

    public final native String getStrParameter(int var1);

    public final int setParameter(int paramNum, int paramVal) {
        return this.setNumParameter(paramNum, paramVal);
    }

    public final int setParameter(int paramNum, String paramVal) {
        return this.setStrParameter(paramNum, paramVal);
    }

    public Parameters getParametersFromString(String s) {
        Parameters p = new Parameters();
        p.unflatten(s);
        return p;
    }

    public final native void setDefaultParameters();

    public final native void addCallbackBuffer(byte[] var1);

    public final native int FWUpdate(String var1, boolean var2, boolean var3);

    public final void startVideoCapture(VideoCallback cb) {
        this.mVideoCallback = cb;
        this.native_startPreview(3);
    }

    public final void startViewFinder(VideoCallback cb) {
        this.mVideoCallback = cb;
        this.native_startPreview(2);
    }

    public final void startPreview() {
        this.native_startPreview(1);
    }

    public final native void stopPreview();

    public final native int startDecode();

    public final native int startHandsFreeDecode(int var1);

    public final native void stopDecode();

    public final native boolean previewEnabled();

    public final native void startSmoothZoom(int var1);

    public final native void stopSmoothZoom();

    public final native void setDisplayOrientation(int var1);

    public final native int getDecodeCount();

    public final native void enableAllCodeTypes();

    public final native void disableAllCodeTypes();

    public final native byte[] getLastDecImage();

    static BarCodeReader open(int readerId) {
        return new BarCodeReader(readerId);
    }

    static BarCodeReader open() {
        int iNumReaders;
        try {
            iNumReaders = BarCodeReader.getNumberOfReaders();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        ReaderInfo readerInfo = new ReaderInfo();
        int iIdx = 0;
        while (iIdx < iNumReaders) {
            BarCodeReader.getReaderInfo(iIdx, readerInfo);
            if (readerInfo.facing == 1) {
                return new BarCodeReader(iIdx);
            }
            ++iIdx;
        }
        return null;
    }

    static BarCodeReader open(int readerId, Context context) {
        return new BarCodeReader(readerId, context);
    }

    static BarCodeReader open(Context context) {
        int iNumReaders;
        try {
            iNumReaders = BarCodeReader.getNumberOfReaders();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        ReaderInfo readerInfo = new ReaderInfo();
        int iIdx = 0;
        while (iIdx < iNumReaders) {
            BarCodeReader.getReaderInfo(iIdx, readerInfo);
            if (readerInfo.facing == 1) {
                return new BarCodeReader(iIdx, context);
            }
            ++iIdx;
        }
        return null;
    }

    public void setNoDisplayMode() {
        Parameters p = this.getParameters();
        p.setPreviewSize(752, 480);
        p.setPictureSize(752, 480);
        p.setNoDisplayMode(1);
        this.setParameters(p);
    }

    public void setDisplayMode() {
        Parameters p = this.getParameters();
        p.setPreviewSize(752, 480);
        p.setPictureSize(752, 480);
        p.setNoDisplayMode(0);
        this.setParameters(p);
    }

    BarCodeReader(int readerId) {
        barcodeScanCallback = null;
        this.mErrorCallback = null;
        this.mPreviewCallback = null;
        this.mSnapshotCallback = null;
        this.mVideoCallback = null;
        this.mZoomListener = null;
        Looper aLooper = Looper.myLooper();
        if (aLooper == null) {
            aLooper = Looper.getMainLooper();
        }
        if (aLooper != null) {
            this.mEventHandler = new EventHandler(this, aLooper);
        }
        this.native_setup(new WeakReference<BarCodeReader>(this), readerId);
    }

    BarCodeReader(int readerId, Context context) {
        barcodeScanCallback = null;
        this.mErrorCallback = null;
        this.mPreviewCallback = null;
        this.mSnapshotCallback = null;
        this.mVideoCallback = null;
        this.mZoomListener = null;
        Looper aLooper = Looper.myLooper();
        if (aLooper == null) {
            aLooper = Looper.getMainLooper();
        }
        if (aLooper != null) {
            this.mEventHandler = new EventHandler(this, aLooper);
        }
        this.native_setup(new WeakReference<BarCodeReader>(this), readerId, context);
    }

    protected void finalize() {
        this.native_release();
    }

    public final void release() {
        this.native_release();
    }

    public final void setPreviewDisplay(SurfaceHolder holder) throws IOException {
        if (holder != null) {
            this.setPreviewDisplay(holder.getSurface());
        } else {
            this.setPreviewDisplay((Surface)null);
        }
    }

    public final void autoFocus(AutoFocusCallback cb) {
        this.mAutoFocusCallback = cb;
        this.native_autoFocus();
    }

    public final void cancelAutoFocus() {
        this.mAutoFocusCallback = null;
        this.native_cancelAutoFocus();
    }

    public final native void setAutoFocusDelay(int var1, int var2);

    public final void setDecodeCallback(DecodeCallback cb) {
        this.mDecodeCallback = cb;
    }

    public final void setDecodeCallback2(BarcodeScanCallback cb) {
        barcodeScanCallback = cb;
    }

    public final void takePicture(PictureCallback cb) {
        this.mSnapshotCallback = cb;
        try {
            this.native_takePicture();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void setOneShotPreviewCallback(PreviewCallback cb) {
        this.mPreviewCallback = cb;
        this.mOneShot = true;
        this.mWithBuffer = false;
        this.setHasPreviewCallback(cb != null, false);
    }

    public final void setPreviewCallbackWithBuffer(PreviewCallback cb) {
        this.mPreviewCallback = cb;
        this.mOneShot = false;
        this.mWithBuffer = true;
        this.setHasPreviewCallback(cb != null, true);
    }

    private static void postEventFromNative(Object reader_ref, int what, int arg1, int arg2, Object obj) {
        BarCodeReader c = (BarCodeReader)((WeakReference)reader_ref).get();
        if (c != null && c.mEventHandler != null) {
            Message m = c.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            c.mEventHandler.sendMessage(m);
        }
        if (barcodeScanCallback != null) {
            switch (what) {
                case 65536: {
                    barcodeScanCallback.onScanComplete(arg1, arg2, (byte[])obj);
                    return;
                }
                case 131072: {
                    barcodeScanCallback.onScanComplete(0, 0, null);
                    return;
                }
                case 262144: {
                    barcodeScanCallback.onScanComplete(0, -1, null);
                    return;
                }
                case 524288: 
                case 0x200000: {
                    barcodeScanCallback.onScanComplete(0, -2, null);
                    return;
                }
                case 1024: {
                    barcodeScanCallback.onScanComplete(arg1, -3, null);
                    return;
                }
            }
            return;
        }
    }

    public final void setZoomChangeListener(OnZoomChangeListener listener) {
        this.mZoomListener = listener;
    }

    public final void setErrorCallback(ErrorCallback cb) {
        this.mErrorCallback = cb;
    }

    public void setParameters(Parameters params) {
        this.native_setParameters(params.flatten());
    }

    public Parameters getParameters() {
        Parameters p = new Parameters();
        String s = this.native_getParameters();
        p.unflatten(s);
        return p;
    }

    static interface AutoFocusCallback {
        public void onAutoFocus(boolean var1, BarCodeReader var2);
    }

    static interface DecodeCallback {
        public void onDecodeComplete(int var1, int var2, byte[] var3, BarCodeReader var4);

        public void onEvent(int var1, int var2, byte[] var3, BarCodeReader var4);
    }

    static interface ErrorCallback {
        public void onError(int var1, BarCodeReader var2);
    }

    private class EventHandler
    extends Handler {
        private BarCodeReader mReader;

        public EventHandler(BarCodeReader rdr, Looper looper) {
            super(looper);
            this.mReader = rdr;
        }

        public void handleMessage(Message msg) {
            Log.v((String)BarCodeReader.TAG, (String)String.format("Event message: %X, arg1=%d, arg2=%d", msg.what, msg.arg1, msg.arg2));
            switch (msg.what) {
                case 65536: {
                    if (BarCodeReader.this.mDecodeCallback != null) {
                        BarCodeReader.this.mDecodeCallback.onDecodeComplete(msg.arg1, msg.arg2, (byte[])msg.obj, this.mReader);
                    }
                    return;
                }
                case 131072: {
                    if (BarCodeReader.this.mDecodeCallback != null) {
                        BarCodeReader.this.mDecodeCallback.onDecodeComplete(0, 0, (byte[])msg.obj, this.mReader);
                    }
                    return;
                }
                case 262144: {
                    if (BarCodeReader.this.mDecodeCallback != null) {
                        BarCodeReader.this.mDecodeCallback.onDecodeComplete(0, -1, (byte[])msg.obj, this.mReader);
                    }
                    return;
                }
                case 524288: 
                case 0x200000: {
                    if (BarCodeReader.this.mDecodeCallback != null) {
                        BarCodeReader.this.mDecodeCallback.onDecodeComplete(0, -2, (byte[])msg.obj, this.mReader);
                    }
                    return;
                }
                case 0x100000: {
                    if (BarCodeReader.this.mDecodeCallback != null) {
                        BarCodeReader.this.mDecodeCallback.onEvent(msg.arg1, msg.arg2, (byte[])msg.obj, this.mReader);
                    }
                    return;
                }
                case 2: {
                    return;
                }
                case 256: {
                    if (BarCodeReader.this.mSnapshotCallback != null) {
                        int iCX = msg.arg1 >> 0 & 0xFFFF;
                        int iCY = msg.arg1 >> 16 & 0xFFFF;
                        BarCodeReader.this.mSnapshotCallback.onPictureTaken(msg.arg2, iCX, iCY, (byte[])msg.obj, this.mReader);
                    } else {
                        Log.e((String)BarCodeReader.TAG, (String)"BCRDR_MSG_COMPRESSED_IMAGE event with no snapshot callback");
                    }
                    return;
                }
                case 32: {
                    if (BarCodeReader.this.mVideoCallback != null) {
                        int iCX = msg.arg1 >> 0 & 0xFFFF;
                        int iCY = msg.arg1 >> 16 & 0xFFFF;
                        BarCodeReader.this.mVideoCallback.onVideoFrame(msg.arg2, iCX, iCY, (byte[])msg.obj, this.mReader);
                    } else {
                        Log.e((String)BarCodeReader.TAG, (String)"BCRDR_MSG_VIDEO_FRAME event with no video callback");
                    }
                    return;
                }
                case 16: {
                    if (BarCodeReader.this.mPreviewCallback != null) {
                        PreviewCallback cb = BarCodeReader.this.mPreviewCallback;
                        if (BarCodeReader.this.mOneShot) {
                            BarCodeReader.this.mPreviewCallback = null;
                        } else if (!BarCodeReader.this.mWithBuffer) {
                            BarCodeReader.this.setHasPreviewCallback(true, false);
                        }
                        cb.onPreviewFrame((byte[])msg.obj, this.mReader);
                    }
                    return;
                }
                case 4: {
                    if (BarCodeReader.this.mAutoFocusCallback != null) {
                        BarCodeReader.this.mAutoFocusCallback.onAutoFocus(msg.arg1 != 0, this.mReader);
                    }
                    return;
                }
                case 8: {
                    if (BarCodeReader.this.mZoomListener != null) {
                        BarCodeReader.this.mZoomListener.onZoomChange(msg.arg1, msg.arg2 != 0, this.mReader);
                    }
                    return;
                }
                case 1: {
                    Log.e((String)BarCodeReader.TAG, (String)("Error " + msg.arg1));
                    if (BarCodeReader.this.mErrorCallback != null) {
                        BarCodeReader.this.mErrorCallback.onError(msg.arg1, this.mReader);
                    }
                    return;
                }
                case 1024: {
                    if (BarCodeReader.this.mDecodeCallback != null) {
                        BarCodeReader.this.mDecodeCallback.onDecodeComplete(msg.arg1, -3, (byte[])msg.obj, this.mReader);
                    }
                    return;
                }
            }
            Log.e((String)BarCodeReader.TAG, (String)("Unknown message type " + msg.what));
        }
    }

    static interface OnZoomChangeListener {
        public void onZoomChange(int var1, boolean var2, BarCodeReader var3);
    }

    static class ParamNum {
        public static final short CODE39 = 0;
        public static final short UPCA = 1;
        public static final short UPCE = 2;
        public static final short EAN13 = 3;
        public static final short EAN8 = 4;
        public static final short D25 = 5;
        public static final short I25 = 6;
        public static final short CODABAR = 7;
        public static final short CODE128 = 8;
        public static final short CODE93 = 9;
        public static final short CODE11 = 10;
        public static final short MSI = 11;
        public static final short UPCE1 = 12;
        public static final short TRIOPTIC = 13;
        public static final short EAN128 = 14;
        public static final short PDF = 15;
        public static final short SUPPS = 16;
        public static final short C39_FULL_ASCII = 17;
        public static final short C39_LEN1 = 18;
        public static final short C39_LEN2 = 19;
        public static final short D25_LEN1 = 20;
        public static final short D25_LEN2 = 21;
        public static final short I25_LEN1 = 22;
        public static final short I25_LEN2 = 23;
        public static final short CBR_LEN1 = 24;
        public static final short CBR_LEN2 = 25;
        public static final short C93_LEN1 = 26;
        public static final short C93_LEN2 = 27;
        public static final short C11_LEN1 = 28;
        public static final short C11_LEN2 = 29;
        public static final short MSI_LEN1 = 30;
        public static final short MSI_LEN2 = 31;
        public static final short UPCA_PREAM = 34;
        public static final short UPCE_PREAM = 35;
        public static final short UPCE1_PREAM = 36;
        public static final short UPCE_TO_A = 37;
        public static final short UPCE1_TO_A = 38;
        public static final short EAN8_TO_13 = 39;
        public static final short UPCA_CHK = 40;
        public static final short UPCE_CHK = 41;
        public static final short UPCE1_CHK = 42;
        public static final short XMIT_C39_CHK = 43;
        public static final short XMIT_I25_CHK = 44;
        public static final short XMIT_CODE_ID = 45;
        public static final short XMIT_MSI_CHK = 46;
        public static final short XMIT_C11_CHK = 47;
        public static final short C39_CHK_EN = 48;
        public static final short I25_CHK_TYPE = 49;
        public static final short MSI_CHK_1_2 = 50;
        public static final short MSI_CHK_SCHEME = 51;
        public static final short C11_CHK_TYPE = 52;
        public static final short CLSI = 54;
        public static final short NOTIS = 55;
        public static final short UPC_SEC_LEV = 77;
        public static final short LIN_SEC_LEV = 78;
        public static final short SUPP_REDUN = 80;
        public static final short I25_TO_EAN13 = 82;
        public static final short BOOKLAND = 83;
        public static final short ISBT_128 = 84;
        public static final short COUPON = 85;
        public static final short CODE32 = 86;
        public static final short POST_US1 = 89;
        public static final short POST_US2 = 90;
        public static final short POST_UK = 91;
        public static final short SIGNATURE = 93;
        public static final short XMIT_NO_READ = 94;
        public static final short POST_US_PARITY = 95;
        public static final short POST_UK_PARITY = 96;
        public static final short EMUL_EAN128 = 123;
        public static final short LASER_ON_PRIM = 136;
        public static final short LASER_OFF_PRIM = 137;
        public static final short PRIM_TRIG_MODE = 138;
        public static final short C128_LEN1 = 209;
        public static final short C128_LEN2 = 210;
        public static final short ISBT_MAX_TRY = 223;
        public static final short UPDF = 227;
        public static final short C32_PREFIX = 231;
        public static final short POSTAL_JAP = 290;
        public static final short POSTAL_AUS = 291;
        public static final short DATAMATRIX = 292;
        public static final short QRCODE = 293;
        public static final short MAXICODE = 294;
        public static final short IMG_ILLUM = 298;
        public static final short IMG_AIM_SNAPSHOT = 300;
        public static final short IMG_CROP = 301;
        public static final short IMG_SUBSAMPLE = 302;
        public static final short IMG_BPP = 303;
        public static final short IMG_FILE_FORMAT = 304;
        public static final short IMG_JPEG_QUAL = 305;
        public static final short IMG_AIM_MODE = 306;
        public static final short IMG_SIG_FMT = 313;
        public static final short IMG_SIG_BPP = 314;
        public static final short IMG_CROP_TOP = 315;
        public static final short IMG_CROP_LEFT = 316;
        public static final short IMG_CROP_BOT = 317;
        public static final short IMG_CROP_RIGHT = 318;
        public static final short IMG_SNAPTIMEOUT = 323;
        public static final short IMG_VIDEOVF = 324;
        public static final short POSTAL_DUTCH = 326;
        public static final short RSS_14 = 338;
        public static final short RSS_LIM = 339;
        public static final short RSS_EXP = 340;
        public static final short CCC_ENABLE = 341;
        public static final short CCAB_ENABLE = 342;
        public static final short UPC_COMPOSITE = 344;
        public static final short IMG_IMAGE_ILLUM = 361;
        public static final short SIGCAP_WIDTH = 366;
        public static final short SIGCAP_HEIGHT = 367;
        public static final short TCIF = 371;
        public static final short MARGIN_RATIO = 381;
        public static final short DEMOTE_RSS = 397;
        public static final short PICKLIST_MODE = 402;
        public static final short C25 = 408;
        public static final short IMAGE_SIG_JPEG_QUALITY = 421;
        public static final short EMUL_UCCEAN128 = 427;
        public static final short MIRROR_IMAGE = 537;
        public static final short IMG_ENHANCEMENT = 564;
        public static final short UQR_EN = 573;
        public static final short AZTEC = 574;
        public static final short BOOKLAND_FORMAT = 576;
        public static final short ISBT_CONCAT_MODE = 577;
        public static final short CHECK_ISBT_TABLE = 578;
        public static final short SUPP_USER_1 = 579;
        public static final short SUPP_USER_2 = 580;
        public static final short K35 = 581;
        public static final short ONE_D_INVERSE = 586;
        public static final short QR_INVERSE = 587;
        public static final short DATAMATRIX_INVERSE = 588;
        public static final short AZTEC_INVERSE = 589;
        public static final short AIMMODEHANDSFREE = 590;
        public static final short POST_US3 = 592;
        public static final short POST_US4 = 611;
        public static final short ISSN_EAN_EN = 617;
        public static final short MATRIX_25_EN = 618;
        public static final short MATRIX_25_LEN1 = 619;
        public static final short MATRIX_25_LEN2 = 620;
        public static final short MATRIX_25_REDUN = 621;
        public static final short MATRIX_25_CHK_EN = 622;
        public static final short MATRIX_25_XMIT_CHK = 623;
        public static final short AIMID_SUPP_FORMAT = 672;
        public static final short CELL_DISPLAY_MODE = 716;
        public static final short POST_AUS_FMT = 718;
        public static final short DATABAR_LIM_SEC_LEV = 728;
        public static final short COUPON_REPORT = 730;
        public static final short VIDEO_SUBSMAPLE = 761;
        public static final short IMG_MOTIONILLUM = 762;
        public static final short MULTI_DECODE = 900;
        public static final short FULL_READ_MODE = 901;
        public static final short NUM_BR_TO_READ = 902;
        public static final short RETRIEVE_LAST_DECODE = 905;
        public static final short SECURITY_LEVEL = 1121;
        public static final short ENABLE_HANXIN = 1167;
        public static final short HANXIN_INVERSE = 1168;

        ParamNum() {
        }
    }

    static class ParamVal {
        public static final byte SUPP_NONE = 0;
        public static final byte SUPP_ONLY = 1;
        public static final byte SUPP_AUTOD = 2;
        public static final byte SUPP_SMART = 3;
        public static final byte SUPP_378_379 = 4;
        public static final byte SUPP_978_979 = 5;
        public static final byte SUPP_414_419_434_439 = 6;
        public static final byte SUPP_977 = 7;
        public static final byte SUPP_491 = 8;
        public static final byte SUPP_PROG_1 = 9;
        public static final byte SUPP_PROG_1_AND_2 = 10;
        public static final byte SUPP_SMART_PLUS_1 = 11;
        public static final byte SUPP_SMART_PLUS_1_2 = 12;
        public static final byte LEVEL = 0;
        public static final byte HANDSFREE = 7;
        public static final byte AUTO_AIM = 9;
        public static final byte IMG_BPP_1 = 0;
        public static final byte IMG_BPP_4 = 1;
        public static final byte IMG_BPP_8 = 2;
        public static final byte IMG_FORMAT_JPEG = 1;
        public static final byte IMG_FORMAT_BMP = 3;
        public static final byte IMG_FORMAT_TIFF = 4;
        public static final byte IMG_SUBSAMPLE_FACTOR_1 = 0;
        public static final byte IMG_SUBSAMPLE_FACTOR_2 = 1;
        public static final byte IMG_SUBSAMPLE_FACTOR_3 = 2;
        public static final byte IMG_SUBSAMPLE_FACTOR_4 = 3;
        public static final byte AIM_OFF = 0;
        public static final byte AIM_ON = 1;
        public static final byte AIM_ON_ALWAYS = 2;
        public static final byte UPC_NEVER = 0;
        public static final byte UPC_ALWAYS = 1;
        public static final byte UPC_AUTOD = 2;
        public static final byte PICKLIST_NEVER = 0;
        public static final byte PICKLIST_OUT_OF_SCANSTAND = 1;
        public static final byte PICKLIST_ALWAYS = 1;
        public static final byte MIRROR_NEVER = 0;
        public static final byte MIRROR_ALWAYS = 1;
        public static final byte MIRROR_AUTO = 2;
        public static final byte IMG_ENHANCE_OFF = 0;
        public static final byte IMG_ENHANCE_LOW = 1;
        public static final byte IMG_ENHANCE_MED = 2;
        public static final byte IMG_ENHANCE_HIGH = 3;
        public static final byte IMG_ENHANCE_CUSTOM = 4;
        public static final byte ISBT_CONCAT_NONE = 0;
        public static final byte ISBT_CONCAT_ONLY = 1;
        public static final byte ISBT_CONCAT_AUTOD = 2;
        public static final byte REGULAR_ONLY = 0;
        public static final byte INVERSE_ONLY = 1;
        public static final byte INVERSE_AUTOD = 2;
        public static final byte PDF_SECURITY_STRICT = 0;
        public static final byte PDF_CWLEN_ZERO_OK = 1;

        ParamVal() {
        }
    }

    class Parameters {
        private static final String KEY_PREVIEW_SIZE = "preview-size";
        private static final String KEY_PREVIEW_FORMAT = "preview-format";
        private static final String KEY_PREVIEW_FRAME_RATE = "preview-frame-rate";
        private static final String KEY_PREVIEW_FPS_RANGE = "preview-fps-range";
        private static final String KEY_PICTURE_SIZE = "picture-size";
        private static final String KEY_PICTURE_FORMAT = "picture-format";
        private static final String KEY_JPEG_THUMBNAIL_SIZE = "jpeg-thumbnail-size";
        private static final String KEY_JPEG_THUMBNAIL_WIDTH = "jpeg-thumbnail-width";
        private static final String KEY_JPEG_THUMBNAIL_HEIGHT = "jpeg-thumbnail-height";
        private static final String KEY_JPEG_THUMBNAIL_QUALITY = "jpeg-thumbnail-quality";
        private static final String KEY_JPEG_QUALITY = "jpeg-quality";
        private static final String KEY_ROTATION = "rotation";
        private static final String KEY_GPS_LATITUDE = "gps-latitude";
        private static final String KEY_GPS_LONGITUDE = "gps-longitude";
        private static final String KEY_GPS_ALTITUDE = "gps-altitude";
        private static final String KEY_GPS_TIMESTAMP = "gps-timestamp";
        private static final String KEY_GPS_PROCESSING_METHOD = "gps-processing-method";
        private static final String KEY_WHITE_BALANCE = "whitebalance";
        private static final String KEY_EFFECT = "effect";
        private static final String KEY_ANTIBANDING = "antibanding";
        private static final String KEY_SCENE_MODE = "scene-mode";
        private static final String KEY_FLASH_MODE = "flash-mode";
        private static final String KEY_FOCUS_MODE = "focus-mode";
        private static final String KEY_FOCAL_LENGTH = "focal-length";
        private static final String KEY_HORIZONTAL_VIEW_ANGLE = "horizontal-view-angle";
        private static final String KEY_VERTICAL_VIEW_ANGLE = "vertical-view-angle";
        private static final String KEY_EXPOSURE_COMPENSATION = "exposure-compensation";
        private static final String KEY_MAX_EXPOSURE_COMPENSATION = "max-exposure-compensation";
        private static final String KEY_MIN_EXPOSURE_COMPENSATION = "min-exposure-compensation";
        private static final String KEY_EXPOSURE_COMPENSATION_STEP = "exposure-compensation-step";
        private static final String KEY_ZOOM = "zoom";
        private static final String KEY_MAX_ZOOM = "max-zoom";
        private static final String KEY_ZOOM_RATIOS = "zoom-ratios";
        private static final String KEY_ZOOM_SUPPORTED = "zoom-supported";
        private static final String KEY_SMOOTH_ZOOM_SUPPORTED = "smooth-zoom-supported";
        private static final String KEY_FOCUS_DISTANCES = "focus-distances";
        private static final String SUPPORTED_VALUES_SUFFIX = "-values";
        private static final String TRUE = "true";
        static final String WHITE_BALANCE_AUTO = "auto";
        static final String WHITE_BALANCE_INCANDESCENT = "incandescent";
        static final String WHITE_BALANCE_FLUORESCENT = "fluorescent";
        static final String WHITE_BALANCE_WARM_FLUORESCENT = "warm-fluorescent";
        static final String WHITE_BALANCE_DAYLIGHT = "daylight";
        static final String WHITE_BALANCE_CLOUDY_DAYLIGHT = "cloudy-daylight";
        static final String WHITE_BALANCE_TWILIGHT = "twilight";
        static final String WHITE_BALANCE_SHADE = "shade";
        static final String EFFECT_NONE = "none";
        static final String EFFECT_MONO = "mono";
        static final String EFFECT_NEGATIVE = "negative";
        static final String EFFECT_SOLARIZE = "solarize";
        static final String EFFECT_SEPIA = "sepia";
        static final String EFFECT_POSTERIZE = "posterize";
        static final String EFFECT_WHITEBOARD = "whiteboard";
        static final String EFFECT_BLACKBOARD = "blackboard";
        static final String EFFECT_AQUA = "aqua";
        static final String ANTIBANDING_AUTO = "auto";
        static final String ANTIBANDING_50HZ = "50hz";
        static final String ANTIBANDING_60HZ = "60hz";
        static final String ANTIBANDING_OFF = "off";
        static final String FLASH_MODE_OFF = "off";
        static final String FLASH_MODE_AUTO = "auto";
        static final String FLASH_MODE_ON = "on";
        static final String FLASH_MODE_RED_EYE = "red-eye";
        static final String FLASH_MODE_TORCH = "torch";
        static final String SCENE_MODE_AUTO = "auto";
        static final String SCENE_MODE_ACTION = "action";
        static final String SCENE_MODE_PORTRAIT = "portrait";
        static final String SCENE_MODE_LANDSCAPE = "landscape";
        static final String SCENE_MODE_NIGHT = "night";
        static final String SCENE_MODE_NIGHT_PORTRAIT = "night-portrait";
        static final String SCENE_MODE_THEATRE = "theatre";
        static final String SCENE_MODE_BEACH = "beach";
        static final String SCENE_MODE_SNOW = "snow";
        static final String SCENE_MODE_SUNSET = "sunset";
        static final String SCENE_MODE_STEADYPHOTO = "steadyphoto";
        static final String SCENE_MODE_FIREWORKS = "fireworks";
        static final String SCENE_MODE_SPORTS = "sports";
        static final String SCENE_MODE_PARTY = "party";
        static final String SCENE_MODE_CANDLELIGHT = "candlelight";
        static final String SCENE_MODE_BARCODE = "barcode";
        static final String FOCUS_MODE_AUTO = "auto";
        static final String FOCUS_MODE_INFINITY = "infinity";
        static final String FOCUS_MODE_MACRO = "macro";
        static final String FOCUS_MODE_FIXED = "fixed";
        static final String FOCUS_MODE_EDOF = "edof";
        static final String FOCUS_MODE_CONTINUOUS_VIDEO = "continuous-video";
        static final int FOCUS_DISTANCE_NEAR_INDEX = 0;
        static final int FOCUS_DISTANCE_OPTIMAL_INDEX = 1;
        static final int FOCUS_DISTANCE_FAR_INDEX = 2;
        static final int PREVIEW_FPS_MIN_INDEX = 0;
        static final int PREVIEW_FPS_MAX_INDEX = 1;
        private static final String PIXEL_FORMAT_YUV422SP = "yuv422sp";
        private static final String PIXEL_FORMAT_YUV420SP = "yuv420sp";
        private static final String PIXEL_FORMAT_YUV422I = "yuv422i-yuyv";
        private static final String PIXEL_FORMAT_RGB565 = "rgb565";
        private static final String PIXEL_FORMAT_JPEG = "jpeg";
        private HashMap<String, String> mMap = new HashMap();
        private static final String KEY_NO_DISPLAY_MODE = "no-display-mode";

        private Parameters() {
        }

        public void dump() {
            Log.e((String)BarCodeReader.TAG, (String)("dump: size=" + this.mMap.size()));
            for (String k : this.mMap.keySet()) {
                Log.e((String)BarCodeReader.TAG, (String)("dump: " + k + "=" + this.mMap.get(k)));
            }
        }

        public String flatten() {
            StringBuilder flattened = new StringBuilder();
            for (String k : this.mMap.keySet()) {
                flattened.append(k);
                flattened.append("=");
                flattened.append(this.mMap.get(k));
                flattened.append(";");
            }
            flattened.deleteCharAt(flattened.length() - 1);
            return flattened.toString();
        }

        public void unflatten(String flattened) {
            this.mMap.clear();
            StringTokenizer tokenizer = new StringTokenizer(flattened, ";");
            while (tokenizer.hasMoreElements()) {
                String strKV = tokenizer.nextToken();
                int iPos = strKV.indexOf(61);
                if (iPos == -1) continue;
                this.mMap.put(strKV.substring(0, iPos), strKV.substring(iPos + 1));
            }
        }

        public void remove(String key) {
            this.mMap.remove(key);
        }

        public void set(String key, String value) {
            if (key.indexOf(61) != -1 || key.indexOf(59) != -1) {
                Log.e((String)BarCodeReader.TAG, (String)("Key \"" + key + "\" contains invalid character (= or ;)"));
                return;
            }
            if (value.indexOf(61) != -1 || value.indexOf(59) != -1) {
                Log.e((String)BarCodeReader.TAG, (String)("Value \"" + value + "\" contains invalid character (= or ;)"));
                return;
            }
            this.mMap.put(key, value);
        }

        public void set(String key, int value) {
            if (key.indexOf(61) != -1 || key.indexOf(59) != -1) {
                Log.e((String)BarCodeReader.TAG, (String)("Key \"" + key + "\" contains invalid character (= or ;)"));
                return;
            }
            this.mMap.put(key, Integer.toString(value));
        }

        public String get(String key) {
            return this.mMap.get(key);
        }

        public int getInt(String key) {
            return this.getInt(key, -1);
        }

        public void setPreviewSize(int width, int height) {
            String v = String.valueOf(Integer.toString(width)) + "x" + Integer.toString(height);
            this.set(KEY_PREVIEW_SIZE, v);
        }

        public Size getPreviewSize() {
            String pair = this.get(KEY_PREVIEW_SIZE);
            return this.strToSize(pair);
        }

        public void setNoDisplayMode(int value) {
            String v = Integer.toString(value);
            this.set(KEY_NO_DISPLAY_MODE, v);
        }

        public List<Size> getSupportedPreviewSizes() {
            String str = this.get("preview-size-values");
            return this.splitSize(str);
        }

        public void setJpegThumbnailSize(int width, int height) {
            this.set(KEY_JPEG_THUMBNAIL_WIDTH, width);
            this.set(KEY_JPEG_THUMBNAIL_HEIGHT, height);
        }

        public Size getJpegThumbnailSize() {
            return new Size(this.getInt(KEY_JPEG_THUMBNAIL_WIDTH), this.getInt(KEY_JPEG_THUMBNAIL_HEIGHT));
        }

        public List<Size> getSupportedJpegThumbnailSizes() {
            String str = this.get("jpeg-thumbnail-size-values");
            return this.splitSize(str);
        }

        public void setJpegThumbnailQuality(int quality) {
            this.set(KEY_JPEG_THUMBNAIL_QUALITY, quality);
        }

        public int getJpegThumbnailQuality() {
            return this.getInt(KEY_JPEG_THUMBNAIL_QUALITY);
        }

        public void setJpegQuality(int quality) {
            this.set(KEY_JPEG_QUALITY, quality);
        }

        public int getJpegQuality() {
            return this.getInt(KEY_JPEG_QUALITY);
        }

        @Deprecated
        public void setPreviewFrameRate(int fps) {
            this.set(KEY_PREVIEW_FRAME_RATE, fps);
        }

        @Deprecated
        public int getPreviewFrameRate() {
            return this.getInt(KEY_PREVIEW_FRAME_RATE);
        }

        @Deprecated
        public List<Integer> getSupportedPreviewFrameRates() {
            String str = this.get("preview-frame-rate-values");
            return this.splitInt(str);
        }

        public void setPreviewFpsRange(int min, int max) {
            this.set(KEY_PREVIEW_FPS_RANGE, min + "," + max);
        }

        public void getPreviewFpsRange(int[] range) {
            if (range == null || range.length != 2) {
                throw new IllegalArgumentException("range must be an array with two elements.");
            }
            this.splitInt(this.get(KEY_PREVIEW_FPS_RANGE), range);
        }

        public List<int[]> getSupportedPreviewFpsRange() {
            String str = this.get("preview-fps-range-values");
            return this.splitRange(str);
        }

        public void setPreviewFormat(int pixel_format) {
            String s = this.readerFormatForPixelFormat(pixel_format);
            if (s == null) {
                throw new IllegalArgumentException("Invalid pixel_format=" + pixel_format);
            }
            this.set(KEY_PREVIEW_FORMAT, s);
        }

        public int getPreviewFormat() {
            return this.pixelFormatForReaderFormat(this.get(KEY_PREVIEW_FORMAT));
        }

        public List<Integer> getSupportedPreviewFormats() {
            String str = this.get("preview-format-values");
            ArrayList<Integer> formats = new ArrayList<Integer>();
            for (String s : this.split(str)) {
                int f = this.pixelFormatForReaderFormat(s);
                if (f == 0) continue;
                formats.add(f);
            }
            return formats;
        }

        public void setPictureSize(int width, int height) {
            String v = String.valueOf(Integer.toString(width)) + "x" + Integer.toString(height);
            this.set(KEY_PICTURE_SIZE, v);
        }

        public Size getPictureSize() {
            String pair = this.get(KEY_PICTURE_SIZE);
            return this.strToSize(pair);
        }

        public List<Size> getSupportedPictureSizes() {
            String str = this.get("picture-size-values");
            return this.splitSize(str);
        }

        public void setPictureFormat(int pixel_format) {
            String s = this.readerFormatForPixelFormat(pixel_format);
            if (s == null) {
                throw new IllegalArgumentException("Invalid pixel_format=" + pixel_format);
            }
            this.set(KEY_PICTURE_FORMAT, s);
        }

        public int getPictureFormat() {
            return this.pixelFormatForReaderFormat(this.get(KEY_PICTURE_FORMAT));
        }

        public List<Integer> getSupportedPictureFormats() {
            String str = this.get("picture-format-values");
            ArrayList<Integer> formats = new ArrayList<Integer>();
            for (String s : this.split(str)) {
                int f = this.pixelFormatForReaderFormat(s);
                if (f == 0) continue;
                formats.add(f);
            }
            return formats;
        }

        private String readerFormatForPixelFormat(int pixel_format) {
            switch (pixel_format) {
                case 16: {
                    return PIXEL_FORMAT_YUV422SP;
                }
                case 17: {
                    return PIXEL_FORMAT_YUV420SP;
                }
                case 20: {
                    return PIXEL_FORMAT_YUV422I;
                }
                case 4: {
                    return PIXEL_FORMAT_RGB565;
                }
                case 256: {
                    return PIXEL_FORMAT_JPEG;
                }
            }
            return null;
        }

        private int pixelFormatForReaderFormat(String format) {
            if (format == null) {
                return 0;
            }
            if (format.equals(PIXEL_FORMAT_YUV422SP)) {
                return 16;
            }
            if (format.equals(PIXEL_FORMAT_YUV420SP)) {
                return 17;
            }
            if (format.equals(PIXEL_FORMAT_YUV422I)) {
                return 20;
            }
            if (format.equals(PIXEL_FORMAT_RGB565)) {
                return 4;
            }
            if (format.equals(PIXEL_FORMAT_JPEG)) {
                return 256;
            }
            return 0;
        }

        public void setRotation(int rotation) {
            if (rotation != 0 && rotation != 90 && rotation != 180 && rotation != 270) {
                throw new IllegalArgumentException("Invalid rotation=" + rotation);
            }
            this.set(KEY_ROTATION, Integer.toString(rotation));
        }

        public void setGpsLatitude(double latitude) {
            this.set(KEY_GPS_LATITUDE, Double.toString(latitude));
        }

        public void setGpsLongitude(double longitude) {
            this.set(KEY_GPS_LONGITUDE, Double.toString(longitude));
        }

        public void setGpsAltitude(double altitude) {
            this.set(KEY_GPS_ALTITUDE, Double.toString(altitude));
        }

        public void setGpsTimestamp(long timestamp) {
            this.set(KEY_GPS_TIMESTAMP, Long.toString(timestamp));
        }

        public void setGpsProcessingMethod(String processing_method) {
            this.set(KEY_GPS_PROCESSING_METHOD, processing_method);
        }

        public void removeGpsData() {
            this.remove(KEY_GPS_LATITUDE);
            this.remove(KEY_GPS_LONGITUDE);
            this.remove(KEY_GPS_ALTITUDE);
            this.remove(KEY_GPS_TIMESTAMP);
            this.remove(KEY_GPS_PROCESSING_METHOD);
        }

        public String getWhiteBalance() {
            return this.get(KEY_WHITE_BALANCE);
        }

        public void setWhiteBalance(String value) {
            this.set(KEY_WHITE_BALANCE, value);
        }

        public List<String> getSupportedWhiteBalance() {
            String str = this.get("whitebalance-values");
            return this.split(str);
        }

        public String getColorEffect() {
            return this.get(KEY_EFFECT);
        }

        public void setColorEffect(String value) {
            this.set(KEY_EFFECT, value);
        }

        public List<String> getSupportedColorEffects() {
            String str = this.get("effect-values");
            return this.split(str);
        }

        public String getAntibanding() {
            return this.get(KEY_ANTIBANDING);
        }

        public void setAntibanding(String antibanding) {
            this.set(KEY_ANTIBANDING, antibanding);
        }

        public List<String> getSupportedAntibanding() {
            String str = this.get("antibanding-values");
            return this.split(str);
        }

        public String getSceneMode() {
            return this.get(KEY_SCENE_MODE);
        }

        public void setSceneMode(String value) {
            this.set(KEY_SCENE_MODE, value);
        }

        public List<String> getSupportedSceneModes() {
            String str = this.get("scene-mode-values");
            return this.split(str);
        }

        public String getFlashMode() {
            return this.get(KEY_FLASH_MODE);
        }

        public void setFlashMode(String value) {
            this.set(KEY_FLASH_MODE, value);
        }

        public List<String> getSupportedFlashModes() {
            String str = this.get("flash-mode-values");
            return this.split(str);
        }

        public String getFocusMode() {
            return this.get(KEY_FOCUS_MODE);
        }

        public void setFocusMode(String value) {
            this.set(KEY_FOCUS_MODE, value);
        }

        public List<String> getSupportedFocusModes() {
            String str = this.get("focus-mode-values");
            return this.split(str);
        }

        public float getFocalLength() {
            return Float.parseFloat(this.get(KEY_FOCAL_LENGTH));
        }

        public float getHorizontalViewAngle() {
            return Float.parseFloat(this.get(KEY_HORIZONTAL_VIEW_ANGLE));
        }

        public float getVerticalViewAngle() {
            return Float.parseFloat(this.get(KEY_VERTICAL_VIEW_ANGLE));
        }

        public int getExposureCompensation() {
            return this.getInt(KEY_EXPOSURE_COMPENSATION, 0);
        }

        public void setExposureCompensation(int value) {
            this.set(KEY_EXPOSURE_COMPENSATION, value);
        }

        public int getMaxExposureCompensation() {
            return this.getInt(KEY_MAX_EXPOSURE_COMPENSATION, 0);
        }

        public int getMinExposureCompensation() {
            return this.getInt(KEY_MIN_EXPOSURE_COMPENSATION, 0);
        }

        public float getExposureCompensationStep() {
            return this.getFloat(KEY_EXPOSURE_COMPENSATION_STEP, 0.0f);
        }

        public int getZoom() {
            return this.getInt(KEY_ZOOM, 0);
        }

        public void setZoom(int value) {
            this.set(KEY_ZOOM, value);
        }

        public boolean isZoomSupported() {
            String str = this.get(KEY_ZOOM_SUPPORTED);
            return TRUE.equals(str);
        }

        public int getMaxZoom() {
            return this.getInt(KEY_MAX_ZOOM, 0);
        }

        public List<Integer> getZoomRatios() {
            return this.splitInt(this.get(KEY_ZOOM_RATIOS));
        }

        public boolean isSmoothZoomSupported() {
            String str = this.get(KEY_SMOOTH_ZOOM_SUPPORTED);
            return TRUE.equals(str);
        }

        public void getFocusDistances(float[] output) {
            if (output == null || output.length != 3) {
                throw new IllegalArgumentException("output must be an float array with three elements.");
            }
            this.splitFloat(this.get(KEY_FOCUS_DISTANCES), output);
        }

        private ArrayList<String> split(String str) {
            if (str == null) {
                return null;
            }
            StringTokenizer tokenizer = new StringTokenizer(str, ",");
            ArrayList<String> substrings = new ArrayList<String>();
            while (tokenizer.hasMoreElements()) {
                substrings.add(tokenizer.nextToken());
            }
            return substrings;
        }

        private ArrayList<Integer> splitInt(String str) {
            if (str == null) {
                return null;
            }
            StringTokenizer tokenizer = new StringTokenizer(str, ",");
            ArrayList<Integer> substrings = new ArrayList<Integer>();
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                substrings.add(Integer.parseInt(token));
            }
            if (substrings.size() == 0) {
                return null;
            }
            return substrings;
        }

        private void splitInt(String str, int[] output) {
            if (str == null) {
                return;
            }
            StringTokenizer tokenizer = new StringTokenizer(str, ",");
            int index = 0;
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                output[index++] = Integer.parseInt(token);
            }
        }

        private void splitFloat(String str, float[] output) {
            if (str == null) {
                return;
            }
            StringTokenizer tokenizer = new StringTokenizer(str, ",");
            int index = 0;
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                output[index++] = Float.parseFloat(token);
            }
        }

        private float getFloat(String key, float defaultValue) {
            try {
                float flRetVal = Float.parseFloat(this.mMap.get(key));
                return flRetVal;
            }
            catch (Throwable throwable) {
                return defaultValue;
            }
        }

        private int getInt(String key, int defaultValue) {
            try {
                int iRetVal = Integer.parseInt(this.mMap.get(key));
                return iRetVal;
            }
            catch (Throwable throwable) {
                return defaultValue;
            }
        }

        private ArrayList<Size> splitSize(String str) {
            if (str == null) {
                return null;
            }
            StringTokenizer tokenizer = new StringTokenizer(str, ",");
            ArrayList<Size> sizeList = new ArrayList<Size>();
            while (tokenizer.hasMoreElements()) {
                Size size = this.strToSize(tokenizer.nextToken());
                if (size == null) continue;
                sizeList.add(size);
            }
            if (sizeList.size() == 0) {
                return null;
            }
            return sizeList;
        }

        private Size strToSize(String str) {
            if (str == null) {
                return null;
            }
            int pos = str.indexOf(120);
            if (pos != -1) {
                String width = str.substring(0, pos);
                String height = str.substring(pos + 1);
                return new Size(Integer.parseInt(width), Integer.parseInt(height));
            }
            Log.e((String)BarCodeReader.TAG, (String)("Invalid size parameter string=" + str));
            return null;
        }

        private ArrayList<int[]> splitRange(String str) {
            int endIndex;
            if (str == null || str.charAt(0) != '(' || str.charAt(str.length() - 1) != ')') {
                Log.e((String)BarCodeReader.TAG, (String)("Invalid range list string=" + str));
                return null;
            }
            ArrayList<int[]> rangeList = new ArrayList<int[]>();
            int fromIndex = 1;
            do {
                int[] range = new int[2];
                endIndex = str.indexOf("),(", fromIndex);
                if (endIndex == -1) {
                    endIndex = str.length() - 1;
                }
                this.splitInt(str.substring(fromIndex, endIndex), range);
                rangeList.add(range);
                fromIndex = endIndex + 3;
            } while (endIndex != str.length() - 1);
            if (rangeList.size() == 0) {
                return null;
            }
            return rangeList;
        }
    }

    static interface PictureCallback {
        public void onPictureTaken(int var1, int var2, int var3, byte[] var4, BarCodeReader var5);
    }

    static interface PreviewCallback {
        public void onPreviewFrame(byte[] var1, BarCodeReader var2);
    }

    static class PropertyNum {
        public static final int MODEL_NUMBER = 1;
        public static final int SERIAL_NUM = 2;
        public static final int MAX_FRAME_BUFFER_SIZE = 3;
        public static final int HORIZONTAL_RES = 4;
        public static final int VERTICAL_RES = 5;
        public static final int IMGKIT_VER = 6;
        public static final int ENGINE_VER = 7;
        public static final int BTLD_FW_VER = 11;
        public static final int SDL_VER = 99;

        PropertyNum() {
        }
    }

    static class ReaderInfo {
        static final int BCRDR_FACING_BACK = 0;
        static final int BCRDR_FACING_FRONT = 1;
        public int facing;
        public int orientation;

        ReaderInfo() {
        }
    }

    class Size {
        public int width;
        public int height;

        public Size(int w, int h) {
            this.width = w;
            this.height = h;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Size)) {
                return false;
            }
            Size s = (Size)obj;
            return this.width == s.width && this.height == s.height;
        }

        public int hashCode() {
            return this.width * 32713 + this.height;
        }
    }

    static interface VideoCallback {
        public void onVideoFrame(int var1, int var2, int var3, byte[] var4, BarCodeReader var5);
    }
}

