/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.adc.decoder;

import android.os.Build;
import android.os.Environment;
import android.util.Log;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.utility.StringUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;

class Barcode2DSoftCommon {
    private static boolean debug = StringUtility.DEBUG;
    private static String TAG = String.valueOf(StringUtility.TAG) + "SoftCommon";
    public static HARDWARE_TYPE currentHardwareType = HARDWARE_TYPE.MOTOROLA_4500;
    public static SCANNER_TYPE currentScannerType = SCANNER_TYPE.MOTOROLA_4500;
    public static boolean isMTK = true;
    public static int CameraID = 1;
    public static boolean isIris = false;
    public static String ScannerCameraIdFile = Environment.getExternalStorageDirectory() + File.separator + ".2DScannerId";
    public static String CameraStateFile = Environment.getExternalStorageDirectory() + File.separator + ".2DScannerCameraState";
    public static String ScannerStateFile = Environment.getExternalStorageDirectory() + File.separator + ".2DScannerState";

    Barcode2DSoftCommon() {
    }

    public static void getBarcodeHardwareType() {
        block19: {
            try {
                if (DeviceConfiguration.getPlatform() == 1) {
                    String info = Barcode2DSoftCommon.ReadMTKScanType();
                    if (info != null && !info.isEmpty()) {
                        if (info.contains("6603") || info.contains("3601")) {
                            if (info.contains("3601")) {
                                currentScannerType = SCANNER_TYPE.H_3601;
                                Log.i((String)TAG, (String)"-------currentScannerType=SCANNER_TYPE.H_3601----------");
                            } else {
                                currentScannerType = SCANNER_TYPE.H_6603;
                                Log.i((String)TAG, (String)"-------currentScannerType=SCANNER_TYPE.H_6603----------");
                            }
                            currentHardwareType = HARDWARE_TYPE.H_6603;
                        } else if (info.contains("FrontCamera:ialengmipiraw")) {
                            currentHardwareType = HARDWARE_TYPE.IA400S;
                            currentScannerType = SCANNER_TYPE.IA400S;
                            Log.i((String)TAG, (String)"-------currentHardwareType = HARDWARE_TYPE.IA400S----------");
                        } else if (info.contains("4500")) {
                            currentScannerType = SCANNER_TYPE.MOTOROLA_4500;
                            Log.i((String)TAG, (String)"-------currentScannerType=SCANNER_TYPE.MOTOROLA_4500----------");
                        } else if (info.contains("4750")) {
                            currentScannerType = SCANNER_TYPE.MOTOROLA_4750;
                            Log.i((String)TAG, (String)"-------currentScannerType=SCANNER_TYPE.MOTOROLA_4750----------");
                        } else {
                            currentScannerType = SCANNER_TYPE.MOTOROLA_4710;
                            Log.i((String)TAG, (String)"-------currentScannerType=SCANNER_TYPE.MOTOROLA_4710----------");
                        }
                        if (info.contains("BackIris:imx132") || info.contains("FrontIris:imx132")) {
                            isIris = true;
                            Log.i((String)TAG, (String)"-------isIris=true;----------");
                        }
                    }
                } else {
                    Log.d((String)TAG, (String)"2D ------------qcomm----------------");
                    isMTK = false;
                    String strType = "";
                    strType = Build.VERSION.SDK_INT >= 28 ? Barcode2DSoftCommon.ReadQualcommScanType90() : Barcode2DSoftCommon.ReadQualcommScanType70();
                    if (strType.contains("hsm_imager")) {
                        currentHardwareType = HARDWARE_TYPE.H_6603;
                        Log.d((String)TAG, (String)"------------currentHardwareType=HARDWARE_TYPE.H_6603----------------");
                    } else if (strType.equals("qcom,se4710")) {
                        currentHardwareType = HARDWARE_TYPE.MOTOROLA_4500;
                        Log.d((String)TAG, (String)"------------ currentHardwareType=HARDWARE_TYPE.MOTOROLA_4500---------------");
                    }
                }
            }
            catch (Exception e) {
                if (!debug) break block19;
                Log.i((String)TAG, (String)"No cameraInfo file found");
            }
        }
    }

    public static void writeScannerCameraId(int id) {
        File scannerCameraIdFile = new File(ScannerCameraIdFile);
        FileOutputStream scannerCameraIdOps = null;
        if (!scannerCameraIdFile.exists()) {
            try {
                scannerCameraIdFile.createNewFile();
                Runtime runtime = Runtime.getRuntime();
                runtime.exec("chmod 0666 " + ScannerCameraIdFile);
            }
            catch (Exception ex) {
                if (debug) {
                    Log.w((String)TAG, (String)("writeScannerCameraId  error: " + ex.getMessage()));
                }
                ex.printStackTrace();
            }
        }
        try {
            try {
                scannerCameraIdOps = new FileOutputStream(scannerCameraIdFile);
                String sid = String.valueOf(id) + "\n";
                scannerCameraIdOps.write(sid.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    scannerCameraIdOps.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                scannerCameraIdOps.close();
            }
            catch (Exception exception) {}
        }
    }

    public static int readScannerCameraId() {
        File scannerCameraIdFile = new File(ScannerCameraIdFile);
        int result = -2;
        if (!scannerCameraIdFile.exists()) {
            return -3;
        }
        FileInputStream fis = null;
        InputStreamReader inputreader = null;
        BufferedReader buffreader = null;
        try {
            try {
                fis = new FileInputStream(scannerCameraIdFile);
                inputreader = new InputStreamReader(fis);
                buffreader = new BufferedReader(inputreader);
                String cameraId = buffreader.readLine();
                result = Integer.parseInt(cameraId);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    fis.close();
                    inputreader.close();
                    buffreader.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                fis.close();
                inputreader.close();
                buffreader.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static void writeScannerState(int id) {
        File scannerStateFile = new File(ScannerStateFile);
        FileOutputStream ops = null;
        if (!scannerStateFile.exists()) {
            try {
                scannerStateFile.createNewFile();
                Runtime runtime = Runtime.getRuntime();
                runtime.exec("chmod 0666 " + ScannerStateFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            try {
                ops = new FileOutputStream(scannerStateFile);
                String sid = String.valueOf(id) + "\n";
                ops.write(sid.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    ops.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                ops.close();
            }
            catch (Exception exception) {}
        }
    }

    public static int readCameraState() {
        File cameraStateFile = new File(CameraStateFile);
        int result = -1;
        if (!cameraStateFile.exists()) {
            return result;
        }
        FileInputStream fis = null;
        InputStreamReader inputreader = null;
        BufferedReader buffreader = null;
        try {
            try {
                fis = new FileInputStream(cameraStateFile);
                inputreader = new InputStreamReader(fis);
                buffreader = new BufferedReader(inputreader);
                String state = buffreader.readLine();
                result = Integer.parseInt(state);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    fis.close();
                    inputreader.close();
                    buffreader.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                fis.close();
                inputreader.close();
                buffreader.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static void writeCameraState(int id) {
        File cameraStateFile = new File(CameraStateFile);
        FileOutputStream ops = null;
        if (!cameraStateFile.exists()) {
            try {
                cameraStateFile.createNewFile();
                Runtime runtime = Runtime.getRuntime();
                runtime.exec("chmod 0666 " + CameraStateFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            try {
                ops = new FileOutputStream(cameraStateFile);
                String sid = String.valueOf(id) + "\n";
                ops.write(sid.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    ops.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                ops.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String ReadQualcommScanType90() {
        Log.d((String)TAG, (String)"ReadQualcommScanType90");
        String path1 = "/sys/class/video4linux/v4l-subdev18/name";
        String path2 = "/sys/class/video4linux/v4l-subdev17/name";
        String data = Barcode2DSoftCommon.ReadQualcommScanType("/sys/class/video4linux/v4l-subdev18/name");
        if (data == null || data.isEmpty()) {
            data = Barcode2DSoftCommon.ReadQualcommScanType("/sys/class/video4linux/v4l-subdev17/name");
        }
        return data;
    }

    public static String ReadQualcommScanType70() {
        Log.d((String)TAG, (String)"ReadQualcommScanType70");
        String path1 = "/sys/class/video4linux/v4l-subdev19/name";
        String path2 = "/sys/class/video4linux/v4l-subdev18/name";
        String data = Barcode2DSoftCommon.ReadQualcommScanType("/sys/class/video4linux/v4l-subdev19/name");
        if (data == null || data.isEmpty()) {
            data = Barcode2DSoftCommon.ReadQualcommScanType("/sys/class/video4linux/v4l-subdev18/name");
        }
        return data;
    }

    public static String ReadQualcommScanType(String path) {
        File file = new File(path);
        String data = "";
        if (!file.exists()) {
            Log.d((String)TAG, (String)("ReadQualcommScanType ==> \u627e\u4e0d\u5230\u8def\u5f84:" + path));
            return null;
        }
        FileInputStream fis = null;
        InputStreamReader inputreader = null;
        BufferedReader buffreader = null;
        try {
            try {
                fis = new FileInputStream(file);
                inputreader = new InputStreamReader(fis);
                buffreader = new BufferedReader(inputreader);
                data = buffreader.readLine();
                Log.d((String)TAG, (String)("ReadFile ==> data=" + data));
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("ReadFile ==>ex=" + e.getMessage()));
                e.printStackTrace();
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    if (inputreader != null) {
                        inputreader.close();
                    }
                    if (buffreader != null) {
                        buffreader.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (inputreader != null) {
                    inputreader.close();
                }
                if (buffreader != null) {
                    buffreader.close();
                }
            }
            catch (Exception exception) {}
        }
        return data;
    }

    public static String ReadMTKScanType() {
        Log.i((String)TAG, (String)"-------ReadMTKScanType----------");
        String info = "";
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            try {
                File file = new File("/proc/wtk_cameraInfo");
                if (file.exists()) {
                    fis = new FileInputStream("/proc/wtk_cameraInfo");
                    isr = new InputStreamReader(fis);
                    br = new BufferedReader(isr, 4096);
                    info = br.readLine();
                    Log.i((String)TAG, (String)("ReadMTKScanType:" + info));
                }
            }
            catch (Exception ex) {
                Log.i((String)TAG, (String)("-------ReadMTKScanType----------ex=" + ex.getMessage()));
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    if (fis != null) {
                        isr.close();
                    }
                    if (fis != null) {
                        br.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (fis != null) {
                    isr.close();
                }
                if (fis != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
        }
        return info;
    }

    public static enum HARDWARE_TYPE {
        H_6603,
        MOTOROLA_4500,
        IA400S;

    }

    public static enum SCANNER_TYPE {
        H_6603,
        H_3601,
        MOTOROLA_4500,
        MOTOROLA_4750,
        MOTOROLA_4710,
        IA400S;

    }
}

