/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.OutputConfiguration;
import android.os.Handler;
import android.view.Surface;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import java.util.List;
import java.util.concurrent.Executor;

public abstract class CameraCaptureSession
implements AutoCloseable {
    @RecentlyNonNull
    public abstract CameraDevice getDevice();

    public abstract void prepare(@RecentlyNonNull Surface var1) throws CameraAccessException;

    public abstract void finalizeOutputConfigurations(List<OutputConfiguration> var1) throws CameraAccessException;

    public abstract int capture(@RecentlyNonNull CaptureRequest var1, @RecentlyNullable CaptureCallback var2, @RecentlyNullable Handler var3) throws CameraAccessException;

    public int captureSingleRequest(@RecentlyNonNull CaptureRequest request, @RecentlyNonNull Executor executor, @RecentlyNonNull CaptureCallback listener) throws CameraAccessException {
        throw new RuntimeException("Method captureSingleRequest in android.hardware.camera2.CameraCaptureSession not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public abstract int captureBurst(@RecentlyNonNull List<CaptureRequest> var1, @RecentlyNullable CaptureCallback var2, @RecentlyNullable Handler var3) throws CameraAccessException;

    public int captureBurstRequests(@RecentlyNonNull List<CaptureRequest> requests, @RecentlyNonNull Executor executor, @RecentlyNonNull CaptureCallback listener) throws CameraAccessException {
        throw new RuntimeException("Method captureBurstRequests in android.hardware.camera2.CameraCaptureSession not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public abstract int setRepeatingRequest(@RecentlyNonNull CaptureRequest var1, @RecentlyNullable CaptureCallback var2, @RecentlyNullable Handler var3) throws CameraAccessException;

    public int setSingleRepeatingRequest(@RecentlyNonNull CaptureRequest request, @RecentlyNonNull Executor executor, @RecentlyNonNull CaptureCallback listener) throws CameraAccessException {
        throw new RuntimeException("Method setSingleRepeatingRequest in android.hardware.camera2.CameraCaptureSession not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public abstract int setRepeatingBurst(@RecentlyNonNull List<CaptureRequest> var1, @RecentlyNullable CaptureCallback var2, @RecentlyNullable Handler var3) throws CameraAccessException;

    public int setRepeatingBurstRequests(@RecentlyNonNull List<CaptureRequest> requests, @RecentlyNonNull Executor executor, @RecentlyNonNull CaptureCallback listener) throws CameraAccessException {
        throw new RuntimeException("Method setRepeatingBurstRequests in android.hardware.camera2.CameraCaptureSession not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public abstract void stopRepeating() throws CameraAccessException;

    public abstract void abortCaptures() throws CameraAccessException;

    public abstract boolean isReprocessable();

    @RecentlyNullable
    public abstract Surface getInputSurface();

    public void updateOutputConfiguration(OutputConfiguration config) throws CameraAccessException {
        throw new RuntimeException("Method updateOutputConfiguration in android.hardware.camera2.CameraCaptureSession not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @Override
    public abstract void close();

    public static abstract class StateCallback {
        public abstract void onConfigured(@RecentlyNonNull CameraCaptureSession var1);

        public abstract void onConfigureFailed(@RecentlyNonNull CameraCaptureSession var1);

        public void onReady(@RecentlyNonNull CameraCaptureSession session) {
            throw new RuntimeException("Method onReady in android.hardware.camera2.CameraCaptureSession$StateCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public void onActive(@RecentlyNonNull CameraCaptureSession session) {
            throw new RuntimeException("Method onActive in android.hardware.camera2.CameraCaptureSession$StateCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public void onCaptureQueueEmpty(@RecentlyNonNull CameraCaptureSession session) {
            throw new RuntimeException("Method onCaptureQueueEmpty in android.hardware.camera2.CameraCaptureSession$StateCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public void onClosed(@RecentlyNonNull CameraCaptureSession session) {
            throw new RuntimeException("Method onClosed in android.hardware.camera2.CameraCaptureSession$StateCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public void onSurfacePrepared(@RecentlyNonNull CameraCaptureSession session, @RecentlyNonNull Surface surface) {
            throw new RuntimeException("Method onSurfacePrepared in android.hardware.camera2.CameraCaptureSession$StateCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }
    }

    public static abstract class CaptureCallback {
        public void onCaptureStarted(@RecentlyNonNull CameraCaptureSession session, @RecentlyNonNull CaptureRequest request, long timestamp, long frameNumber) {
            throw new RuntimeException("Method onCaptureStarted in android.hardware.camera2.CameraCaptureSession$CaptureCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public void onCaptureProgressed(@RecentlyNonNull CameraCaptureSession session, @RecentlyNonNull CaptureRequest request, @RecentlyNonNull CaptureResult partialResult) {
            throw new RuntimeException("Method onCaptureProgressed in android.hardware.camera2.CameraCaptureSession$CaptureCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public void onCaptureCompleted(@RecentlyNonNull CameraCaptureSession session, @RecentlyNonNull CaptureRequest request, @RecentlyNonNull TotalCaptureResult result) {
            throw new RuntimeException("Method onCaptureCompleted in android.hardware.camera2.CameraCaptureSession$CaptureCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public void onCaptureFailed(@RecentlyNonNull CameraCaptureSession session, @RecentlyNonNull CaptureRequest request, @RecentlyNonNull CaptureFailure failure) {
            throw new RuntimeException("Method onCaptureFailed in android.hardware.camera2.CameraCaptureSession$CaptureCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public void onCaptureSequenceCompleted(@RecentlyNonNull CameraCaptureSession session, int sequenceId, long frameNumber) {
            throw new RuntimeException("Method onCaptureSequenceCompleted in android.hardware.camera2.CameraCaptureSession$CaptureCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public void onCaptureSequenceAborted(@RecentlyNonNull CameraCaptureSession session, int sequenceId) {
            throw new RuntimeException("Method onCaptureSequenceAborted in android.hardware.camera2.CameraCaptureSession$CaptureCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public void onCaptureBufferLost(@RecentlyNonNull CameraCaptureSession session, @RecentlyNonNull CaptureRequest request, @RecentlyNonNull Surface target, long frameNumber) {
            throw new RuntimeException("Method onCaptureBufferLost in android.hardware.camera2.CameraCaptureSession$CaptureCallback not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }
    }
}

