/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioRouting;
import android.media.AudioTimestamp;
import android.media.MediaSyncEvent;
import android.media.MicrophoneInfo;
import android.os.Handler;
import android.os.PersistableBundle;
import androidx.annotation.RecentlyNonNull;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public class AudioRecord
implements AudioRouting {
    public static final int ERROR = -1;
    public static final int ERROR_BAD_VALUE = -2;
    public static final int ERROR_DEAD_OBJECT = -6;
    public static final int ERROR_INVALID_OPERATION = -3;
    public static final int READ_BLOCKING = 0;
    public static final int READ_NON_BLOCKING = 1;
    public static final int RECORDSTATE_RECORDING = 3;
    public static final int RECORDSTATE_STOPPED = 1;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_UNINITIALIZED = 0;
    public static final int SUCCESS = 0;

    public AudioRecord(int audioSource, int sampleRateInHz, int channelConfig, int audioFormat, int bufferSizeInBytes) throws IllegalArgumentException {
    }

    public void release() {
        throw new RuntimeException("Method release in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    protected void finalize() {
        throw new RuntimeException("Method finalize in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int getSampleRate() {
        throw new RuntimeException("Method getSampleRate in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int getAudioSource() {
        throw new RuntimeException("Method getAudioSource in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int getAudioFormat() {
        throw new RuntimeException("Method getAudioFormat in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int getChannelConfiguration() {
        throw new RuntimeException("Method getChannelConfiguration in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @RecentlyNonNull
    public AudioFormat getFormat() {
        throw new RuntimeException("Method getFormat in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int getChannelCount() {
        throw new RuntimeException("Method getChannelCount in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int getState() {
        throw new RuntimeException("Method getState in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int getRecordingState() {
        throw new RuntimeException("Method getRecordingState in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int getBufferSizeInFrames() {
        throw new RuntimeException("Method getBufferSizeInFrames in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int getNotificationMarkerPosition() {
        throw new RuntimeException("Method getNotificationMarkerPosition in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int getPositionNotificationPeriod() {
        throw new RuntimeException("Method getPositionNotificationPeriod in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int getTimestamp(@RecentlyNonNull AudioTimestamp outTimestamp, int timebase) {
        throw new RuntimeException("Method getTimestamp in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public static int getMinBufferSize(int sampleRateInHz, int channelConfig, int audioFormat) {
        throw new RuntimeException("Method getMinBufferSize in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int getAudioSessionId() {
        throw new RuntimeException("Method getAudioSessionId in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void startRecording() throws IllegalStateException {
        throw new RuntimeException("Method startRecording in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void startRecording(MediaSyncEvent syncEvent) throws IllegalStateException {
        throw new RuntimeException("Method startRecording in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void stop() throws IllegalStateException {
        throw new RuntimeException("Method stop in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int read(@RecentlyNonNull byte[] audioData, int offsetInBytes, int sizeInBytes) {
        throw new RuntimeException("Method read in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int read(@RecentlyNonNull byte[] audioData, int offsetInBytes, int sizeInBytes, int readMode) {
        throw new RuntimeException("Method read in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int read(@RecentlyNonNull short[] audioData, int offsetInShorts, int sizeInShorts) {
        throw new RuntimeException("Method read in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int read(@RecentlyNonNull short[] audioData, int offsetInShorts, int sizeInShorts, int readMode) {
        throw new RuntimeException("Method read in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int read(@RecentlyNonNull float[] audioData, int offsetInFloats, int sizeInFloats, int readMode) {
        throw new RuntimeException("Method read in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int read(@RecentlyNonNull ByteBuffer audioBuffer, int sizeInBytes) {
        throw new RuntimeException("Method read in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int read(@RecentlyNonNull ByteBuffer audioBuffer, int sizeInBytes, int readMode) {
        throw new RuntimeException("Method read in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public PersistableBundle getMetrics() {
        throw new RuntimeException("Method getMetrics in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void setRecordPositionUpdateListener(OnRecordPositionUpdateListener listener) {
        throw new RuntimeException("Method setRecordPositionUpdateListener in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void setRecordPositionUpdateListener(OnRecordPositionUpdateListener listener, Handler handler) {
        throw new RuntimeException("Method setRecordPositionUpdateListener in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int setNotificationMarkerPosition(int markerInFrames) {
        throw new RuntimeException("Method setNotificationMarkerPosition in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @Override
    public AudioDeviceInfo getRoutedDevice() {
        throw new RuntimeException("Method getRoutedDevice in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @Override
    public void addOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener, Handler handler) {
        throw new RuntimeException("Method addOnRoutingChangedListener in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @Override
    public void removeOnRoutingChangedListener(AudioRouting.OnRoutingChangedListener listener) {
        throw new RuntimeException("Method removeOnRoutingChangedListener in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @Deprecated
    public void addOnRoutingChangedListener(OnRoutingChangedListener listener, Handler handler) {
        throw new RuntimeException("Method addOnRoutingChangedListener in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @Deprecated
    public void removeOnRoutingChangedListener(OnRoutingChangedListener listener) {
        throw new RuntimeException("Method removeOnRoutingChangedListener in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public int setPositionNotificationPeriod(int periodInFrames) {
        throw new RuntimeException("Method setPositionNotificationPeriod in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @Override
    public boolean setPreferredDevice(AudioDeviceInfo deviceInfo) {
        throw new RuntimeException("Method setPreferredDevice in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @Override
    public AudioDeviceInfo getPreferredDevice() {
        throw new RuntimeException("Method getPreferredDevice in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public List<MicrophoneInfo> getActiveMicrophones() throws IOException {
        throw new RuntimeException("Method getActiveMicrophones in android.media.AudioRecord not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @Deprecated
    public static interface OnRoutingChangedListener
    extends AudioRouting.OnRoutingChangedListener {
        public void onRoutingChanged(AudioRecord var1);

        @Override
        default public void onRoutingChanged(AudioRouting router) {
            throw new RuntimeException("Method onRoutingChanged in android.media.AudioRecord$OnRoutingChangedListener not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }
    }

    public static interface OnRecordPositionUpdateListener {
        public void onMarkerReached(AudioRecord var1);

        public void onPeriodicNotification(AudioRecord var1);
    }

    public static class MetricsConstants {
        public static final String CHANNELS = "android.media.audiorecord.channels";
        public static final String ENCODING = "android.media.audiorecord.encoding";
        public static final String LATENCY = "android.media.audiorecord.latency";
        public static final String SAMPLERATE = "android.media.audiorecord.samplerate";
        public static final String SOURCE = "android.media.audiorecord.source";

        MetricsConstants() {
        }
    }

    public static class Builder {
        public Builder setAudioSource(int source) throws IllegalArgumentException {
            throw new RuntimeException("Method setAudioSource in android.media.AudioRecord$Builder not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public Builder setAudioFormat(@RecentlyNonNull AudioFormat format) throws IllegalArgumentException {
            throw new RuntimeException("Method setAudioFormat in android.media.AudioRecord$Builder not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public Builder setBufferSizeInBytes(int bufferSizeInBytes) throws IllegalArgumentException {
            throw new RuntimeException("Method setBufferSizeInBytes in android.media.AudioRecord$Builder not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public AudioRecord build() throws UnsupportedOperationException {
            throw new RuntimeException("Method build in android.media.AudioRecord$Builder not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }
    }
}

