/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.DeniedByServerException;
import android.media.NotProvisionedException;
import android.media.ResourceBusyException;
import android.media.UnsupportedSchemeException;
import android.os.Handler;
import android.os.PersistableBundle;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class MediaDrm
implements AutoCloseable {
    @Deprecated
    public static final int EVENT_KEY_EXPIRED = 3;
    public static final int EVENT_KEY_REQUIRED = 2;
    @Deprecated
    public static final int EVENT_PROVISION_REQUIRED = 1;
    public static final int EVENT_SESSION_RECLAIMED = 5;
    public static final int EVENT_VENDOR_DEFINED = 4;
    public static final int HDCP_LEVEL_UNKNOWN = 0;
    public static final int HDCP_NONE = 1;
    public static final int HDCP_NO_DIGITAL_OUTPUT = Integer.MAX_VALUE;
    public static final int HDCP_V1 = 2;
    public static final int HDCP_V2 = 3;
    public static final int HDCP_V2_1 = 4;
    public static final int HDCP_V2_2 = 5;
    public static final int KEY_TYPE_OFFLINE = 2;
    public static final int KEY_TYPE_RELEASE = 3;
    public static final int KEY_TYPE_STREAMING = 1;
    public static final String PROPERTY_ALGORITHMS = "algorithms";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_DEVICE_UNIQUE_ID = "deviceUniqueId";
    public static final String PROPERTY_VENDOR = "vendor";
    public static final String PROPERTY_VERSION = "version";
    public static final int SECURITY_LEVEL_HW_SECURE_ALL = 5;
    public static final int SECURITY_LEVEL_HW_SECURE_CRYPTO = 3;
    public static final int SECURITY_LEVEL_HW_SECURE_DECODE = 4;
    public static final int SECURITY_LEVEL_SW_SECURE_CRYPTO = 1;
    public static final int SECURITY_LEVEL_SW_SECURE_DECODE = 2;
    public static final int SECURITY_LEVEL_UNKNOWN = 0;

    public MediaDrm(@RecentlyNonNull UUID uuid) throws UnsupportedSchemeException {
    }

    public static boolean isCryptoSchemeSupported(@RecentlyNonNull UUID uuid) {
        throw new RuntimeException("Method isCryptoSchemeSupported in android.media.MediaDrm not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public static boolean isCryptoSchemeSupported(@RecentlyNonNull UUID uuid, @RecentlyNonNull String mimeType) {
        throw new RuntimeException("Method isCryptoSchemeSupported in android.media.MediaDrm not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void setOnExpirationUpdateListener(@RecentlyNullable OnExpirationUpdateListener listener, @RecentlyNullable Handler handler) {
        throw new RuntimeException("Method setOnExpirationUpdateListener in android.media.MediaDrm not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void setOnKeyStatusChangeListener(@RecentlyNullable OnKeyStatusChangeListener listener, @RecentlyNullable Handler handler) {
        throw new RuntimeException("Method setOnKeyStatusChangeListener in android.media.MediaDrm not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void setOnEventListener(@RecentlyNullable OnEventListener listener) {
        throw new RuntimeException("Method setOnEventListener in android.media.MediaDrm not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @RecentlyNonNull
    public byte[] openSession() throws NotProvisionedException, ResourceBusyException {
        throw new RuntimeException("Method openSession in android.media.MediaDrm not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @RecentlyNonNull
    public native byte[] openSession(int var1) throws NotProvisionedException, ResourceBusyException;

    public native void closeSession(@RecentlyNonNull byte[] var1);

    @RecentlyNonNull
    public native KeyRequest getKeyRequest(@RecentlyNonNull byte[] var1, @RecentlyNullable byte[] var2, @RecentlyNullable String var3, int var4, @RecentlyNullable HashMap<String, String> var5) throws NotProvisionedException;

    @RecentlyNullable
    public native byte[] provideKeyResponse(@RecentlyNonNull byte[] var1, @RecentlyNonNull byte[] var2) throws DeniedByServerException, NotProvisionedException;

    public native void restoreKeys(@RecentlyNonNull byte[] var1, @RecentlyNonNull byte[] var2);

    public native void removeKeys(@RecentlyNonNull byte[] var1);

    @RecentlyNonNull
    public native HashMap<String, String> queryKeyStatus(@RecentlyNonNull byte[] var1);

    @RecentlyNonNull
    public ProvisionRequest getProvisionRequest() {
        throw new RuntimeException("Method getProvisionRequest in android.media.MediaDrm not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public void provideProvisionResponse(@RecentlyNonNull byte[] response) throws DeniedByServerException {
        throw new RuntimeException("Method provideProvisionResponse in android.media.MediaDrm not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @RecentlyNonNull
    public native List<byte[]> getSecureStops();

    @RecentlyNonNull
    public native List<byte[]> getSecureStopIds();

    @RecentlyNonNull
    public native byte[] getSecureStop(@RecentlyNonNull byte[] var1);

    public native void releaseSecureStops(@RecentlyNonNull byte[] var1);

    public native void removeSecureStop(@RecentlyNonNull byte[] var1);

    public native void removeAllSecureStops();

    @Deprecated
    public void releaseAllSecureStops() {
        throw new RuntimeException("Method releaseAllSecureStops in android.media.MediaDrm not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public native int getConnectedHdcpLevel();

    public native int getMaxHdcpLevel();

    public native int getOpenSessionCount();

    public native int getMaxSessionCount();

    public static int getMaxSecurityLevel() {
        throw new RuntimeException("Method getMaxSecurityLevel in android.media.MediaDrm not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public native int getSecurityLevel(@RecentlyNonNull byte[] var1);

    @RecentlyNonNull
    public native String getPropertyString(@RecentlyNonNull String var1);

    public native void setPropertyString(@RecentlyNonNull String var1, @RecentlyNonNull String var2);

    @RecentlyNonNull
    public native byte[] getPropertyByteArray(String var1);

    public native void setPropertyByteArray(@RecentlyNonNull String var1, @RecentlyNonNull byte[] var2);

    public PersistableBundle getMetrics() {
        throw new RuntimeException("Method getMetrics in android.media.MediaDrm not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    public CryptoSession getCryptoSession(@RecentlyNonNull byte[] sessionId, @RecentlyNonNull String cipherAlgorithm, @RecentlyNonNull String macAlgorithm) {
        throw new RuntimeException("Method getCryptoSession in android.media.MediaDrm not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    protected void finalize() throws Throwable {
        throw new RuntimeException("Method finalize in android.media.MediaDrm not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @Override
    public void close() {
        throw new RuntimeException("Method close in android.media.MediaDrm not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @Deprecated
    public void release() {
        throw new RuntimeException("Method release in android.media.MediaDrm not mocked. See http://g.co/androidstudio/not-mocked for details.");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SecurityLevel {
    }

    public static class ProvisionRequest {
        ProvisionRequest() {
        }

        @RecentlyNonNull
        public byte[] getData() {
            throw new RuntimeException("Method getData in android.media.MediaDrm$ProvisionRequest not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        @RecentlyNonNull
        public String getDefaultUrl() {
            throw new RuntimeException("Method getDefaultUrl in android.media.MediaDrm$ProvisionRequest not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }
    }

    public static interface OnKeyStatusChangeListener {
        public void onKeyStatusChange(@RecentlyNonNull MediaDrm var1, @RecentlyNonNull byte[] var2, @RecentlyNonNull List<KeyStatus> var3, boolean var4);
    }

    public static interface OnExpirationUpdateListener {
        public void onExpirationUpdate(@RecentlyNonNull MediaDrm var1, @RecentlyNonNull byte[] var2, long var3);
    }

    public static interface OnEventListener {
        public void onEvent(@RecentlyNonNull MediaDrm var1, @RecentlyNullable byte[] var2, int var3, int var4, @RecentlyNullable byte[] var5);
    }

    public static class MetricsConstants {
        public static final String CLOSE_SESSION_ERROR_COUNT = "drm.mediadrm.close_session.error.count";
        public static final String CLOSE_SESSION_ERROR_LIST = "drm.mediadrm.close_session.error.list";
        public static final String CLOSE_SESSION_OK_COUNT = "drm.mediadrm.close_session.ok.count";
        public static final String EVENT_KEY_EXPIRED_COUNT = "drm.mediadrm.event.KEY_EXPIRED.count";
        public static final String EVENT_KEY_NEEDED_COUNT = "drm.mediadrm.event.KEY_NEEDED.count";
        public static final String EVENT_PROVISION_REQUIRED_COUNT = "drm.mediadrm.event.PROVISION_REQUIRED.count";
        public static final String EVENT_SESSION_RECLAIMED_COUNT = "drm.mediadrm.event.SESSION_RECLAIMED.count";
        public static final String EVENT_VENDOR_DEFINED_COUNT = "drm.mediadrm.event.VENDOR_DEFINED.count";
        public static final String GET_DEVICE_UNIQUE_ID_ERROR_COUNT = "drm.mediadrm.get_device_unique_id.error.count";
        public static final String GET_DEVICE_UNIQUE_ID_ERROR_LIST = "drm.mediadrm.get_device_unique_id.error.list";
        public static final String GET_DEVICE_UNIQUE_ID_OK_COUNT = "drm.mediadrm.get_device_unique_id.ok.count";
        public static final String GET_KEY_REQUEST_ERROR_COUNT = "drm.mediadrm.get_key_request.error.count";
        public static final String GET_KEY_REQUEST_ERROR_LIST = "drm.mediadrm.get_key_request.error.list";
        public static final String GET_KEY_REQUEST_OK_COUNT = "drm.mediadrm.get_key_request.ok.count";
        public static final String GET_KEY_REQUEST_OK_TIME_MICROS = "drm.mediadrm.get_key_request.ok.average_time_micros";
        public static final String GET_PROVISION_REQUEST_ERROR_COUNT = "drm.mediadrm.get_provision_request.error.count";
        public static final String GET_PROVISION_REQUEST_ERROR_LIST = "drm.mediadrm.get_provision_request.error.list";
        public static final String GET_PROVISION_REQUEST_OK_COUNT = "drm.mediadrm.get_provision_request.ok.count";
        public static final String KEY_STATUS_EXPIRED_COUNT = "drm.mediadrm.key_status.EXPIRED.count";
        public static final String KEY_STATUS_INTERNAL_ERROR_COUNT = "drm.mediadrm.key_status.INTERNAL_ERROR.count";
        public static final String KEY_STATUS_OUTPUT_NOT_ALLOWED_COUNT = "drm.mediadrm.key_status_change.OUTPUT_NOT_ALLOWED.count";
        public static final String KEY_STATUS_PENDING_COUNT = "drm.mediadrm.key_status_change.PENDING.count";
        public static final String KEY_STATUS_USABLE_COUNT = "drm.mediadrm.key_status_change.USABLE.count";
        public static final String OPEN_SESSION_ERROR_COUNT = "drm.mediadrm.open_session.error.count";
        public static final String OPEN_SESSION_ERROR_LIST = "drm.mediadrm.open_session.error.list";
        public static final String OPEN_SESSION_OK_COUNT = "drm.mediadrm.open_session.ok.count";
        public static final String PROVIDE_KEY_RESPONSE_ERROR_COUNT = "drm.mediadrm.provide_key_response.error.count";
        public static final String PROVIDE_KEY_RESPONSE_ERROR_LIST = "drm.mediadrm.provide_key_response.error.list";
        public static final String PROVIDE_KEY_RESPONSE_OK_COUNT = "drm.mediadrm.provide_key_response.ok.count";
        public static final String PROVIDE_KEY_RESPONSE_OK_TIME_MICROS = "drm.mediadrm.provide_key_response.ok.average_time_micros";
        public static final String PROVIDE_PROVISION_RESPONSE_ERROR_COUNT = "drm.mediadrm.provide_provision_response.error.count";
        public static final String PROVIDE_PROVISION_RESPONSE_ERROR_LIST = "drm.mediadrm.provide_provision_response.error.list";
        public static final String PROVIDE_PROVISION_RESPONSE_OK_COUNT = "drm.mediadrm.provide_provision_response.ok.count";
        public static final String SESSION_END_TIMES_MS = "drm.mediadrm.session_end_times_ms";
        public static final String SESSION_START_TIMES_MS = "drm.mediadrm.session_start_times_ms";

        MetricsConstants() {
        }
    }

    public static class MediaDrmStateException
    extends IllegalStateException {
        MediaDrmStateException(int errorCode, String detailMessage) {
        }

        @RecentlyNonNull
        public String getDiagnosticInfo() {
            throw new RuntimeException("Method getDiagnosticInfo in android.media.MediaDrm$MediaDrmStateException not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }
    }

    public static class KeyStatus {
        public static final int STATUS_EXPIRED = 1;
        public static final int STATUS_INTERNAL_ERROR = 4;
        public static final int STATUS_OUTPUT_NOT_ALLOWED = 2;
        public static final int STATUS_PENDING = 3;
        public static final int STATUS_USABLE = 0;

        KeyStatus(byte[] keyId, int statusCode) {
        }

        public int getStatusCode() {
            throw new RuntimeException("Method getStatusCode in android.media.MediaDrm$KeyStatus not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        @RecentlyNonNull
        public byte[] getKeyId() {
            throw new RuntimeException("Method getKeyId in android.media.MediaDrm$KeyStatus not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }
    }

    public static class KeyRequest {
        public static final int REQUEST_TYPE_INITIAL = 0;
        public static final int REQUEST_TYPE_NONE = 3;
        public static final int REQUEST_TYPE_RELEASE = 2;
        public static final int REQUEST_TYPE_RENEWAL = 1;
        public static final int REQUEST_TYPE_UPDATE = 4;

        KeyRequest() {
        }

        @RecentlyNonNull
        public byte[] getData() {
            throw new RuntimeException("Method getData in android.media.MediaDrm$KeyRequest not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        @RecentlyNonNull
        public String getDefaultUrl() {
            throw new RuntimeException("Method getDefaultUrl in android.media.MediaDrm$KeyRequest not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public int getRequestType() {
            throw new RuntimeException("Method getRequestType in android.media.MediaDrm$KeyRequest not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HdcpLevel {
    }

    public class CryptoSession {
        final /* synthetic */ MediaDrm this$0;

        /*
         * WARNING - void declaration
         */
        CryptoSession(MediaDrm this$0, byte[] sessionId, String cipherAlgorithm, String macAlgorithm) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @RecentlyNonNull
        public byte[] encrypt(@RecentlyNonNull byte[] keyid, @RecentlyNonNull byte[] input, @RecentlyNonNull byte[] iv) {
            throw new RuntimeException("Method encrypt in android.media.MediaDrm$CryptoSession not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        @RecentlyNonNull
        public byte[] decrypt(@RecentlyNonNull byte[] keyid, @RecentlyNonNull byte[] input, @RecentlyNonNull byte[] iv) {
            throw new RuntimeException("Method decrypt in android.media.MediaDrm$CryptoSession not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        @RecentlyNonNull
        public byte[] sign(@RecentlyNonNull byte[] keyid, @RecentlyNonNull byte[] message) {
            throw new RuntimeException("Method sign in android.media.MediaDrm$CryptoSession not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }

        public boolean verify(@RecentlyNonNull byte[] keyid, @RecentlyNonNull byte[] message, @RecentlyNonNull byte[] signature) {
            throw new RuntimeException("Method verify in android.media.MediaDrm$CryptoSession not mocked. See http://g.co/androidstudio/not-mocked for details.");
        }
    }
}

