/*
 * Decompiled with CFR 0.152.
 */
package com.imagealgorithmlab.barcode.camera;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Vibrator;
import android.text.TextUtils;
import android.view.Display;
import android.view.WindowManager;
import com.imagealgorithmlab.barcode.AEData;
import com.imagealgorithmlab.barcode.AEMgr;
import com.imagealgorithmlab.barcode.DecodeEngine;
import com.imagealgorithmlab.barcode.SaveMode;
import com.imagealgorithmlab.barcode.SymbologyData;
import com.imagealgorithmlab.barcode.camera.f;
import com.imagealgorithmlab.barcode.camera.g;
import com.imagealgorithmlab.barcode.e;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class DecoderLibrary {
    private static DecoderLibrary decoderLibrary = null;
    private ConditionVariable mConditionVariable;
    private ConditionVariable mConditionVariable2;
    private Context cxt;
    private boolean mPreviewStarted;
    private CameraType mCameraType;
    private Resolution mResolution;
    private Focus mFocusMode;
    private boolean cameraPreviewOn;
    private b cameraManagerInterface;
    private HandlerThread mCameraBackgroundThread;
    private Handler mCameraBackgroundHandler;
    private HandlerThread mDecodeTimeOutThread;
    private Handler mDecodeTimeOutHandler;
    private HandlerThread mImageBackgroundThread;
    private Handler mImageBackgroundHandler;
    private HandlerThread mDecodeBackgroundThread;
    private Handler mDecodeBackgroundHandler;
    private HandlerThread mTimeOutBackgroudThread;
    private Handler mTimeOutBackgroundHandler;
    private Handler mRequestLayoutHandler;
    private Handler mBackgroundHandler;
    private long timeOutWaitingClose = 5000L;
    private long timeOutWaitingOpen = 1500L;
    private long timeOutWaitingFor1920x1080 = 100L;
    private long timeOutWaitingForOtherResolution = 50L;
    private boolean syncOn;
    private Handler autoFocusHandler;
    private long circleAutoFocusTime = 500L;
    private AEMgr aeMgr;
    private SaveMode saveMode;
    private Vibrator mVibrator;
    private long timeOutForkill = 300L;
    private boolean isTimeOut;
    private int initIllAvg = 50;
    private int defaultIllAvg = 50;
    private int currentIllAvg = 50;
    private long decodeTimeOut = 2000L;
    private long openCameraTime = 0L;
    private SurfaceTexture surfaceTexture;
    private DecoderLibraryCallBack previewFrameCallBack;
    private DecodeLibraryTimeoutCallBack decodeTimeoutCallBack;
    private boolean needAE;
    private boolean torchOn;
    private boolean aimerOn;
    private final byte[] preivewBuf = new byte[3110400];
    private Object obj;
    private Object obj2;
    private boolean singleScan;
    private boolean multiScan;
    private BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (DecoderLibrary.this.cameraManagerInterface.m()) {
                if (DecoderLibrary.this.singleScan) {
                    DecoderLibrary.this.startDecoding();
                } else if (DecoderLibrary.this.multiScan) {
                    if (DecoderLibrary.this.getDecodeState()) {
                        DecoderLibrary.this.stopDecoding();
                    } else {
                        DecoderLibrary.this.startDecoding();
                    }
                }
            }
        }
    };
    private boolean needBroadcast = false;
    private long tt1;

    public static DecoderLibrary sharedObject(Context context) {
        if (decoderLibrary == null) {
            decoderLibrary = new DecoderLibrary(context);
        }
        return decoderLibrary;
    }

    private DecoderLibrary(Context context) {
        this.obj = new Object();
        this.obj2 = new Object();
        this.cxt = context;
        this.syncOn = false;
        this.mResolution = Resolution.Resolution_1280x800;
        this.mConditionVariable = new ConditionVariable(true);
        this.mConditionVariable2 = new ConditionVariable(true);
        this.mCameraType = CameraType.Camera0;
        this.cameraPreviewOn = false;
        this.mPreviewStarted = false;
        this.torchOn = false;
        this.aimerOn = false;
        this.needAE = false;
        this.mFocusMode = Focus.Focus_Normal;
        this.defaultIllAvg = this.initIllAvg;
        this.currentIllAvg = this.initIllAvg;
        this.mVibrator = (Vibrator)context.getSystemService("vibrator");
        this.surfaceTexture = new SurfaceTexture(10);
        this.mBackgroundHandler = new Handler(Looper.getMainLooper());
        this.mRequestLayoutHandler = new Handler(Looper.getMainLooper());
        this.autoFocusHandler = new Handler();
        this.startBackgroundThread();
        this.startTimeoutThread();
        this.startImageThread();
        this.startDecodeTimeOutThread();
        this.cameraManagerInterface = new a();
        this.aeMgr = new AEMgr();
        this.aeMgr.initialize(0, 50, 0, 56, 90);
        this.saveMode = SaveMode.NOTSAVE;
        this.singleScan = true;
        this.multiScan = false;
    }

    public void registerBroadcastReceiver(String ... stringArray) {
        IntentFilter intentFilter = new IntentFilter();
        for (String string : stringArray) {
            intentFilter.addAction(string);
        }
        this.cxt.registerReceiver(this.receiver, intentFilter);
        this.needBroadcast = true;
    }

    public void unregisterBroadcastReceiver() {
        if (this.needBroadcast) {
            this.cxt.unregisterReceiver(this.receiver);
        }
    }

    public void setDefulatIllAvg(int n) {
        this.currentIllAvg = this.defaultIllAvg = n;
        this.initIllAvg = this.defaultIllAvg;
    }

    public void setSingleScan() {
        this.singleScan = true;
        this.multiScan = false;
    }

    public void setMultiScan() {
        this.singleScan = false;
        this.multiScan = true;
    }

    public int getCameraType() {
        return this.mCameraType.getVal();
    }

    public boolean getDecodeState() {
        return this.cameraManagerInterface.c();
    }

    public boolean getSingleScanState() {
        return this.singleScan;
    }

    public boolean getMultiScanState() {
        return this.multiScan;
    }

    public void setSaveMode(SaveMode saveMode) {
        this.saveMode = saveMode;
    }

    public SaveMode getSaveMode() {
        return this.saveMode;
    }

    public void setDecodeTimeout(long l) {
        this.timeOutForkill = l;
    }

    public void setTimeout(long l) {
        this.decodeTimeOut = l;
    }

    public void torchOn() {
        this.aeMgr.setFlashOn(true);
    }

    public void torchOff() {
        this.aeMgr.setFlashOn(false);
    }

    public void aimerOn() {
        this.aeMgr.setAimerOn(true);
    }

    public void aimerOff() {
        this.aeMgr.setAimerOn(false);
    }

    private void backgroundHandler(Runnable runnable) {
        if (this.mBackgroundHandler != null) {
            com.imagealgorithmlab.barcode.camera.b.b("DL", "this.mBackgroundHandler.post(runnable):" + runnable);
            this.mBackgroundHandler.post(runnable);
        } else {
            com.imagealgorithmlab.barcode.camera.b.b("DL", "mBackgroundHandler is null!");
        }
    }

    private void cameraBackgroundHandler(Runnable runnable) {
        if (this.mCameraBackgroundHandler != null) {
            com.imagealgorithmlab.barcode.camera.b.b("DL", "this.mCameraBackgroundHandler.post(runnable):" + runnable);
            this.mCameraBackgroundHandler.post(runnable);
        } else {
            com.imagealgorithmlab.barcode.camera.b.b("DL", "mCameraBackgroundHandler is null!");
        }
    }

    public long getOpenCameraTime() {
        return this.openCameraTime;
    }

    public void circleAutoFocus() {
        this.sharedObject();
        this.cameraManagerInterface.a();
    }

    public void closeSharedObject() {
        com.imagealgorithmlab.barcode.camera.b.b("DL", "closeSharedObject()");
        this.sharedObject();
        this.closeCamera();
        this.unregisterBroadcastReceiver();
        decoderLibrary = null;
    }

    public Focus getmFocusMode() {
        return this.mFocusMode;
    }

    public synchronized void stopBackgroundThread() {
        com.imagealgorithmlab.barcode.camera.b.b("DL", "stopBackgroundThread()");
        if (this.mBackgroundHandler != null) {
            HandlerThread handlerThread = this.mCameraBackgroundThread;
            if (handlerThread != null) {
                this.mBackgroundHandler.post((Runnable)new com.imagealgorithmlab.barcode.camera.e(this, this.mCameraBackgroundThread));
            }
            this.mBackgroundHandler = null;
            this.mCameraBackgroundThread = null;
        }
    }

    public synchronized void startBackgroundThread() {
        com.imagealgorithmlab.barcode.camera.b.b("DL", "startBackgroundThread()");
        if (this.mCameraBackgroundThread != null) {
            com.imagealgorithmlab.barcode.camera.b.b("DL", "Background thread already started!");
        } else {
            this.mCameraBackgroundThread = new HandlerThread("CameraBackground", 10);
            this.mCameraBackgroundThread.start();
            this.mCameraBackgroundHandler = new Handler(this.mCameraBackgroundThread.getLooper());
            com.imagealgorithmlab.barcode.camera.b.b("DL", "startDecodeBackgroundThread()");
            if (this.mDecodeBackgroundThread != null) {
                com.imagealgorithmlab.barcode.camera.b.b("DL", "The Decode thread already started!");
            } else {
                this.mDecodeBackgroundThread = new HandlerThread("DoDocodeBackground", 10);
                this.mDecodeBackgroundThread.start();
                this.mDecodeBackgroundHandler = new Handler(this.mDecodeBackgroundThread.getLooper());
            }
        }
    }

    public synchronized void startImageThread() {
        com.imagealgorithmlab.barcode.camera.b.b("DL", "startImageThread()");
        if (this.mImageBackgroundThread != null) {
            com.imagealgorithmlab.barcode.camera.b.b("DL", "save Image thread already started!");
        } else {
            this.mImageBackgroundThread = new HandlerThread("ImageBackground", 10);
            this.mImageBackgroundThread.start();
            this.mImageBackgroundHandler = new Handler(this.mImageBackgroundThread.getLooper());
        }
    }

    public void setTimeoutCallback(DecodeLibraryTimeoutCallBack decodeLibraryTimeoutCallBack) {
        com.imagealgorithmlab.barcode.camera.b.b("DL", "setTimeoutCallback(" + decodeLibraryTimeoutCallBack + ")");
        this.sharedObject();
        this.decodeTimeoutCallBack = decodeLibraryTimeoutCallBack;
    }

    public synchronized void startDecodeTimeOutThread() {
        com.imagealgorithmlab.barcode.camera.b.b("DL", "startDecodeTimeOutThread()");
        if (this.mDecodeTimeOutThread != null) {
            com.imagealgorithmlab.barcode.camera.b.b("DL", "decode time out thread already started!");
        } else {
            this.mDecodeTimeOutThread = new HandlerThread("DecodeTimeOutBackground", 10);
            this.mDecodeTimeOutThread.start();
            this.mDecodeTimeOutHandler = new Handler(this.mDecodeTimeOutThread.getLooper());
        }
    }

    public synchronized void startTimeoutThread() {
        if (this.mTimeOutBackgroudThread != null) {
            com.imagealgorithmlab.barcode.camera.b.b("DL", "time out thread already started!");
        } else {
            this.mTimeOutBackgroudThread = new HandlerThread("timeOutThread", 10);
            this.mTimeOutBackgroudThread.start();
            this.mTimeOutBackgroundHandler = new Handler(this.mTimeOutBackgroudThread.getLooper());
        }
    }

    public void setPreviewResolution(Resolution resolution) {
        this.sharedObject();
        this.cameraManagerInterface.a(resolution);
    }

    public List<Camera.CameraInfo> getCameras() {
        ArrayList<Camera.CameraInfo> arrayList = new ArrayList<Camera.CameraInfo>();
        int n = Camera.getNumberOfCameras();
        for (int i = 0; i < n; ++i) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            arrayList.add(cameraInfo);
        }
        return arrayList;
    }

    public void setZoomValue(int n) {
        this.sharedObject();
        this.cameraManagerInterface.a(n);
    }

    public void setExposureValue(int n) {
        this.sharedObject();
        this.cameraManagerInterface.b(n);
    }

    public int getMaxZoom() {
        return this.cameraManagerInterface.g();
    }

    public void setTorch(boolean bl) {
        this.torchOn = bl;
    }

    public void setAE(boolean bl) {
        this.needAE = bl;
        if (!bl) {
            this.defaultIllAvg = this.initIllAvg;
            this.currentIllAvg = this.initIllAvg;
        }
    }

    public void setAimer(boolean bl) {
        this.aimerOn = bl;
    }

    public void setLogMode(boolean bl) {
        if (bl) {
            com.imagealgorithmlab.barcode.camera.b.a(1);
        } else {
            com.imagealgorithmlab.barcode.camera.b.a(4);
        }
    }

    public boolean setCameraType(CameraType cameraType) {
        this.sharedObject();
        return this.cameraManagerInterface.b(cameraType);
    }

    private void isStartCameraPreview() {
        com.imagealgorithmlab.barcode.camera.b.b("DL", "this.cameraPreviewOn:" + this.cameraPreviewOn + " this.mPreviewStarted:" + this.mPreviewStarted);
        if (this.cameraPreviewOn && !this.mPreviewStarted) {
            this.startCameraPreview();
        }
    }

    public void startCameraPreview() {
        com.imagealgorithmlab.barcode.camera.b.b("DL", "startCameraPreview()");
        this.sharedObject();
        this.cameraManagerInterface.e();
    }

    public void stopCameraPreview() {
        this.sharedObject();
        this.cameraManagerInterface.b(this.syncOn);
    }

    public void closeCamera() {
        com.imagealgorithmlab.barcode.camera.b.b("DL", "closeCamera()");
        this.sharedObject();
        this.stopDecoding();
        this.stopCameraPreview();
        this.cameraManagerInterface.a(this.syncOn);
    }

    private void sharedObject() {
        if (decoderLibrary == null) {
            com.imagealgorithmlab.barcode.camera.b.b("DL", "Shared object has already been closed!");
            throw new IllegalStateException("Shared object has already been closed!");
        }
    }

    public synchronized void stopDecoding() {
        com.imagealgorithmlab.barcode.camera.b.b("DL", "stopDecoding()");
        this.sharedObject();
        this.cameraManagerInterface.i();
    }

    public void startDecoding() {
        if (this.aimerOn) {
            this.aimerOn();
        }
        if (this.torchOn) {
            this.torchOn();
        }
        if (this.needAE) {
            this.aeMgr.beginAE();
        }
        this.tt1 = System.currentTimeMillis();
        com.imagealgorithmlab.barcode.camera.b.b("DL", "startDecoding()");
        this.sharedObject();
        this.cameraManagerInterface.h();
    }

    public void setCallback(DecoderLibraryCallBack decoderLibraryCallBack) {
        com.imagealgorithmlab.barcode.camera.b.b("DL", "setCallback(" + decoderLibraryCallBack + ")");
        this.sharedObject();
        this.previewFrameCallBack = decoderLibraryCallBack;
    }

    private d setResolution(Resolution resolution) {
        switch (resolution) {
            case Resolution_1920x1080: {
                return new d(1920, 1080);
            }
            case Resolution_1280x720: {
                return new d(1280, 720);
            }
            case Resolution_1280x960: {
                return new d(1280, 960);
            }
            case Resolution_640x480: {
                return new d(640, 480);
            }
            case Resolution_352x288: {
                return new d(352, 288);
            }
            case Resolution_1208x800: {
                return new d(1208, 800);
            }
            case Resolution_1280x800: {
                return new d(1280, 800);
            }
            case Resolution_4160x3120: {
                return new d(4160, 3120);
            }
        }
        com.imagealgorithmlab.barcode.camera.b.b("DL", "Unknown value for resolution:" + (Object)((Object)resolution));
        return new d(0, 0);
    }

    static /* synthetic */ Handler access$3200(DecoderLibrary decoderLibrary) {
        return decoderLibrary.mImageBackgroundHandler;
    }

    public static enum Focus {
        Focus_Normal,
        Focus_Fix_Normal,
        Focus_Far,
        Focus_Fix_Far;

    }

    public static enum Resolution {
        Resolution_1920x1080,
        Resolution_1280x720,
        Resolution_640x480,
        Resolution_1208x800,
        Resolution_1280x800,
        Resolution_1280x960,
        Resolution_4160x3120,
        Resolution_352x288;

    }

    public static class d {
        public static int a;
        public static int b;

        public d(int n, int n2) {
            a = n;
            b = n2;
        }

        public String toString() {
            return a + "x" + b;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (object == null) return false;
            if (!(object instanceof d)) return false;
            d d2 = (d)object;
            if (a != a) return false;
            if (b != b) return false;
            return true;
        }
    }

    public static enum CameraType {
        Camera0(0),
        Camera1(1),
        Camera2(2);

        private int mVal;

        private CameraType(int n2) {
            this.mVal = n2;
        }

        public int getVal() {
            return this.mVal;
        }
    }

    public static interface DecodeLibraryTimeoutCallBack {
        public void timeoutCallBack();
    }

    public static interface DecoderLibraryCallBack {
        public void receivedDecodedData(SymbologyData var1);
    }

    private static interface b {
        public void e();

        public boolean k();

        public void h();

        public void i();

        public void b(boolean var1);

        public void a(boolean var1);

        public void a();

        public boolean b(CameraType var1);

        public void a(int var1);

        public void b(int var1);

        public int g();

        public void a(Resolution var1);

        public boolean c();

        public boolean m();
    }

    public class com.imagealgorithmlab.barcode.camera.DecoderLibrary$a
    implements Camera.PreviewCallback,
    com.imagealgorithmlab.barcode.camera.DecoderLibrary$b {
        private Camera c;
        private final Object d = new Object();
        private final Object e = new Object();
        private List f = null;
        private List g;
        private boolean h;
        Camera.AutoFocusCallback a;
        private int i;
        private boolean j;
        private volatile boolean k;
        private boolean l = true;
        private int m = 0;

        private com.imagealgorithmlab.barcode.camera.DecoderLibrary$a() {
            this.a = new com.imagealgorithmlab.barcode.camera.a(DecoderLibrary.this, this);
            this.h = false;
            this.j = false;
            this.k = false;
        }

        @Override
        public void a() {
            DecoderLibrary.this.autoFocusHandler.postDelayed((Runnable)new com.imagealgorithmlab.barcode.camera.d(this), DecoderLibrary.this.circleAutoFocusTime);
        }

        @Override
        public void a(boolean bl) {
            com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "releaseCamera(synchronous " + bl + ")");
            if (this.c == null) {
                com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "releaseCamera(): camera already closed");
                DecoderLibrary.this.mConditionVariable.open();
            } else if (!DecoderLibrary.this.mConditionVariable.block(1L)) {
                com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "releaseCamera(): releaseCamera() already pending");
            } else {
                DecoderLibrary.this.mConditionVariable.close();
                if (bl) {
                    this.b();
                } else {
                    DecoderLibrary.this.cameraBackgroundHandler(new com.imagealgorithmlab.barcode.camera.c(this));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void b() {
            com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "releaseCameraSynchronous()");
            try {
                this.d();
                Object object = this.d;
                Object object2 = this.d;
                synchronized (object2) {
                    if (this.c == null) {
                        com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "releaseCamera(): camera already closed");
                        DecoderLibrary.this.mConditionVariable.open();
                        return;
                    }
                    DecoderLibrary.this.mConditionVariable.close();
                    com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "mCamera.setPreviewCallbackWithBuffer(null)");
                    this.c.setPreviewCallbackWithBuffer(null);
                    com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "mCamera.release()");
                    this.c.release();
                    this.c = null;
                    DecoderLibrary.this.mConditionVariable.open();
                }
            }
            catch (Exception exception) {
                com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "Error in releaseCameraSynchronous(): " + exception);
            }
        }

        @Override
        public boolean c() {
            return this.j;
        }

        public boolean a(CameraType cameraType) {
            int n = Camera.getNumberOfCameras();
            for (int i = 0; i < n; ++i) {
                Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
                if (i == 0 && cameraType == CameraType.Camera0) {
                    return true;
                }
                if (i == 1 && cameraType == CameraType.Camera1) {
                    return true;
                }
                if (cameraType != CameraType.Camera2 || i != 2) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean b(CameraType cameraType) {
            boolean bl;
            if (!this.a(cameraType)) {
                return false;
            }
            if (DecoderLibrary.this.mCameraType == cameraType) {
                DecoderLibrary.this.mCameraType = cameraType;
                return true;
            }
            boolean bl2 = DecoderLibrary.this.cameraPreviewOn || DecoderLibrary.this.mPreviewStarted;
            boolean bl3 = bl = this.c != null;
            if (bl) {
                this.b(true);
                this.a(true);
            }
            DecoderLibrary.this.mCameraType = cameraType;
            this.g = null;
            this.f = null;
            if (bl) {
                if (!this.k()) {
                    return false;
                }
                if (bl2) {
                    this.e();
                }
            }
            return true;
        }

        @Override
        public void b(boolean bl) {
            com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "stopCameraPreview(synchronous " + bl + ")");
            DecoderLibrary.this.cameraPreviewOn = false;
            if (this.c != null && DecoderLibrary.this.mPreviewStarted) {
                DecoderLibrary.this.aeMgr.setFlashOn(false);
                DecoderLibrary.this.aeMgr.setAimerOn(false);
                DecoderLibrary.this.mPreviewStarted = false;
                this.c.cancelAutoFocus();
                com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "cancelled auto focus");
                try {
                    if (bl) {
                        this.d();
                    } else {
                        DecoderLibrary.this.cameraBackgroundHandler(new f(this));
                    }
                }
                catch (Exception exception) {
                    com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "Error in stopCameraPreview(): " + exception);
                }
                this.a(bl);
            } else {
                com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "stopCameraPreview(): Preview is already stopped");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void d() {
            com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "stopCameraPreviewSynchronous()");
            try {
                Object object = this.d;
                Object object2 = this.d;
                synchronized (object2) {
                    if (this.c == null) {
                        com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "stopCameraPreviewSynchronous(): mCamera is null!");
                        return;
                    }
                    com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "mCamera.setPreviewCallbackWithBuffer(null)");
                    this.c.setPreviewCallbackWithBuffer(null);
                    com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "mCamera.stopPreview()");
                    this.c.stopPreview();
                    this.h = false;
                    this.k = false;
                }
            }
            catch (Exception exception) {
                com.imagealgorithmlab.barcode.camera.b.a("DL.Camera1", "Error in stopCameraPreviewSynchronous():", exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void e() {
            com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "startCameraPreview()");
            DecoderLibrary.this.cameraPreviewOn = true;
            this.k = false;
            if (DecoderLibrary.this.mPreviewStarted) {
                com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "startCameraPreview() preview already started");
            } else {
                try {
                    if (!this.k()) {
                        return;
                    }
                    Object object = this.d;
                    Object object2 = this.d;
                    synchronized (object2) {
                        int n = this.j();
                        com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "mCamera.setDisplayOrientation(" + n + ")");
                        this.c.setDisplayOrientation(n);
                        com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "mCamera.startPreview()");
                        this.c.startPreview();
                        DecoderLibrary.this.mPreviewStarted = true;
                        this.a(DecoderLibrary.this.mFocusMode);
                    }
                }
                catch (Exception exception) {
                    com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "Exception: " + exception);
                }
            }
        }

        private String n() {
            try {
                Camera.Parameters parameters = this.c.getParameters();
                return parameters.getFocusMode();
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void f() {
            com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "startAutoFocus() mCamera=" + this.c + " mFocusMode=" + (Object)((Object)DecoderLibrary.this.mFocusMode) + " mPreviewStarted=" + DecoderLibrary.this.mPreviewStarted);
            if (this.c != null && "auto".equals(this.n()) && DecoderLibrary.this.mPreviewStarted) {
                try {
                    com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "mCamera.autoFocus(autoFocusCallBack)");
                    this.c.autoFocus(this.a);
                    this.h = true;
                }
                catch (Exception exception) {
                    com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "mCamera.autoFocus(autoFocusCallback): " + exception);
                }
            } else {
                com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "Skipping mCamera.autoFocus(autoFocusCallback)");
            }
        }

        @Override
        public void a(int n) {
            com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "setZoomValue(" + n + ")");
            if (this.c != null) {
                try {
                    Camera.Parameters parameters = this.c.getParameters();
                    if (parameters.isZoomSupported()) {
                        parameters.setZoom(n);
                    }
                    this.c.setParameters(parameters);
                }
                catch (RuntimeException runtimeException) {
                    com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "Could not set zoom value to " + n + ":" + runtimeException);
                }
            }
        }

        @Override
        public void b(int n) {
            com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "setZoomValue(" + n + ")");
            if (this.c != null) {
                try {
                    Camera.Parameters parameters = this.c.getParameters();
                    parameters.setExposureCompensation(n);
                    this.c.setParameters(parameters);
                }
                catch (RuntimeException runtimeException) {
                    com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "Could not set zoom value to " + n + ":" + runtimeException);
                }
            }
        }

        @Override
        public int g() {
            com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "getMaxZoom()");
            int n = 0;
            if (this.c != null) {
                try {
                    Camera.Parameters parameters = this.c.getParameters();
                    n = parameters.getMaxZoom();
                }
                catch (RuntimeException runtimeException) {
                    com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "Could not get max zoom value to " + n + ":" + runtimeException);
                }
            }
            return n;
        }

        @Override
        public void h() {
            this.j = true;
        }

        @Override
        public void i() {
            this.j = false;
            if (DecoderLibrary.this.aimerOn) {
                DecoderLibrary.this.aimerOff();
            }
            if (DecoderLibrary.this.torchOn) {
                DecoderLibrary.this.torchOff();
            }
            if (DecoderLibrary.this.needAE) {
                DecoderLibrary.this.aeMgr.endAE();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean a(String string) {
            try {
                Object object = this.d;
                Object object2 = this.d;
                synchronized (object2) {
                    Camera.Parameters parameters = this.c.getParameters();
                    parameters.setFocusMode(string);
                    this.c.setParameters(parameters);
                    this.f();
                    return true;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }

        public boolean a(Focus focus) {
            com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "setFocus(" + (Object)((Object)focus) + ")");
            if (!DecoderLibrary.this.cameraManagerInterface.k()) {
                return false;
            }
            try {
                switch (focus) {
                    case Focus_Normal: {
                        if (this.g.contains("continuous-picture")) {
                            com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "setFocusMode(FOCUS_MODE_CONTINUOUS_PICTURE)");
                            if (this.a("continuous-picture")) {
                                DecoderLibrary.this.mFocusMode = focus;
                                return true;
                            }
                        }
                        if (this.g.contains("continuous-video")) {
                            com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "setFocusMode(FOCUS_MODE_CONTINUOUS_VIDEO)");
                            if (this.a("continuous-video")) {
                                DecoderLibrary.this.mFocusMode = focus;
                                return true;
                            }
                        }
                        com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "setFocusMode(FOCUS_MODE_AUTO)");
                        if (!this.g.contains("auto")) break;
                        com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "setFocusMode(FOCUS_MODE_AUTO)");
                        if (!this.a("auto")) break;
                        DecoderLibrary.this.mFocusMode = focus;
                        return true;
                    }
                }
                return false;
            }
            catch (Exception exception) {
                com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "setFocus(" + exception + ")");
                return false;
            }
        }

        public int j() {
            int n;
            Context context = DecoderLibrary.this.cxt;
            DecoderLibrary.this.cxt;
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            Display display = windowManager.getDefaultDisplay();
            int n2 = display.getRotation();
            int n3 = 0;
            switch (n2) {
                case 0: {
                    n3 = 0;
                    break;
                }
                case 1: {
                    n3 = 90;
                    break;
                }
                case 2: {
                    n3 = 180;
                    break;
                }
                case 3: {
                    n3 = 270;
                }
            }
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)this.i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing == 1) {
                n = (cameraInfo.orientation + n3) % 360;
                n = (360 - n) % 360;
            } else {
                n = (cameraInfo.orientation - n3 + 360) % 360;
            }
            return n;
        }

        @Override
        public synchronized boolean k() {
            if (!DecoderLibrary.this.mConditionVariable.block(DecoderLibrary.this.timeOutWaitingClose)) {
                com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "openCamera():Timeout waiting camera to close!");
            }
            if (this.c != null) {
                return true;
            }
            if (Thread.currentThread() == DecoderLibrary.this.mCameraBackgroundThread) {
                com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "openCamera() called on background thread!");
                return this.o();
            }
            try {
                boolean[] blArray = new boolean[1];
                CountDownLatch countDownLatch = new CountDownLatch(1);
                DecoderLibrary.this.cameraBackgroundHandler(new a(this, blArray, countDownLatch));
                com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "Waiting for camera to open...");
                countDownLatch.await(DecoderLibrary.this.timeOutWaitingOpen, TimeUnit.MILLISECONDS);
                com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "b[0]: " + blArray[0] + " this.mCamera:" + this.c);
                return blArray[0] && this.c != null;
            }
            catch (InterruptedException interruptedException) {
                com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "Timeout waiting for camera to open");
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean o() {
            com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "openCameraSynchronous()");
            Object object = this.d;
            Object object2 = this.d;
            synchronized (object2) {
                int n = Camera.getNumberOfCameras();
                for (int i = 0; i < n; ++i) {
                    Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
                    Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
                    com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "cameraInfo.facing == " + cameraInfo.facing + "  this.mCameraType == " + (Object)((Object)DecoderLibrary.this.mCameraType));
                    if (!(i == 0 && DecoderLibrary.this.mCameraType == CameraType.Camera0 || i == 1 && DecoderLibrary.this.mCameraType == CameraType.Camera1) && (DecoderLibrary.this.mCameraType != CameraType.Camera2 || i != 2)) continue;
                    com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "mCamera = Camera.open(" + i + ")");
                    try {
                        this.c = Camera.open((int)i);
                        if (this.c == null) {
                            com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "Could not open camera!");
                            return false;
                        }
                        this.i = i;
                        Camera.Parameters parameters = this.c.getParameters();
                        this.f = parameters.getSupportedFlashModes();
                        this.g = parameters.getSupportedFocusModes();
                        com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "mCamera.setPreviewCallbackWithBuffer(this)");
                        this.c.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
                        this.c.addCallbackBuffer(DecoderLibrary.this.preivewBuf);
                        this.c.setPreviewTexture(DecoderLibrary.this.surfaceTexture);
                        this.a(DecoderLibrary.this.mResolution);
                    }
                    catch (Exception exception) {
                        com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "Camera.open(): " + exception);
                    }
                    break;
                }
                return this.c != null;
            }
        }

        @Override
        public void a(Resolution resolution) {
            com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "setDecoderResolution(" + (Object)((Object)resolution) + ")");
            DecoderLibrary.this.mResolution = resolution;
            if (this.c != null) {
                try {
                    d d2 = DecoderLibrary.this.setResolution(resolution);
                    d d3 = com.imagealgorithmlab.barcode.camera.g.a(this.c, com.imagealgorithmlab.barcode.camera.DecoderLibrary$d.a, com.imagealgorithmlab.barcode.camera.DecoderLibrary$d.b);
                    Camera.Parameters parameters = this.c.getParameters();
                    com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "p.setPreviewSize(" + com.imagealgorithmlab.barcode.camera.DecoderLibrary$d.a + ", " + com.imagealgorithmlab.barcode.camera.DecoderLibrary$d.b + ")");
                    parameters.setPreviewSize(com.imagealgorithmlab.barcode.camera.DecoderLibrary$d.a, com.imagealgorithmlab.barcode.camera.DecoderLibrary$d.b);
                    this.c.setParameters(parameters);
                    try {
                        parameters.setPictureSize(com.imagealgorithmlab.barcode.camera.DecoderLibrary$d.a, com.imagealgorithmlab.barcode.camera.DecoderLibrary$d.b);
                        this.c.setParameters(parameters);
                    }
                    catch (Exception exception) {
                        com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "Could not set picture size to match preview size: " + exception);
                    }
                }
                catch (Exception exception) {
                    com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "setDecoderResolution(" + (Object)((Object)resolution) + "):" + exception);
                }
            }
        }

        public void l() {
            this.h = false;
        }

        public void onPreviewFrame(byte[] byArray, Camera camera) {
            if (this.c == camera) {
                com.imagealgorithmlab.barcode.camera.b.a("DL.Camera1", "onPreviewFrame.onPreviewFrame: startDecoding-" + this.j);
                if (this.j) {
                    try {
                        this.a(byArray);
                    }
                    catch (Exception exception) {
                        com.imagealgorithmlab.barcode.camera.b.a("DL.Camera1", "onPreviewFrame.startDecode():" + exception);
                    }
                }
            }
            camera.addCallbackBuffer(byArray);
        }

        @Override
        public boolean m() {
            return this.c != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void a(byte[] byArray, int n, int n2) {
            long l;
            if (DecoderLibrary.this.mConditionVariable2.block(1L)) {
                DecoderLibrary.this.mConditionVariable2.close();
                DecoderLibrary.this.mDecodeTimeOutHandler.postDelayed((Runnable)new com.imagealgorithmlab.barcode.camera.DecoderLibrary$c(this), DecoderLibrary.this.decodeTimeOut);
            }
            if (DecoderLibrary.this.mTimeOutBackgroundHandler != null) {
                DecoderLibrary.this.mTimeOutBackgroundHandler.post((Runnable)new c(this.e));
            }
            if (DecoderLibrary.this.needAE) {
                long l2 = System.currentTimeMillis();
                AEData aEData = DecoderLibrary.this.aeMgr.caculateFrameAE(byArray, n, n2);
                l = System.currentTimeMillis() - l2;
                com.imagealgorithmlab.barcode.camera.b.b("DL.doDecode", "caculateFrameAE takes " + l + "ms");
                com.imagealgorithmlab.barcode.camera.b.b("DL.doDecode", "illumAvg:" + aEData.getIllumAvg());
                DecoderLibrary.this.currentIllAvg = aEData.getIllumAvg();
            }
            SymbologyData symbologyData = null;
            long l3 = System.currentTimeMillis();
            if (DecoderLibrary.this.currentIllAvg >= DecoderLibrary.this.defaultIllAvg) {
                com.imagealgorithmlab.barcode.camera.b.b("DL.doDecode", "currentIllAvg >= defaultIllAvg:" + DecoderLibrary.this.currentIllAvg + ">=" + DecoderLibrary.this.defaultIllAvg);
                symbologyData = DecodeEngine.startDecode(byArray, n, n2);
            }
            l = System.currentTimeMillis() - l3;
            com.imagealgorithmlab.barcode.camera.b.a("DL.doDecode", "It takes " + l + " ms to decode!");
            Object object = this.e;
            synchronized (object) {
                this.e.notify();
            }
            switch (DecoderLibrary.this.saveMode) {
                case SAVEPREVIEWALLBMP: 
                case SAVEPREVIEWLASTBMP: {
                    com.imagealgorithmlab.barcode.e.a(DecoderLibrary.this.cxt, byArray, n, n2, DecoderLibrary.this.saveMode);
                }
            }
            if (symbologyData != null && !TextUtils.isEmpty((CharSequence)symbologyData.getData())) {
                long l4 = System.currentTimeMillis() - DecoderLibrary.this.tt1;
                DecoderLibrary.this.mDecodeTimeOutHandler.removeCallbacksAndMessages(null);
                DecoderLibrary.this.mConditionVariable2.open();
                if (DecoderLibrary.this.torchOn) {
                    DecoderLibrary.this.torchOff();
                }
                if (DecoderLibrary.this.aimerOn) {
                    DecoderLibrary.this.aimerOff();
                }
                switch (DecoderLibrary.this.saveMode) {
                    case SAVEDECODESUCCESSALLBMP: 
                    case SAVEDECODESUCCESSLASTBMP: {
                        com.imagealgorithmlab.barcode.e.a(DecoderLibrary.this.cxt, byArray, n, n2, DecoderLibrary.this.saveMode);
                    }
                }
                com.imagealgorithmlab.barcode.camera.b.a("DL.doDecode", "Decoding is success:" + symbologyData.getData());
                symbologyData.setDecodeTime(l);
                symbologyData.setAllTime(l4);
                DecoderLibrary.this.stopDecoding();
                DecoderLibrary.this.previewFrameCallBack.receivedDecodedData(symbologyData);
                DecoderLibrary.this.mDecodeBackgroundHandler.removeCallbacksAndMessages(null);
            } else {
                com.imagealgorithmlab.barcode.camera.b.a("DL.doDecode", "Decoding is failure:" + symbologyData);
            }
            DecoderLibrary.this.mDecodeBackgroundHandler.removeCallbacksAndMessages(null);
            if (DecoderLibrary.this.mTimeOutBackgroundHandler != null) {
                DecoderLibrary.this.mTimeOutBackgroundHandler.removeCallbacksAndMessages(null);
            }
        }

        public void a(byte[] byArray) {
            if (this.j) {
                DecoderLibrary.this.mDecodeBackgroundHandler.post((Runnable)new b(this, byArray, com.imagealgorithmlab.barcode.camera.DecoderLibrary$d.a, com.imagealgorithmlab.barcode.camera.DecoderLibrary$d.b));
            }
        }

        public class c
        implements Runnable {
            private Object b;

            public c(Object object) {
                this.b = object;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long l = System.currentTimeMillis();
                try {
                    Object object = this.b;
                    synchronized (object) {
                        this.b.wait(DecoderLibrary.this.timeOutForkill);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long l2 = System.currentTimeMillis() - l;
                com.imagealgorithmlab.barcode.camera.b.b("Timeout", "time:" + l2);
                if (l2 >= DecoderLibrary.this.timeOutForkill) {
                    com.imagealgorithmlab.barcode.camera.b.b("kill", "DecodeEngine.kill() and It takes " + l2);
                    DecodeEngine.kill();
                }
                if (DecoderLibrary.this.mTimeOutBackgroundHandler != null) {
                    DecoderLibrary.this.mTimeOutBackgroundHandler.removeCallbacksAndMessages(null);
                }
            }
        }

        public class b
        implements Runnable {
            private com.imagealgorithmlab.barcode.camera.DecoderLibrary$a b;
            private byte[] c;
            private int d;
            private int e;

            b(com.imagealgorithmlab.barcode.camera.DecoderLibrary$a a3, byte[] byArray, int n, int n2) {
                this.b = a3;
                this.c = byArray;
                this.d = n;
                this.e = n2;
            }

            @Override
            public void run() {
                a.this.a(this.c, this.d, this.e);
            }
        }

        public class a
        implements Runnable {
            private com.imagealgorithmlab.barcode.camera.DecoderLibrary$a b;
            private boolean[] c;
            private CountDownLatch d;

            a(com.imagealgorithmlab.barcode.camera.DecoderLibrary$a a3, boolean[] blArray, CountDownLatch countDownLatch) {
                this.b = a3;
                this.c = blArray;
                this.d = countDownLatch;
            }

            @Override
            public void run() {
                com.imagealgorithmlab.barcode.camera.b.b("DL.Camera1", "into run() method to open  Camera");
                long l = System.currentTimeMillis();
                this.c[0] = a.this.o();
                com.imagealgorithmlab.barcode.camera.b.b("DL", "open camera cost " + (System.currentTimeMillis() - l) + " ms");
                com.imagealgorithmlab.barcode.camera.b.b("DL", "this.b[0]: " + this.c[0] + " Camera1.this.mcamera:" + a.this.c);
                DecoderLibrary.this.openCameraTime = System.currentTimeMillis() - l;
                this.d.countDown();
            }
        }
    }

    public class c
    implements Runnable {
        a a;

        public c(a a2) {
            this.a = a2;
        }

        @Override
        public void run() {
            com.imagealgorithmlab.barcode.camera.b.b("DL", "DecodeTimeOutRunnable.run()");
            if (this.a.j) {
                if (DecoderLibrary.this.singleScan) {
                    DecoderLibrary.this.stopDecoding();
                    if (DecoderLibrary.this.needAE) {
                        DecoderLibrary.this.aeMgr.endAE();
                    }
                }
                if (DecoderLibrary.this.aimerOn) {
                    com.imagealgorithmlab.barcode.camera.b.b("DL", "DecodeTimeOutRunnable.run().aimerOff");
                    DecoderLibrary.this.aimerOff();
                }
                if (DecoderLibrary.this.torchOn) {
                    com.imagealgorithmlab.barcode.camera.b.b("DL", "DecodeTimeOutRunnable.run().torchOff");
                    DecoderLibrary.this.torchOff();
                }
                DecoderLibrary.this.mVibrator.vibrate(new long[]{20L, 50L}, -1);
                if (DecoderLibrary.this.aimerOn && DecoderLibrary.this.multiScan) {
                    DecoderLibrary.this.aimerOn();
                }
                if (DecoderLibrary.this.torchOn && DecoderLibrary.this.multiScan) {
                    DecoderLibrary.this.torchOn();
                }
                if (DecoderLibrary.this.decodeTimeoutCallBack != null) {
                    DecoderLibrary.this.decodeTimeoutCallBack.timeoutCallBack();
                }
            }
            DecoderLibrary.this.mConditionVariable2.open();
        }
    }
}

