/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.graphics.Rect;
import android.os.Build;
import android.support.v4.app.BackStackRecord;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManagerImpl;
import android.support.v4.app.FragmentTransitionCompat21;
import android.support.v4.app.OneShotPreDrawListener;
import android.support.v4.app.SharedElementCallback;
import android.support.v4.util.ArrayMap;
import android.support.v4.view.ViewCompat;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

class FragmentTransition {
    private static final int[] INVERSE_OPS = new int[]{0, 3, 0, 1, 5, 4, 7, 6, 9, 8};

    FragmentTransition() {
    }

    static void startTransitions(FragmentManagerImpl fragmentManager, ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop, int startIndex, int endIndex, boolean isOptimized) {
        if (fragmentManager.mCurState < 1 || Build.VERSION.SDK_INT < 21) {
            return;
        }
        SparseArray transitioningFragments = new SparseArray();
        for (int i = startIndex; i < endIndex; ++i) {
            BackStackRecord record = records.get(i);
            boolean isPop = isRecordPop.get(i);
            if (isPop) {
                FragmentTransition.calculatePopFragments(record, (SparseArray<FragmentContainerTransition>)transitioningFragments, isOptimized);
                continue;
            }
            FragmentTransition.calculateFragments(record, (SparseArray<FragmentContainerTransition>)transitioningFragments, isOptimized);
        }
        if (transitioningFragments.size() != 0) {
            View nonExistentView = new View(fragmentManager.mHost.getContext());
            int numContainers = transitioningFragments.size();
            for (int i = 0; i < numContainers; ++i) {
                int containerId = transitioningFragments.keyAt(i);
                ArrayMap<String, String> nameOverrides = FragmentTransition.calculateNameOverrides(containerId, records, isRecordPop, startIndex, endIndex);
                FragmentContainerTransition containerTransition = (FragmentContainerTransition)transitioningFragments.valueAt(i);
                if (isOptimized) {
                    FragmentTransition.configureTransitionsOptimized(fragmentManager, containerId, containerTransition, nonExistentView, nameOverrides);
                    continue;
                }
                FragmentTransition.configureTransitionsUnoptimized(fragmentManager, containerId, containerTransition, nonExistentView, nameOverrides);
            }
        }
    }

    private static ArrayMap<String, String> calculateNameOverrides(int containerId, ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop, int startIndex, int endIndex) {
        ArrayMap nameOverrides = new ArrayMap();
        for (int recordNum = endIndex - 1; recordNum >= startIndex; --recordNum) {
            ArrayList<String> sources;
            ArrayList<String> targets;
            BackStackRecord record = records.get(recordNum);
            if (!record.interactsWith(containerId)) continue;
            boolean isPop = isRecordPop.get(recordNum);
            if (record.mSharedElementSourceNames == null) continue;
            int numSharedElements = record.mSharedElementSourceNames.size();
            if (isPop) {
                targets = record.mSharedElementSourceNames;
                sources = record.mSharedElementTargetNames;
            } else {
                sources = record.mSharedElementSourceNames;
                targets = record.mSharedElementTargetNames;
            }
            for (int i = 0; i < numSharedElements; ++i) {
                String sourceName = sources.get(i);
                String targetName = targets.get(i);
                String previousTarget = (String)nameOverrides.remove((Object)targetName);
                if (previousTarget != null) {
                    nameOverrides.put((Object)sourceName, (Object)previousTarget);
                    continue;
                }
                nameOverrides.put((Object)sourceName, (Object)targetName);
            }
        }
        return nameOverrides;
    }

    private static void configureTransitionsOptimized(FragmentManagerImpl fragmentManager, int containerId, FragmentContainerTransition fragments, View nonExistentView, ArrayMap<String, String> nameOverrides) {
        ViewGroup sceneRoot = null;
        if (fragmentManager.mContainer.onHasView()) {
            sceneRoot = (ViewGroup)fragmentManager.mContainer.onFindViewById(containerId);
        }
        if (sceneRoot == null) {
            return;
        }
        Fragment inFragment = fragments.lastIn;
        Fragment outFragment = fragments.firstOut;
        boolean inIsPop = fragments.lastInIsPop;
        boolean outIsPop = fragments.firstOutIsPop;
        ArrayList<View> sharedElementsIn = new ArrayList<View>();
        ArrayList<View> sharedElementsOut = new ArrayList<View>();
        Object enterTransition = FragmentTransition.getEnterTransition(inFragment, inIsPop);
        Object exitTransition = FragmentTransition.getExitTransition(outFragment, outIsPop);
        Object sharedElementTransition = FragmentTransition.configureSharedElementsOptimized(sceneRoot, nonExistentView, nameOverrides, fragments, sharedElementsOut, sharedElementsIn, enterTransition, exitTransition);
        if (enterTransition == null && sharedElementTransition == null && exitTransition == null) {
            return;
        }
        ArrayList<View> exitingViews = FragmentTransition.configureEnteringExitingViews(exitTransition, outFragment, sharedElementsOut, nonExistentView);
        ArrayList<View> enteringViews = FragmentTransition.configureEnteringExitingViews(enterTransition, inFragment, sharedElementsIn, nonExistentView);
        FragmentTransition.setViewVisibility(enteringViews, 4);
        Object transition = FragmentTransition.mergeTransitions(enterTransition, exitTransition, sharedElementTransition, inFragment, inIsPop);
        if (transition != null) {
            FragmentTransition.replaceHide(exitTransition, outFragment, exitingViews);
            ArrayList<String> inNames = FragmentTransitionCompat21.prepareSetNameOverridesOptimized(sharedElementsIn);
            FragmentTransitionCompat21.scheduleRemoveTargets(transition, enterTransition, enteringViews, exitTransition, exitingViews, sharedElementTransition, sharedElementsIn);
            FragmentTransitionCompat21.beginDelayedTransition(sceneRoot, transition);
            FragmentTransitionCompat21.setNameOverridesOptimized((View)sceneRoot, sharedElementsOut, sharedElementsIn, inNames, nameOverrides);
            FragmentTransition.setViewVisibility(enteringViews, 0);
            FragmentTransitionCompat21.swapSharedElementTargets(sharedElementTransition, sharedElementsOut, sharedElementsIn);
        }
    }

    private static void replaceHide(Object exitTransition, Fragment exitingFragment, final ArrayList<View> exitingViews) {
        if (exitingFragment != null && exitTransition != null && exitingFragment.mAdded && exitingFragment.mHidden && exitingFragment.mHiddenChanged) {
            exitingFragment.setHideReplaced(true);
            FragmentTransitionCompat21.scheduleHideFragmentView(exitTransition, exitingFragment.getView(), exitingViews);
            ViewGroup container = exitingFragment.mContainer;
            OneShotPreDrawListener.add((View)container, new Runnable(){

                @Override
                public void run() {
                    FragmentTransition.setViewVisibility(exitingViews, 4);
                }
            });
        }
    }

    private static void configureTransitionsUnoptimized(FragmentManagerImpl fragmentManager, int containerId, FragmentContainerTransition fragments, View nonExistentView, ArrayMap<String, String> nameOverrides) {
        ViewGroup sceneRoot = null;
        if (fragmentManager.mContainer.onHasView()) {
            sceneRoot = (ViewGroup)fragmentManager.mContainer.onFindViewById(containerId);
        }
        if (sceneRoot == null) {
            return;
        }
        Fragment inFragment = fragments.lastIn;
        Fragment outFragment = fragments.firstOut;
        boolean inIsPop = fragments.lastInIsPop;
        boolean outIsPop = fragments.firstOutIsPop;
        Object enterTransition = FragmentTransition.getEnterTransition(inFragment, inIsPop);
        Object exitTransition = FragmentTransition.getExitTransition(outFragment, outIsPop);
        ArrayList<View> sharedElementsOut = new ArrayList<View>();
        ArrayList<View> sharedElementsIn = new ArrayList<View>();
        Object sharedElementTransition = FragmentTransition.configureSharedElementsUnoptimized(sceneRoot, nonExistentView, nameOverrides, fragments, sharedElementsOut, sharedElementsIn, enterTransition, exitTransition);
        if (enterTransition == null && sharedElementTransition == null && exitTransition == null) {
            return;
        }
        ArrayList<View> exitingViews = FragmentTransition.configureEnteringExitingViews(exitTransition, outFragment, sharedElementsOut, nonExistentView);
        if (exitingViews == null || exitingViews.isEmpty()) {
            exitTransition = null;
        }
        FragmentTransitionCompat21.addTarget(enterTransition, nonExistentView);
        Object transition = FragmentTransition.mergeTransitions(enterTransition, exitTransition, sharedElementTransition, inFragment, fragments.lastInIsPop);
        if (transition != null) {
            ArrayList<View> enteringViews = new ArrayList<View>();
            FragmentTransitionCompat21.scheduleRemoveTargets(transition, enterTransition, enteringViews, exitTransition, exitingViews, sharedElementTransition, sharedElementsIn);
            FragmentTransition.scheduleTargetChange(sceneRoot, inFragment, nonExistentView, sharedElementsIn, enterTransition, enteringViews, exitTransition, exitingViews);
            FragmentTransitionCompat21.setNameOverridesUnoptimized((View)sceneRoot, sharedElementsIn, nameOverrides);
            FragmentTransitionCompat21.beginDelayedTransition(sceneRoot, transition);
            FragmentTransitionCompat21.scheduleNameReset(sceneRoot, sharedElementsIn, nameOverrides);
        }
    }

    private static void scheduleTargetChange(ViewGroup sceneRoot, final Fragment inFragment, final View nonExistentView, final ArrayList<View> sharedElementsIn, final Object enterTransition, final ArrayList<View> enteringViews, final Object exitTransition, final ArrayList<View> exitingViews) {
        OneShotPreDrawListener.add((View)sceneRoot, new Runnable(){

            @Override
            public void run() {
                if (enterTransition != null) {
                    FragmentTransitionCompat21.removeTarget(enterTransition, nonExistentView);
                    ArrayList views = FragmentTransition.configureEnteringExitingViews(enterTransition, inFragment, sharedElementsIn, nonExistentView);
                    enteringViews.addAll(views);
                }
                if (exitingViews != null) {
                    if (exitTransition != null) {
                        ArrayList<View> tempExiting = new ArrayList<View>();
                        tempExiting.add(nonExistentView);
                        FragmentTransitionCompat21.replaceTargets(exitTransition, exitingViews, tempExiting);
                    }
                    exitingViews.clear();
                    exitingViews.add(nonExistentView);
                }
            }
        });
    }

    private static Object getSharedElementTransition(Fragment inFragment, Fragment outFragment, boolean isPop) {
        if (inFragment == null || outFragment == null) {
            return null;
        }
        Object transition = FragmentTransitionCompat21.cloneTransition(isPop ? outFragment.getSharedElementReturnTransition() : inFragment.getSharedElementEnterTransition());
        return FragmentTransitionCompat21.wrapTransitionInSet(transition);
    }

    private static Object getEnterTransition(Fragment inFragment, boolean isPop) {
        if (inFragment == null) {
            return null;
        }
        return FragmentTransitionCompat21.cloneTransition(isPop ? inFragment.getReenterTransition() : inFragment.getEnterTransition());
    }

    private static Object getExitTransition(Fragment outFragment, boolean isPop) {
        if (outFragment == null) {
            return null;
        }
        return FragmentTransitionCompat21.cloneTransition(isPop ? outFragment.getReturnTransition() : outFragment.getExitTransition());
    }

    private static Object configureSharedElementsOptimized(ViewGroup sceneRoot, View nonExistentView, ArrayMap<String, String> nameOverrides, FragmentContainerTransition fragments, ArrayList<View> sharedElementsOut, ArrayList<View> sharedElementsIn, Object enterTransition, Object exitTransition) {
        View epicenterView;
        Rect epicenter;
        final Fragment inFragment = fragments.lastIn;
        final Fragment outFragment = fragments.firstOut;
        if (inFragment != null) {
            inFragment.getView().setVisibility(0);
        }
        if (inFragment == null || outFragment == null) {
            return null;
        }
        final boolean inIsPop = fragments.lastInIsPop;
        Object sharedElementTransition = nameOverrides.isEmpty() ? null : FragmentTransition.getSharedElementTransition(inFragment, outFragment, inIsPop);
        ArrayMap<String, View> outSharedElements = FragmentTransition.captureOutSharedElements(nameOverrides, sharedElementTransition, fragments);
        final ArrayMap<String, View> inSharedElements = FragmentTransition.captureInSharedElements(nameOverrides, sharedElementTransition, fragments);
        if (nameOverrides.isEmpty()) {
            sharedElementTransition = null;
            if (outSharedElements != null) {
                outSharedElements.clear();
            }
            if (inSharedElements != null) {
                inSharedElements.clear();
            }
        } else {
            FragmentTransition.addSharedElementsWithMatchingNames(sharedElementsOut, outSharedElements, nameOverrides.keySet());
            FragmentTransition.addSharedElementsWithMatchingNames(sharedElementsIn, inSharedElements, nameOverrides.values());
        }
        if (enterTransition == null && exitTransition == null && sharedElementTransition == null) {
            return null;
        }
        FragmentTransition.callSharedElementStartEnd(inFragment, outFragment, inIsPop, outSharedElements, true);
        if (sharedElementTransition != null) {
            sharedElementsIn.add(nonExistentView);
            FragmentTransitionCompat21.setSharedElementTargets(sharedElementTransition, nonExistentView, sharedElementsOut);
            boolean outIsPop = fragments.firstOutIsPop;
            BackStackRecord outTransaction = fragments.firstOutTransaction;
            FragmentTransition.setOutEpicenter(sharedElementTransition, exitTransition, outSharedElements, outIsPop, outTransaction);
            epicenter = new Rect();
            epicenterView = FragmentTransition.getInEpicenterView(inSharedElements, fragments, enterTransition, inIsPop);
            if (epicenterView != null) {
                FragmentTransitionCompat21.setEpicenter(enterTransition, epicenter);
            }
        } else {
            epicenter = null;
            epicenterView = null;
        }
        OneShotPreDrawListener.add((View)sceneRoot, new Runnable(){

            @Override
            public void run() {
                FragmentTransition.callSharedElementStartEnd(inFragment, outFragment, inIsPop, (ArrayMap<String, View>)inSharedElements, false);
                if (epicenterView != null) {
                    FragmentTransitionCompat21.getBoundsOnScreen(epicenterView, epicenter);
                }
            }
        });
        return sharedElementTransition;
    }

    private static void addSharedElementsWithMatchingNames(ArrayList<View> views, ArrayMap<String, View> sharedElements, Collection<String> nameOverridesSet) {
        for (int i = sharedElements.size() - 1; i >= 0; --i) {
            View view = (View)sharedElements.valueAt(i);
            if (!nameOverridesSet.contains(ViewCompat.getTransitionName((View)view))) continue;
            views.add(view);
        }
    }

    private static Object configureSharedElementsUnoptimized(ViewGroup sceneRoot, final View nonExistentView, final ArrayMap<String, String> nameOverrides, final FragmentContainerTransition fragments, final ArrayList<View> sharedElementsOut, final ArrayList<View> sharedElementsIn, final Object enterTransition, Object exitTransition) {
        Rect inEpicenter;
        final Fragment inFragment = fragments.lastIn;
        final Fragment outFragment = fragments.firstOut;
        if (inFragment == null || outFragment == null) {
            return null;
        }
        final boolean inIsPop = fragments.lastInIsPop;
        Object sharedElementTransition = nameOverrides.isEmpty() ? null : FragmentTransition.getSharedElementTransition(inFragment, outFragment, inIsPop);
        ArrayMap<String, View> outSharedElements = FragmentTransition.captureOutSharedElements(nameOverrides, sharedElementTransition, fragments);
        if (nameOverrides.isEmpty()) {
            sharedElementTransition = null;
        } else {
            sharedElementsOut.addAll(outSharedElements.values());
        }
        if (enterTransition == null && exitTransition == null && sharedElementTransition == null) {
            return null;
        }
        FragmentTransition.callSharedElementStartEnd(inFragment, outFragment, inIsPop, outSharedElements, true);
        if (sharedElementTransition != null) {
            inEpicenter = new Rect();
            FragmentTransitionCompat21.setSharedElementTargets(sharedElementTransition, nonExistentView, sharedElementsOut);
            boolean outIsPop = fragments.firstOutIsPop;
            BackStackRecord outTransaction = fragments.firstOutTransaction;
            FragmentTransition.setOutEpicenter(sharedElementTransition, exitTransition, outSharedElements, outIsPop, outTransaction);
            if (enterTransition != null) {
                FragmentTransitionCompat21.setEpicenter(enterTransition, inEpicenter);
            }
        } else {
            inEpicenter = null;
        }
        final Object finalSharedElementTransition = sharedElementTransition;
        OneShotPreDrawListener.add((View)sceneRoot, new Runnable(){

            @Override
            public void run() {
                ArrayMap inSharedElements = FragmentTransition.captureInSharedElements((ArrayMap<String, String>)nameOverrides, finalSharedElementTransition, fragments);
                if (inSharedElements != null) {
                    sharedElementsIn.addAll(inSharedElements.values());
                    sharedElementsIn.add(nonExistentView);
                }
                FragmentTransition.callSharedElementStartEnd(inFragment, outFragment, inIsPop, (ArrayMap<String, View>)inSharedElements, false);
                if (finalSharedElementTransition != null) {
                    FragmentTransitionCompat21.swapSharedElementTargets(finalSharedElementTransition, sharedElementsOut, sharedElementsIn);
                    View inEpicenterView = FragmentTransition.getInEpicenterView((ArrayMap<String, View>)inSharedElements, fragments, enterTransition, inIsPop);
                    if (inEpicenterView != null) {
                        FragmentTransitionCompat21.getBoundsOnScreen(inEpicenterView, inEpicenter);
                    }
                }
            }
        });
        return sharedElementTransition;
    }

    private static ArrayMap<String, View> captureOutSharedElements(ArrayMap<String, String> nameOverrides, Object sharedElementTransition, FragmentContainerTransition fragments) {
        ArrayList<String> names;
        SharedElementCallback sharedElementCallback;
        if (nameOverrides.isEmpty() || sharedElementTransition == null) {
            nameOverrides.clear();
            return null;
        }
        Fragment outFragment = fragments.firstOut;
        ArrayMap outSharedElements = new ArrayMap();
        FragmentTransitionCompat21.findNamedViews((Map<String, View>)outSharedElements, outFragment.getView());
        BackStackRecord outTransaction = fragments.firstOutTransaction;
        if (fragments.firstOutIsPop) {
            sharedElementCallback = outFragment.getEnterTransitionCallback();
            names = outTransaction.mSharedElementTargetNames;
        } else {
            sharedElementCallback = outFragment.getExitTransitionCallback();
            names = outTransaction.mSharedElementSourceNames;
        }
        outSharedElements.retainAll(names);
        if (sharedElementCallback != null) {
            sharedElementCallback.onMapSharedElements(names, (Map)outSharedElements);
            for (int i = names.size() - 1; i >= 0; --i) {
                String name = names.get(i);
                View view = (View)outSharedElements.get((Object)name);
                if (view == null) {
                    nameOverrides.remove((Object)name);
                    continue;
                }
                if (name.equals(ViewCompat.getTransitionName((View)view))) continue;
                String targetValue = (String)nameOverrides.remove((Object)name);
                nameOverrides.put((Object)ViewCompat.getTransitionName((View)view), (Object)targetValue);
            }
        } else {
            nameOverrides.retainAll((Collection)outSharedElements.keySet());
        }
        return outSharedElements;
    }

    private static ArrayMap<String, View> captureInSharedElements(ArrayMap<String, String> nameOverrides, Object sharedElementTransition, FragmentContainerTransition fragments) {
        ArrayList<String> names;
        SharedElementCallback sharedElementCallback;
        Fragment inFragment = fragments.lastIn;
        View fragmentView = inFragment.getView();
        if (nameOverrides.isEmpty() || sharedElementTransition == null || fragmentView == null) {
            nameOverrides.clear();
            return null;
        }
        ArrayMap inSharedElements = new ArrayMap();
        FragmentTransitionCompat21.findNamedViews((Map<String, View>)inSharedElements, fragmentView);
        BackStackRecord inTransaction = fragments.lastInTransaction;
        if (fragments.lastInIsPop) {
            sharedElementCallback = inFragment.getExitTransitionCallback();
            names = inTransaction.mSharedElementSourceNames;
        } else {
            sharedElementCallback = inFragment.getEnterTransitionCallback();
            names = inTransaction.mSharedElementTargetNames;
        }
        inSharedElements.retainAll(names);
        if (sharedElementCallback != null) {
            sharedElementCallback.onMapSharedElements(names, (Map)inSharedElements);
            for (int i = names.size() - 1; i >= 0; --i) {
                String key;
                String name = names.get(i);
                View view = (View)inSharedElements.get((Object)name);
                if (view == null) {
                    key = FragmentTransition.findKeyForValue(nameOverrides, name);
                    if (key == null) continue;
                    nameOverrides.remove((Object)key);
                    continue;
                }
                if (name.equals(ViewCompat.getTransitionName((View)view)) || (key = FragmentTransition.findKeyForValue(nameOverrides, name)) == null) continue;
                nameOverrides.put((Object)key, (Object)ViewCompat.getTransitionName((View)view));
            }
        } else {
            FragmentTransition.retainValues(nameOverrides, (ArrayMap<String, View>)inSharedElements);
        }
        return inSharedElements;
    }

    private static String findKeyForValue(ArrayMap<String, String> map, String value) {
        int numElements = map.size();
        for (int i = 0; i < numElements; ++i) {
            if (!value.equals(map.valueAt(i))) continue;
            return (String)map.keyAt(i);
        }
        return null;
    }

    private static View getInEpicenterView(ArrayMap<String, View> inSharedElements, FragmentContainerTransition fragments, Object enterTransition, boolean inIsPop) {
        BackStackRecord inTransaction = fragments.lastInTransaction;
        if (enterTransition != null && inTransaction.mSharedElementSourceNames != null && !inTransaction.mSharedElementSourceNames.isEmpty()) {
            String targetName = inIsPop ? inTransaction.mSharedElementSourceNames.get(0) : inTransaction.mSharedElementTargetNames.get(0);
            return (View)inSharedElements.get((Object)targetName);
        }
        return null;
    }

    private static void setOutEpicenter(Object sharedElementTransition, Object exitTransition, ArrayMap<String, View> outSharedElements, boolean outIsPop, BackStackRecord outTransaction) {
        if (outTransaction.mSharedElementSourceNames != null && !outTransaction.mSharedElementSourceNames.isEmpty()) {
            String sourceName = outIsPop ? outTransaction.mSharedElementTargetNames.get(0) : outTransaction.mSharedElementSourceNames.get(0);
            View outEpicenterView = (View)outSharedElements.get((Object)sourceName);
            FragmentTransitionCompat21.setEpicenter(sharedElementTransition, outEpicenterView);
            if (exitTransition != null) {
                FragmentTransitionCompat21.setEpicenter(exitTransition, outEpicenterView);
            }
        }
    }

    private static void retainValues(ArrayMap<String, String> nameOverrides, ArrayMap<String, View> namedViews) {
        for (int i = nameOverrides.size() - 1; i >= 0; --i) {
            String targetName = (String)nameOverrides.valueAt(i);
            if (namedViews.containsKey((Object)targetName)) continue;
            nameOverrides.removeAt(i);
        }
    }

    private static void callSharedElementStartEnd(Fragment inFragment, Fragment outFragment, boolean isPop, ArrayMap<String, View> sharedElements, boolean isStart) {
        SharedElementCallback sharedElementCallback;
        SharedElementCallback sharedElementCallback2 = sharedElementCallback = isPop ? outFragment.getEnterTransitionCallback() : inFragment.getEnterTransitionCallback();
        if (sharedElementCallback != null) {
            ArrayList<Object> views = new ArrayList<Object>();
            ArrayList<Object> names = new ArrayList<Object>();
            int count = sharedElements == null ? 0 : sharedElements.size();
            for (int i = 0; i < count; ++i) {
                names.add(sharedElements.keyAt(i));
                views.add(sharedElements.valueAt(i));
            }
            if (isStart) {
                sharedElementCallback.onSharedElementStart(names, views, null);
            } else {
                sharedElementCallback.onSharedElementEnd(names, views, null);
            }
        }
    }

    private static ArrayList<View> configureEnteringExitingViews(Object transition, Fragment fragment, ArrayList<View> sharedElements, View nonExistentView) {
        ArrayList<View> viewList = null;
        if (transition != null) {
            viewList = new ArrayList<View>();
            View root = fragment.getView();
            FragmentTransitionCompat21.captureTransitioningViews(viewList, root);
            if (sharedElements != null) {
                viewList.removeAll(sharedElements);
            }
            if (!viewList.isEmpty()) {
                viewList.add(nonExistentView);
                FragmentTransitionCompat21.addTargets(transition, viewList);
            }
        }
        return viewList;
    }

    private static void setViewVisibility(ArrayList<View> views, int visibility) {
        if (views == null) {
            return;
        }
        for (int i = views.size() - 1; i >= 0; --i) {
            View view = views.get(i);
            view.setVisibility(visibility);
        }
    }

    private static Object mergeTransitions(Object enterTransition, Object exitTransition, Object sharedElementTransition, Fragment inFragment, boolean isPop) {
        boolean overlap = true;
        if (enterTransition != null && exitTransition != null && inFragment != null) {
            overlap = isPop ? inFragment.getAllowReturnTransitionOverlap() : inFragment.getAllowEnterTransitionOverlap();
        }
        Object transition = overlap ? FragmentTransitionCompat21.mergeTransitionsTogether(exitTransition, enterTransition, sharedElementTransition) : FragmentTransitionCompat21.mergeTransitionsInSequence(exitTransition, enterTransition, sharedElementTransition);
        return transition;
    }

    public static void calculateFragments(BackStackRecord transaction, SparseArray<FragmentContainerTransition> transitioningFragments, boolean isOptimized) {
        int numOps = transaction.mOps.size();
        for (int opNum = 0; opNum < numOps; ++opNum) {
            BackStackRecord.Op op = transaction.mOps.get(opNum);
            FragmentTransition.addToFirstInLastOut(transaction, op, transitioningFragments, false, isOptimized);
        }
    }

    public static void calculatePopFragments(BackStackRecord transaction, SparseArray<FragmentContainerTransition> transitioningFragments, boolean isOptimized) {
        if (!transaction.mManager.mContainer.onHasView()) {
            return;
        }
        int numOps = transaction.mOps.size();
        for (int opNum = numOps - 1; opNum >= 0; --opNum) {
            BackStackRecord.Op op = transaction.mOps.get(opNum);
            FragmentTransition.addToFirstInLastOut(transaction, op, transitioningFragments, true, isOptimized);
        }
    }

    private static void addToFirstInLastOut(BackStackRecord transaction, BackStackRecord.Op op, SparseArray<FragmentContainerTransition> transitioningFragments, boolean isPop, boolean isOptimizedTransaction) {
        Fragment fragment = op.fragment;
        if (fragment == null) {
            return;
        }
        int containerId = fragment.mContainerId;
        if (containerId == 0) {
            return;
        }
        int command = isPop ? INVERSE_OPS[op.cmd] : op.cmd;
        boolean setLastIn = false;
        boolean wasRemoved = false;
        boolean setFirstOut = false;
        boolean wasAdded = false;
        switch (command) {
            case 5: {
                setLastIn = isOptimizedTransaction ? fragment.mHiddenChanged && !fragment.mHidden && fragment.mAdded : fragment.mHidden;
                wasAdded = true;
                break;
            }
            case 1: 
            case 7: {
                setLastIn = isOptimizedTransaction ? fragment.mIsNewlyAdded : !fragment.mAdded && !fragment.mHidden;
                wasAdded = true;
                break;
            }
            case 4: {
                setFirstOut = isOptimizedTransaction ? fragment.mHiddenChanged && fragment.mAdded && fragment.mHidden : fragment.mAdded && !fragment.mHidden;
                wasRemoved = true;
                break;
            }
            case 3: 
            case 6: {
                setFirstOut = isOptimizedTransaction ? !fragment.mAdded && fragment.mView != null && fragment.mView.getVisibility() == 0 && fragment.mPostponedAlpha >= 0.0f : fragment.mAdded && !fragment.mHidden;
                wasRemoved = true;
            }
        }
        FragmentContainerTransition containerTransition = (FragmentContainerTransition)transitioningFragments.get(containerId);
        if (setLastIn) {
            containerTransition = FragmentTransition.ensureContainer(containerTransition, transitioningFragments, containerId);
            containerTransition.lastIn = fragment;
            containerTransition.lastInIsPop = isPop;
            containerTransition.lastInTransaction = transaction;
        }
        if (!isOptimizedTransaction && wasAdded) {
            if (containerTransition != null && containerTransition.firstOut == fragment) {
                containerTransition.firstOut = null;
            }
            FragmentManagerImpl manager = transaction.mManager;
            if (fragment.mState < 1 && manager.mCurState >= 1 && !transaction.mAllowOptimization) {
                manager.makeActive(fragment);
                manager.moveToState(fragment, 1, 0, 0, false);
            }
        }
        if (setFirstOut && (containerTransition == null || containerTransition.firstOut == null)) {
            containerTransition = FragmentTransition.ensureContainer(containerTransition, transitioningFragments, containerId);
            containerTransition.firstOut = fragment;
            containerTransition.firstOutIsPop = isPop;
            containerTransition.firstOutTransaction = transaction;
        }
        if (!isOptimizedTransaction && wasRemoved && containerTransition != null && containerTransition.lastIn == fragment) {
            containerTransition.lastIn = null;
        }
    }

    private static FragmentContainerTransition ensureContainer(FragmentContainerTransition containerTransition, SparseArray<FragmentContainerTransition> transitioningFragments, int containerId) {
        if (containerTransition == null) {
            containerTransition = new FragmentContainerTransition();
            transitioningFragments.put(containerId, (Object)containerTransition);
        }
        return containerTransition;
    }

    static class FragmentContainerTransition {
        public Fragment lastIn;
        public boolean lastInIsPop;
        public BackStackRecord lastInTransaction;
        public Fragment firstOut;
        public boolean firstOutIsPop;
        public BackStackRecord firstOutTransaction;

        FragmentContainerTransition() {
        }
    }
}

