package com.nfctest;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentFilter;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.IsoDep;
import android.nfc.tech.MifareClassic;
import android.nfc.tech.NfcA;

import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import android.app.AlertDialog;
import android.content.DialogInterface;

import java.io.IOException;
import java.util.ArrayList;
import java.lang.reflect.Array;
import java.util.List;

import android.widget.ArrayAdapter;
import android.app.ListActivity;

import android.app.ListActivity;
import android.view.View;

import android.content.Intent;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;


import android.content.IntentFilter.MalformedMimeTypeException;

import com.nfctest.mifare.MifareBlock;
import com.nfctest.mifare.MifareClassCard;
import com.nfctest.mifare.MifareSector;
import com.nfctest.mifare.StringUtils;

public class MainActivity extends AppCompatActivity{

    //---------控件定义------------
    Button btnSelectMF;
    Button btnGetRand;
    ListView listView;
    Button btnReadCardSN;
    Button btnCardSAK;
    Button btnTechList;
    Button btnReadMifareCard;


    // NFC parts
    private static NfcAdapter nfcAdapter;
    private static PendingIntent mPendingIntent;

    private static IntentFilter[] mFilters;
    private static String[][] mTechLists;
    private Intent mIntent = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        //----------------控件---------------------
        btnSelectMF = (Button) findViewById(R.id.btnSelectMF);
        btnReadCardSN = (Button) findViewById(R.id.btnReadCardSN);
        btnCardSAK = (Button) findViewById(R.id.btnCardSAK);
        btnTechList = (Button) findViewById(R.id.btnTechList);
        btnGetRand = (Button) findViewById(R.id.btnGetRand);
        btnReadMifareCard = (Button) findViewById(R.id.btnReadMifareCard);

        listView = (ListView) findViewById(R.id.listview_msg);

        //-------------事件绑定---------------
        btnSelectMF.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                SelectMF();
            }
        });

        btnGetRand.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                GetRand();
            }
        });

        btnReadCardSN.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                ReadCardSN();
            }
        });

        btnCardSAK.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                CardSAK();
            }
        });
        btnTechList.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                TechList();
            }
        });
        btnReadMifareCard.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                ReadMifareCard();
            }
        });


        nfcAdapter = NfcAdapter.getDefaultAdapter(this);
        if (nfcAdapter == null) {
            Log.d("h_bl", "No support NFC！");
            Toast.makeText(getApplicationContext(), "No support NFC！", Toast.LENGTH_SHORT).show();

            return;
        }
        if (!nfcAdapter.isEnabled()) {
            Toast.makeText(getApplicationContext(), "Please enable the NFC function first in the system settings！", Toast.LENGTH_SHORT).show();
            Log.d("h_bl", "请在系统设置中先启用NFC功能！");
        }


        mPendingIntent = PendingIntent.getActivity(this, 0, new Intent(this,
                getClass()), 0);

        IntentFilter ndef = new IntentFilter(NfcAdapter.ACTION_TECH_DISCOVERED);

        try {
            ndef.addDataType("*/*");
        } catch (MalformedMimeTypeException e) {
            throw new RuntimeException("fail", e);
        }
        mFilters = new IntentFilter[]{ndef};

        //设置
        mTechLists = new String[][]{new String[]{IsoDep.class
                .getName()}, new String[]{MifareClassic.class.getName()}};//MifareClassic

        mIntent = this.getIntent();
    }


    /**
     * 读M1卡
     */
    private void ReadMifareCard() {
        String action = mIntent.getAction();

        if (NfcAdapter.ACTION_TECH_DISCOVERED.equals(action)) {//当前的action
            Tag tag = mIntent.getParcelableExtra(NfcAdapter.EXTRA_TAG);
            MifareClassic mifareClassic = MifareClassic.get(tag);
            if(mifareClassic == null){
                showAlert("It is not a Mifare card");
                return;
            }

            MifareClassCard mifareClassCard=null;

            try {
                mifareClassic.connect();

                boolean auth = false;
                // 5.2) and get the number of sectors this card has..and loop
                // thru these sectors
                int secCount = mifareClassic.getSectorCount();
                mifareClassCard= new MifareClassCard(secCount);
                int bCount = 0;
                int bIndex = 0;

                for (int j = 0; j < secCount; j++) {
                    MifareSector mifareSector = new MifareSector();
                    mifareSector.sectorIndex = j;
                    // 6.1) authenticate the sector
                    auth = mifareClassic.authenticateSectorWithKeyA(j,
                            MifareClassic.KEY_DEFAULT);
                    mifareSector.authorized = auth;
                    if (auth) {
                        // 6.2) In each sector - get the block count
                        bCount = mifareClassic.getBlockCountInSector(j);
                        bCount =Math.min(bCount, MifareSector.BLOCKCOUNT);
                        bIndex = mifareClassic.sectorToBlock(j);
                        for (int i = 0; i < bCount; i++) {

                            // 6.3) Read the block
                            byte []data = mifareClassic.readBlock(bIndex);
                            MifareBlock mifareBlock = new MifareBlock(data);
                            mifareBlock.blockIndex = bIndex;
                            // 7) Convert the data into a string from Hex
                            // format.

                            bIndex++;
                            mifareSector.blocks[i] = mifareBlock;


                        }
                        mifareClassCard.setSector(mifareSector.sectorIndex,
                                mifareSector);
                    } else { // Authentication failed - Handle it

                    }
                }

                ArrayList<String> blockData = new ArrayList<String>();

                int blockIndex=0;
                for(int i=0;i<secCount;i++){

                    MifareSector mifareSector=mifareClassCard.getSector(i);
                    for(int j=0;j<MifareSector.BLOCKCOUNT;j++){
                        MifareBlock mifareBlock=mifareSector.blocks[j];
                        byte []data=mifareBlock.getData();
                        blockData.add("Block "+ blockIndex++ +" : "+ StringUtils.bytesToHexString(data));
                    }
                }

                //---------------------显示输出---------------------
                String[] contents = new String[blockData.size()];
                blockData.toArray(contents);
                listView.setAdapter(new ArrayAdapter<String>(this,
                        android.R.layout.simple_list_item_1, contents));


                mifareClassic.close();

            } catch (IOException e) {
//                Log.e(TAG, e.getLocalizedMessage());
                //showAlert(3);
            }

        } else {
            showAlert("Do not find a card");
        }
    }

    /**
     * 选择MF
     */
    private void SelectMF() {
        String action = mIntent.getAction();

        if (NfcAdapter.ACTION_TECH_DISCOVERED.equals(action)) {
            Tag tagFromIntent = mIntent.getParcelableExtra(NfcAdapter.EXTRA_TAG);
            IsoDep isoDep = IsoDep.get(tagFromIntent);
            if(isoDep == null){
                showAlert("It is not a CPU card");
                return;
            }

            try {
                //连接卡片
                isoDep.connect();

                ArrayList<String> blockData = new ArrayList<String>();
                byte[] sendData = null;
                byte[] recvB = null;
                String send = "";
                String recv = "";

                send = "00A40000023F00";
                sendData = StringUtils.hexStringToByte(send);
                recvB = isoDep.transceive(sendData);
                recv = StringUtils.bytesToHexString(recvB);

                blockData.add(send);
                blockData.add(">" + recv);

                //断开卡片
                isoDep.close();


                //---------------------显示输出---------------------
                String[] contents = new String[blockData.size()];
                blockData.toArray(contents);
                listView.setAdapter(new ArrayAdapter<String>(this,
                        android.R.layout.simple_list_item_1, contents));

            } catch (IOException e) {
//                Log.e(TAG, e.getLocalizedMessage());
                //showAlert(3);
            }

        } else {
            showAlert("Do not find a card");
        }
    }

    /**
     * 取随机数
     */
    private void GetRand() {
        String action = mIntent.getAction();

        if (NfcAdapter.ACTION_TECH_DISCOVERED.equals(action)) {//当前的action
            Tag tag = mIntent.getParcelableExtra(NfcAdapter.EXTRA_TAG);
            IsoDep isoDep = IsoDep.get(tag);
            if(isoDep == null){
                showAlert("It is not a CPU card");
                return;
            }

            try {
                isoDep.connect();

                if (isoDep.isConnected() == false) {
                    showAlert("Connect fail");
                    return;
                }

                byte[] sendData = null;
                byte[] recvB = null;
                String send = "";
                String recv = "";

                send = "0084000004";
                sendData =StringUtils.hexStringToByte(send);
                recvB = isoDep.transceive(sendData);
                recv =StringUtils.bytesToHexString(recvB);


                ArrayList<String> blockData = new ArrayList<String>();

                blockData.add(send);
                blockData.add(">" + recv);

                //---------------------显示输出---------------------
                String[] contents = new String[blockData.size()];
                blockData.toArray(contents);
                listView.setAdapter(new ArrayAdapter<String>(this,
                        android.R.layout.simple_list_item_1, contents));


                isoDep.close();

            } catch (IOException e) {
//                Log.e(TAG, e.getLocalizedMessage());
                //showAlert(3);
            }

        } else {
            showAlert("Do not find a card");
        }
    }

    /**
     * 读卡唯一号
     */
    private void ReadCardSN() {
        String action = mIntent.getAction();

        if (NfcAdapter.ACTION_TECH_DISCOVERED.equals(action)) {//当前的action
            Tag tag = mIntent.getParcelableExtra(NfcAdapter.EXTRA_TAG);

            byte[] bytCardSN = tag.getId();
            String strCardSN = StringUtils.bytesToHexString(bytCardSN);


            ArrayList<String> blockData = new ArrayList<String>();


            blockData.add("Read unique number of card");
            blockData.add(">" + strCardSN);

            //---------------------显示输出---------------------
            String[] contents = new String[blockData.size()];
            blockData.toArray(contents);
            listView.setAdapter(new ArrayAdapter<String>(this,
                    android.R.layout.simple_list_item_1, contents));

        } else {
            showAlert("Do not find a card");
        }
    }

    /**
     * 支持的协议
     */
    private void TechList() {
        String action = mIntent.getAction();
        ArrayList<String> blockData = new ArrayList<String>();

        if (NfcAdapter.ACTION_TECH_DISCOVERED.equals(action)) {//当前的action
            Tag tag = mIntent.getParcelableExtra(NfcAdapter.EXTRA_TAG);

            String[] arTeachList = tag.getTechList();

            blockData.add("Supported agreement");
            for (int i = 0; i < arTeachList.length; i++) {
                String strTeach = arTeachList[i];

                blockData.add(">" + strTeach);
            }

            //---------------------显示输出---------------------
            String[] contents = new String[blockData.size()];
            blockData.toArray(contents);
            listView.setAdapter(new ArrayAdapter<String>(this,
                    android.R.layout.simple_list_item_1, contents));

        } else {
            showAlert("Do not find a card");
        }

    }

    /**
     * 读卡SAK
     */
    private void CardSAK() {
        String action = mIntent.getAction();

        if (NfcAdapter.ACTION_TECH_DISCOVERED.equals(action)) {//当前的action
            Tag tag = mIntent.getParcelableExtra(NfcAdapter.EXTRA_TAG);

            NfcA nfcA = NfcA.get(tag);

            byte[] bytAtqa = nfcA.getAtqa();
            short Sak = nfcA.getSak();
            int maxTranLen = nfcA.getMaxTransceiveLength();

            String strAtqa = StringUtils.bytesToHexString(bytAtqa);
            String strSAK = String.format("%02X", Sak);
            String strCardType;
            if (Sak == 0x08){
                strCardType = "M1 card";
            }else if(Sak == 0x20){
                strCardType = "CPU card";
            }else if(Sak == 0x28 || Sak == 0x38){
                strCardType = "Composite card";
            }else{
                strCardType = "Unknown type";
            }

            ArrayList<String> blockData = new ArrayList<String>();

            blockData.add("ATQA");
            blockData.add(">" + strAtqa);

            blockData.add("SAK");
            blockData.add(">" + strSAK + " " + strCardType);

            blockData.add("Max transmission length");
            blockData.add(">" + maxTranLen);

            //---------------------显示输出---------------------
            String[] contents = new String[blockData.size()];
            blockData.toArray(contents);
            listView.setAdapter(new ArrayAdapter<String>(this,
                    android.R.layout.simple_list_item_1, contents));

        } else {
            showAlert("Do not find a card");
        }
    }

    /**
     * 显示对话框
     *
     * @param alertCase
     */
    private void showAlert(String alertCase) {
        // prepare the alert box
        AlertDialog.Builder alertbox = new AlertDialog.Builder(this);

        alertbox.setMessage(alertCase);
        // set a positive/yes button and create a listener
        alertbox.setPositiveButton("OK", new DialogInterface.OnClickListener() {

            // Save the data from the UI to the database - already done
            public void onClick(DialogInterface arg0, int arg1) {
                //clearFields();
            }
        });
        // display box
        alertbox.show();
    }

    @Override
    public void onResume() {
        super.onResume();

        //-----------------非常关键，必要的哦，不能删除----------------
        nfcAdapter.enableForegroundDispatch(this, mPendingIntent, mFilters,
                mTechLists);
    }

    @Override
    public void onNewIntent(Intent intent) {
        Log.i("Foreground dispatch", "Discovered tag with intent: " + intent);
        //resolveIntent(intent);
        // mText.setText("Discovered tag " + ++mCount + " with intent: " +
        // intent);
        mIntent = intent;
    }

}
