package com.yctxkj.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;




//[------------------------------ MAIN CLASS ----------------------------------]
//--------------------------------- REVISIONS ----------------------------------
//Date       Name                 Tracking #         Description
//--------   -------------------  -------------      --------------------------
//13SEP2011  James Shen                 	         Initial Creation
////////////////////////////////////////////////////////////////////////////////
/**
 * Convert help class.
 * <hr>
 * <b>&copy; Copyright 2011 Guidebee, Inc. All Rights Reserved.</b>
 *
 * @version 1.00, 13/09/11
 * @author Guidebee Pty Ltd.
 */
public class Converter {

    // Hex help
    private static final byte[] HEX_CHAR_TABLE = { (byte) '0', (byte) '1',
            (byte) '2', (byte) '3', (byte) '4', (byte) '5', (byte) '6',
            (byte) '7', (byte) '8', (byte) '9', (byte) 'A', (byte) 'B',
            (byte) 'C', (byte) 'D', (byte) 'E', (byte) 'F' };

    ////////////////////////////////////////////////////////////////////////////
    //--------------------------------- REVISIONS ------------------------------
    // Date       Name                 Tracking #         Description
    // ---------  -------------------  -------------      ----------------------
    // 13SEP2011  James Shen                 	          Initial Creation
    ////////////////////////////////////////////////////////////////////////////
    /**
     * convert a byte arrary to hex string
     * @param raw byte arrary
     * @param len lenght of the arrary.
     * @return hex string.
     */
    public static String getHexString(byte[] raw, int len) {
        byte[] hex = new byte[2 * len];
        int index = 0;
        int pos = 0;

        for (byte b : raw) {
            if (pos >= len)
                break;

            pos++;
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
        }

        return new String(hex);
    }

    public static void copyByte(byte[] src, int srcOffset, byte[] dst,
                                int dstOffset, int count) {
        if (dstOffset + count > dst.length) {
            throw new RuntimeException("目标字节数组所分配的长度不够");
        }
        if (srcOffset + count > src.length) {
            throw new RuntimeException("源字节数组的长度与要求复制的长度不符");
        }
        for (int i = 0; i < count; i++) {
            dst[dstOffset + i] = src[srcOffset + i];
        }
    }
    public static String readString(byte[] bytes,
                                    int offset,int count,String charset){
        try{
            String s = "";
            byte[] b = new byte[count];
            copyByte(bytes, offset, b, 0, count);
            s = new String(b,charset);
            return s;
        }catch(Exception e){
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 将一个char字符转换成一个字节类型
     *
     * @param c
     * @return
     */
    private static byte toByte(char c) {
        byte b = (byte) "0123456789ABCDEF".indexOf(c);
        return b;
    }

    public static byte[] getAPDUResData(byte[] resAllData){
        byte[] res = new byte[resAllData.length - 2];
        System.arraycopy(resAllData, 0, res, 0, res.length);
        return res;
    }

    public static byte[] getAPDUResCode(byte[] resAllData){
        byte[] res = new byte[2];
        System.arraycopy(resAllData, resAllData.length - 2, res, 0, res.length);
        return res;
    }
    public static boolean checkSuccess(byte[] resAllData){
        byte[] res = new byte[2];
        System.arraycopy(resAllData, resAllData.length - 2, res, 0, res.length);
        return Converter.getHexString(res,res.length).equals("9000");
    }
    /**
     * 把16进制字符串转换成字节数组
     *
     * @param hex
     * @return
     */
    public static byte[] hexStringToByte(String hex) {
        int len = (hex.length() / 2);
        byte[] result = new byte[len];
        char[] achar = hex.toCharArray();
        for (int i = 0; i < len; i++) {
            int pos = i * 2;
            result[i] = (byte) (toByte(achar[pos]) << 4 | toByte(achar[pos + 1]));
        }
        return result;
    }


}
